/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.ChangeUserSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DatabasePropertyTestSetup
extends BaseJDBCTestSetup {
    private Properties newValues;
    private Properties oldValues;
    private final boolean staticProperties;

    public static Test setLockTimeouts(Test test, int deadlockTime, int waitTime) {
        Properties properties = new Properties();
        if (deadlockTime >= 0) {
            properties.setProperty("derby.locks.deadlockTimeout", Integer.toString(deadlockTime));
        }
        if (waitTime >= 0) {
            properties.setProperty("derby.locks.waitTimeout", Integer.toString(waitTime));
        }
        if (properties.isEmpty()) {
            return test;
        }
        return new DatabasePropertyTestSetup(test, properties, true);
    }

    public static Test builtinAuthentication(Test test, String[] users, String passwordToken) {
        Properties userProps = new Properties();
        Properties authProps = new Properties();
        authProps.setProperty("derby.connection.requireAuthentication", "true");
        authProps.setProperty("derby.authentication.provider", "BUILTIN");
        for (int i = 0; i < users.length; ++i) {
            String user = users[i];
            userProps.setProperty("derby.user." + user, TestConfiguration.getPassword(user, passwordToken));
        }
        test = new DatabasePropertyTestSetup((Test)test, authProps, true);
        test = new ChangeUserSetup((Test)test, users[0], TestConfiguration.getPassword(users[0], passwordToken), passwordToken);
        test = new DatabasePropertyTestSetup((Test)test, userProps, false);
        return test;
    }

    public static Test builtinAuthenticationNoTeardown(Test test, String[] users, String passwordToken) {
        Properties userProps = new Properties();
        Properties authProps = new Properties();
        authProps.setProperty("derby.connection.requireAuthentication", "true");
        authProps.setProperty("derby.authentication.provider", "BUILTIN");
        for (int i = 0; i < users.length; ++i) {
            String user = users[i];
            userProps.setProperty("derby.user." + user, TestConfiguration.getPassword(user, passwordToken));
        }
        test = DatabasePropertyTestSetup.getNoTeardownInstance(test, authProps, true);
        test = new ChangeUserSetup((Test)test, users[0], TestConfiguration.getPassword(users[0], passwordToken), passwordToken);
        test = DatabasePropertyTestSetup.getNoTeardownInstance(test, userProps, false);
        return test;
    }

    static DatabasePropertyTestSetup getNoTeardownInstance(Test test, Properties p, boolean staticp) {
        return new DatabasePropertyTestSetup(test, p, staticp){

            protected void tearDown() throws Exception {
                this.clearConnection();
            }
        };
    }

    public static Test singleProperty(Test test, String property, String value) {
        return DatabasePropertyTestSetup.singleProperty(test, property, value, false);
    }

    public static Test singleProperty(Test test, String property, String value, boolean reboot) {
        Properties properties = new Properties();
        properties.setProperty(property, value);
        return new DatabasePropertyTestSetup(test, properties, reboot);
    }

    public DatabasePropertyTestSetup(Test test, Properties newValues) {
        this(test, newValues, false);
    }

    public DatabasePropertyTestSetup(Test test, Properties newValues, boolean staticProperties) {
        super(test);
        this.newValues = newValues;
        this.oldValues = new Properties();
        this.staticProperties = staticProperties;
    }

    protected void setUp() throws Exception {
        this.setProperties(this.newValues);
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownDatabase();
        }
    }

    protected void tearDown() throws Exception {
        block9: {
            Connection conn = this.getConnection();
            try {
                this.clearProperties(conn);
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("25502")) {
                    block8: {
                        System.out.println("Apparently this is a read-only connection in teardown()? Get some data:");
                        System.out.println("conn.isClosed: " + conn.isClosed());
                        System.out.println("conn.isReadOnly: " + conn.isReadOnly());
                        System.out.println("conn.getHoldability: " + conn.getHoldability());
                        System.out.println("conn.getTransactionIsolation: " + conn.getTransactionIsolation());
                        System.out.println("conn.getAutoCommit: " + conn.getAutoCommit());
                        try {
                            conn.close();
                        }
                        catch (SQLException isqle) {
                            if (sqle.getSQLState() == "25001") {
                                conn.commit();
                                conn.close();
                                break block8;
                            }
                            System.out.println("close failed - see SQLState.");
                            throw sqle;
                        }
                    }
                    Connection conn2 = this.getConnection();
                    if (conn2.isReadOnly()) {
                        System.out.println("Sorry, conn2 is also read-only, won't retry");
                        throw sqle;
                    }
                    System.out.println("retrying clearing the Properties");
                    this.clearProperties(conn2);
                }
                if (sqle.getSQLState().equals("XCY02")) break block9;
                throw sqle;
            }
        }
        this.setProperties(this.oldValues);
        super.tearDown();
        this.newValues = null;
        this.oldValues = null;
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownDatabase();
        }
    }

    private void clearProperties(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        Enumeration<?> e = this.newValues.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.oldValues.getProperty(key) != null) continue;
            setDBP.setString(1, key);
            setDBP.executeUpdate();
        }
    }

    private void setProperties(Properties values) throws SQLException {
        block6: {
            Connection conn = this.getConnection();
            try {
                this.attemptSetProperties(values, conn);
            }
            catch (SQLException sqle) {
                block7: {
                    if (!sqle.getSQLState().equals("25502")) break block6;
                    System.out.println("Apparently this is a read-only connection? Get some data:");
                    System.out.println("conn.isClosed: " + conn.isClosed());
                    System.out.println("conn.isReadOnly: " + conn.isReadOnly());
                    System.out.println("conn.getHoldability: " + conn.getHoldability());
                    System.out.println("conn.getTransactionIsolation: " + conn.getTransactionIsolation());
                    System.out.println("conn.getAutoCommit: " + conn.getAutoCommit());
                    try {
                        conn.close();
                    }
                    catch (SQLException isqle) {
                        if (sqle.getSQLState() == "25001") {
                            conn.commit();
                            conn.close();
                            break block7;
                        }
                        System.out.println("close failed - see SQLState.");
                        throw sqle;
                    }
                }
                Connection conn2 = this.getConnection();
                if (conn2.isReadOnly()) {
                    System.out.println("Sorry, conn2 is also read-only, won't retry");
                    throw sqle;
                }
                System.out.println("retrying to set the Properties");
                this.attemptSetProperties(values, conn2);
            }
        }
    }

    private void attemptSetProperties(Properties values, Connection coonn) throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement getDBP = conn.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        Enumeration<?> e = values.propertyNames();
        while (e.hasMoreElements()) {
            boolean change;
            String key = (String)e.nextElement();
            String value = values.getProperty(key);
            getDBP.setString(1, key);
            ResultSet rs = getDBP.executeQuery();
            rs.next();
            String old = rs.getString(1);
            rs.close();
            if (old != null) {
                boolean bl = change = !old.equals(value);
                if (change && values != this.oldValues) {
                    this.oldValues.setProperty(key, old);
                }
            } else {
                change = true;
            }
            if (!change) continue;
            setDBP.setString(1, key);
            setDBP.setString(2, value);
            setDBP.executeUpdate();
        }
        conn.commit();
        getDBP.close();
        setDBP.close();
        conn.close();
    }
}

