/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceConnector
implements Connector {
    private TestConfiguration config;
    private DataSource ds;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = JDBCDataSource.getDataSource(config, null);
    }

    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection();
        }
    }

    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            DataSource tmpDs = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection();
        }
    }

    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getConnection(user, password);
        }
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getConnection(user, password);
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            HashMap hm = DataSourceConnector.makeCreateDBAttributes(this.config);
            if (connectionProperties != null) {
                hm.putAll(connectionProperties);
            }
            DataSource tmpDs = this.singleUseDS(hm);
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getConnection(user, password);
        }
    }

    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getConnection();
    }

    public void shutEngine() throws SQLException {
        DataSource tmpDs = this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config));
        JDBCDataSource.setBeanProperty(tmpDs, "databaseName", "");
        tmpDs.getConnection();
    }

    private DataSource singleUseDS(HashMap hm) throws SQLException {
        DataSource sds = JDBCDataSource.getDataSource(this.config, hm);
        return sds;
    }

    static HashMap makeCreateDBAttributes(TestConfiguration configuration) {
        HashMap hm = JDBCDataSource.getDataSourceProperties(configuration);
        hm.put("createDatabase", "create");
        return hm;
    }

    static HashMap makeShutdownDBAttributes(TestConfiguration configuration) {
        HashMap hm = JDBCDataSource.getDataSourceProperties(configuration);
        hm.put("shutdownDatabase", "shutdown");
        return hm;
    }
}

