/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import junit.extensions.TestSetup;
import junit.framework.Test;

public class ClasspathSetup
extends TestSetup {
    private URL _resource;
    private ClassLoader _originalClassLoader;

    public ClasspathSetup(Test test, URL resource) throws Exception {
        super(test);
        this._resource = resource;
    }

    protected void setUp() throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws PrivilegedActionException {
                ClasspathSetup.this._originalClassLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader newClassLoader = new URLClassLoader(new URL[]{ClasspathSetup.this._resource}, ClasspathSetup.this._originalClassLoader);
                Thread.currentThread().setContextClassLoader(newClassLoader);
                return null;
            }
        });
    }

    protected void tearDown() throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws PrivilegedActionException {
                Thread.currentThread().setContextClassLoader(ClasspathSetup.this._originalClassLoader);
                return null;
            }
        });
    }
}

