/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public abstract class BaseTestCase
extends TestCase {
    protected static final String ERRORSTACKTRACEFILE = "error-stacktrace.out";
    protected static final String DEFAULT_DB_DIR = "system";
    protected static final String DERBY_LOG = "derby.log";
    private static final PrintStream out = System.out;
    static /* synthetic */ Class class$org$apache$derbyTesting$junit$BaseTestCase;

    private BaseTestCase() {
    }

    public BaseTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        TestConfiguration config = this.getTestConfiguration();
        boolean trace = config.doTrace();
        long startTime = 0L;
        if (trace) {
            startTime = System.currentTimeMillis();
            out.println();
            String junitClassName = ((Object)((Object)this)).getClass().getName();
            junitClassName = Utilities.formatTestClassNames(junitClassName);
            out.print(BaseTestCase.traceClientType());
            out.print(junitClassName + "." + this.getName() + " ");
        }
        if (System.getSecurityManager() == null && config.defaultSecurityManagerSetup()) {
            BaseTestCase.assertSecurityManager();
        }
        try {
            super.runBare();
        }
        catch (Throwable running) {
            PrintWriter stackOut = null;
            try {
                String failPath = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                stackOut = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(failPath, ERRORSTACKTRACEFILE), true));
                stackOut.println("[Error/failure logged at " + new Date() + "]");
                running.printStackTrace(stackOut);
                stackOut.println();
                File origLog = new File(DEFAULT_DB_DIR, DERBY_LOG);
                File newLog = new File(failPath, DERBY_LOG);
                PrivilegedFileOpsForTests.copy(origLog, newLog);
                String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
                File dbDir = new File(DEFAULT_DB_DIR, dbName);
                File newDbDir = new File(failPath, dbName);
                PrivilegedFileOpsForTests.copy(dbDir, newDbDir);
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                if (stackOut != null) {
                    stackOut.println("Copying derby.log or database failed:");
                    ioe.printStackTrace(stackOut);
                    stackOut.println();
                }
            }
            finally {
                if (stackOut != null) {
                    stackOut.close();
                }
                throw running;
            }
        }
        finally {
            if (trace) {
                long timeUsed = System.currentTimeMillis() - startTime;
                out.print("used " + timeUsed + " ms ");
            }
        }
    }

    public final TestConfiguration getTestConfiguration() {
        return TestConfiguration.getCurrent();
    }

    public final File getFailureFolder() {
        return this.getTestConfiguration().getFailureFolder(this);
    }

    public static void alarm(String text) {
        out.println("ALARM: " + text);
    }

    public static void println(String text) {
        if (TestConfiguration.getCurrent().isVerbose()) {
            out.println("DEBUG: " + text);
        }
    }

    public static void traceit(String text) {
        if (TestConfiguration.getCurrent().doTrace()) {
            out.println(text);
        }
    }

    public static void printStackTrace(Throwable t) {
        while (t != null) {
            t.printStackTrace(out);
            out.flush();
            if (!(t instanceof SQLException)) break;
            t = ((SQLException)t).getNextException();
        }
    }

    protected static void setSystemProperty(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty(name, value);
                return null;
            }
        });
    }

    public static void removeSystemProperty(final String name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.getProperties().remove(name);
                return null;
            }
        });
    }

    protected static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    protected static String[] getFilesWith(final File dir, String prefix) {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FilenameFilter filefilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.startsWith("javacore");
                    }
                };
                return dir.list(filefilter);
            }
        });
    }

    protected static URL getTestResource(final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$org$apache$derbyTesting$junit$BaseTestCase == null ? (class$org$apache$derbyTesting$junit$BaseTestCase = BaseTestCase.class$("org.apache.derbyTesting.junit.BaseTestCase")) : class$org$apache$derbyTesting$junit$BaseTestCase).getClassLoader().getResource(name);
            }
        });
    }

    protected static InputStream openTestResource(final URL url) throws PrivilegedActionException {
        return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return url.openStream();
            }
        });
    }

    public static void assertSecurityManager() {
        BaseTestCase.assertNotNull((String)"No SecurityManager installed", (Object)System.getSecurityManager());
    }

    public static void assertEquals(InputStream is1, InputStream is2) throws IOException {
        if (is1 == null || is2 == null) {
            BaseTestCase.assertNull((String)"InputStream is2 is null, is1 is not", (Object)is1);
            BaseTestCase.assertNull((String)"InputStream is1 is null, is2 is not", (Object)is2);
            return;
        }
        long index = 0L;
        int b1 = is1.read();
        int b2 = is2.read();
        do {
            if (b1 != b2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)b1, (int)b2);
            }
            ++index;
            b1 = is1.read();
            b2 = is2.read();
        } while (b1 != -1 || b2 != -1);
        is1.close();
        is2.close();
    }

    public static void assertEquals(Reader r1, Reader r2) throws IOException {
        long index = 0L;
        if (r1 == null || r2 == null) {
            BaseTestCase.assertNull((String)"Reader r2 is null, r1 is not", (Object)r1);
            BaseTestCase.assertNull((String)"Reader r1 is null, r2 is not", (Object)r2);
            return;
        }
        int c1 = r1.read();
        int c2 = r2.read();
        do {
            if (c1 != c2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)c1, (int)c2);
            }
            ++index;
            c1 = r1.read();
            c2 = r2.read();
        } while (c1 != -1 || c2 != -1);
        r1.close();
        r2.close();
    }

    public static void assertThrowableEquals(Throwable t12, Throwable t22) {
        BaseTestCase.assertNotNull((String)"Passed-in throwable t1 cannot be null to assert detailed message", (Object)t12);
        BaseTestCase.assertNotNull((String)"Passed-in throwable t2 cannot be null to assert detailed message", (Object)t22);
        BaseTestCase.assertEquals((String)"Throwable class types are different", (String)t12.getClass().getName(), (String)t22.getClass().getName());
        BaseTestCase.assertEquals((String)"Detailed messages of the throwable's are different", (String)t12.getMessage(), (String)t22.getMessage());
    }

    public static void assertEquals(final File file1, final File file2) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    BufferedInputStream f1 = new BufferedInputStream(new FileInputStream(file1));
                    BufferedInputStream f2 = new BufferedInputStream(new FileInputStream(file2));
                    BaseTestCase.assertEquals(f1, f2);
                }
                catch (FileNotFoundException e) {
                    Assert.fail((String)("FileNotFoundException in assertEquals(File,File): " + e.getMessage()));
                    e.printStackTrace();
                }
                catch (IOException e) {
                    Assert.fail((String)("IOException in assertEquals(File, File): " + e.getMessage()));
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void assertExecJavaCmdAsExpected(String[] expectedString, String[] cmd, int expectedExitValue) throws InterruptedException, IOException {
        int i;
        Process pr = BaseTestCase.execJavaCmd(cmd);
        String output = BaseTestCase.readProcessOutput(pr);
        int exitValue = pr.exitValue();
        String expectedStrings = "";
        for (i = 0; i < expectedString.length; ++i) {
            expectedStrings = expectedStrings + "\t[" + i + "]" + expectedString[i] + "\n";
        }
        Assert.assertEquals((String)("expectedExitValue:" + expectedExitValue + " does not match exitValue:" + exitValue + "\n" + "expected output strings:\n" + expectedStrings + " actual output:" + output), (int)expectedExitValue, (int)exitValue);
        if (expectedString != null) {
            for (i = 0; i < expectedString.length; ++i) {
                BaseTestCase.assertTrue((String)("Could not find expectedString:" + expectedString[i] + " in output:" + output), (output.indexOf(expectedString[i]) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    public static Process execJavaCmd(String[] cmd) throws IOException {
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add(BaseTestCase.getJavaExecutableName());
        if (BaseTestCase.isJ9Platform()) {
            cmdlist.add("-jcl:foun11");
            String emmaactive = BaseTestCase.getSystemProperty("emma.active");
            if (emmaactive != null) {
                cmdlist.add("-Demma.active=" + emmaactive);
            }
        }
        if (BaseTestCase.isCVM()) {
            cmdlist.add("-Xmx32M");
        }
        cmdlist.add("-classpath");
        cmdlist.add(BaseTestCase.getSystemProperty("java.class.path"));
        for (int i = 0; i < cmd.length; ++i) {
            cmdlist.add(cmd[i]);
        }
        final String[] command = cmdlist.toArray(cmd);
        BaseTestCase.println("execute java command:");
        for (int i = 0; i < command.length; ++i) {
            BaseTestCase.println("command[" + i + "]" + command[i]);
        }
        Process pr = null;
        try {
            pr = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Process result = null;
                    result = Runtime.getRuntime().exec(command);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (IOException)pe.getException();
        }
        return pr;
    }

    public static final String getJavaExecutableName() {
        String vmname = BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe");
        if (vmname == null) {
            vmname = BaseTestCase.getSystemProperty("java.vm.name");
            vmname = "CVM".equals(vmname) ? BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "cvm" : BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        return vmname;
    }

    public static File currentDirectory() {
        return new File(BaseTestCase.getSystemProperty("user.dir"));
    }

    public static final boolean isJ9Platform() {
        return BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe") != null;
    }

    public static final boolean isSunJVM() {
        String vendor = BaseTestCase.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(vendor) || "Oracle Corporation".equals(vendor);
    }

    public static boolean isCVM() {
        return "CVM".equals(BaseTestCase.getSystemProperty("java.vm.name"));
    }

    public static boolean isPhoneME() {
        return BaseTestCase.isCVM() && BaseTestCase.getSystemProperty("java.vm.version").startsWith("phoneme");
    }

    public static final boolean isPlatform(String osName) {
        return BaseTestCase.getSystemProperty("os.name").equals(osName);
    }

    public static final boolean isWindowsPlatform() {
        return BaseTestCase.getSystemProperty("os.name").startsWith("Windows");
    }

    public static final boolean isJava5() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.5");
    }

    public static final boolean isJava7() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.7");
    }

    public static final boolean runsWithEmma() {
        return BaseTestCase.getSystemProperty("java.class.path").indexOf("emma.jar") != -1;
    }

    public static int getClassVersionMajor() {
        String tmp = BaseTestCase.getSystemProperty("java.class.version");
        if (tmp == null) {
            BaseTestCase.println("VM doesn't have property java.class.version");
            return -1;
        }
        int dot = tmp.indexOf(46);
        int major = -1;
        try {
            major = Integer.parseInt(tmp.substring(0, dot));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return major;
    }

    public static final boolean hasInterruptibleIO() {
        boolean interruptibleIO = false;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, InterruptedIOException {
                    TestConfiguration curr = TestConfiguration.getCurrent();
                    String sysHome = BaseTestCase.getSystemProperty("derby.system.home");
                    StringBuffer arbitraryRAFFileNameB = new StringBuffer();
                    arbitraryRAFFileNameB.append(sysHome);
                    arbitraryRAFFileNameB.append(File.separatorChar);
                    arbitraryRAFFileNameB.append(BaseTestCase.DERBY_LOG);
                    String arbitraryRAFFileName = arbitraryRAFFileNameB.toString();
                    new File(sysHome).mkdirs();
                    new File(arbitraryRAFFileName).createNewFile();
                    RandomAccessFile f = new RandomAccessFile(arbitraryRAFFileName, "r");
                    try {
                        Thread.currentThread().interrupt();
                        f.read();
                    }
                    finally {
                        Thread.interrupted();
                        f.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InterruptedIOException) {
                interruptibleIO = true;
            }
            BaseTestCase.println("Could not test for interruptible IO, so assuming we don't have it: " + e);
            e.getCause().printStackTrace();
            return false;
        }
        return interruptibleIO;
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(BaseTestCase.getSystemProperty("java.vendor"));
    }

    public static String readProcessOutput(Process pr) throws InterruptedException {
        SpawnedProcess wrapper = new SpawnedProcess(pr, "readProcessOutput");
        wrapper.suppressOutputOnComplete();
        try {
            wrapper.complete();
        }
        catch (IOException ioe) {
            BaseTestCase.fail("process completion method failed", ioe);
        }
        String output = "<STDOUT>" + wrapper.getFullServerOutput() + "<END STDOUT>\n";
        output = output + "<STDERR>" + wrapper.getFullServerError() + "<END STDERR>\n";
        return output;
    }

    public static void removeDirectory(String path) {
        DropDatabaseSetup.removeDirectory(path);
    }

    public static void removeDirectory(File dir) {
        DropDatabaseSetup.removeDirectory(dir);
    }

    public static void removeFiles(String[] list) {
        DropDatabaseSetup.removeFiles(list);
    }

    public static void fail(String msg, Throwable t) throws AssertionFailedError {
        AssertionFailedError ae = new AssertionFailedError(msg);
        ae.initCause(t);
        throw ae;
    }

    public static void assertLaunchedJUnitTestMethod(String testLaunchMethod) throws Exception {
        String[] cmd = new String[]{"junit.textui.TestRunner", "-m", testLaunchMethod};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, cmd, 0);
    }

    public static void assertLaunchedJUnitTestMethod(String testLaunchMethod, String databaseName) throws Exception {
        String[] cmd = new String[]{"-Dderby.tests.defaultDatabaseName=" + databaseName, "junit.textui.TestRunner", "-m", testLaunchMethod};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, cmd, 0);
    }

    private static String traceClientType() {
        if (TestConfiguration.getCurrent().getJDBCClient().isEmbedded()) {
            return "(emb)";
        }
        return "(net)";
    }
}

