/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;

public class Version
implements Comparable {
    private static final int EXPECTED_LEG_COUNT = 4;
    private int[] _legs;
    private String _key;
    private String _branchID;
    private static HashMap _classLoaders = new HashMap();

    public Version(int major, int minor, int fixpack, int bugversion) {
        this(new int[]{major, minor, fixpack, bugversion});
    }

    public Version(int[] legs) {
        this.constructorMinion(legs);
    }

    public Version(ProductVersionHolder pvh) {
        this.constructorMinion(this.getLegs(pvh));
    }

    private void constructorMinion(int[] legs) {
        int count;
        if (legs == null) {
            legs = new int[]{};
        }
        if ((count = legs.length) != 4) {
            throw new IllegalArgumentException("Expected 4 legs but only saw " + count);
        }
        this._legs = new int[count];
        for (int i = 0; i < count; ++i) {
            this._legs[i] = legs[i];
        }
        this.makeKey();
    }

    private int[] getLegs(ProductVersionHolder pvh) {
        int[] result = new int[4];
        int idx = 0;
        result[idx++] = pvh.getMajorVersion();
        result[idx++] = pvh.getMinorVersion();
        result[idx++] = pvh.getMaintVersion() / 1000000;
        result[idx++] = pvh.getMaintVersion() % 1000000;
        return result;
    }

    public String toString() {
        return this._key;
    }

    public String getBranchID() {
        if (this._branchID == null) {
            this._branchID = Integer.toString(this._legs[0]) + '.' + Integer.toString(this._legs[1]);
        }
        return this._branchID;
    }

    public ClassLoader getClassLoader() {
        ClassLoader retval = (ClassLoader)_classLoaders.get(this._key);
        if (retval != null) {
            return retval;
        }
        this.addClassLoader();
        return (ClassLoader)_classLoaders.get(this._key);
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        if (!(other instanceof Version)) {
            return 1;
        }
        Version that = (Version)other;
        for (int i = 0; i < 4; ++i) {
            int result = this._legs[i] - that._legs[i];
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void addClassLoader() {
        ClassLoader classLoader = UpgradeClassLoader.makeClassLoader(this._legs);
        _classLoaders.put(this._key, classLoader);
    }

    private void makeKey() {
        StringBuffer buffer = new StringBuffer();
        int legCount = this._legs.length;
        for (int i = 0; i < legCount; ++i) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append(this._legs[i]);
        }
        this._key = buffer.toString();
    }

    public static final class Trajectory
    implements Comparable {
        private Version[] _versions;

        public Trajectory(ArrayList versionList) {
            if (versionList == null) {
                versionList = new ArrayList();
            }
            Version[] versions = new Version[versionList.size()];
            versionList.toArray(versions);
            this.constructorMinion(versions);
        }

        public Trajectory(Version[] versions) {
            if (versions == null) {
                versions = new Version[]{};
            }
            this.constructorMinion(versions);
        }

        private void constructorMinion(Version[] versions) {
            int count = versions.length;
            this._versions = new Version[count];
            for (int i = 0; i < count; ++i) {
                this._versions[i] = versions[i];
            }
        }

        public Trajectory sort() {
            Arrays.sort(this._versions);
            return this;
        }

        public int getVersionCount() {
            return this._versions.length;
        }

        public Version getVersion(int idx) {
            return this._versions[idx];
        }

        public Version getEndingVersion() {
            return this.getVersion(this.getVersionCount() - 1);
        }

        public boolean startsAt(Version candidate) {
            return this.getVersion(0).equals(candidate);
        }

        public boolean startsAt(String branchID) {
            return this.getVersion(0).getBranchID().equals(branchID);
        }

        public boolean contains(Version candidate) {
            int count = this.getVersionCount();
            for (int i = 0; i < count; ++i) {
                if (!this.getVersion(i).equals(candidate)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(String branchID) {
            int count = this.getVersionCount();
            for (int i = 0; i < count; ++i) {
                if (!this.getVersion(i).getBranchID().equals(branchID)) continue;
                return true;
            }
            return false;
        }

        public boolean endsAt(Version candidate) {
            return this.getVersion(this.getVersionCount() - 1).equals(candidate);
        }

        public boolean endsAt(String branchID) {
            return this.getVersion(this.getVersionCount() - 1).getBranchID().equals(branchID);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            int count = this._versions.length;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(" -> ");
                }
                buffer.append(this._versions[i].toString());
            }
            return buffer.toString();
        }

        public int compareTo(Object other) {
            int thatLength;
            if (other == null) {
                return -1;
            }
            if (!(other instanceof Trajectory)) {
                return -1;
            }
            Trajectory that = (Trajectory)other;
            int thisLength = this.getVersionCount();
            int minLength = thisLength < (thatLength = that.getVersionCount()) ? thisLength : thatLength;
            for (int i = 0; i < minLength; ++i) {
                int result = this.getVersion(i).compareTo(that.getVersion(i));
                if (result == 0) continue;
                return result;
            }
            return thisLength - thatLength;
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

