/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RowLockBasicTest
extends BaseJDBCTestCase {
    public RowLockBasicTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(RowLockBasicTest.class);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setTransactionIsolation(8);
        Statement s = this.createStatement();
        s.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.createLockTableQueryEntries(s);
        s.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        s.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.rowLocking', 'true')");
        s.close();
        this.getConnection().setAutoCommit(false);
        this.dropTable("a");
    }

    private void createLockTableQueryEntries(Statement s) throws SQLException {
        s.execute("create view lock_table as select cast(username as char(8)) as username,cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l  right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' and t.type='UserTransaction'");
        s.execute("create view full_lock_table as select cast(username as char(8)) as username, cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode, cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' ");
        s.execute("create view lock_table2 as select cast(l.xid as char(8)) as xid,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state from syscs_diag.lock_table l where l.tableType <> 'S' ");
        s.execute("create view tran_table as select * from syscs_diag.transaction_table");
    }

    public void tearDown() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("DROP FUNCTION PADSTRING");
        st.execute("drop view lock_table");
        st.execute("drop view full_lock_table");
        st.execute("drop view lock_table2");
        st.execute("drop view tran_table");
        st.close();
        this.dropTable("a");
        this.commit();
        super.tearDown();
    }

    public void testInsertIntoHeap() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table a (a int)");
        this.commit();
        st.execute("insert into a values (1)");
        ResultSet rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        st.execute("insert into a values (2)");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        this.dropTable("a");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "3", "X", "*** TRANSIEN", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testInsertIntoBtree() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table a (a int, b varchar(1000))");
        ResultSet rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        st.execute("create index a_idx on a (a, b)");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "4", "S", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        st.execute("insert into a values (1, PADSTRING('a',1000))");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        st.execute("insert into a values (2, PADSTRING('b',1000))");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        st.execute("insert into a values (3, PADSTRING('c',1000))");
        this.commit();
        st.execute("insert into a values (4, PADSTRING('d',1000))");
        rs = st.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,10)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(2,6)", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testInsertOnNewPage() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table a (a int, b varchar(1000))");
        st.execute("create unique index a_idx on a (a, b)");
        st.execute("insert into a values (1, PADSTRING('a',1000))");
        st.execute("insert into a values (2, PADSTRING('b',1000))");
        st.execute("insert into a values (3, PADSTRING('c',1000))");
        st.execute("insert into a values (4, PADSTRING('d',1000))");
        ResultSet rs = st.executeQuery("select a from a");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        st.execute("delete from a where a = 3");
        rs = st.executeQuery("select a from a");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"4"}});
        this.commit();
        st.execute("insert into a values (3, PADSTRING('c',1000))");
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,9)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(2,7)", "GRANT", "ACTIVE"}});
        st.close();
    }

    public void testFullCoveredIndexScan() throws SQLException {
        Statement st = this.createStatement();
        this.createTableAandUniqueIndex(st);
        ResultSet rs = st.executeQuery("select a from a");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "S", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    private void createTableAandUniqueIndex(Statement st) throws SQLException {
        st.execute("create table a (a int, b char(200))");
        st.execute("create unique index a_idx on a (a)");
        st.execute("insert into a values (1, 'a')");
        st.execute("insert into a values (2, 'b')");
        st.execute("insert into a values (3, 'c')");
        st.execute("insert into a values (4, 'd')");
        this.commit();
    }

    public void testSingleProbeIntoFirstKey() throws SQLException {
        Statement st = this.createStatement();
        this.createTableAandUniqueIndex(st);
        ResultSet rs = st.executeQuery("select a from a where a = 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testSingleProbeIntoLastKey() throws SQLException {
        Statement st = this.createStatement();
        this.createTableAandUniqueIndex(st);
        ResultSet rs = st.executeQuery("select a from a where a = 4");
        JDBC.assertFullResultSet(rs, new String[][]{{"4"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testSetOfRangeScanFor1RowReturn() throws SQLException {
        Statement st = this.createStatement();
        this.createTableAandUniqueIndex(st);
        ResultSet rs = st.executeQuery("select a from a where a <= 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,3)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        rs = st.executeQuery("select a from a where a >= 2 and a < 3");
        JDBC.assertFullResultSet(rs, new String[][]{{"2"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        rs = st.executeQuery("select a from a where a > 3");
        JDBC.assertFullResultSet(rs, new String[][]{{"4"}});
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,9)", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testSetOfRangeScanFor0RowReturn() throws SQLException {
        Statement st = this.createStatement();
        this.createTableAandUniqueIndex(st);
        ResultSet rs = st.executeQuery("select a from a where a < 1");
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,3)", "GRANT", "ACTIVE"}});
        this.commit();
        rs = st.executeQuery("select a from a where a > 4");
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        rs = st.executeQuery("select a from a where a > 2 and a < 3");
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        st.close();
    }

    public void testCreateIndexDoesTableLevelLocking() throws SQLException {
        Statement st = this.createStatement();
        st.execute("create table a (a int, b char(200))");
        st.execute("create table b (a int, b char(200))");
        st.execute("insert into a values (1, 'a')");
        st.execute("insert into a values (2, 'b')");
        st.execute("insert into a values (3, 'c')");
        st.execute("insert into a values (4, 'd')");
        this.commit();
        st.execute("create unique index a_idx on a (a)");
        ResultSet rs = st.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTran", "TABLE", "4", "S", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        rs = st.executeQuery("select a from a");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        rs = st.executeQuery("select a from b");
        JDBC.assertDrainResults(rs, 0);
        this.commit();
        st.execute("drop index a_idx");
        this.dropTable("a");
        this.dropTable("b");
        st.close();
    }
}

