/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class KeepDisposableStatsPropertyTest
extends BaseJDBCTestCase {
    public KeepDisposableStatsPropertyTest(String name) {
        super(name);
    }

    public void testPropertyFalse() throws SQLException {
        this.assertOnSCUI(false);
    }

    public void testPropertyTrue() throws SQLException {
        this.assertOnSCUI(true);
    }

    public void testPropertyDefault() throws SQLException {
        this.assertOnSCUI(false);
    }

    private void assertOnSCUI(boolean keepDisposable) throws SQLException {
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection(), 20000L);
        String TAB = "STAT_SCUI";
        this.dropTable(TAB);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table " + TAB + " (id int not null, val int)");
        stats.assertNoStatsTable(TAB);
        PreparedStatement psIns = this.prepareStatement("insert into " + TAB + " values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 20; ++i) {
            psIns.setInt(1, i);
            psIns.setInt(2, i);
            psIns.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        stmt.executeUpdate("alter table " + TAB + " add constraint PK_" + TAB + " primary key(id)");
        stats.assertTableStats(TAB, keepDisposable ? 1 : 0);
        stmt.executeUpdate("create unique index UNIQ_IDX_" + TAB + " ON " + TAB + "(val)");
        stats.assertTableStats(TAB, keepDisposable ? 2 : 0);
        PreparedStatement ps = this.prepareStatement("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', ?, ?)");
        ps.setString(1, TAB);
        ps.setNull(2, 12);
        ps.execute();
        stats.assertTableStats(TAB, keepDisposable ? 2 : 0);
        ps.setString(2, "UNIQ_IDX_" + TAB);
        ps.execute();
        stats.assertTableStats(TAB, keepDisposable ? 2 : 0);
        stmt.execute("call SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP', '" + TAB + "', null)");
        stats.assertNoStatsTable(TAB);
        ps.execute();
        stats.assertTableStats(TAB, keepDisposable ? 1 : 0);
        ps.setNull(2, 12);
        ps.execute();
        stats.assertTableStats(TAB, keepDisposable ? 2 : 0);
        IndexStatsUtil.IdxStats[] oldStats = stats.getStatsTable(TAB);
        this.setAutoCommit(false);
        for (int i = 20; i < 2000; ++i) {
            psIns.setInt(1, i);
            psIns.setInt(2, i);
            psIns.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        this.prepareStatement("select * from " + TAB + " where id = ?");
        IndexStatsUtil.IdxStats[] newStats = stats.getNewStatsTable(TAB, oldStats);
        KeepDisposableStatsPropertyTest.assertEquals((int)oldStats.length, (int)newStats.length);
        for (int i = 0; i < oldStats.length; ++i) {
            KeepDisposableStatsPropertyTest.assertEquals((boolean)keepDisposable, (boolean)newStats[i].after(oldStats[i]));
        }
        this.dropTable(TAB);
        stats.release();
    }

    public static Test suite() {
        String property = "derby.storage.indexStats.debug.keepDisposableStats";
        TestSuite suite = new TestSuite("KeepDisposableStatsPropertyTestSuite");
        suite.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyDefault"));
        Properties propsOn = new Properties();
        propsOn.setProperty(property, "true");
        TestSuite suiteOn = new TestSuite("Do KeepDisposableStats");
        suiteOn.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyTrue"));
        suite.addTest((Test)new SystemPropertyTestSetup((Test)suiteOn, propsOn, true));
        Properties propsOff = new Properties();
        propsOff.setProperty(property, "false");
        TestSuite suiteOff = new TestSuite("Don't KeepDisposableStats");
        suiteOff.addTest((Test)new KeepDisposableStatsPropertyTest("testPropertyFalse"));
        suite.addTest((Test)new SystemPropertyTestSetup((Test)suiteOff, propsOff, true));
        return suite;
    }
}

