/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class HoldCursorJDBC30Test
extends BaseJDBCTestCase {
    public HoldCursorJDBC30Test(String name) {
        super(name);
    }

    private static Test decorateTest(Test test) {
        return new CleanDatabaseTestSetup(test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table foo1 (a int, data int)");
                s.execute("create table foo2 (a int, data int)");
                s.execute("create table foo3 (a int, data int)");
                s.execute("create index foox_3 on foo3 (a)");
                s.execute("create table foo4 (a int, data int)");
                s.execute("create table foo5 (a int, data int)");
                s.execute("create index foox_5 on foo5 (a)");
                s.execute("create table foo6 (a int, data int)");
                s.execute("create table foo7 (a int, data int)");
                s.execute("create index foox_7 on foo7 (a)");
                s.execute("create table t1_8 (c1 int, c2 int)");
                s.execute("create table t1_9 (c1 int, c2 int)");
                s.execute("create table t1_10 (c1 int, c2 int)");
                s.execute("create index tx_10 on t1_10 (c1)");
                s.execute("create table t1_11 (c1 varchar(1000), c2 int)");
                s.execute("create table t1_12 (t1_i1 int, t1_i2 int)");
                s.execute("create table t2_12 (t2_i1 int, t2_i2 int)");
                s.execute("create index t1_idx_12 on t1_12 (t1_i1)");
                s.execute("create index t2_idx_12 on t2_12 (t2_i1)");
                s.execute("create table t1_13 (t1_i1 int, t1_i2 int)");
                s.execute("create table t2_13 (t2_i1 int, t2_i2 int)");
                s.execute("create index t1_idx_13 on t1_13 (t1_i1)");
                s.execute("create index t2_idx_13 on t2_13 (t2_i1)");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("HoldCursorJDBC30Test");
        suite.addTest(HoldCursorJDBC30Test.decorateTest(TestConfiguration.embeddedSuite(HoldCursorJDBC30Test.class)));
        suite.addTest(HoldCursorJDBC30Test.decorateTest(TestConfiguration.clientServerSuite(HoldCursorJDBC30Test.class)));
        return suite;
    }

    protected void setUp() throws SQLException {
        this.setAutoCommit(false);
        this.createStatement().execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
    }

    public void testBasicHeapScanZeroRows() throws SQLException {
        Statement stUtil = this.createStatement();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo1");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1 for update");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo1");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testBasicHeapScanMultiRows() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into foo2 values (1, 10)");
        stUtil.addBatch("insert into foo2 values (1, 20)");
        stUtil.addBatch("insert into foo2 values (1, 30)");
        stUtil.addBatch("insert into foo2 values (1, 40)");
        stUtil.addBatch("insert into foo2 values (1, 50)");
        stUtil.executeBatch();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo2 for update");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo2 for update");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testBasicBtreeScanForZeroRowsUpdateNonkeyfield() throws SQLException {
        Statement stUtil = this.createStatement();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo3 for update of data");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo3 for update of data");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testBasicBtreeScanTestsForMultipleRowsOrUpdateNonkeyField() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into foo4 values (1, 10)");
        stUtil.addBatch("insert into foo4 values (1, 20)");
        stUtil.addBatch("insert into foo4 values (1, 30)");
        stUtil.addBatch("insert into foo4 values (1, 40)");
        stUtil.addBatch("insert into foo4 values (1, 50)");
        stUtil.executeBatch();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo4 for update of data");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        try {
            test1.deleteRow();
            HoldCursorJDBC30Test.fail((String)"Should be unable to delete row!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XJ083", e);
        }
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        try {
            test1.updateInt("data", -3000);
            HoldCursorJDBC30Test.fail((String)"Should be unable to update row!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XJ083", e);
        }
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        st = this.createStatement(1004, 1008, 1);
        test1 = st.executeQuery("select * from foo4");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        test1.deleteRow();
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        test1.updateInt("data", -3000);
        test1.updateRow();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo4 for update of data");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)-3000, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testBasicBtreeScanForZeroRowsReadOnlyNoGroupFetch() throws SQLException {
        Statement stUtil = this.createStatement();
        Statement st = this.createStatement(1003, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo5");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo5");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testBasicBtreeScanTestsForMultipleRowsOrReadOnly() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into foo6 values (1, 10)");
        stUtil.addBatch("insert into foo6 values (1, 20)");
        stUtil.addBatch("insert into foo6 values (1, 30)");
        stUtil.addBatch("insert into foo6 values (1, 40)");
        stUtil.addBatch("insert into foo6 values (1, 50)");
        stUtil.executeBatch();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select * from foo6");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select * from foo6");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testOrder() throws SQLException {
        Statement stUtil = this.createStatement();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select a,data from foo7 order by data desc");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        stUtil.addBatch("insert into foo7 values (1, 10)");
        stUtil.addBatch("insert into foo7 values (1, 20)");
        stUtil.addBatch("insert into foo7 values (1, 30)");
        stUtil.addBatch("insert into foo7 values (1, 40)");
        stUtil.addBatch("insert into foo7 values (1, 50)");
        stUtil.executeBatch();
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        test1 = st.executeQuery("select a,data from foo7 order by data desc");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test1.getInt("data"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)30, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("a"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt("data"));
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        try {
            test1.next();
            HoldCursorJDBC30Test.fail((String)"Should be unable to establish cursor!");
        }
        catch (SQLException e) {
            HoldCursorJDBC30Test.assertSQLState("XCL16", e);
        }
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testDistinctScalarAggregateResultSet() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.executeUpdate("insert into t1_8 values (null, null), (1,1), (null, null), (2,1), (3,1), (10,10)");
        JDBC.assertFullResultSet(stUtil.executeQuery("select * from t1_8"), new String[][]{{null, null}, {"1", "1"}, {null, null}, {"2", "1"}, {"3", "1"}, {"10", "10"}});
        JDBC.assertFullResultSet(stUtil.executeQuery("select sum(distinct c1) from t1_8"), new String[][]{{"16"}});
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select sum(distinct c1) from t1_8");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)16, (int)test1.getInt(1));
        test1.close();
        test1 = st.executeQuery("select sum(distinct c1) from t1_8");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)16, (int)test1.getInt(1));
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        this.commit();
        test1.close();
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testDistinctScalarAggregateResultSetGrouped() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.executeUpdate("insert into t1_9 values (null, null), (1,1), (null, null), (2,1), (3,1), (10,10)");
        JDBC.assertFullResultSet(stUtil.executeQuery("select * from t1_9"), new String[][]{{null, null}, {"1", "1"}, {null, null}, {"2", "1"}, {"3", "1"}, {"10", "10"}});
        JDBC.assertFullResultSet(stUtil.executeQuery("select sum(distinct c1) from t1_9 group by c2"), new String[][]{{"6"}, {"10"}, {null}});
        this.commit();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select sum(distinct c1) from t1_9 group by c2");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)6, (int)test1.getInt(1));
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt(1));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        test1.getInt(1);
        HoldCursorJDBC30Test.assertTrue((boolean)test1.wasNull());
        test1.close();
        test1 = st.executeQuery("select sum(distinct c1) from t1_9 group by c2");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)6, (int)test1.getInt(1));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test1.getInt(1));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        test1.getInt(1);
        HoldCursorJDBC30Test.assertTrue((boolean)test1.wasNull());
        test1.close();
        this.commit();
        st.close();
        stUtil.close();
    }

    public void testPositionPurgedRow() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.executeUpdate("insert into t1_10 values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6)");
        Statement st = this.createStatement(1004, 1008, 1);
        ResultSet test1 = st.executeQuery("select c1 from t1_10");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test1.getInt("c1"));
        this.commit();
        HoldCursorJDBC30Test.assertUpdateCount(stUtil, 2, "delete from t1_10 where c1 = 1 or c1 = 2");
        if (HoldCursorJDBC30Test.usingEmbedded()) {
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)3, (int)test1.getInt("c1"));
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 1, "delete from t1_10 where c1 = 3");
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)4, (int)test1.getInt("c1"));
            this.commit();
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 3, "delete from t1_10");
            this.commit();
            HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        } else {
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)2, (int)test1.getInt("c1"));
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 1, "delete from t1_10 where c1 = 3");
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)3, (int)test1.getInt("c1"));
            this.commit();
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 3, "delete from t1_10");
            this.commit();
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)4, (int)test1.getInt("c1"));
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)5, (int)test1.getInt("c1"));
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((int)6, (int)test1.getInt("c1"));
            HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        }
        test1.close();
        stUtil.close();
    }

    public void testPositionPurgedPage() throws SQLException {
        String[] rows = new String[7];
        for (int i = 1; i <= rows.length; ++i) {
            rows[i - 1] = Formatters.padString("" + i, 1000);
        }
        Statement stUtil = this.createStatement();
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        stUtil.executeUpdate("create index tx_11 on t1_11 (c1)");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', Null)");
        PreparedStatement ps = this.prepareStatement("insert into t1_11 values(?,1), (?,2), (?,3), (?,4), (?,5), (?,6), (?,7)");
        for (int i = 0; i < rows.length; ++i) {
            ps.setString(i + 1, rows[i]);
        }
        ps.executeUpdate();
        ps.close();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test1 = st.executeQuery("select c1 from t1_11");
        HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorJDBC30Test.assertEquals((String)rows[0], (String)test1.getString("c1"));
        this.commit();
        ps = this.prepareStatement("delete from t1_11 where c1 = ? or c1 = ?");
        ps.setString(1, rows[0]);
        ps.setString(2, rows[1]);
        HoldCursorJDBC30Test.assertUpdateCount(ps, 2);
        ps.close();
        if (HoldCursorJDBC30Test.usingEmbedded()) {
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[2], (String)test1.getString("c1"));
            ps = this.prepareStatement("delete from t1_11 where c1 = ?");
            ps.setString(1, rows[2]);
            HoldCursorJDBC30Test.assertUpdateCount(ps, 1);
            ps.close();
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[3], (String)test1.getString("c1"));
            this.commit();
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 4, "delete from t1_11");
            this.commit();
            HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        } else {
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[1], (String)test1.getString("c1"));
            ps = this.prepareStatement("delete from t1_11 where c1 = ?");
            ps.setString(1, rows[2]);
            HoldCursorJDBC30Test.assertUpdateCount(ps, 1);
            ps.close();
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[2], (String)test1.getString("c1"));
            this.commit();
            HoldCursorJDBC30Test.assertUpdateCount(stUtil, 4, "delete from t1_11");
            this.commit();
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[3], (String)test1.getString("c1"));
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[4], (String)test1.getString("c1"));
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[5], (String)test1.getString("c1"));
            HoldCursorJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorJDBC30Test.assertEquals((String)rows[6], (String)test1.getString("c1"));
            HoldCursorJDBC30Test.assertFalse((boolean)test1.next());
        }
        test1.close();
        st.close();
        stUtil.close();
    }

    public void testBeetle4902() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into t1_12 values (1, 10), (2, 20), (3, 30), (4, 40), (5, 50)");
        stUtil.addBatch("insert into t2_12 values (1, 10), (2, 20), (4, 40), (5, 50)");
        stUtil.executeBatch();
        this.commit();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test11 = st.executeQuery("select * from t1_12, t2_12 where t1_12.t1_i1 = t2_12.t2_i1");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test11.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test11.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test11.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test11.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test11.getInt("t2_i2"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test11.next());
        HoldCursorJDBC30Test.assertEquals((int)2, (int)test11.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test11.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)2, (int)test11.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test11.getInt("t2_i2"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test11.next());
        HoldCursorJDBC30Test.assertEquals((int)4, (int)test11.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test11.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)4, (int)test11.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test11.getInt("t2_i2"));
        HoldCursorJDBC30Test.assertTrue((boolean)test11.next());
        HoldCursorJDBC30Test.assertEquals((int)5, (int)test11.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test11.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)5, (int)test11.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test11.getInt("t2_i2"));
        this.commit();
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test11.next());
        this.commit();
        test11.close();
        st.close();
        stUtil.close();
    }

    public void testBeetle4902WithBulkFetchDefaultSet() throws SQLException {
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into t1_13 values (1, 10), (2, 20), (3, 30), (4, 40), (5, 50)");
        stUtil.addBatch("insert into t2_13 values (1, 10), (2, 20), (4, 40), (5, 50)");
        stUtil.executeBatch();
        this.commit();
        Statement st = this.createStatement(1004, 1007, 1);
        ResultSet test12 = st.executeQuery("select * from t1_13, t2_13 where t1_13.t1_i1 = t2_13.t2_i1");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test12.next());
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test12.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test12.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)1, (int)test12.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)10, (int)test12.getInt("t2_i2"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test12.next());
        HoldCursorJDBC30Test.assertEquals((int)2, (int)test12.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test12.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)2, (int)test12.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)20, (int)test12.getInt("t2_i2"));
        this.commit();
        HoldCursorJDBC30Test.assertTrue((boolean)test12.next());
        HoldCursorJDBC30Test.assertEquals((int)4, (int)test12.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test12.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)4, (int)test12.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)40, (int)test12.getInt("t2_i2"));
        HoldCursorJDBC30Test.assertTrue((boolean)test12.next());
        HoldCursorJDBC30Test.assertEquals((int)5, (int)test12.getInt("t1_i1"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test12.getInt("t1_i2"));
        HoldCursorJDBC30Test.assertEquals((int)5, (int)test12.getInt("t2_i1"));
        HoldCursorJDBC30Test.assertEquals((int)50, (int)test12.getInt("t2_i2"));
        this.commit();
        this.commit();
        HoldCursorJDBC30Test.assertFalse((boolean)test12.next());
        this.commit();
        test12.close();
        st.close();
        stUtil.close();
    }
}

