/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby4676Test
extends BaseJDBCTestCase {
    private List threads;

    public Derby4676Test(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby4676Test.class);
    }

    protected void setUp() {
        this.threads = new ArrayList();
    }

    protected void tearDown() throws Exception {
        HelperThread t;
        int i;
        super.tearDown();
        List localThreads = this.threads;
        this.threads = null;
        for (i = 0; i < localThreads.size(); ++i) {
            t = (HelperThread)localThreads.get(i);
            t.join();
            Connection c = t.conn;
            if (c == null || c.isClosed()) continue;
            c.rollback();
            c.close();
        }
        for (i = 0; i < localThreads.size(); ++i) {
            t = (HelperThread)localThreads.get(i);
            if (t.exception == null) continue;
            Derby4676Test.fail("Helper thread failed", t.exception);
        }
    }

    public void testConcurrentFetchAndDelete() throws Exception {
        Statement s = this.createStatement();
        s.execute("create table t(x int, y int)");
        s.execute("create index idx on t(x)");
        HelperThread thread = new HelperThread(){

            void body(Connection conn) throws Exception {
                Thread.sleep(1000L);
                Statement s = conn.createStatement();
                for (int i = 0; i < 1000; ++i) {
                    s.execute("insert into t values (1,2)");
                    s.execute("delete from t");
                }
                s.close();
            }
        };
        this.startThread(thread);
        while (thread.isAlive()) {
            JDBC.assertDrainResults(s.executeQuery("select * from t --derby-properties index=idx"));
        }
    }

    private void startThread(HelperThread thread) {
        thread.start();
        this.threads.add(thread);
    }

    private abstract class HelperThread
    extends Thread {
        Exception exception;
        Connection conn;

        private HelperThread() {
        }

        public void run() {
            try {
                this.conn = Derby4676Test.this.openDefaultConnection();
                this.body(this.conn);
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        abstract void body(Connection var1) throws Exception;
    }
}

