/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_Derby4910
extends ReplicationRun {
    public ReplicationRun_Local_Derby4910(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Replication test - DERBY-4910");
        suite.addTestSuite(ReplicationRun_Local_Derby4910.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testSlaveWaitsForMaster() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        Thread.sleep(3000L);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        String dbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int tuplesToInsert = 10000;
        this._testInsertUpdateDeleteOnMaster(masterServerHost, masterServerPort, dbPath, tuplesToInsert);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        dbPath = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, dbPath, tuplesToInsert);
        dbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, dbPath, tuplesToInsert);
    }
}

