/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class largeCodeGen
extends BaseJDBCTestCase {
    private static boolean TEST_QUERY_EXECUTION = true;

    public largeCodeGen(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        if (largeCodeGen.usingEmbedded()) {
            suite.addTestSuite(largeCodeGen.class);
            return new CleanDatabaseTestSetup((Test)suite);
        }
        return suite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        String createSQL = "create table t0 (si smallint,i int, bi bigint, r real, f float, d double precision, n5_2 numeric(5,2), dec10_3 decimal(10,3), ch20 char(3),vc varchar(20), lvc long varchar)";
        stmt.executeUpdate(createSQL);
        stmt.executeUpdate("insert into t0 values(2,3,4,5.3,5.3,5.3,31.13,123456.123, 'one','one','one')");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("DROP TABLE T0");
        stmt.close();
        this.commit();
        super.tearDown();
    }

    private boolean checkT0Query(String testName, StringBuffer sqlBuffer, int numParams, int paramValue) {
        try {
            PreparedStatement ps = this.prepareStatement(sqlBuffer.toString());
            if (TEST_QUERY_EXECUTION) {
                for (int i = 1; i <= numParams; ++i) {
                    ps.setInt(i, paramValue);
                }
                ResultSet rs = ps.executeQuery();
                rs.next();
                largeCodeGen.checkRowData(rs);
                rs.close();
            }
            ps.close();
            this.commit();
            return false;
        }
        catch (SQLException e) {
            largeCodeGen.assertSQLState("42ZA0", e);
            return true;
        }
    }

    public void testLogicalOperators() throws SQLException {
        int passCount = 0;
        for (int count = 700; count <= 10000 && !this.logicalOperators(count); count += 100) {
            passCount = count;
        }
        largeCodeGen.assertEquals((String)"logical operators change from previous limit", (int)800, (int)passCount);
    }

    private boolean logicalOperators(int numOperands) throws SQLException {
        String pred = "(si = ? AND si = ? )";
        String testName = "Logical operators with " + numOperands + " parameters";
        StringBuffer sqlBuffer = new StringBuffer(numOperands * 20 + 512);
        sqlBuffer.append("SELECT * FROM T0 WHERE " + pred);
        for (int i = 2; i < numOperands; i += 2) {
            sqlBuffer.append(" OR " + pred);
        }
        return this.checkT0Query(testName, sqlBuffer, numOperands, 2);
    }

    public void testInClause() throws SQLException {
        largeCodeGen.assertFalse((String)"IN clause with 3400 parameters ", (boolean)this.inClause(3400));
        int passCount = 0;
        for (int count = 97000; count <= 200000 && !this.inClause(count); count += 1000) {
            passCount = count;
        }
        largeCodeGen.assertEquals((String)"IN clause change from previous limit", (int)98000, (int)passCount);
    }

    private boolean inClause(int numParams) throws SQLException {
        String testName = "IN clause with " + numParams + " parameters";
        StringBuffer sqlBuffer = new StringBuffer(numParams * 20 + 512);
        sqlBuffer.append("SELECT * FROM T0 WHERE SI IN (");
        for (int i = 1; i < numParams; ++i) {
            sqlBuffer.append("?, ");
        }
        sqlBuffer.append("?)");
        return this.checkT0Query(testName, sqlBuffer, numParams, 2);
    }

    public void testUnions() throws SQLException {
        String viewName = "v0";
        Statement stmt = this.createStatement();
        StringBuffer createView = new StringBuffer("create view " + viewName + " as select * from t0 ");
        for (int i = 1; i < 100; ++i) {
            createView.append(" UNION ALL (SELECT * FROM t0 )");
        }
        stmt.executeUpdate(createView.toString());
        this.commit();
        int passCount = 0;
        for (int count = 1000; count <= 1000 && !this.largeUnionSelect(viewName, count); count += 1000) {
            passCount = count;
        }
        this.createStatement().executeUpdate("DROP VIEW " + viewName);
        largeCodeGen.assertEquals((String)"UNION operators change from previous limit", (int)1000, (int)passCount);
    }

    private boolean largeUnionSelect(String viewName, int numUnions) throws SQLException {
        String unionClause = " UNION ALL (SELECT * FROM " + viewName + ")";
        StringBuffer selectSQLBuffer = new StringBuffer(numUnions / 100 * unionClause.length() + 512);
        selectSQLBuffer.append("select * from t0 ");
        for (int i = 1; i < numUnions / 100; ++i) {
            selectSQLBuffer.append(unionClause);
        }
        try {
            String selectSQL = selectSQLBuffer.toString();
            PreparedStatement pstmt = this.prepareStatement(selectSQL);
            if (TEST_QUERY_EXECUTION) {
                ResultSet rs = pstmt.executeQuery();
                int numRows = 0;
                while (rs.next()) {
                    if (++numRows % 100 != 0) continue;
                    largeCodeGen.checkRowData(rs);
                }
                rs.close();
                this.commit();
            }
            pstmt.close();
            return false;
        }
        catch (SQLException sqle) {
            largeCodeGen.assertSQLState("42ZA0", sqle);
            return true;
        }
    }

    private static void checkRowData(ResultSet rs) throws SQLException {
        String[] values = new String[]{"2", "3", "4", "5.3", "5.3", "5.3", "31.13", "123456.123", "one", "one", "one"};
        for (int i = 1; i <= 11; ++i) {
            largeCodeGen.assertEquals((String)"Result set data value: ", (String)values[i - 1], (String)rs.getString(i));
        }
    }

    public void testInsertValues() throws SQLException {
        int passCount = 0;
        for (int count = 1500; count <= 1700 && !this.insertValues(count); count += 200) {
            passCount = count;
        }
        largeCodeGen.assertEquals((String)"INSERT VALUES change from previous limit", (int)1700, (int)passCount);
    }

    private boolean insertValues(int rowCount) throws SQLException {
        Random r = new Random(3457245435L);
        StringBuffer insertSQL = new StringBuffer("INSERT INTO T0(SI,I,BI,R,F,D,N5_2,DEC10_3,CH20,VC,LVC) VALUES\n");
        for (int i = 0; i < rowCount; ++i) {
            if (i != 0) {
                insertSQL.append(',');
            }
            insertSQL.append('(');
            insertSQL.append((short)r.nextInt());
            insertSQL.append(',');
            insertSQL.append(i);
            insertSQL.append(',');
            insertSQL.append(r.nextLong());
            insertSQL.append(',');
            insertSQL.append(r.nextFloat());
            insertSQL.append(',');
            insertSQL.append(r.nextFloat());
            insertSQL.append(',');
            insertSQL.append(r.nextDouble());
            insertSQL.append(',');
            insertSQL.append("462.54");
            insertSQL.append(',');
            insertSQL.append("9324324.34");
            insertSQL.append(',');
            insertSQL.append('\'');
            insertSQL.append("c");
            insertSQL.append(r.nextInt() % 10);
            insertSQL.append('\'');
            insertSQL.append(',');
            insertSQL.append('\'');
            insertSQL.append("vc");
            insertSQL.append(r.nextInt() % 1000000);
            insertSQL.append('\'');
            insertSQL.append(',');
            insertSQL.append('\'');
            insertSQL.append("lvc");
            insertSQL.append(r.nextInt());
            insertSQL.append('\'');
            insertSQL.append(')');
            insertSQL.append('\n');
        }
        try {
            PreparedStatement ps = this.prepareStatement(insertSQL.toString());
            largeCodeGen.assertEquals((String)"Incorrect update count", (int)rowCount, (int)ps.executeUpdate());
            ps.close();
            this.rollback();
            return false;
        }
        catch (SQLException e) {
            largeCodeGen.assertSQLState("42ZA0", e);
            return true;
        }
    }
}

