/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UniqueConstraintSetNullTest
extends BaseJDBCTestCase {
    public UniqueConstraintSetNullTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("UniqueConstraintSetNullTest");
        suite.addTest(TestConfiguration.embeddedSuite(UniqueConstraintSetNullTest.class));
        return suite;
    }

    protected void setUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table constraintest (val1 varchar (20) not null, val2 varchar (20))");
    }

    protected void tearDown() throws Exception {
        this.dropTable("constraintest");
        this.commit();
        super.tearDown();
    }

    public void testUpdateNullablity() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement ps = this.prepareStatement("insert into constraintest (val1) values (?)");
        ps.setString(1, "name1");
        ps.executeUpdate();
        try {
            ps.setString(1, "name1");
            ps.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException e) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", e);
        }
        try {
            ps.setNull(1, 12);
            ps.executeUpdate();
            UniqueConstraintSetNullTest.fail((String)"null value in not null field!!");
        }
        catch (SQLException e) {
            UniqueConstraintSetNullTest.assertSQLState("null value in non null field", "23502", e);
        }
        stmt.executeUpdate("alter table constraintest alter column val1 null");
        ps.setNull(1, 12);
        ps.executeUpdate();
        ps.setNull(1, 12);
        ps.executeUpdate();
        try {
            ps.setString(1, "name1");
            ps.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException e) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", e);
        }
        stmt.executeUpdate("delete from constraintest where val1 is null");
        stmt.executeUpdate("alter table constraintest alter column val1 not null");
        try {
            ps.setString(1, "name1");
            ps.execute();
            UniqueConstraintSetNullTest.fail((String)"duplicate key in unique constraint!!!");
        }
        catch (SQLException e) {
            UniqueConstraintSetNullTest.assertSQLState("duplicate key in unique constraint", "23505", e);
        }
        try {
            ps.setNull(1, 12);
            ps.executeUpdate();
            UniqueConstraintSetNullTest.fail((String)"null value in not null field!!");
        }
        catch (SQLException e) {
            UniqueConstraintSetNullTest.assertSQLState("null value in non null field", "23502", e);
        }
    }
}

