/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UnaryArithmeticParameterTest
extends BaseJDBCTestCase {
    public UnaryArithmeticParameterTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (!JDBC.vmSupportsJDBC3()) {
            return new TestSuite("empty UnaryArithmeticParameterTest - supported only from JDBC3.0 and above");
        }
        return TestConfiguration.defaultSuite(UnaryArithmeticParameterTest.class);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t1 (c11 int, c12 smallint, c13 double, c14 char(3))");
        stmt.execute("insert into t1 values(1,1,1.1,'abc')");
        stmt.execute("insert into t1 values(-1,-1,-1.0,'def')");
        stmt.execute("create table t2 (c21 int)");
        stmt.execute("insert into t2 values (-1),(-2)");
        stmt.close();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("drop table t1");
        stmt.executeUpdate("drop table t2");
        stmt.close();
        this.commit();
        super.tearDown();
    }

    public void testParametersForUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("insert into t1 values(?,+?,-?,?)");
        ps.setInt(1, 3);
        ps.setInt(2, 3);
        ps.setDouble(3, -3.1);
        ps.setString(4, "ghi");
        int[] expectedTypes = new int[]{4, 5, 8, 1};
        JDBC.assertParameterTypes(ps, expectedTypes);
        ps.executeUpdate();
        ps.setInt(1, -1);
        ps.setInt(2, -1);
        ps.setDouble(3, 1.0);
        ps.setString(4, "jkl");
        ps.executeUpdate();
        ps = this.prepareStatement("select * from t1 where -? in (select c21 from t2)");
        ps.setInt(1, 1);
        expectedTypes = new int[]{4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}, {new Integer(3), new Integer(3), new Double(3.1), new String("ghi")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("jkl")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where c11 = -? and c12 = +? and c13 = ?");
        ps.setInt(1, -1);
        ps.setInt(2, 1);
        ps.setDouble(3, 1.1);
        expectedTypes = new int[]{4, 5, 8};
        JDBC.assertParameterTypes(ps, expectedTypes);
        expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.setShort(1, (short)1);
        ps.setInt(2, -1);
        ps.setInt(3, -1);
        expectedRows = new Object[][]{{new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("jkl")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
    }

    public void testABSWithUnaryMinusAndPlus() throws Exception {
        Statement s = this.createStatement();
        s.execute("CREATE FUNCTION ABS_FUNCT(P1 INT) RETURNS INT CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement ps = this.prepareStatement("select * from t1 where -? = abs_funct(+?)");
        ps.setInt(1, -1);
        ps.setInt(2, 1);
        int[] expectedTypes = new int[]{4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
        s.execute("Drop function ABS_FUNCT");
        s.close();
    }

    public void testMAXWithUnaryMinusAndPlus() throws Exception {
        Statement s = this.createStatement();
        s.execute("CREATE FUNCTION MAX_CNI(P1 INT, P2 INT) RETURNS INT CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.Math.max' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement ps = this.prepareStatement("select * from t1 where -? = max_cni(-5,-1)");
        ps.setInt(1, 1);
        int[] expectedTypes = new int[]{4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where -? = max_cni(-?,+?)");
        ps.setInt(1, -1);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        expectedTypes = new int[]{4, 4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where -? = max_cni(abs(-?), sqrt(+?))");
        ps.setInt(1, -2);
        ps.setInt(2, 1);
        ps.setInt(3, 4);
        expectedTypes = new int[]{4, 8, 8};
        JDBC.assertParameterTypes(ps, expectedTypes);
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
        s.execute("Drop function MAX_CNI");
        s.close();
    }

    public void testBETWEENWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select * from t1 where c11 between -? and +?");
        ps.setInt(1, -1);
        ps.setInt(2, 1);
        int[] expectedTypes = new int[]{4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
    }

    public void testNOTINWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select * from t1 where +? not in (-?, +?, 2, ?)");
        ps.setInt(1, -11);
        ps.setInt(2, 1);
        ps.setInt(3, 1);
        ps.setInt(4, 4);
        int[] expectedTypes = new int[]{4, 4, 4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}, {new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where -? not in (select c21+? from t2)");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        expectedTypes = new int[]{4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
    }

    public void testOperatorsWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select * from t1 where +? < c12");
        ps.setInt(1, 0);
        int[] expectedTypes = new int[]{5};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer(1), new Integer(1), new Double(1.1), new String("abc")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where -? = c11 + ?");
        ps.setInt(1, 2);
        ps.setInt(2, -1);
        expectedTypes = new int[]{4, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        expectedRows = new Object[][]{{new Integer(-1), new Integer(-1), new Double(-1.0), new String("def")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where c11 + ? = -?");
        ps.setInt(1, -1);
        ps.setInt(2, 2);
        JDBC.assertParameterTypes(ps, expectedTypes);
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps = this.prepareStatement("select * from t1 where c11 + c12 = -?");
        ps.setInt(1, 2);
        expectedTypes = new int[]{4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
    }

    public void testCastWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select cast(-? as smallint), cast(+? as int) from t1");
        ps.setInt(1, 2);
        ps.setInt(2, 2);
        int[] expectedTypes = new int[]{5, 4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new String[][]{{"-2", "2"}, {"-2", "2"}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, true);
        ps.close();
    }

    public void testNullIfWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select nullif(-?,c11) from t1");
        ps.setInt(1, 22);
        int[] expectedTypes = new int[]{4};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new String("-22")}, {new String("-22")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, true);
        ps.close();
    }

    public void testSQRTWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select sqrt(-?) from t1");
        ps.setInt(1, -64);
        int[] expectedTypes = new int[]{8};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new String("8.0")}, {new String("8.0")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, true);
        ps.close();
    }

    public void testSelectWithUnaryMinusAndPlus() throws Exception {
        PreparedStatement ps = this.prepareStatement("select case when -?=c11 then -? else c12 end from t1");
        ps.setInt(1, 1);
        ps.setInt(2, 22);
        int[] expectedTypes = new int[]{4, 5};
        JDBC.assertParameterTypes(ps, expectedTypes);
        Object[][] expectedRows = new Object[][]{{new Integer("1")}, {new Integer("-22")}};
        JDBC.assertFullResultSet(ps.executeQuery(), expectedRows, false);
        ps.close();
    }

    public void testExpectedErrors() throws Exception {
        this.assertCompileError("42X34", "select * from t1 where c11 = any (select -? from t2)");
        this.assertCompileError("42X19", "select * from t1 where -? and c11=c11 or +?");
        this.assertCompileError("42X37", "select * from sys.systables where tablename like -? escape +?");
        this.assertCompileError("42X37", "select timestamp(-?,+?) from t1");
        this.assertCompileError("42X36", "select timestamp(-?) from t1");
        this.assertCompileError("42X98", "create view v1 as select * from t1 where c11 = -?");
        this.assertCompileError("42X37", "select * from t1 inner join t1 as t333 on -?");
        this.assertCompileError("42X19", "select * from t1 where -?");
        this.assertCompileError("42X37", "select * from t1 where -? is null");
        this.assertCompileError("42X35", "select * from t1 where c11 = ?/-?");
        this.assertCompileError("42X37", "select c11 || +? from t1");
        this.assertCompileError("42X37", "select * from t1 where c14 = -?");
        this.assertCompileError("42X37", "select * from t1 where c14 like +?");
    }
}

