/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class SubqueryTest
extends BaseJDBCTestCase {
    public SubqueryTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties props = new Properties();
        props.setProperty("derby.language.statementCacheSize", "0");
        return new DatabasePropertyTestSetup((Test)new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup((Test)new TestSuite(SubqueryTest.class, "SubqueryTest")){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE FUNCTION ConsistencyChecker() RETURNS VARCHAR(128) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.runConsistencyChecker' LANGUAGE JAVA PARAMETER STYLE JAVA");
                s.execute("create table s (i int, s smallint, c char(30), vc char(30), b bigint)");
                s.execute("create table t (i int, s smallint, c char(30), vc char(30), b bigint)");
                s.execute("create table tt (ii int, ss smallint, cc char(30), vcvc char(30), b bigint)");
                s.execute("create table ttt (iii int, sss smallint, ccc char(30), vcvcvc char(30))");
                s.execute("insert into s values (null, null, null, null, null)");
                s.execute("insert into s values (0, 0, '0', '0', 0)");
                s.execute("insert into s values (1, 1, '1', '1', 1)");
                s.execute("insert into t values (null, null, null, null, null)");
                s.execute("insert into t values (0, 0, '0', '0', 0)");
                s.execute("insert into t values (1, 1, '1', '1', 1)");
                s.execute("insert into t values (1, 1, '1', '1', 1)");
                s.execute("insert into t values (2, 2, '2', '2', 1)");
                s.execute("insert into tt values (null, null, null, null, null)");
                s.execute("insert into tt values (0, 0, '0', '0', 0)");
                s.execute("insert into tt values (1, 1, '1', '1', 1)");
                s.execute("insert into tt values (1, 1, '1', '1', 1)");
                s.execute("insert into tt values (2, 2, '2', '2', 1)");
                s.execute("insert into ttt values (null, null, null, null)");
                s.execute("insert into ttt values (11, 11, '11', '11')");
                s.execute("insert into ttt values (11, 11, '11', '11')");
                s.execute("insert into ttt values (22, 22, '22', '22')");
            }
        }, props), props, true);
    }

    public void testExistsNonCorrelated() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        SubqueryTest.assertStatementError("42X10", st, "select * from s where exists (select tt.* from t)");
        SubqueryTest.assertStatementError("42X10", st, "select * from s where exists (select t.* from t tt)");
        SubqueryTest.assertStatementError("42X04", st, "select * from s where exists (select nosuchcolumn from t)");
        SubqueryTest.assertStatementError("42X03", st, "select * from s where exists (select i from s, t)");
        SubqueryTest.assertStatementError("42X34", st, "select * from s where exists (select ? from s)");
        rs = st.executeQuery("select * from s where exists (select s.* from t)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s t where exists (select t.* from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s u where exists (select u.* from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select i from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select t.i from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select i, s from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select * from t where i = -1)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where exists (select t.* from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select 0 from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from (select * from s where exists (select * from t) and i = 0) a");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where 0=1 or exists (select * from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where 1=1 or exists (select * from t where 0=1)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select * from t where 0=1) or exists (select * from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from s where exists (select * from t where exists (select * from t where 0=1) or exists (select * from t))");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (exists (select * from t where 0=1)) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where not exists (select * from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where not exists (select * from t where i = -1)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs.close();
        st.close();
    }

    public void testExpressionNonCorrelated() throws Exception {
        Object[][] expRS;
        Statement st = this.createStatement();
        ResultSet rs = null;
        SubqueryTest.assertStatementError("42X38", st, "select * from s where i = (select * from t)");
        SubqueryTest.assertStatementError("42X39", st, "select * from s where i = (select i, s from t)");
        SubqueryTest.assertStatementError("21000", st, "select * from s where i = (select 1 from t)");
        SubqueryTest.assertStatementError("21000", st, "select * from s where i = (select b from t)");
        SubqueryTest.assertStatementError("42X34", st, "select * from s where i = (select ? from t)");
        rs = st.executeQuery("values ConsistencyChecker()");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        SubqueryTest.assertStatementError("21000", st, "select * from s where i = (select i from t)");
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        SubqueryTest.assertStatementError("21000", st, "select * from s where s = (select s from t where s = 1)");
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        if (SubqueryTest.usingEmbedded()) {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        } else {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        }
        SubqueryTest.assertStatementError("21000", st, "update s set b = (select max(b) from t) where vc <> (select vc from t where vc = '1')");
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        if (SubqueryTest.usingEmbedded()) {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        } else {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        }
        SubqueryTest.assertStatementError("21000", st, "delete from s where c = (select c from t where c = '1')");
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        if (SubqueryTest.usingEmbedded()) {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        } else {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        }
        rs = st.executeQuery("select * from s");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from t");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1"}, {"2", "2", "2", "2", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSimpleSubquery() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where i = (select i from t where i = 0)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where s = (select s from t where s = 0)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where c = (select c from t where c = '0')");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where vc = (select vc from t where vc = '0')");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where b = (select max(b) from t where b = 0)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where b = (select max(b) from t where i = 2)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testParameterOnLeft() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        PreparedStatement pSt = this.prepareStatement("select * from s where ? = (select i from t where i = 0)");
        rs = st.executeQuery("values (0)");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            pSt.setObject(i, rs.getObject(i));
        }
        rs = pSt.executeQuery();
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testConversions() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where i = (select s from t where s = 0)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where s = (select i from t where i = 0)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where c = (select vc from t where vc = '0')");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where vc = (select c from t where c = '0')");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testClone() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where (select s from s where i is null) is null");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (select i from s where i is null) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (select c from s where i is null) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (select vc from s where i is null) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (select b from s where i is null) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where (select 1 from t where exists (select * from t where 1 = 0) and s = -1) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSubqueryInSubquery() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where (select i from t where i = 0) = (select s from t where s = 0)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i = (select s from t where s = 0) and s = (select i from t where i = 2)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where i = (select s from t where s = 0) and s = (select i from t where i = 0)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i = (select i from t where s = (select i from t where s = 2))");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where i = (select i - 1 from t where s = (select i from t where s = 2))");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSubqueriesInSelect() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select (select i from t where 0=1) from s");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null}, {null}, {null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select (select i from t where i = 2) * (select s from t where i = 2) from s where i > (select i from t where i = 0) - (select i from t where i = 0)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("42X38", st, "select * from s where s in (select * from s)");
        rs = st.executeQuery("select * from s where s in (select b from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testConstants() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where 1 in (select s from t)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where -1 in (select i from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where '1' in (select vc from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where 0 in (select b from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i in (select 1 from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i in (select -1 from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where c in (select '1' from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where b in (select 0 from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where 0 in (select 0 from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where c in (select vc from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where vc in (select c from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i in (select s from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where s in (select i from t)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testEmptyResultSet() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where i in (select i from t where 1 = 0)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where (i in (select i from t where i = 0)) is null");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
    }

    public void testSubqueriesInSelectList() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select ( i in (select i from t) ) a from s order by a");
        String[] expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"false"}, {"true"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select ( i in (select i from t where 1 = 0) ) a from s order by a");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select ( (i in (select i from t where 1 = 0)) is null ) a from s order by a");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSubqueryUnderOR() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i from s where i = -1 or i in (select i from t)");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from s where i = 0 or i in (select i from t where i = -1)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from s where i = -1 or i in (select i from t where i = -1 or i = 1)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testDistinct() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i from s where i in (select i from s)");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from s where i in (select distinct i from s)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from s ss where i in (select i from s where s.i = ss.i)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select i from s ss where i in (select distinct i from s where s.i = ss.i)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        if (SubqueryTest.usingEmbedded()) {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        } else {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        }
    }

    public void testMatches() throws Exception {
        Statement st = this.createStatement();
        SubqueryTest.assertStatementError("42X03", st, "select * from s, t where exists (select i from tt)");
        SubqueryTest.assertStatementError("42X04", st, "select * from s ss (c1, c2, c3, c4, c5) where exists (select i from tt)");
        SubqueryTest.assertStatementError("42X04", st, " select * from s ss (c1, c2, c3, c4, c5) where exists (select ss.i from tt)");
        SubqueryTest.assertStatementError("42X04", st, "select * from s where exists (select s.i from tt s)");
        SubqueryTest.assertStatementError("42X04", st, "select * from s where exists (select * from tt) and exists (select ii from t)");
        SubqueryTest.assertStatementError("42X04", st, " select * from s where exists (select * from tt) and exists (select tt.ii from t)");
        SubqueryTest.assertStatementError("42X04", st, "select * from s, (select * from tt where i = ii) a");
        SubqueryTest.assertStatementError("42X04", st, " select * from s, (select * from tt where s.i = ii) a");
    }

    public void testSimpleCorrelated() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select (select i from tt where ii = i and ii <> 1) from s");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null}, {"0"}, {null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select (select s.i from tt where ii = s.i and ii <> 1) from s");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0"}, {null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select (select s.i from ttt where iii = i) from s");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {null}, {null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select * from tt where i = ii and ii <> 1)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select * from tt where s.i = ii and ii <> 1)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where exists (select * from ttt where i = iii)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        try {
            rs = st.executeQuery("select (select i from tt where ii = i) from s");
        }
        catch (SQLException sqle) {
            BaseJDBCTestCase.assertSQLState("Scalar subquery is only allowed to return a single row.", "21000", sqle);
        }
        rs = st.executeQuery("select * from s where exists (select * from ttt where iii = (select 11 from tt where ii = i and ii <> 1))");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testJoinInSubqueries() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where i in (select i from t, tt where s.i <> i and i = ii)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from s where i in (select i from t, ttt where s.i < iii and s.i = t.i)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select s.i, t.i from s, t where exists (select * from ttt where iii = 1)");
        expColNames = new String[]{"I", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select s.i, t.i from s, t where exists (select * from ttt where iii = 11)");
        expColNames = new String[]{"I", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null}, {null, "0"}, {null, "1"}, {null, "1"}, {null, "2"}, {"0", null}, {"0", "0"}, {"0", "1"}, {"0", "1"}, {"0", "2"}, {"1", null}, {"1", "0"}, {"1", "1"}, {"1", "1"}, {"1", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select s.i, t.i from s, t where t.i = (select iii from ttt, tt where iii = t.i)");
        expColNames = new String[]{"I", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select s.i, t.i from s, t where t.i = (select ii from ttt, tt where s.i = t.i and t.i = tt.ii and iii = 22 and ii <> 1)");
        expColNames = new String[]{"I", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSubqueriesInPS() throws Exception {
        int i;
        Statement st = this.createStatement();
        ResultSet rs = null;
        PreparedStatement pSt = this.prepareStatement("select s.i from s where s.i in (select s.i from s, t where s.i = t.i and t.s = ?)");
        rs = st.executeQuery("values(0)");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (i = 1; i <= rsmd.getColumnCount(); ++i) {
            pSt.setObject(i, rs.getObject(i));
        }
        rs = pSt.executeQuery();
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values(1)");
        rs.next();
        rsmd = rs.getMetaData();
        for (i = 1; i <= rsmd.getColumnCount(); ++i) {
            pSt.setObject(i, rs.getObject(i));
        }
        rs = pSt.executeQuery();
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.setAutoCommit(false);
        pSt = this.prepareStatement("select s.i from s where s.i in (select s.i from s, t where s.i = t.i and t.s = 3)");
        rs = pSt.executeQuery();
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        this.setAutoCommit(false);
        st.executeUpdate("insert into t(i,s) values(1,3)");
        rs = pSt.executeQuery();
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
    }

    public void testSubuqeryInSelectListOfDerivedTable() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from (select (select iii from ttt where  sss > i and sss = iii and iii <> 11) from s) a");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null}, {"22"}, {"22"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table li(i int, s smallint, l bigint)");
        st.executeUpdate("insert into li values (null, null, null)");
        st.executeUpdate("insert into li values (1, 1, 1)");
        st.executeUpdate("insert into li values (2, 2, 2)");
        rs = st.executeQuery("select l from li o where l = (select i from li i where o.l = i.i)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select l from li o where l = (select s from li i where o.l = i.s)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select l from li o where l = (select l from li i where o.l = i.l)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select l from li where l in (select i from li)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select l from li where l in (select s from li)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select l from li where l in (select l from li)");
        expColNames = new String[]{"L"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testSubqueryFlattening() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select i in (1,2) from (select i from s) as tmp(i)");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("42X01", st, "select i = 1 ? 1 : i from (select i from s) as tmp(i)");
        rs = st.executeQuery("select * from s where i = (values i)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t.* from s, t where t.i = (values s.i)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from s where i in (values i)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select t.* from s, t where t.i in (values s.i)");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testNoNeedForCardinalityCheck() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select * from s where i = (select min(i) from s where i is not null)");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", "0", "0", "0", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("21000", st, "select * from s where i = (select min(i) from s group by i)");
        st.executeUpdate("create table dist1 (c1 int)");
        st.executeUpdate("create table dist2 (c1 int)");
        st.executeUpdate("insert into dist1 values null, 1, 2");
        st.executeUpdate("insert into dist2 values null, null");
        rs = st.executeQuery("select * from dist1 where c1 = (select distinct c1 from dist2)");
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("insert into dist2 values 1");
        SubqueryTest.assertStatementError("21000", st, "select * from dist1 where c1 = (select distinct c1 from dist2)");
        SubqueryTest.assertUpdateCount(st, 3, "update dist2 set c1 = 2");
        rs = st.executeQuery("select * from dist1 where c1 = (select distinct c1 from dist2)");
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table dist1");
        st.executeUpdate("drop table dist2");
        st.executeUpdate("create table u (i int, s smallint, c char(30), vc char(30), b bigint)");
        st.executeUpdate("insert into u select * from s");
        rs = st.executeQuery("select * from u");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("42821", st, "update u set b = exists (select b from t) where vc <> (select vc from s where vc = '1')");
        rs = st.executeQuery("select * from u");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertUpdateCount(st, 3, "delete from u");
        st.executeUpdate("insert into u select * from s");
        SubqueryTest.assertUpdateCount(st, 2, "delete from u where c < (select c from t where c = '2')");
        rs = st.executeQuery("select * from u");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertUpdateCount(st, 1, "delete from u");
        st.executeUpdate("insert into u select * from s");
    }

    public void testErrorsInNestedSubqueries() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        SubqueryTest.assertStatementError("22012", st, "insert into u select * from s s_outer where i = (select s_inner.i/(s_inner.i-1) from s s_inner where s_outer.i = s_inner.i)");
        rs = st.executeQuery("select * from u");
        String[] expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("22012", st, "delete from u where i = (select i/(i-1) from s where u.i = s.i)");
        rs = st.executeQuery("select * from u");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("22012", st, "update u  set i = (select i from s where u.i = s.i) where i = (select i/(i-1) from s where u.i = s.i)");
        SubqueryTest.assertStatementError("22012", st, "update u  set i = (select i/i-1 from s where u.i = s.i) where i = (select i from s where u.i = s.i)");
        rs = st.executeQuery("select * from u");
        expColNames = new String[]{"I", "S", "C", "VC", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, null, null, null, null}, {"0", "0", "0", "0", "0"}, {"1", "1", "1", "1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SubqueryTest.assertStatementError("21000", st, "select (select (select (select i from s) from s) from s) from s");
        rs = st.executeQuery("values ConsistencyChecker()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        if (SubqueryTest.usingEmbedded()) {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        } else {
            expRS = new String[][]{{"No open scans, etc.\n16 dependencies found"}};
            JDBC.assertFullResultSet(rs, expRS, true);
        }
        this.setAutoCommit(true);
    }

    public void testSubqueryWithClause() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        rs = st.executeQuery("select distinct vc, i from t as myt1 where s <= (select max(myt1.s) from t as myt2 where myt1.vc = myt2.vc and myt1.s <= myt2.s group by s having count(distinct s) <= 3)");
        String[] expColNames = new String[]{"VC", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0", "0"}, {"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select distinct vc, i from t as myt1 where s <= (select max(myt1.s) from t as myt2 where myt1.vc = myt2.vc and myt1.s <= myt2.s having count(distinct s) <= 3)");
        expColNames = new String[]{"VC", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0"}, {"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    public void testDERBY1007() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        st.executeUpdate("create table t_1 (i int, j int)");
        st.executeUpdate("insert into T_1 values (1,1), (2,2), (3,3), (4,4), (5,5)");
        st.executeUpdate("create table t_3 (a int, b int)");
        st.executeUpdate("insert into T_3 values (1,1), (2,2), (3,3), (4,4)");
        st.executeUpdate("insert into t_3 values (6, 24), (7, 28), (8, 32), (9, 36), (10, 40)");
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        rs = st.executeQuery("select x1.j, x2.b from (select distinct i,j from t_1) x1, (select distinct a,b from t_3) x2 where x1.i = x2.a order by x1.j, x2.b");
        String[] expColNames = new String[]{"J", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        rs.next();
        String rts = rs.getString(1);
        RuntimeStatisticsParser rtsp = new RuntimeStatisticsParser(rts);
        SubqueryTest.println("full stats: \n" + rtsp.toString());
        rtsp.assertSequence(new String[]{"Source result set:", "_Project-Restrict ResultSet (5):", "_Source result set:", "__Hash Join ResultSet:", "__Left result set:", "___Distinct Scan ResultSet for T_1 at read committed isolation level using instantaneous share row locking:", "____Bit set of columns fetched=All", "____Scan type=heap", "__Right result set:", "___Hash Table ResultSet (4):", "___Source result set:", "____Distinct Scan ResultSet for T_3 at read committed isolation level using instantaneous share row locking:", "_____Bit set of columns fetched=All", "_____Scan type=heap"});
        st.executeUpdate("drop table t_1");
        st.executeUpdate("drop table t_3");
    }

    public void testDERBY781() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        st.executeUpdate("create table t1 (i int, j int)");
        st.executeUpdate("create table t2 (i int, j int)");
        st.executeUpdate("insert into t1 values (1,1), (2,2), (3,3), (4,4), (5,5)");
        st.executeUpdate("insert into t2 values (1,1), (2,2), (3,3), (4,4), (5,5)");
        st.executeUpdate("create table t3 (a int, b int)");
        st.executeUpdate("create table t4 (a int, b int)");
        st.executeUpdate("insert into t3 values (2,2), (4,4), (5,5)");
        st.executeUpdate("insert into t4 values (2,2), (4,4), (5,5)");
        st.executeUpdate("create view V1 as select distinct T1.i, T2.j from T1, T2 where T1.i = T2.i");
        st.executeUpdate("create view V2 as select distinct T3.a, T4.b from T3, T4 where T3.a = T4.a");
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        rs = st.executeQuery("select * from V1, V2 where V1.j = V2.b and V1.i in (1,2,3,4,5)");
        String[] expColNames = new String[]{"I", "J", "A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"2", "2", "2", "2"}, {"4", "4", "4", "4"}, {"5", "5", "5", "5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        rs.next();
        String rts = rs.getString(1);
        RuntimeStatisticsParser rtsp = new RuntimeStatisticsParser(rts);
        SubqueryTest.println("full stats: \n" + rtsp.toString());
        rtsp.assertSequence(new String[]{"Hash Join ResultSet:", "Right result set:", "_Hash Table ResultSet (13):"});
        SubqueryTest.assertTrue((boolean)rtsp.findString("Right result set:", 3));
        SubqueryTest.assertTrue((boolean)rtsp.findString("Hash Scan ResultSet for T4 at read committed isolation level using instantaneous share row locking: ", 1));
        st.executeUpdate("insert into t1 select * from t2");
        st.executeUpdate("insert into t2 select * from t1");
        st.executeUpdate("insert into t2 select * from t1");
        st.executeUpdate("insert into t1 select * from t2");
        st.executeUpdate("insert into t2 select * from t1");
        st.executeUpdate("insert into t1 select * from t2");
        st.executeUpdate("insert into t2 select * from t1");
        st.executeUpdate("insert into t1 select * from t2");
        st.executeUpdate("insert into t2 select * from t1");
        st.executeUpdate("insert into t1 select * from t2");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("insert into t4 select * from t3");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("insert into t4 select * from t3");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("insert into t4 select * from t3");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("insert into t4 select * from t3");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("insert into t4 select * from t3");
        st.executeUpdate("insert into t3 select * from t4");
        st.executeUpdate("drop view v1");
        st.executeUpdate("drop view v2");
        st.executeUpdate("create view VV1 as select distinct T1.i, T2.j from T1, T2 where T1.i = T2.i");
        st.executeUpdate("create view VV2 as select distinct T3.a, T4.b from T3, T4 where T3.a = T4.a");
        rs = st.executeQuery("select * from VV1, VV2 where VV1.j = VV2.b and VV1.i in (1,2,3,4,5)");
        expColNames = new String[]{"I", "J", "A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2", "2", "2", "2"}, {"4", "4", "4", "4"}, {"5", "5", "5", "5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        rs.next();
        rts = rs.getString(1);
        rtsp = new RuntimeStatisticsParser(rts);
        SubqueryTest.println("full stats: \n" + rtsp.toString());
        rtsp.assertSequence(new String[]{"Hash Join ResultSet:", "_Rows input = 53055", "____Right result set:", "_____Hash Scan ResultSet for T3 at read committed isolation level using instantaneous share row locking: "});
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        st.executeUpdate("drop view vv1");
        st.executeUpdate("drop view vv2");
        st.executeUpdate("drop table t1");
        st.executeUpdate("drop table t2");
        st.executeUpdate("drop table t3");
        st.executeUpdate("drop table t4");
    }

    public void testSubqueryInCOALESCE() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        st.executeUpdate("create table t1 (id int)");
        st.executeUpdate("create table t2 (i integer primary key, j int)");
        st.executeUpdate("insert into t1 values 1,2,3,4,5");
        st.executeUpdate("insert into t2 values (1,1),(2,4),(3,9),(4,16)");
        SubqueryTest.assertUpdateCount(st, 5, "update t1 set id = coalesce((select j from t2 where t2.i=t1.id), 0)");
        rs = st.executeQuery("select * from t1");
        String[] expColNames = new String[]{"ID"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"4"}, {"9"}, {"16"}, {"0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table t1");
        st.executeUpdate("drop table t2");
    }

    public void testDERBY_2218() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        st.executeUpdate("create table t1 (i int)");
        rs = st.executeQuery("select * from t1 where i in (1, 2, (values cast(null as integer)))");
        String[] expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where i in (1, 2, (values null))");
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where i in (select i from t1 where i in (1, 2, (values null)))");
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where exists (values null)");
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where exists (select * from t1 where exists(values null))");
        SubqueryTest.assertStatementError("42X07", st, "select i from t1 where exists (select i from t1 where exists(values null))");
        SubqueryTest.assertStatementError("42X07", st, "select * from (values null) as t2");
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where exists (select 1 from (values null) as t2)");
        SubqueryTest.assertStatementError("42X07", st, "select * from t1 where exists (select * from (values null) as t2)");
        st.executeUpdate("drop table t1");
        st.close();
    }

    public void testDERBY_4549() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs = null;
        st.executeUpdate("create table ABC (ID int)");
        st.executeUpdate("create table DEF (ID int)");
        PreparedStatement pSt = this.prepareStatement("select * from ABC t1 where (select distinct t2.ID from DEF t2) in (select t3.ID from DEF t3)");
        rs = pSt.executeQuery();
        String[] expColNames = new String[]{"ID"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("insert into ABC values 1, 2");
        rs = pSt.executeQuery();
        expColNames = new String[]{"ID"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("insert into DEF values 2");
        rs = pSt.executeQuery();
        expColNames = new String[]{"ID"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("insert into DEF values 2");
        rs = pSt.executeQuery();
        expColNames = new String[]{"ID"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("insert into DEF values 3");
        SubqueryTest.assertStatementError("21000", pSt);
        st.executeUpdate("drop table ABC");
        st.executeUpdate("drop table DEF");
    }
}

