/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.DummyBinary;
import org.apache.derbyTesting.functionTests.tests.lang.DummyReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class StreamsTest
extends BaseJDBCTestCase {
    private int pkCount;

    public StreamsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite test = new TestSuite(StreamsTest.class, "StreamsTest");
        test = DatabasePropertyTestSetup.singleProperty((Test)test, "derby.storage.pageSize", "2048");
        return new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table t1 (id int, pid int, lvc long varchar, lvb long varchar for bit data)");
                s.executeUpdate("create table t2 (id int, pid int, lvc long varchar, lvb long varchar for bit data)");
                s.executeUpdate("create trigger tr21 after insert on t2 for each statement values 1");
                s.executeUpdate("create table t3 (id int not null primary key, pid int, lvc long varchar, lvb long varchar for bit data, CONSTRAINT FK1 Foreign Key(pid) REFERENCES T3 (id))");
                s.executeUpdate("create table t4 (id int, longcol long varchar)");
                s.executeUpdate("create table t5 (id int, longcol long varchar)");
            }
        };
    }

    public void testStreams() throws Exception {
        int i;
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into  t1 values(?, ?, ?,?)");
        int level1 = this.insertLongString(ps, 8, true);
        ps.close();
        ps = this.prepareStatement("insert into  t2 values(?, ?, ?,?)");
        int level2 = this.insertLongString(ps, 8, true);
        StreamsTest.assertEquals((String)"FAILED!! level difference not expected since streams are materialized.", (int)level1, (int)level2);
        ps.close();
        ps = this.prepareStatement("insert into  t3 values(?, ?, ?,?)");
        int level3 = this.insertLongString(ps, 8, true);
        ps.close();
        StreamsTest.assertEquals((String)"FAILED!! should not materialize in this case.", (int)level3, (int)level1);
        this.rollback();
        s.executeUpdate("insert into t3 values (1,1,'a',null),(2,2,'b',null), (3,3,'c',null)");
        ps = this.prepareStatement("update t3 set id = ?, lvc = ? where pid = 2");
        level1 = this.insertLongString(ps, 8, false);
        ps.close();
        ps = this.prepareStatement("update t3 set id = ?, lvc = ? where pid = 2 and id = 2");
        level2 = this.insertLongString(ps, 8, false);
        ps.close();
        StreamsTest.assertEquals((String)"FAILED!! level difference not expected because streams are materialized with fix for bug 5592.", (int)level1, (int)level2);
        s.executeUpdate("insert into t4 values (1, 'ccccc')");
        ps = this.prepareStatement("insert into t4 values(?, ?)");
        this.insertLongString(ps, 6, false);
        s.executeUpdate("insert into t4 values (3, 'abbb')");
        s.executeUpdate("insert into t4 values (4, 'bbbbbb')");
        this.insertLongString(ps, 5, false);
        ps.close();
        ResultSet rs = s.executeQuery("select id, cast(longcol as varchar(8192)) lcol from t4 order by lcol");
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)3, (int)rs.getInt(1));
        StreamsTest.assertEquals((String)"abbb", (String)rs.getString(2));
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)4, (int)rs.getInt(1));
        StreamsTest.assertEquals((String)"bbbbbb", (String)rs.getString(2));
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)2, (int)rs.getInt(1));
        String col2 = rs.getString(2);
        StreamsTest.assertNotNull((Object)col2);
        StreamsTest.assertEquals((int)5393, (int)col2.length());
        for (i = 0; i < col2.length(); ++i) {
            StreamsTest.assertEquals((char)'b', (char)col2.charAt(i));
        }
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)2, (int)rs.getInt(1));
        col2 = rs.getString(2);
        StreamsTest.assertNotNull((Object)col2);
        StreamsTest.assertEquals((int)6417, (int)col2.length());
        for (i = 0; i < col2.length(); ++i) {
            StreamsTest.assertEquals((char)'b', (char)col2.charAt(i));
        }
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)1, (int)rs.getInt(1));
        StreamsTest.assertEquals((String)"ccccc", (String)rs.getString(2));
        StreamsTest.assertFalse((boolean)rs.next());
        rs.close();
        s.executeUpdate("insert into t5 values (1, 'bbbbbb')");
        ps = this.prepareStatement("insert into t5 values(?, ?)");
        this.insertLongString(ps, 5, false);
        this.insertLongString(ps, 7, false);
        ps.close();
        s.executeUpdate("insert into t5 values (3, 'aaaaabbbbbba')");
        s.executeUpdate("insert into t5 values (4, 'bbbbbbbbb')");
        rs = s.executeQuery("select t4.id, t4.longcol, t5.id, cast(t5.longcol as varchar(8192)) lcol from t4, t5 where cast(t4.longcol as varchar(8192)) = cast(t5.longcol as varchar(8192)) order by lcol");
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)4, (int)rs.getInt(1));
        StreamsTest.assertEquals((int)6, (int)rs.getString(2).length());
        StreamsTest.assertEquals((int)1, (int)rs.getInt(3));
        StreamsTest.assertEquals((int)6, (int)rs.getString(4).length());
        StreamsTest.assertTrue((boolean)rs.next());
        StreamsTest.assertEquals((int)2, (int)rs.getInt(1));
        StreamsTest.assertEquals((int)5393, (int)rs.getString(2).length());
        StreamsTest.assertEquals((int)2, (int)rs.getInt(3));
        StreamsTest.assertEquals((int)5393, (int)rs.getString(4).length());
        StreamsTest.assertFalse((boolean)rs.next());
        rs.close();
        this.rollback();
        ps = this.prepareStatement("insert into  t1 values(?, ?, ?,?)");
        level1 = this.insertLongBinary(ps, 8);
        ps.close();
        ps = this.prepareStatement("insert into  t2 values(?, ?, ?,?)");
        level2 = this.insertLongBinary(ps, 8);
        ps.close();
        StreamsTest.assertTrue((String)"FAILED, check stack level change.", (level1 > level2 + 5 ? 1 : 0) != 0);
        ps = this.prepareStatement("insert into  t3 values(?, ?, ?,?)");
        level3 = this.insertLongBinary(ps, 8);
        ps.close();
        StreamsTest.assertEquals((String)"FAILED!! should not materialize stream in this case.", (int)level3, (int)level1);
        s.close();
        this.rollback();
    }

    private int insertLongString(PreparedStatement ps, int kchars, boolean isInsert) throws SQLException {
        int chars = kchars * 1024 + 273;
        DummyReader dr = new DummyReader(chars);
        if (isInsert) {
            ps.setInt(1, this.pkCount);
            ps.setInt(2, this.pkCount++);
            ps.setCharacterStream(3, (Reader)dr, chars);
            ps.setNull(4, -3);
        } else {
            ps.setInt(1, 2);
            ps.setCharacterStream(2, (Reader)dr, chars);
        }
        ps.executeUpdate();
        return dr.readerStackLevel;
    }

    private int insertLongBinary(PreparedStatement ps, int kbytes) throws SQLException {
        int bytes = kbytes * 1024 + 273;
        ps.setInt(1, this.pkCount);
        ps.setInt(2, this.pkCount++);
        ps.setNull(3, -1);
        DummyBinary db = new DummyBinary(bytes);
        ps.setBinaryStream(4, (InputStream)db, bytes);
        ps.executeUpdate();
        return db.readerStackLevel;
    }
}

