/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class SelectivityTest
extends BaseJDBCTestCase {
    public SelectivityTest(String name) {
        super(name);
    }

    public void testSingleColumnSelectivity() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.executeQuery("select template.id from --DERBY-PROPERTIES joinOrder=fixed\ntest, template where test.two = template.two").close();
        SelectivityTest.checkEstimatedRowCount(conn, 8020012.5);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new TestSuite(SelectivityTest.class, "SelectivityTest")){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table two (x int)");
                s.executeUpdate("insert into two values (1),(2)");
                s.executeUpdate("create table ten (x int)");
                s.executeUpdate("insert into ten values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10)");
                s.executeUpdate("create table twenty (x int)");
                s.executeUpdate("insert into twenty values (1),(2),(3),(4),(5),(6),(7),(8),(9),(10),(11),(12),(13),(14),(15),(16),(17),(18),(19),(20)");
                s.executeUpdate("create table hundred (x int generated always as identity, dc int)");
                s.executeUpdate("insert into hundred (dc) select t1.x from ten t1, ten t2");
                s.executeUpdate("create table template (id int not null generated always as identity, two int, twenty int, hundred int)");
                s.executeUpdate("insert into template (two, twenty, hundred) select two.x, twenty.x, hundred.x from two, twenty, hundred");
                s.executeUpdate("create index template_two on template(two)");
                s.executeUpdate("create index template_twenty on template(twenty)");
                s.executeUpdate("create index template_22 on template(twenty,two)");
                s.executeUpdate("create unique index template_id on template(id)");
                s.executeUpdate("create index template_102 on template(hundred,two)");
                s.executeUpdate("create table test (id int, two int, twenty int, hundred int)");
                s.executeUpdate("create index test_id on test(id)");
                s.executeUpdate("insert into test select * from template");
                s.executeUpdate("create view showstats as select cast (conglomeratename as varchar(20)) indexname, cast (statistics as varchar(40)) stats, creationtimestamp createtime, colcount ncols from sys.sysstatistics, sys.sysconglomerates where conglomerateid = referenceid");
                ResultSet statsrs = s.executeQuery("select indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}});
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEMPLATE',null)");
                s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST',null)");
                statsrs = s.executeQuery("select  indexname, stats, ncols from showstats order by indexname, stats, createtime, ncols");
                JDBC.assertFullResultSet(statsrs, new String[][]{{"TEMPLATE_102", "numunique= 100 numrows= 4000", "1"}, {"TEMPLATE_102", "numunique= 200 numrows= 4000", "2"}, {"TEMPLATE_22", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_22", "numunique= 40 numrows= 4000", "2"}, {"TEMPLATE_TWENTY", "numunique= 20 numrows= 4000", "1"}, {"TEMPLATE_TWO", "numunique= 2 numrows= 4000", "1"}, {"TEST_ID", "numunique= 4000 numrows= 4000", "1"}});
            }
        };
    }
}

