/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class ResultSetsFromPreparedStatementTest
extends BaseJDBCTestCase {
    public static final Integer i1 = new Integer(1);
    public static final Integer i2 = new Integer(2);
    public static final Integer i3 = new Integer(3);
    public static final Integer i4 = new Integer(4);
    public static final Integer i5 = new Integer(5);
    public static final Integer i6 = new Integer(6);
    public static final Integer i7 = new Integer(7);
    public static final Integer i8 = new Integer(8);
    public static final Integer i9 = new Integer(9);
    public static final Integer i10 = new Integer(10);
    public static final Integer i11 = new Integer(11);
    public static final Integer i12 = new Integer(12);
    public static final Integer i13 = new Integer(13);
    public static final Integer i14 = new Integer(14);
    public static final Integer i15 = new Integer(15);
    public static final Integer i16 = new Integer(16);
    public static final Integer i17 = new Integer(17);
    public static final Integer i18 = new Integer(18);
    public static final Integer i19 = new Integer(19);
    public static final Integer i20 = new Integer(20);
    public static final String k55 = "K55";
    public static final String k52 = "K52";
    public static final String k51 = "K51";
    public static final String ashok = "ASHOK     ";
    public static final String john = "JOHN      ";
    public static final String robin = "ROBIN     ";
    public static final String joe1 = "JOE1      ";
    public static final String joe2 = "JOE2      ";
    public static final String hamid = "HAMID     ";
    public static final String truong = "TRUONG    ";
    public static final String larry1 = "LARRY1    ";
    public static final String larry2 = "LARRY2    ";
    public static final String bobbie = "BOBBIE    ";
    public static final String roger = "ROGER     ";
    public static final String jim = "JIM       ";
    public static final String dan = "DAN       ";
    public static final String sam1 = "SAM1      ";
    public static final String sam2 = "SAM2      ";
    public static final String guy = "GUY       ";
    public static final String don = "DON       ";
    public static final String monica = "MONICA    ";
    public static final String lily1 = "LILY1     ";
    public static final String lily2 = "LILY2     ";
    public static final Object[] db_dept = new Object[]{i1, "K55", "DB        "};
    public static final Object[] ofc_dept = new Object[]{i2, "K52", "OFC       "};
    public static final Object[] cs_dept = new Object[]{i3, "K51", "CS        "};
    public static final Object[][] dept = new Object[][]{db_dept, ofc_dept, cs_dept};
    public static final Object[] ashok_emp = new Object[]{i1, "ASHOK     ", null, "K51"};
    public static final Object[] john_emp = new Object[]{i2, "JOHN      ", "ASHOK     ", "K51"};
    public static final Object[] robin_emp = new Object[]{i3, "ROBIN     ", "ASHOK     ", "K51"};
    public static final Object[] joe1_emp = new Object[]{i4, "JOE1      ", "ASHOK     ", "K51"};
    public static final Object[] joe2_emp = new Object[]{i5, "JOE2      ", "ASHOK     ", "K51"};
    public static final Object[] hamid_emp = new Object[]{i6, "HAMID     ", "JOHN      ", "K55"};
    public static final Object[] truong_emp = new Object[]{i7, "TRUONG    ", "HAMID     ", "K55"};
    public static final Object[] larry1_emp = new Object[]{i8, "LARRY1    ", "HAMID     ", "K55"};
    public static final Object[] larry2_emp = new Object[]{i9, "LARRY2    ", "HAMID     ", "K55"};
    public static final Object[] bobbie_emp = new Object[]{i10, "BOBBIE    ", "HAMID     ", "K55"};
    public static final Object[] roger_emp = new Object[]{i11, "ROGER     ", "ROBIN     ", "K52"};
    public static final Object[] jim_emp = new Object[]{i12, "JIM       ", "ROGER     ", "K52"};
    public static final Object[] dan_emp = new Object[]{i13, "DAN       ", "ROGER     ", "K52"};
    public static final Object[] sam1_emp = new Object[]{i14, "SAM1      ", "ROGER     ", "K52"};
    public static final Object[] sam2_emp = new Object[]{i15, "SAM2      ", "ROGER     ", "K52"};
    public static final Object[] guy_emp = new Object[]{i16, "GUY       ", "JOHN      ", "K55"};
    public static final Object[] don_emp = new Object[]{i17, "DON       ", "GUY       ", "K55"};
    public static final Object[] monica_emp = new Object[]{i18, "MONICA    ", "GUY       ", "K55"};
    public static final Object[] lily1_emp = new Object[]{i19, "LILY1     ", "GUY       ", "K55"};
    public static final Object[] lily2_emp = new Object[]{i20, "LILY2     ", "GUY       ", "K55"};
    public static final Object[][] emp = new Object[][]{ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp};
    private static final String[] mgrs = new String[]{"ASHOK     ", "JOHN      ", "HAMID     ", "ROBIN     ", "ROGER     ", "GUY       "};
    private static final String[] non_mgrs = new String[]{"JOE1      ", "JOE2      ", "TRUONG    ", "LARRY1    ", "LARRY2    ", "BOBBIE    ", "JIM       ", "DAN       ", "SAM1      ", "SAM2      ", "DON       ", "MONICA    ", "LILY1     ", "LILY2     "};
    public static final String SCHEMA = "db2test";
    public static final String CT = "create table ";
    public static final String DS = " (c0 int, dno char(3) not null primary key, dname char(10))";
    public static final String ES = " (c0 int, name char(10) not null primary key, mgrname char(10)";
    public static final String DNO = " dno char(3)";
    public static final String CAS = " on delete cascade";
    public static final String SETN = " on delete set null";
    private Connection c2;
    private Connection c3;
    private static final long DERBY_DEFAULT_TIMEOUT = 60L;
    private static final String SQLSTATE_NULL_INTO_NON_NULL = "23502";

    public static String ref(String table) {
        return " references " + table;
    }

    public static String insertInto(String table, int params) {
        StringBuffer tmp = new StringBuffer("insert into " + table + " values ( ?");
        while (--params > 0) {
            tmp.append(", ?");
        }
        tmp.append(")");
        return tmp.toString();
    }

    private static String insertFrom(String dst, String src) {
        return "insert into " + dst + " select * from " + src;
    }

    private void createTestTable(String name, String signature, String src) throws SQLException {
        Statement s = this.createStatement();
        s.execute(CT + name + signature);
        s.execute(ResultSetsFromPreparedStatementTest.insertFrom(name, src));
        s.close();
    }

    public static void apply(PreparedStatement action, Object[][] table) throws SQLException {
        for (int row = 0; row < table.length; ++row) {
            for (int col = 0; col < table[row].length; ++col) {
                Object obj = table[row][col];
                if (obj == null) {
                    action.setNull(col + 1, 1);
                    continue;
                }
                action.setObject(col + 1, obj);
            }
            action.execute();
        }
    }

    private static void assertResultSet(String message, Object[][] expected, ResultSet returned) throws SQLException {
        int i;
        boolean moreRows = false;
        try {
            for (i = 0; i < expected.length && (moreRows = returned.next()); ++i) {
                ResultSetsFromPreparedStatementTest.assertRow(message + "(row " + (i + 1) + ", ", expected[i], returned);
            }
            ResultSetsFromPreparedStatementTest.assertEquals((String)(message + " too few rows, "), (int)expected.length, (int)i);
            moreRows = returned.next();
            ResultSetsFromPreparedStatementTest.assertFalse((String)(message + " too many rows, expected:<" + expected.length + "> but was at least:<" + ++i + ">"), (boolean)moreRows);
        }
        catch (AssertionFailedError af) {
            System.err.println((Object)af);
            ResultSetsFromPreparedStatementTest.dumpDiff(expected, i, returned, moreRows, System.err);
            throw af;
        }
        finally {
            returned.close();
        }
    }

    private static void assertRow(String message, Object[] expected, ResultSet returned) throws SQLException {
        ResultSetMetaData rmd = returned.getMetaData();
        ResultSetsFromPreparedStatementTest.assertEquals((String)(message + " columns:"), (int)expected.length, (int)rmd.getColumnCount());
        for (int i = 0; i < expected.length; ++i) {
            ResultSetsFromPreparedStatementTest.assertEquals((String)(message + rmd.getColumnLabel(i + 1) + ") "), (Object)expected[i], (Object)returned.getObject(i + 1));
        }
    }

    private static void dump(ResultSet dumpee, PrintStream stream) throws SQLException {
        int c;
        ResultSetMetaData rm = dumpee.getMetaData();
        int colCount = rm.getColumnCount();
        for (c = 1; c <= colCount; ++c) {
            stream.print("" + rm.getColumnLabel(c) + " " + rm.getColumnTypeName(c) + ", ");
        }
        stream.println("");
        while (dumpee.next()) {
            for (c = 1; c <= colCount; ++c) {
                stream.print("" + dumpee.getObject(c) + ", ");
            }
            stream.println("");
        }
        dumpee.close();
    }

    private static void dumpDiff(Object[][] expected, int fromRow, ResultSet dumpee, boolean moreRows, PrintStream stream) throws SQLException {
        int c;
        ResultSetMetaData rm = dumpee.getMetaData();
        int colCount = rm.getColumnCount();
        for (c = 1; c <= colCount; ++c) {
            stream.print("" + rm.getColumnLabel(c) + " " + rm.getColumnTypeName(c) + ", ");
        }
        stream.println("");
        while (moreRows || fromRow < expected.length) {
            for (c = 1; c <= colCount; ++c) {
                Object e = fromRow < expected.length ? expected[fromRow][c - 1] : null;
                Object ret = moreRows ? dumpee.getObject(c) : null;
                stream.print(e);
                if (e == null || ret == null || !ret.equals(e)) {
                    stream.print("<" + ret + ">");
                }
                stream.print(", ");
            }
            stream.println("");
            moreRows = dumpee.next();
            ++fromRow;
        }
        dumpee.close();
    }

    private static void dumpObjectArray(ResultSet dumpee, PrintStream stream) throws SQLException {
        ResultSetMetaData rm = dumpee.getMetaData();
        int colCount = rm.getColumnCount();
        int rows = 0;
        String rowPrefix = "";
        while (dumpee.next()) {
            ++rows;
            stream.print(rowPrefix + "{ ");
            rowPrefix = ",\n";
            String colPrefix = "";
            for (int c = 1; c <= colCount; ++c) {
                stream.print(colPrefix);
                colPrefix = ", ";
                Object theObject = dumpee.getObject(c);
                if (theObject == null) {
                    stream.print("null");
                    continue;
                }
                if (theObject instanceof String) {
                    stream.print("\"" + theObject + "\"");
                    continue;
                }
                stream.print("new " + rm.getColumnClassName(c) + "(" + theObject + ")");
            }
            stream.print(" }");
        }
        if (rows > 0) {
            stream.println("");
        } else {
            stream.println("<empty ResultSet>");
        }
        dumpee.close();
    }

    private boolean hasTableXLock(String table) throws SQLException {
        PreparedStatement ps = this.prepareStatement("select count(*) from syscs_diag.lock_table where tablename=? and CAST(type AS CHAR(5))='TABLE' and CAST(mode AS CHAR(1))='X'");
        ps.setString(1, table);
        ResultSet rs = ps.executeQuery();
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)rs.next());
        int count = rs.getInt(1);
        rs.close();
        ps.close();
        return count != 0;
    }

    protected void setUp() throws Exception {
        Statement s1 = this.createStatement();
        s1.executeUpdate("set schema db2test");
        s1.close();
        this.getConnection().setAutoCommit(false);
        this.c2 = this.openDefaultConnection();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("set schema db2test");
        s2.close();
        this.c2.setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        this.rollback();
        this.c2.rollback();
        this.c2.close();
        this.c2 = null;
        Statement s = this.createStatement();
        try {
            s.executeUpdate("drop view vemp");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop view vdept");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table emp");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table emp2");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table dept");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.c3 != null && !this.c3.isClosed()) {
                this.c3.rollback();
                this.c3.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.c3 = null;
        try {
            s.executeUpdate("drop table APP.FILECHANGES");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table APP.CHANGESETS");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table APP.AUTHORS");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table APP.FILES");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table APP.REPOSITORIES");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            s.executeUpdate("drop table APP.FILECHANGES_2");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.setTimeout(60L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.close();
        this.commit();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Create ResultSets from PreparedStatements");
        suite.addTestSuite(ResultSetsFromPreparedStatementTest.class);
        CleanDatabaseTestSetup wrapper = new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                Connection c = s.getConnection();
                s.execute("create schema db2test");
                s.execute("set schema db2test");
                s.execute("create table dept_data (c0 int, dno char(3) not null primary key, dname char(10))");
                s.execute("create table emp_data (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))");
                c.commit();
                PreparedStatement ps = c.prepareStatement(ResultSetsFromPreparedStatementTest.insertInto("dept_data", 3));
                ResultSetsFromPreparedStatementTest.apply(ps, dept);
                c.commit();
                ps.close();
                ps = c.prepareStatement(ResultSetsFromPreparedStatementTest.insertInto("emp_data", 4));
                ResultSetsFromPreparedStatementTest.apply(ps, emp);
                c.commit();
                ps.close();
            }
        };
        return wrapper;
    }

    public ResultSetsFromPreparedStatementTest(String name) {
        super(name);
    }

    public void testSetTransactionResultSet() throws Exception {
        PreparedStatement[] setIsoLevel = new PreparedStatement[]{this.prepareStatement("set current isolation = read uncommitted"), this.prepareStatement("set current isolation = read committed"), this.prepareStatement("set current isolation = rs"), this.prepareStatement("set current isolation = serializable")};
        int[] expectedIsoLevel = new int[]{1, 2, 4, 8};
        Connection c = this.getConnection();
        for (int i = 0; i < 20; ++i) {
            for (int iso = 0; iso < setIsoLevel.length; ++iso) {
                setIsoLevel[iso].execute();
                ResultSetsFromPreparedStatementTest.assertEquals((String)("i=" + i + " iso=" + iso), (int)expectedIsoLevel[iso], (int)c.getTransactionIsolation());
            }
        }
        for (int iso = 0; iso < setIsoLevel.length; ++iso) {
            setIsoLevel[iso].close();
        }
    }

    public void testCallStatementResultSet() throws Exception {
        CallableStatement cs = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, "some.property.name");
        PreparedStatement ps = this.prepareStatement("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('some.property.name')");
        for (int i = 0; i < 20; ++i) {
            Integer I = new Integer(i);
            cs.setObject(2, (Object)I);
            cs.execute();
            ResultSet rs = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=?=" + i, new Object[][]{{I.toString()}}, rs);
            cs.execute();
            rs = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=?=" + i, new Object[][]{{I.toString()}}, rs);
        }
        cs.close();
        ps.close();
    }

    public void testVTIResultSet() throws Exception {
        PreparedStatement ps = this.prepareStatement("select tablename, schemaname from sys.systables inner join sys.sysschemas on sys.systables.schemaid = sys.sysschemas.schemaid");
        ResultSet rs = ps.executeQuery();
        ps = this.prepareStatement("select st.conglomeratename from TABLE(SYSCS_DIAG.SPACE_TABLE(?,?)) st where st.isindex = 0");
        while (rs.next()) {
            ps.setString(1, rs.getString(2));
            ps.setString(2, rs.getString(1));
            ResultSet rs2 = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("BooHoo", new Object[][]{{rs.getString(1)}}, rs2);
            rs2 = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Re-exec", new Object[][]{{rs.getString(1)}}, rs2);
        }
        rs.close();
        ps.close();
    }

    public void testScalarAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement ps = this.prepareStatement("select max(c0) from emp where mgrname = ?");
        this.testScalarAggregateResultSet(ps, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testScalarAggregateResultSet(ps, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        this.testScalarAggregateResultSet(ps, null);
        ps.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testScalarAggregateResultSet(PreparedStatement ps, PreparedStatement del) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            ps.setObject(1, non_mgrs[i]);
            ResultSet rs = ps.executeQuery();
            rs.next();
            ResultSetsFromPreparedStatementTest.assertNull((Object)rs.getObject(1));
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs = ps.executeQuery();
            rs.next();
            ResultSetsFromPreparedStatementTest.assertNull((Object)rs.getObject(1));
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        if (del == null) {
            return;
        }
        Object[][][] m = new Object[][][]{{{i5}}, {{i16}}, {{i10}}, {{i11}}, {{i15}}, {{i20}}};
        for (int i = 0; i < mgrs.length; ++i) {
            ps.setObject(1, mgrs[i]);
            ResultSet rs = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], m[i], rs);
            rs = ps.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], m[i], rs);
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testLastIndexKeyResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("select ? || max(name) from emp");
        PreparedStatement del = this.prepareStatement("delete from emp where name = ?");
        this.testLastIndexKeyResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testLastIndexKeyResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, "0_");
        JDBC.assertFullResultSet(tst.executeQuery(), (Object[][])new String[][]{{"0_TRUONG    "}}, false);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testLastIndexKeyResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        Object[][][] expected = new Object[][][]{{{"0_TRUONG    "}}, {{"1_SAM2      "}}, {{"2_SAM1      "}}, {{"3_ROGER     "}}, {{"4_ROBIN     "}}, {{"5_MONICA    "}}, {{"6_LILY2     "}}, {{"7_LILY1     "}}, {{"8_LARRY2    "}}, {{"9_LARRY1    "}}, {{"10_JOHN      "}}, {{"11_JOE2      "}}, {{"12_JOE1      "}}, {{"13_JIM       "}}, {{"14_HAMID     "}}, {{"15_GUY       "}}, {{"16_DON       "}}, {{"17_DAN       "}}, {{"18_BOBBIE    "}}, {{"19_ASHOK     "}}, {{null}}};
        for (int i = 0; i < expected.length; ++i) {
            tst.setString(1, new Integer(i).toString() + "_");
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i + "_", expected[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R ?=" + i + "_", expected[i], rs);
            String victim = (String)expected[i][0][0];
            if (victim == null) continue;
            del.setString(1, victim.substring(victim.indexOf(95) + 1));
            del.execute();
        }
    }

    public void testDistinctScanResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select ? || T.dm from (select distinct mgrname dm from emp) as T");
        this.testDistinctScanResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctScanResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, "0_");
        JDBC.assertDrainResults(tst.executeQuery(), 7);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testDistinctScanResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        Object[][][] expected = new Object[][][]{{{"0_ROGER     "}, {"0_JOHN      "}, {"0_ROBIN     "}, {"0_GUY       "}, {"0_HAMID     "}, {"0_ASHOK     "}, {null}}, {{"1_ROGER     "}, {"1_JOHN      "}, {"1_ROBIN     "}, {"1_GUY       "}, {"1_HAMID     "}, {null}}, {{"2_ROGER     "}, {"2_ROBIN     "}, {"2_GUY       "}, {"2_HAMID     "}, {null}}, {{"3_ROGER     "}, {"3_ROBIN     "}, {"3_GUY       "}, {null}}, {{"4_ROGER     "}, {"4_GUY       "}, {null}}, {{"5_GUY       "}, {null}}, {{null}}};
        for (int i = 0; i < expected.length; ++i) {
            tst.setString(1, new Integer(i) + "_");
            ResultSet rs = tst.executeQuery();
            JDBC.assertUnorderedResultSet(rs, expected[i], false);
            rs = tst.executeQuery();
            JDBC.assertUnorderedResultSet(rs, expected[i], false);
            if (i >= mgrs.length) continue;
            del.setObject(1, mgrs[i]);
            del.execute();
        }
    }

    public void testDistinctScalarAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select count(distinct mgrname)+? from emp");
        this.testDistinctScalarAggregateResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctScalarAggregateResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setInt(1, 0);
        JDBC.assertFullResultSet(tst.executeQuery(), (Object[][])new Integer[][]{{i6}}, false);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testDistinctScalarAggregateResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        Object[][][] expected = new Object[][][]{{{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}, {{i6}}};
        for (int i = 0; i < expected.length; ++i) {
            tst.setInt(1, i);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i, expected[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + i, expected[i], rs);
            if (i >= mgrs.length) continue;
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testDistinctGroupedAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select count(distinct mgrname) nummgrs, dno from emp group by dno having dno <> ?");
        this.testDistinctGroupedAggregateResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testDistinctGroupedAggregateResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setObject(1, dept[0][1]);
        JDBC.assertFullResultSet(tst.executeQuery(), (Object[][])new Object[][]{{i1, k51}, {i2, k52}}, false);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testDistinctGroupedAggregateResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        Integer i0 = new Integer(0);
        Object[][][][] expected = new Object[][][][]{{{{i1, k51}, {i2, k52}}, {{i1, k51}, {i3, k55}}, {{i2, k52}, {i3, k55}}}, {{{i0, k51}, {i2, k52}}, {{i0, k51}, {i3, k55}}, {{i2, k52}, {i3, k55}}}, {{{i0, k51}, {i2, k52}}, {{i0, k51}, {i2, k55}}, {{i2, k52}, {i2, k55}}}, {{{i0, k51}, {i2, k52}}, {{i0, k51}, {i1, k55}}, {{i2, k52}, {i1, k55}}}, {{{i0, k51}, {i1, k52}}, {{i0, k51}, {i1, k55}}, {{i1, k52}, {i1, k55}}}, {{{i0, k51}}, {{i0, k51}, {i1, k55}}, {{i1, k55}}}, {{{i0, k51}}, {{i0, k51}}, new Object[0][]}};
        for (int i = 0; i < expected.length; ++i) {
            for (int d = 0; d < dept.length; ++d) {
                tst.setObject(1, dept[d][1]);
                ResultSet rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " d=" + d + "(" + dept[d][1] + ")", expected[i][d], rs);
                rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " d=" + d + "(" + dept[d][1] + ")", expected[i][d], rs);
            }
            if (i >= mgrs.length) continue;
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testGroupedAggregateResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where name = ?");
        PreparedStatement tst = this.prepareStatement("select max(name) maxemp, mgrname from emp group by mgrname having mgrname <> ?");
        this.testGroupedAggregateResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testGroupedAggregateResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, mgrs[0]);
        JDBC.assertDrainResults(tst.executeQuery(), 5);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testGroupedAggregateResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        Object[][][] expected = new Object[][][]{{{monica, guy}, {truong, hamid}, {hamid, john}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {truong, hamid}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {hamid, john}, {roger, robin}, {sam2, roger}}, {{robin, ashok}, {monica, guy}, {truong, hamid}, {guy, john}, {sam2, roger}}, {{joe2, ashok}, {monica, guy}, {truong, hamid}, {guy, john}, {roger, robin}}, {{joe2, ashok}, {truong, hamid}, {guy, john}, {sam2, roger}}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setString(1, mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + mgrs[i], expected[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + mgrs[i], expected[i], rs);
            if (i >= mgrs.length) continue;
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testNestedLoopResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select T.name, T.mgrname, T.dno, dept.dname from dept, (select * from emp where mgrname = ?) as T where dept.dno = T.dno");
        this.testNestedLoopResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testNestedLoopResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, mgrs[0]);
        JDBC.assertDrainResults(tst.executeQuery(), 4);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testNestedLoopResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            tst.setString(1, non_mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        Object[][][] results = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setString(1, mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], results[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], results[i], rs);
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testHashTableResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        Statement s = this.createStatement();
        s.execute("create view vemp as select * from emp");
        s.execute("create view vdept as select * from dept");
        PreparedStatement tst = this.prepareStatement("select vemp.name, vemp.mgrname, vemp.dno, vdept.dname from vemp inner join vdept on vemp.dno = vdept.dno where mgrname = ?");
        this.testHashTableResultSet(tst, del);
        s.executeUpdate("drop view vemp");
        s.executeUpdate("drop view vdept");
        s.executeUpdate("drop table dept");
        this.createTestTable("dept", DS, "dept_data");
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        s.executeUpdate("create view vemp as select * from emp");
        s.executeUpdate("create view vdept as select * from dept");
        this.testHashTableResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, mgrs[0]);
        JDBC.assertDrainResults(tst.executeQuery(), 4);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testHashTableResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            tst.setObject(1, non_mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        Object[][][] results = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setObject(1, mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], results[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], results[i], rs);
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testNestedLoopLeftOuterJoinResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select emp.name, emp.mgrname, emp.dno, dept.dname from emp left outer join dept on emp.dno = dept.dno where mgrname = ?");
        this.testNestedLoopLeftOuterJoinResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table dept");
        this.createTestTable("dept", DS, "dept_data");
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testNestedLoopLeftOuterJoinResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, mgrs[0]);
        JDBC.assertDrainResults(tst.executeQuery(), 4);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testNestedLoopLeftOuterJoinResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            tst.setObject(1, non_mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        Object[][][] results = new Object[][][]{{{john, ashok, k51, "CS        "}, {robin, ashok, k51, "CS        "}, {joe1, ashok, k51, "CS        "}, {joe2, ashok, k51, "CS        "}}, {{hamid, john, k55, "DB        "}, {guy, john, k55, "DB        "}}, {{truong, hamid, k55, "DB        "}, {larry1, hamid, k55, "DB        "}, {larry2, hamid, k55, "DB        "}, {bobbie, hamid, k55, "DB        "}}, {{roger, robin, k52, "OFC       "}}, {{jim, roger, k52, "OFC       "}, {dan, roger, k52, "OFC       "}, {sam1, roger, k52, "OFC       "}, {sam2, roger, k52, "OFC       "}}, {{don, guy, k55, "DB        "}, {monica, guy, k55, "DB        "}, {lily1, guy, k55, "DB        "}, {lily2, guy, k55, "DB        "}}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setObject(1, mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], results[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], results[i], rs);
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testHashLeftOuterJoinResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.createTestTable("emp2", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement del = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("select distinct emp.* from emp left outer join emp2 on emp.dno = emp2.dno where emp.mgrname = ? order by emp.c0");
        this.testHashLeftOuterJoinResultSet(tst, del);
        Statement s = this.createStatement();
        s.executeUpdate("drop table emp");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        s.executeUpdate("drop table emp2");
        this.createTestTable("emp2", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        this.testHashLeftOuterJoinResultSet(tst, del);
        s.executeUpdate("delete from emp");
        s.executeUpdate(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        this.commit();
        Statement s2 = this.c2.createStatement();
        s2.executeUpdate("update emp set c0 = c0");
        this.getConnection().setTransactionIsolation(1);
        tst.setString(1, mgrs[0]);
        JDBC.assertDrainResults(tst.executeQuery(), 4);
        tst.close();
        del.close();
        s.close();
        s2.close();
    }

    private void testHashLeftOuterJoinResultSet(PreparedStatement tst, PreparedStatement del) throws SQLException {
        for (int i = 0; i < non_mgrs.length; ++i) {
            tst.setObject(1, non_mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        Object[][][] results = new Object[][][]{{john_emp, robin_emp, joe1_emp, joe2_emp}, {hamid_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp}, {roger_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, {don_emp, monica_emp, lily1_emp, lily2_emp}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setObject(1, mgrs[i]);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + mgrs[i], results[i], rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + mgrs[i], results[i], rs);
            del.setString(1, mgrs[i]);
            del.execute();
        }
    }

    public void testUpdateResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("update dept set dname = ? where dno = ?");
        PreparedStatement sel = this.prepareStatement("select dno, dname from dept order by c0");
        Object[][][] expected = new Object[][][]{{{k55, "DataBase  "}, {k52, "OFC       "}, {k51, "CS        "}}, {{k55, "DataBase  "}, {k52, "Office    "}, {k51, "CS        "}}, {{k55, "DataBase  "}, {k52, "Office    "}, {k51, "Computer S"}}};
        for (int i = 0; i < expected.length; ++i) {
            tst.setObject(1, expected[i][i][1]);
            tst.setObject(2, expected[i][i][0]);
            tst.executeUpdate();
            ResultSet rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + expected[i][i][1] + " ?=" + expected[i][i][0], expected[i], rs);
            tst.executeUpdate();
            rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + expected[i][i][1] + " ?=" + expected[i][i][0], expected[i], rs);
        }
        tst.close();
        sel.close();
    }

    public void testUpdateResultSetWithIsolation() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.commit();
        PreparedStatement ps = this.prepareStatement("update dept set c0 = c0");
        this.getConnection().setTransactionIsolation(8);
        ResultSetsFromPreparedStatementTest.assertEquals((int)3, (int)ps.executeUpdate());
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)this.hasTableXLock("DEPT"));
        this.commit();
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)this.hasTableXLock("DEPT"));
        this.getConnection().setTransactionIsolation(2);
        ResultSetsFromPreparedStatementTest.assertEquals((int)3, (int)ps.executeUpdate());
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)this.hasTableXLock("DEPT"));
        ps.close();
    }

    public void testCurrentOfResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement selForUpd = this.prepareStatement("select * from dept for update of dname");
        selForUpd.setCursorName("C1");
        ResultSet rs = selForUpd.executeQuery();
        PreparedStatement tst = this.prepareStatement("update dept set dname = ? where current of C1");
        PreparedStatement sel = this.prepareStatement("select dname from dept");
        Object[][][] expected = new Object[][][]{{{"foobar___0"}, {"OFC       "}, {"CS        "}}, {{"foobar___0"}, {"foobar___1"}, {"CS        "}}, {{"foobar___0"}, {"foobar___1"}, {"foobar___2"}}};
        for (int i = 0; i < expected.length; ++i) {
            ResultSetsFromPreparedStatementTest.assertTrue((boolean)rs.next());
            tst.setObject(1, expected[i][i][0]);
            tst.executeUpdate();
            ResultSet sel_rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + expected[i][i][0], expected[i], sel_rs);
            tst.executeUpdate();
            sel_rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + expected[i][i][0], expected[i], sel_rs);
        }
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
        rs.close();
        tst.close();
        sel.close();
        selForUpd.close();
    }

    public void testDeleteResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement sel = this.prepareStatement("select * from emp");
        for (int i = 0; i < non_mgrs.length; ++i) {
            tst.setObject(1, non_mgrs[i]);
            tst.execute();
            ResultSet rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + non_mgrs[i], emp, rs);
            tst.execute();
            rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + non_mgrs[i], emp, rs);
        }
        Object[][][] expected = new Object[][][]{{ashok_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {ashok_emp}};
        for (int i = 0; i < mgrs.length; ++i) {
            tst.setObject(1, mgrs[i]);
            tst.execute();
            ResultSet rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i + " ?=" + non_mgrs[i], expected[i], rs);
            tst.execute();
            rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i + " ?=" + non_mgrs[i], expected[i], rs);
        }
        tst.close();
        sel.close();
    }

    public void testDeleteCascadeUpdateResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", ES + ResultSetsFromPreparedStatementTest.ref("emp") + SETN + "," + DNO + ResultSetsFromPreparedStatementTest.ref("dept") + SETN + ")", "emp_data");
        PreparedStatement delMgr = this.prepareStatement("delete from emp where mgrname = ?");
        PreparedStatement tst = this.prepareStatement("delete from emp");
        PreparedStatement ins = this.prepareStatement(ResultSetsFromPreparedStatementTest.insertFrom("emp", "emp_data"));
        PreparedStatement sel = this.prepareStatement("select * from emp");
        for (int i = 0; i < mgrs.length; ++i) {
            delMgr.setString(1, mgrs[i]);
            delMgr.execute();
            tst.execute();
            ResultSet rs = sel.executeQuery();
            ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
            rs.close();
            ins.execute();
        }
        delMgr.close();
        tst.close();
        ins.close();
        sel.close();
    }

    public void testSetOpResultSet_intersect() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("select * from emp where dno = ? intersect select * from emp where mgrname = ?");
        Object[][][][] expected = new Object[][][][]{{new Object[0][], {hamid_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp}, new Object[0][], new Object[0][], {don_emp, monica_emp, lily1_emp, lily2_emp}}, {new Object[0][], new Object[0][], new Object[0][], {roger_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, new Object[0][]}, {{john_emp, robin_emp, joe1_emp, joe2_emp}, new Object[0][], new Object[0][], new Object[0][], new Object[0][], new Object[0][]}};
        for (int d = 0; d < dept.length; ++d) {
            tst.setObject(1, dept[d][1]);
            for (int m = 0; m < mgrs.length; ++m) {
                tst.setString(2, mgrs[m]);
                ResultSet rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
                rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
            }
        }
        tst.close();
    }

    public void testSetOpResultSet_except() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("select * from emp where dno = ? except select * from emp where mgrname = ?");
        Object[][][][] expected = new Object[][][][]{{{hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp}}, {{roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}}, {{ashok_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}}};
        for (int d = 0; d < dept.length; ++d) {
            tst.setObject(1, dept[d][1]);
            for (int m = 0; m < mgrs.length; ++m) {
                tst.setString(2, mgrs[m]);
                ResultSet rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
                rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
            }
        }
        tst.close();
    }

    public void testUnionResultSet() throws Exception {
        this.createTestTable("dept", DS, "dept_data");
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("(select * from emp where dno = ?) union (select * from emp where mgrname = ?)");
        Object[][][][] expected = new Object[][][][]{{{john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}, {hamid_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp, guy_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}, {{john_emp, robin_emp, joe1_emp, joe2_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {hamid_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, guy_emp}, {truong_emp, larry1_emp, larry2_emp, bobbie_emp, roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {roger_emp, jim_emp, dan_emp, sam1_emp, sam2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}, {{ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, hamid_emp, guy_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, truong_emp, larry1_emp, larry2_emp, bobbie_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, roger_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, jim_emp, dan_emp, sam1_emp, sam2_emp}, {ashok_emp, john_emp, robin_emp, joe1_emp, joe2_emp, don_emp, monica_emp, lily1_emp, lily2_emp}}};
        for (int d = 0; d < dept.length; ++d) {
            tst.setObject(1, dept[d][1]);
            for (int m = 0; m < mgrs.length; ++m) {
                tst.setString(2, mgrs[m]);
                ResultSet rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
                rs = tst.executeQuery();
                ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + dept[d][1] + " ?=" + mgrs[m], expected[d][m], rs);
            }
        }
        tst.close();
    }

    public void testOnceResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst1 = this.prepareStatement("select * from emp where c0 = (values (1+?) union values (1+?))");
        for (int i = 0; i < emp.length; ++i) {
            tst1.setInt(1, i);
            tst1.setInt(2, i);
            ResultSet rs = tst1.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i, new Object[][]{emp[i]}, rs);
            rs = tst1.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i, new Object[][]{emp[i]}, rs);
        }
        tst1.close();
        PreparedStatement tst2 = this.prepareStatement("select * from emp where name = (select name from emp where c0 <= ? intersect select name from emp where c0 >= ?)");
        for (int i = 0; i < emp.length; ++i) {
            tst2.setInt(1, i + 1);
            tst2.setInt(2, i + 1);
            ResultSet rs = tst2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("i=" + i, new Object[][]{emp[i]}, rs);
            rs = tst2.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("Ri=" + i, new Object[][]{emp[i]}, rs);
        }
        tst2.close();
    }

    public void testAnyResultSet() throws Exception {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement tst = this.prepareStatement("select * from ( values 'EXISTED' ) as T(result) where exists ((select name from emp where c0 <= ?) intersect (select name from emp where c0 >= ?))");
        Object[][] existed = new Object[][]{{"EXISTED"}};
        Object[][] empty = new Object[][]{};
        for (int i = 0; i < emp.length; ++i) {
            tst.setInt(1, i + 1);
            tst.setInt(2, i + 1);
            ResultSet rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + (i + 1) + " ?=" + (i + 1), existed, rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + (i + 1) + " ?=" + (i + 1), existed, rs);
            tst.setInt(1, i);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("?=" + i + " ?=" + (i + 1), empty, rs);
            rs = tst.executeQuery();
            ResultSetsFromPreparedStatementTest.assertResultSet("R?=" + i + " ?=" + (i + 1), empty, rs);
        }
        tst.close();
    }

    private void testGeneratedIdentity(String dataType, String generatedType) throws Exception {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T(GI " + dataType + " PRIMARY KEY GENERATED " + generatedType + " AS IDENTITY (START WITH 5, INCREMENT BY 10), " + "L VARCHAR(8))");
        PreparedStatement implicit = this.prepareStatement("INSERT INTO T(L) VALUES('implicit')");
        implicit.executeUpdate();
        implicit.executeUpdate();
        implicit.executeUpdate();
        PreparedStatement explicit = this.prepareStatement("INSERT INTO T(GI, L) VALUES(DEFAULT, 'explicit')");
        explicit.executeUpdate();
        explicit.executeUpdate();
        explicit.executeUpdate();
    }

    public void testIntGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("INT", "BY DEFAULT");
    }

    public void testSmallintGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("SMALLINT", "BY DEFAULT");
    }

    public void testBigintGeneratedByDefaultAsIdentity() throws Exception {
        this.testGeneratedIdentity("BIGINT", "BY DEFAULT");
    }

    public void testIntGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("INT", "ALWAYS");
    }

    public void testSmallintGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("SMALLINT", "ALWAYS");
    }

    public void testBigintGeneratedAlwaysAsIdentity() throws Exception {
        this.testGeneratedIdentity("BIGINT", "ALWAYS");
    }

    public void testSetMaxRowsTable() throws SQLException {
        this.createTestTable("emp", " (c0 int, name char(10) not null primary key, mgrname char(10), dno char(3))", "emp_data");
        PreparedStatement ps = this.prepareStatement("select * from emp_data", 1004, 1007);
        ResultSetsFromPreparedStatementTest.assertTrue((JDBC.assertDrainResults(ps.executeQuery()) >= 20 ? 1 : 0) != 0);
        ps.setMaxRows(5);
        JDBC.assertDrainResults(ps.executeQuery(), 5);
        ps.setMaxRows(20);
        JDBC.assertDrainResults(ps.executeQuery(), 20);
    }

    public void testSetMaxRowsValues() throws SQLException {
        PreparedStatement ps = this.prepareStatement("values 0,1,2,3,4,5,6,7,8,9", 1004, 1007);
        ps.setMaxRows(10);
        JDBC.assertDrainResults(ps.executeQuery(), 10);
        ps.setMaxRows(2);
        JDBC.assertDrainResults(ps.executeQuery(), 2);
    }

    private void testRuntimeStatistics(String sql, String schema) throws SQLException {
        Statement s = this.createStatement();
        s.execute("call syscs_util.syscs_set_runtimestatistics(1)");
        if (schema != null) {
            s.execute("call syscs_util.syscs_set_xplain_schema('" + schema.toUpperCase() + "')");
        }
        PreparedStatement ps = this.prepareStatement(sql);
        for (int i = 0; i < 5; ++i) {
            ps.execute();
            while (true) {
                if (ps.getMoreResults()) {
                    JDBC.assertDrainResults(ps.getResultSet());
                    continue;
                }
                if (ps.getUpdateCount() == -1) break;
            }
            RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
            ResultSetsFromPreparedStatementTest.assertTrue((String)"Wrong statement", (boolean)rtsp.findString(sql, 1));
        }
        if (schema != null) {
            s.execute("call syscs_util.syscs_set_xplain_schema('')");
            PreparedStatement psStatsQ = this.prepareStatement("select count(*) from " + schema + ".sysxplain_statements" + " where stmt_text = ?");
            psStatsQ.setString(1, sql);
            JDBC.assertSingleValueResultSet(psStatsQ.executeQuery(), "5");
        }
    }

    public void testRuntimeStatisticsForSelect() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("select * from dept", "select_stats");
    }

    public void testRuntimeStatisticsForUpdate() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("update dept set dname = upper(dname)", "update_stats");
    }

    public void testRuntimeStatisticsForInsert() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("insert into dept select * from dept where 1<>1", "insert_stats");
    }

    public void testRuntimeStatisticsForDelete() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("delete from dept", "delete_stats");
    }

    public void testRuntimeStatisticsForValues() throws SQLException {
        this.testRuntimeStatistics("values (1, 2, 3, 'this is a test')", "values_stats");
    }

    public void testRuntimeStatisticsForCall() throws SQLException {
        this.createTestTable("dept", DS, "dept_data");
        this.testRuntimeStatistics("call syscs_util.syscs_compress_table(current schema, 'DEPT', 1)", null);
    }

    public void testDerby4330_JoinResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_join_tables();
        PreparedStatement ps = this.prepareStatement("SELECT CS.REVISION, A.NAME, CS.TIME, CS.MESSAGE, F.PATH FROM CHANGESETS CS, FILECHANGES FC,            REPOSITORIES R, FILES F, AUTHORS A WHERE F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID) ORDER BY CS.ID DESC");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement stm2 = this.c3.createStatement();
        stm2.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
        stm2.close();
        try {
            ps.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet rs = ps.executeQuery();
        ResultSetsFromPreparedStatementTest.assertTrue((boolean)rs.next());
        ResultSetsFromPreparedStatementTest.assertEquals((String)rs.getString(2), (String)"xyz");
        ResultSetsFromPreparedStatementTest.assertFalse((boolean)rs.next());
        ps.close();
    }

    public void testDerby4330_UnionResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement ps = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES_2  UNION SELECT * FROM FILECHANGES) X");
        PreparedStatement ps_inverse = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES  UNION SELECT * FROM FILECHANGES_2) X");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement stm2 = this.c3.createStatement();
        stm2.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
        stm2.close();
        try {
            ps.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        try {
            ps_inverse.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1", "1"}});
        rs = ps_inverse.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1", "1"}});
        ps.close();
        ps_inverse.close();
    }

    public void testDerby4330_SetOpResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        String[] ops = new String[]{"EXCEPT", "INTERSECT"};
        String[][][] opExpectedRs = new String[][][]{null, {{"1", "1", "1"}}};
        for (int i = 0; i < 2; ++i) {
            PreparedStatement ps = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES_2 " + ops[i] + " " + "SELECT * FROM FILECHANGES) X ORDER BY ID");
            PreparedStatement ps_inverse = this.prepareStatement("SELECT * FROM (SELECT * FROM FILECHANGES " + ops[i] + " " + "SELECT * FROM FILECHANGES_2) X ORDER BY ID");
            this.c3 = this.openDefaultConnection();
            this.c3.setAutoCommit(false);
            Statement stm2 = this.c3.createStatement();
            stm2.execute("LOCK TABLE FILECHANGES IN EXCLUSIVE MODE");
            stm2.close();
            try {
                ps.executeQuery();
                ResultSetsFromPreparedStatementTest.fail();
            }
            catch (SQLException e) {
                ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
            }
            try {
                ps_inverse.executeQuery();
                ResultSetsFromPreparedStatementTest.fail();
            }
            catch (SQLException e) {
                ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
            }
            this.c3.rollback();
            this.c3.close();
            ResultSet rs = ps.executeQuery();
            if (opExpectedRs[i] != null) {
                JDBC.assertFullResultSet(rs, opExpectedRs[i]);
            } else {
                JDBC.assertEmpty(rs);
            }
            rs = ps_inverse.executeQuery();
            if (opExpectedRs[i] != null) {
                JDBC.assertFullResultSet(rs, opExpectedRs[i]);
            } else {
                JDBC.assertEmpty(rs);
            }
            ps.close();
            ps_inverse.close();
        }
    }

    public void testDerby4330_GroupedAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement ps = this.prepareStatement("SELECT SUM(CHANGESET) from FILECHANGES GROUP BY FILE");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement stm2 = this.c3.createStatement();
        stm2.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        stm2.close();
        try {
            ps.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        ps.close();
    }

    public void testDerby4330_DistinctGroupedAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement ps = this.prepareStatement("SELECT SUM(DISTINCT CHANGESET) from FILECHANGES GROUP BY FILE");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement stm2 = this.c3.createStatement();
        stm2.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        stm2.close();
        try {
            ps.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        ps.close();
    }

    public void testDerby4330_DistinctScalarAggregateResultSet() throws SQLException {
        this.setTimeout(1L);
        this.setSchema("APP");
        this.createDerby4330_union_tables();
        PreparedStatement ps = this.prepareStatement("SELECT SUM(DISTINCT CHANGESET) from FILECHANGES");
        this.c3 = this.openDefaultConnection();
        this.c3.setAutoCommit(false);
        Statement stm2 = this.c3.createStatement();
        stm2.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (2,2)");
        stm2.close();
        try {
            ps.executeQuery();
            ResultSetsFromPreparedStatementTest.fail();
        }
        catch (SQLException e) {
            ResultSetsFromPreparedStatementTest.assertSQLState("Expected timeout", "40XL1", e);
        }
        this.c3.rollback();
        this.c3.close();
        ResultSet rs = ps.executeQuery();
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        ps.close();
    }

    private void setTimeout(long t) throws SQLException {
        Statement stm = this.createStatement();
        stm.execute("call syscs_util.syscs_set_database_property('derby.locks.waitTimeout', '" + t + "')");
        stm.close();
    }

    private void createDerby4330_join_tables() throws SQLException {
        Statement stm = this.createStatement();
        stm.execute("CREATE TABLE REPOSITORIES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,PATH VARCHAR(32672) UNIQUE NOT NULL)");
        stm.execute("INSERT INTO REPOSITORIES(PATH) VALUES ('r')");
        stm.execute("CREATE TABLE FILES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,PATH VARCHAR(32672) NOT NULL,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES    ON DELETE CASCADE,UNIQUE (REPOSITORY, PATH))");
        stm.execute("INSERT INTO FILES(PATH, REPOSITORY) VALUES ('/adsf',1)");
        stm.execute("CREATE TABLE AUTHORS (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES            ON DELETE CASCADE,NAME VARCHAR(32672) NOT NULL,UNIQUE (REPOSITORY, NAME))");
        stm.execute("INSERT INTO AUTHORS(REPOSITORY, NAME) VALUES (1, 'xyz')");
        stm.execute("CREATE TABLE CHANGESETS (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,REPOSITORY INT NOT NULL REFERENCES REPOSITORIES            ON DELETE CASCADE,REVISION VARCHAR(1024) NOT NULL,AUTHOR INT NOT NULL REFERENCES AUTHORS ON DELETE CASCADE,TIME TIMESTAMP NOT NULL,MESSAGE VARCHAR(32672) NOT NULL,UNIQUE (REPOSITORY, REVISION))");
        stm.execute("INSERT INTO CHANGESETS(REPOSITORY, REVISION,                        AUTHOR, TIME, MESSAGE) VALUES (1,'',1,CURRENT_TIMESTAMP,'')");
        stm.execute("CREATE TABLE FILECHANGES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL REFERENCES FILES ON DELETE CASCADE,CHANGESET INT NOT NULL REFERENCES CHANGESETS ON DELETE CASCADE,UNIQUE (FILE, CHANGESET))");
        stm.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (1,1)");
        stm.close();
        this.commit();
    }

    private void createDerby4330_union_tables() throws SQLException {
        Statement stm = this.createStatement();
        stm.execute("CREATE TABLE FILECHANGES (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL,CHANGESET INT NOT NULL,UNIQUE (FILE, CHANGESET))");
        stm.execute("CREATE TABLE FILECHANGES_2 (ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY,FILE INT NOT NULL,CHANGESET INT NOT NULL,UNIQUE (FILE, CHANGESET))");
        stm.execute("INSERT INTO FILECHANGES(FILE,CHANGESET) VALUES (1,1)");
        stm.execute("INSERT INTO FILECHANGES_2(FILE,CHANGESET) VALUES (1,1)");
        stm.close();
        this.commit();
    }

    private void setSchema(String schema) throws SQLException {
        Statement stm = this.createStatement();
        stm.execute("SET SCHEMA " + schema);
        stm.close();
    }

    public void testInsertNullIntoNonNullableColumn() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table d4488_t1 (pk int primary key)");
        s.execute("insert into d4488_t1 values 1");
        s.execute("create table d4488_t2 (c1 int, c2 int not null)");
        this.commit();
        PreparedStatement ps = this.prepareStatement("insert into d4488_t2(c1) select 1 from d4488_t1");
        for (int i = 0; i < 5; ++i) {
            ResultSetsFromPreparedStatementTest.assertStatementError(SQLSTATE_NULL_INTO_NON_NULL, ps);
            this.rollback();
        }
    }
}

