/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GeneratedColumnsTest
extends GeneratedColumnsHelper {
    private static final String IMPORT_FILE_NAME = "t_bi_1.dat";
    private static int _minusCounter;
    private static ArrayList _triggerReports;
    private String _clearingProcName;
    private String _triggerReportVTIName;

    public GeneratedColumnsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)TestConfiguration.embeddedSuite(GeneratedColumnsTest.class);
        CleanDatabaseTestSetup cleanDatabaseSuite = new CleanDatabaseTestSetup((Test)suite);
        SupportFilesSetup result = new SupportFilesSetup((Test)cleanDatabaseSuite, new String[]{"functionTests/tests/lang/t_bi_1.dat"});
        return result;
    }

    public void testDerby_4448_4451() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = null;
        this.setAutoCommit(false);
        s.execute("create table t(a int, b generated always as (-a))");
        s.execute("insert into t(b,a) values (default,1)");
        this.expectCompilationError("42XA3", "insert into t(b,a) select a,b from t union select a,b from t");
        this.expectCompilationError("42XA3", "insert into t(a,b) select * from t union select * from t");
        this.expectCompilationError("42XA3", "insert into t(b,a) select * from t union select * from t");
        this.expectCompilationError("42XA3", "insert into t(b,a) select * from t intersect select * from t");
        this.expectCompilationError("42XA3", "insert into t(b,a) select * from t except select * from t");
        this.expectCompilationError("42XA3", "insert into t(b,a) select a,b from t");
        this.expectCompilationError("42XA3", "insert into t(a,b) values (1,1)");
        this.expectCompilationError("42XA3", "insert into t(b,a) values (default,1), (2, 2)");
        this.expectCompilationError("42XA3", "insert into t(b,a) values (default,1), (default, 2),(3,3)");
        this.expectCompilationError("42XA3", "insert into t(b,a) values (1,1), (default, 2),(default,3)");
        s.execute("insert into t(b,a) values (default,1), (default, 2)");
        rs = s.executeQuery("select * from t");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "-1"}, {"1", "-1"}, {"2", "-2"}});
        this.expectCompilationError("42XA3", "insert into t(b) values (2)");
        this.expectCompilationError("42XA3", "insert into t(b) values (default), (2)");
        this.expectCompilationError("42XA3", "insert into t(b) values (default), (default), (2)");
        this.rollback();
    }

    public void testDerby_4426() throws SQLException {
        Statement s = this.createStatement();
        Object rs = null;
        this.setAutoCommit(false);
        s.execute("create table t(a int, b generated always as (-a))");
        s.execute("insert into t(b,a) values (default,1)");
        this.expectCompilationError("42Y85", "insert into t(b,a) values (default,3) intersect                    values (default,3)");
        this.expectCompilationError("42Y85", "insert into t(a,b) values (3,default) except values (3,default)");
        this.expectCompilationError("42Y85", "insert into t values (3,default) union values (3,default)");
        this.rollback();
    }

    public void test_001_determinism_of_stored_system_routines() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement functionCreate = conn.prepareStatement("create function f1()\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'foo.bar.wibble'\n");
        functionCreate.execute();
        functionCreate.close();
        PreparedStatement procedureCreate = conn.prepareStatement("create procedure p1()\nlanguage java\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
        procedureCreate.execute();
        procedureCreate.close();
        PreparedStatement ps = conn.prepareStatement("select s.schemaname, a.alias, a.aliastype, a.systemalias, a.aliasinfo\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaid = a.schemaid\norder by s.schemaname, a.alias\n");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String aliasName = rs.getString(2);
            boolean isSystemAlias = rs.getBoolean(4);
            RoutineAliasInfo rai = (RoutineAliasInfo)rs.getObject(5);
            if (!isSystemAlias) continue;
            GeneratedColumnsTest.assertFalse((String)aliasName, (boolean)rai.isDeterministic());
        }
        rs.close();
        ps.close();
    }

    public void test_002_determinism_positive() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f11()\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "F11", false);
        this.goodStatement(conn, "create function f12()\nreturns int\nlanguage java\nparameter style java\ndeterministic\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "F12", true);
        this.goodStatement(conn, "create function f13()\nreturns int\nlanguage java\nparameter style java\nno sql\nnot deterministic\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "F13", false);
        this.goodStatement(conn, "create procedure p11()\nlanguage java\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "P11", false);
        this.goodStatement(conn, "create procedure p12()\ndeterministic\nlanguage java\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "P12", true);
        this.goodStatement(conn, "create procedure p13()\nlanguage java\nnot deterministic\nparameter style java\nmodifies sql data\nexternal name 'foo.bar.wibble'\n");
        this.assertDeterministic(conn, "P13", false);
    }

    public void test_003_determinism_redundantClause() throws Exception {
        Connection conn = this.getConnection();
        this.expectCompilationError("42613", "create function f_fail()\nreturns int\nlanguage java\nparameter style java\ndeterministic\ndeterministic\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.expectCompilationError("42613", "create function f_fail()\nreturns int\nlanguage java\nparameter style java\nnot deterministic\ndeterministic\nno sql\nexternal name 'foo.bar.wibble'\n");
        this.expectCompilationError("42613", "create procedure p_fail()\nlanguage java\ndeterministic\nparameter style java\nmodifies sql data\ndeterministic\nexternal name 'foo.bar.wibble'\n");
        this.expectCompilationError("42613", "create procedure p_fail()\nlanguage java\nnot deterministic\nparameter style java\nmodifies sql data\nnot deterministic\nexternal name 'foo.bar.wibble'\n");
    }

    public void test_004_basicParser() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_parse_deterministic( a int )\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(conn, "create function f_parse_non_deterministic( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(conn, "create table t_parse_1\n(\n   a int,\n   b int generated always as ( f_parse_deterministic( a ) ),\n   c int\n)");
        this.expectCompilationError("42XA2", "create table t_parse_shouldFail\n(\n   a int,\n   b int generated always as ( f_parse_non_deterministic( a ) ),\n   c int\n)\n");
    }

    public void test_005_basicInsert() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_insert_1( a int,  b int  default 1, c int )");
        this.goodStatement(conn, "create table t_insert_2( a int,  b int  generated always as( -a ) check ( b < 0 ), c int )");
        this.goodStatement(conn, "create unique index t_insert_2_b on t_insert_2( b )");
        this.goodStatement(conn, "create table t_insert_3( a int, b int generated always as ( -a ) )");
        this.goodStatement(conn, "insert into t_insert_1( a, c ) values ( 100, 1000 ), ( 200, 2000 ), ( 300, 3000 )");
        this.goodStatement(conn, "insert into t_insert_2( a, c ) values ( 2, 200 )");
        this.goodStatement(conn, "insert into t_insert_2( a, c ) values ( 1, 100 ), ( 3, 300 ), ( 4, 400 ), ( 5, 500 )");
        this.goodStatement(conn, "insert into t_insert_2( a, c ) select a, c from t_insert_1");
        this.goodStatement(conn, "insert into t_insert_2( a, b ) values ( 6, default )");
        this.goodStatement(conn, "insert into t_insert_3 values ( 1, default )");
        this.goodStatement(conn, "insert into t_insert_3 values ( 2, default ), ( 3, default ), ( 4, default )");
        this.assertResults(conn, "select * from t_insert_2 order by a", new String[][]{{"1", "-1", "100"}, {"2", "-2", "200"}, {"3", "-3", "300"}, {"4", "-4", "400"}, {"5", "-5", "500"}, {"6", "-6", null}, {"100", "-100", "1000"}, {"200", "-200", "2000"}, {"300", "-300", "3000"}}, false);
        this.assertResults(conn, "select * from t_insert_3 order by a", new String[][]{{"1", "-1"}, {"2", "-2"}, {"3", "-3"}, {"4", "-4"}}, false);
        this.expectCompilationError("42XA3", "insert into t_insert_2( a, b ) values ( 7, 70 )");
        this.expectExecutionError(conn, "23513", "insert into t_insert_2( a ) values ( -8 )");
        this.expectExecutionError(conn, "23505", "insert into t_insert_2( a ) values ( 2 )");
    }

    public void test_006_basicUpdate() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(conn, "create function f_readMinusCounter()\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.readMinusCounter'\n");
        this.goodStatement(conn, "create table t_update_1( a int,  b int  generated always as( f_minus(a) ) check ( b < 0 ), c int )");
        this.goodStatement(conn, "create unique index t_update_1_b on t_update_1( b )");
        int counter = this.readMinusCounter(conn);
        this.goodStatement(conn, "insert into t_update_1( a, c ) values ( 1, 100 ), ( 2, 200 ), ( 3, 300 )");
        GeneratedColumnsTest.assertEquals((int)(counter + 3), (int)this.readMinusCounter(conn));
        counter = this.readMinusCounter(conn);
        this.goodStatement(conn, "update t_update_1\nset a = a + 10 where a > 1\n");
        GeneratedColumnsTest.assertEquals((int)(counter + 2), (int)this.readMinusCounter(conn));
        this.goodStatement(conn, "update t_update_1\nset a = a + 10, b = default where c = 300\n");
        this.expectCompilationError("42XA3", "update t_update_1\nset a = a + 10, b = -3 where c = 300\n");
        this.expectExecutionError(conn, "23513", "update t_update_1\nset a = -100\nwhere a = 1\n");
        this.expectExecutionError(conn, "23505", "update t_update_1\nset a = 12\nwhere a = 1\n");
        this.assertResults(conn, "select * from t_update_1 order by c", new String[][]{{"1", "-1", "100"}, {"12", "-12", "200"}, {"23", "-23", "300"}}, false);
    }

    public void test_007_basicTriggers() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_bt_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(conn, "create function triggerReports()\nreturns TABLE\n  (\n     contents varchar( 100 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.triggerReport'\n");
        this.goodStatement(conn, "create procedure clearTriggerReports\n()\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.clearTriggerReports'\n");
        this.goodStatement(conn, "create procedure report_proc\n( tag varchar( 40 ), a int, b int, c int )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.showValues'\n");
        this.goodStatement(conn, "create procedure wide_report_proc\n( tag varchar( 40 ), old_a int, old_b int, old_c int, new_a int, new_b int, new_c int )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.showValues'\n");
        this.goodStatement(conn, "create table t1_trig( a int, b int generated always as ( f_bt_minus(a) ), c int )\n");
        this.goodStatement(conn, "create trigger t1_trig_before_insert_row_trigger\nno cascade before insert on t1_trig\nreferencing new as ar\nfor each row\ncall report_proc( 'before_insert_row_trigger', ar.a, ar.a, ar.c )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_insert_row_trigger\nafter insert on t1_trig\nreferencing new as ar\nfor each row\ncall report_proc( 'after_insert_row_trigger', ar.a, ar.b, ar.c ) \n");
        this.goodStatement(conn, "create trigger t1_trig_before_update_row_trigger\nno cascade before update on t1_trig\nreferencing old as br new as ar\nfor each row\ncall wide_report_proc( 'before_update_row_trigger', br.a, br.b, br.c, ar.a, ar.a, ar.c )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_update_row_trigger\nafter update on t1_trig\nreferencing old as br new as ar\nfor each row\ncall wide_report_proc( 'after_update_row_trigger', br.a, br.b, br.c, ar.a, ar.b, ar.c )\n");
        this.goodStatement(conn, "create trigger t1_trig_before_delete_row_trigger\nno cascade before delete on t1_trig\nreferencing old as br\nfor each row\ncall report_proc( 'before_delete_row_trigger', br.a, br.b, br.c )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_delete_row_trigger\nafter delete on t1_trig\nreferencing old as br\nfor each row\ncall report_proc( 'after_delete_row_trigger', br.a, br.b, br.c )\n");
        this.goodStatement(conn, "create trigger t1_trig_before_insert_statement_trigger\nno cascade before insert on t1_trig\nfor each statement\ncall report_proc( 'before_insert_statement_trigger', -1, -1, -1 )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_insert_statement_trigger\nafter insert on t1_trig\nfor each statement\ncall report_proc( 'after_insert_statement_trigger', -1, -1, -1 )\n");
        this.goodStatement(conn, "create trigger t1_trig_before_update_statement_trigger\nno cascade before update on t1_trig\nfor each statement\ncall report_proc( 'before_update_statement_trigger', -1, -1, -1 )\n");
        this.goodStatement(conn, "create trigger t1_trig_before_delete_statement_trigger\nno cascade before delete on t1_trig\nfor each statement\ncall report_proc( 'before_delete_statement_trigger', -1, -1, -1 )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_update_statement_trigger\nafter update on t1_trig\nfor each statement\ncall report_proc( 'after_update_statement_trigger', -1, -1, -1 )\n");
        this.goodStatement(conn, "create trigger t1_trig_after_delete_statement_trigger\nafter delete on t1_trig\nfor each statement\ncall report_proc( 'after_delete_statement_trigger', -1, -1, -1 )\n");
        this._clearingProcName = "clearTriggerReports";
        this._triggerReportVTIName = "triggerReports";
        this.assertTriggerStatus(conn, "insert into t1_trig( a ) values ( 1 ), ( 2 ), ( 3 )", new String[][]{{"before_insert_row_trigger: [ 1, 1, null ]"}, {"before_insert_row_trigger: [ 2, 2, null ]"}, {"before_insert_row_trigger: [ 3, 3, null ]"}, {"before_insert_statement_trigger: [ -1, -1, -1 ]"}, {"after_insert_row_trigger: [ 1, -1, null ]"}, {"after_insert_row_trigger: [ 2, -2, null ]"}, {"after_insert_row_trigger: [ 3, -3, null ]"}, {"after_insert_statement_trigger: [ -1, -1, -1 ]"}});
        this.assertTriggerStatus(conn, "update t1_trig set a = a + 10", new String[][]{{"before_update_row_trigger: [ 1, -1, null, 11, 11, null ]"}, {"before_update_row_trigger: [ 2, -2, null, 12, 12, null ]"}, {"before_update_row_trigger: [ 3, -3, null, 13, 13, null ]"}, {"before_update_statement_trigger: [ -1, -1, -1 ]"}, {"after_update_row_trigger: [ 1, -1, null, 11, -11, null ]"}, {"after_update_row_trigger: [ 2, -2, null, 12, -12, null ]"}, {"after_update_row_trigger: [ 3, -3, null, 13, -13, null ]"}, {"after_update_statement_trigger: [ -1, -1, -1 ]"}});
        this.assertTriggerStatus(conn, "delete from t1_trig where a > 11", new String[][]{{"before_delete_row_trigger: [ 12, -12, null ]"}, {"before_delete_row_trigger: [ 13, -13, null ]"}, {"before_delete_statement_trigger: [ -1, -1, -1 ]"}, {"after_delete_row_trigger: [ 12, -12, null ]"}, {"after_delete_row_trigger: [ 13, -13, null ]"}, {"after_delete_statement_trigger: [ -1, -1, -1 ]"}});
    }

    public void test_008_basicForeignKeys() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_bfk_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(conn, "create table t1_for( a int, b int generated always as ( f_bfk_minus(a) ) primary key, c int )");
        this.goodStatement(conn, "create table t2_for( a int, b int references t1_for( b ), c int )");
        this.goodStatement(conn, "create table t3_for( a int, b int primary key, c int )");
        this.goodStatement(conn, "create table t4_for( a int, b int generated always as ( f_bfk_minus(a) ) references t3_for( b ), c int )");
        this.goodStatement(conn, "insert into t1_for( a ) values ( 1 ), ( 2 ), ( 3 )");
        this.goodStatement(conn, "insert into t2_for( b ) values ( -1 ), ( -3 )");
        this.goodStatement(conn, "insert into t3_for( b ) values ( 1 ), ( 2 ), ( 3 )");
        this.goodStatement(conn, "insert into t4_for( a ) values ( -1 ), ( -2 ), ( -3 )");
        this.expectExecutionError(conn, "23503", "update t1_for set a = a + 10 where a = 1");
        this.expectExecutionError(conn, "23503", "update t4_for set a = a + 10 where a = -1");
        this.expectExecutionError(conn, "23503", "insert into t4_for( a ) values ( -4 )");
    }

    public void test_009_basicDefaultInfo() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_di_1\n(\n   a int,\n   b int generated always as ( 1 ),\n   c int\n)");
        this.goodStatement(conn, "create table t_di_2\n(\n   a int,\n   b int generated always as ( -a ),\n   c int\n)");
        this.goodStatement(conn, "create table t_di_3\n(\n   a int,\n   b int generated always as ( a + c ),\n   c int\n)");
        this.assertDefaultInfo(conn, "T_DI_1", "B", new String[0], "1");
        this.assertDefaultInfo(conn, "T_DI_2", "B", new String[]{"A"}, "-a");
        this.assertDefaultInfo(conn, "T_DI_3", "B", new String[]{"A", "C"}, "a + c");
    }

    public void test_010_updateDefaultLiteral() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_ud_1( a int, b int generated always as ( a*a ) , c int )");
        this.goodStatement(conn, "create table t_ud_2( a int, b int generated always as ( a*c ) , c int )");
        this.goodStatement(conn, "insert into t_ud_1( a ) values ( 1 ), ( 2 )");
        this.goodStatement(conn, "insert into t_ud_2( a ) values ( 1 ), ( 2 )");
        this.expectCompilationError("42XA3", "update t_ud_1 set b = a*a");
        this.assertResults(conn, "select * from t_ud_1 order by a", new String[][]{{"1", "1", null}, {"2", "4", null}}, false);
        this.goodStatement(conn, "update t_ud_1 set c = -1, b = default");
        this.assertResults(conn, "select * from t_ud_1 order by a", new String[][]{{"1", "1", "-1"}, {"2", "4", "-1"}}, false);
        this.goodStatement(conn, "update t_ud_1 set a = 2*a, b = default");
        this.assertResults(conn, "select * from t_ud_1 order by a", new String[][]{{"2", "4", "-1"}, {"4", "16", "-1"}}, false);
        this.expectCompilationError("42XA3", "update t_ud_2 set b = a*c");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"1", null, null}, {"2", null, null}}, false);
        this.goodStatement(conn, "update t_ud_2 set b = default");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"1", null, null}, {"2", null, null}}, false);
        this.goodStatement(conn, "update t_ud_2 set c = -5");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"1", "-5", "-5"}, {"2", "-10", "-5"}}, false);
        this.goodStatement(conn, "update t_ud_2 set c = -3, b = default");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"1", "-3", "-3"}, {"2", "-6", "-3"}}, false);
        this.goodStatement(conn, "update t_ud_2 set a = 2*a, b = default");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"2", "-6", "-3"}, {"4", "-12", "-3"}}, false);
        this.goodStatement(conn, "update t_ud_2 set a = a - 1, b = default, c = 4");
        this.assertResults(conn, "select * from t_ud_2 order by a", new String[][]{{"1", "4", "4"}, {"3", "12", "4"}}, false);
    }

    public void test_011_basicAlter() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_alt_1( a int, c int )");
        this.goodStatement(conn, "create function f_alt_deterministic( a int )\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(conn, "create function f_alt_non_deterministic( a int )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(conn, "insert into t_alt_1( a ) values ( 1 ), ( 2 )");
        this.goodStatement(conn, "alter table t_alt_1 add column b int generated always as ( -a )");
        this.assertResults(conn, "select * from t_alt_1 order by a", new String[][]{{"1", null, "-1"}, {"2", null, "-2"}}, false);
        this.goodStatement(conn, "insert into t_alt_1( a ) values ( 3 ), ( 4 )");
        this.assertResults(conn, "select * from t_alt_1 order by a", new String[][]{{"1", null, "-1"}, {"2", null, "-2"}, {"3", null, "-3"}, {"4", null, "-4"}}, false);
        this.expectCompilationError("42XA2", "alter table t_alt_1 add column d int generated always as ( f_alt_non_deterministic( a ) )");
        this.goodStatement(conn, "alter table t_alt_1 add column d int generated always as ( f_alt_deterministic( a ) )");
        this.assertResults(conn, "select * from t_alt_1 order by a", new String[][]{{"1", null, "-1", "1"}, {"2", null, "-2", "2"}, {"3", null, "-3", "3"}, {"4", null, "-4", "4"}}, false);
    }

    public void test_012_referencedColumns() throws Exception {
        Connection conn = this.getConnection();
        this.expectCompilationError("42XA4", "create table t_recurse_1( a int, b int generated always as ( -a ), c int generated always as ( b*b) )");
        this.expectCompilationError("42XA4", "create table t_recurse_1( a int, b int generated always as ( -b ) )");
        this.goodStatement(conn, "create table t_recurse_1( a int, b int generated always as ( -a ) )");
        this.expectCompilationError("42XA4", "alter table t_recurse_1 add column c int generated always as ( b*b )");
        this.expectCompilationError("42XA4", "alter table t_recurse_1 add column c int generated always as ( -c )");
    }

    public void test_013_badReferences() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_br_1( a int )");
        this.goodStatement(conn, "create table t_br_3( a int )");
        this.goodStatement(conn, "create function f_br_reads_sql( a int )\nreturns int\nlanguage java\ndeterministic\nparameter style java\nreads sql data\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(conn, "create function f_br_contains_sql( a int )\nreturns int\nlanguage java\ndeterministic\nparameter style java\ncontains sql\nexternal name 'java.lang.Math.abs'\n");
        this.expectCompilationError("42X04", "create table t_br_2( a int, b int generated always as ( t_br_1.a ) )");
        this.expectCompilationError("42X01", "create table t_br_2( a int, b int generated always as ( select a from t_br_1 ) )");
        this.expectCompilationError("42X04", "alter table t_br_3 add column b int generated always as ( t_br_1.a )");
        this.expectCompilationError("42X01", "alter table t_br_3 add column b int generated always as ( select a from t_br_1 )");
        this.expectCompilationError("42XA5", "create table t_br_2( a int, b int generated always as ( f_br_reads_sql( a ) ) )");
        this.expectCompilationError("42XA5", "create table t_br_2( a int, b int generated always as ( f_br_contains_sql( a ) ) )");
        this.expectCompilationError("42XA1", "create table t_br_2( a int, b int generated always as ( sum( a ) ) )");
        this.expectCompilationError("42XA1", "create table t_br_2( a int, b int generated always as ( max( a ) ) )");
        this.expectCompilationError("42XA1", "create table t_br_2( a int, b int generated always as ( min( a ) ) )");
        this.expectCompilationError("42XA1", "create table t_br_2( a int, b int generated always as ( count( a ) ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b date generated always as ( current_date ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b time generated always as ( current_time ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b timestamp generated always as ( current_timestamp ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b varchar( 128 ) generated always as ( current_user ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b varchar( 128 ) generated always as ( session_user ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b date generated always as ( current schema ) )");
        this.expectCompilationError("42XA2", "create table t_br_2( a int, b date generated always as ( current sqlid ) )");
    }

    public void test_014_assignment() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_dt_smallint\n(\n   a  smallint,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_int\n(\n   a  int,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_bigint\n(\n   a  bigint,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_decimal\n(\n   a  decimal,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_real\n(\n   a  real,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_double\n(\n   a  double,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_float\n(\n   a  float,\n   b  smallint generated always as ( -a ),\n   c  int generated always as ( -a ),\n   d bigint generated always as ( -a ),\n   e decimal generated always as ( -a ),\n   f real generated always as ( -a ),\n   g double generated always as ( -a ),\n   h float generated always as ( -a )\n)\n");
        this.goodStatement(conn, "create table t_dt_char\n(\n   a  char( 20 ),\n   b  char( 20 ) generated always as ( upper( a ) ),\n   c  varchar( 20 ) generated always as ( upper( a ) ),\n   d long varchar generated always as ( upper( a ) ),\n   e clob generated always as ( upper( a ) ),\n   f date generated always as ( a ),\n   g time generated always as ( '15:09:02' ),\n   h timestamp generated always as ( trim( a ) || ' 03:23:34.234' )\n)\n");
        this.goodStatement(conn, "create table t_dt_varchar\n(\n   a  varchar( 20 ),\n   b  char( 20 ) generated always as ( upper( a ) ),\n   c  varchar( 20 ) generated always as ( upper( a ) ),\n   d long varchar generated always as ( upper( a ) ),\n   e clob generated always as ( upper( a ) ),\n   f date generated always as ( a ),\n   g time generated always as ( '15:09:02' ),\n   h timestamp generated always as ( trim( a ) || ' 03:23:34.234' )\n)\n");
        this.goodStatement(conn, "create table t_dt_longvarchar\n(\n   a  long varchar,\n   b  char( 20 ) generated always as ( upper( a ) ),\n   c  varchar( 20 ) generated always as ( upper( a ) ),\n   d long varchar generated always as ( upper( a ) ),\n   e clob generated always as ( upper( a ) )\n)\n");
        this.goodStatement(conn, "create table t_dt_clob\n(\n   a  clob,\n   b  char( 20 ) generated always as ( upper( a ) ),\n   c  varchar( 20 ) generated always as ( upper( a ) ),\n   d long varchar generated always as ( upper( a ) ),\n   e clob generated always as ( upper( a ) )\n)\n");
        this.goodStatement(conn, "create table t_dt_charforbitdata\n(\n   a  char( 4 ) for bit data,\n   b  char( 4) for bit data generated always as ( a ),\n   c  varchar( 4 ) for bit data generated always as ( a ),\n   d long varchar for bit data generated always as ( a )\n)\n");
        this.goodStatement(conn, "create table t_dt_varcharforbitdata\n(\n   a  varchar( 4 ) for bit data,\n   b  char( 4) for bit data generated always as ( a ),\n   c  varchar( 4 ) for bit data generated always as ( a ),\n   d long varchar for bit data generated always as ( a )\n)\n");
        this.goodStatement(conn, "create table t_dt_longvarcharforbitdata\n(\n   a  long varchar for bit data,\n   b  char( 4) for bit data generated always as ( a ),\n   c  varchar( 4 ) for bit data generated always as ( a ),\n   d long varchar for bit data generated always as ( a )\n)\n");
        this.goodStatement(conn, "create table t_dt_date\n(\n   a  date,\n   b  char( 20 ) generated always as ( a ),\n   c  varchar( 20 ) generated always as ( a ),\n   d date generated always as ( a )\n)\n");
        this.goodStatement(conn, "create table t_dt_time\n(\n   a  time,\n   b  char( 20 ) generated always as ( a ),\n   c  varchar( 20 ) generated always as ( a ),\n   d time generated always as ( a )\n)\n");
        this.goodStatement(conn, "create table t_dt_timestamp\n(\n   a  timestamp,\n   b  char( 30 ) generated always as ( a ),\n   c  varchar( 30 ) generated always as ( a ),\n   d timestamp generated always as ( a )\n)\n");
        this.goodStatement(conn, "insert into t_dt_smallint( a ) values ( 1 )");
        this.goodStatement(conn, "insert into t_dt_int( a ) values ( 1 )");
        this.goodStatement(conn, "insert into t_dt_bigint( a ) values ( 1 )");
        this.goodStatement(conn, "insert into t_dt_decimal( a ) values ( 1.0 )");
        this.goodStatement(conn, "insert into t_dt_real( a ) values ( 1.0 )");
        this.goodStatement(conn, "insert into t_dt_double( a ) values ( 1.0 )");
        this.goodStatement(conn, "insert into t_dt_float( a ) values ( 1.0 )");
        this.goodStatement(conn, "insert into t_dt_char( a ) values ( '1994-02-23' )");
        this.goodStatement(conn, "insert into t_dt_varchar( a ) values ( '1994-02-23' )");
        this.goodStatement(conn, "insert into t_dt_longvarchar( a ) values ( 'foo' )");
        this.goodStatement(conn, "insert into t_dt_clob( a ) values ( 'foo' )");
        this.goodStatement(conn, "insert into t_dt_charforbitdata( a ) values ( X'ABCDEFAB' )");
        this.goodStatement(conn, "insert into t_dt_varcharforbitdata( a ) values ( X'ABCDEFAB' )");
        this.goodStatement(conn, "insert into t_dt_longvarcharforbitdata( a ) values ( X'ABCDEFAB' )");
        this.goodStatement(conn, "insert into t_dt_date( a ) values ( date('1994-02-23') )");
        this.goodStatement(conn, "insert into t_dt_time( a ) values ( time('15:09:02') )");
        this.goodStatement(conn, "insert into t_dt_timestamp( a ) values ( timestamp('1962-09-23 03:23:34.234') )");
        this.assertResults(conn, "select * from t_dt_smallint order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_int order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_bigint order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_decimal order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_real order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_double order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_float order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.assertResults(conn, "select * from t_dt_char order by a", new String[][]{{"1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "15:09:02", "1994-02-23 03:23:34.234"}}, true);
        this.assertResults(conn, "select * from t_dt_varchar order by a", new String[][]{{"1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "15:09:02", "1994-02-23 03:23:34.234"}}, true);
        this.assertResults(conn, "select * from t_dt_longvarchar", new String[][]{{"foo", "FOO", "FOO", "FOO", "FOO"}}, true);
        this.assertResults(conn, "select * from t_dt_clob", new String[][]{{"foo", "FOO", "FOO", "FOO", "FOO"}}, true);
        this.assertResults(conn, "select * from t_dt_charforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, true);
        this.assertResults(conn, "select * from t_dt_varcharforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, true);
        this.assertResults(conn, "select * from t_dt_longvarcharforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, true);
        this.assertResults(conn, "select * from t_dt_date order by a", new String[][]{{"1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23"}}, true);
        this.assertResults(conn, "select * from t_dt_time order by a", new String[][]{{"15:09:02", "15:09:02", "15:09:02", "15:09:02"}}, true);
        this.assertResults(conn, "select * from t_dt_timestamp order by a", new String[][]{{"1962-09-23 03:23:34.234", "1962-09-23 03:23:34.234", "1962-09-23 03:23:34.234", "1962-09-23 03:23:34.234"}}, true);
    }

    public void test_015_foreignKeyActions() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t1_for_ra( a int, b int primary key )");
        this.goodStatement(conn, "create table t3_for_ra( a int, b int, constraint t3_for_ra_pk primary key( a, b ) )");
        this.goodStatement(conn, "create table t6_for_ra( a int, b int generated always as (-a) )");
        this.expectCompilationError("42XA6", "create table t2_for_ra( a int, b int generated always as ( -a ) references t1_for_ra( b ) on delete set null )");
        this.expectCompilationError("42XA6", "create table t2_for_ra( a int, b int generated always as ( -a ) references t1_for_ra( b ) on delete set default )");
        this.expectCompilationError("42XA6", "create table t4_for_ra\n(\n   aa int,\n   bb int generated always as ( -aa ),\n   cc int,\n   constraint t4_for_ra_fk foreign key( aa, bb ) references t3_for_ra( a, b ) on delete set null\n)\n");
        this.expectCompilationError("42XA6", "create table t4_for_ra\n(\n   aa int,\n   bb int generated always as ( -aa ),\n   cc int,\n   constraint t4_for_ra_fk foreign key( aa, bb ) references t3_for_ra( a, b ) on delete set default\n)\n");
        this.expectCompilationError("42XA6", "alter table t6_for_ra\n  add constraint t6_for_ra_fk foreign key( b ) references t1_for_ra( b ) on delete set null\n");
        this.expectCompilationError("42XA6", "alter table t6_for_ra\n  add constraint t6_for_ra_fk foreign key( b ) references t1_for_ra( b ) on delete set default\n");
        this.expectCompilationError("42X01", "alter table t6_for_ra\n  add constraint t6_for_ra_fk foreign key( b ) references t1_for_ra( b ) on update cascade\n");
    }

    public void test_016_notNull() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t1_nn( a int, b int generated always as (-a) not null, c int )");
        this.goodStatement(conn, "create table t2_nn( a int, c int )");
        this.goodStatement(conn, "insert into t1_nn( a ) values ( 1 )");
        this.expectExecutionError(conn, "23502", "insert into t1_nn( c ) values ( 1 )");
        this.goodStatement(conn, "update t1_nn set a = a + 1");
        this.expectExecutionError(conn, "23502", "update t1_nn set a = null");
        this.assertResults(conn, "select * from t1_nn order by a", new String[][]{{"2", "-2", null}}, true);
        this.goodStatement(conn, "insert into t2_nn values ( 1, 1 )");
        this.goodStatement(conn, "alter table t2_nn\n  add column b int generated always as (-a) not null\n");
        this.goodStatement(conn, "insert into t2_nn( a ) values ( 2 )");
        this.expectExecutionError(conn, "23502", "insert into t2_nn( c ) values ( 10 )");
        this.goodStatement(conn, "update t2_nn set a = a + 1");
        this.expectExecutionError(conn, "23502", "update t2_nn set a = null");
        this.assertResults(conn, "select * from t2_nn order by a", new String[][]{{"2", "1", "-2"}, {"3", null, "-3"}}, true);
    }

    public void test_017_padding() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_cc_char\n(\n    a char( 10 ),\n    b char( 5 ) generated always as( cast(upper( a ) as char(5))),\n    c char( 10 ) generated always as( upper( a ) ),\n    d char( 15 ) generated always as( upper( a ) ),\n    e varchar( 5 ) generated always as( cast(upper( a ) as varchar(5))),\n    f varchar( 10 ) generated always as( upper( a ) ),\n    g varchar( 15 ) generated always as( upper( a ) )\n)\n");
        this.goodStatement(conn, "create table t_cc_varchar\n(\n    a varchar( 10 ),\n    b char( 5 ) generated always as( cast(upper( a ) as char(5))),\n    c char( 10 ) generated always as( upper( a ) ),\n    d char( 15 ) generated always as( upper( a ) ),\n    e varchar( 5 ) generated always as( cast(upper( a ) as varchar(5))),\n    f varchar( 10 ) generated always as( upper( a ) ),\n    g varchar( 15 ) generated always as( upper( a ) )\n)\n");
        this.goodStatement(conn, "create table t_cc_decimal\n(\n    a decimal( 6, 2 ),\n    b decimal( 5, 1 ) generated always as ( a ),\n    c decimal( 5, 2 ) generated always as ( a ),\n    d decimal( 5, 3 ) generated always as ( a ),\n    e decimal( 6, 1 ) generated always as ( a ),\n    f decimal( 6, 2 ) generated always as ( a ),\n    g decimal( 6, 3 ) generated always as ( a ),\n    h decimal( 7, 1 ) generated always as ( a ),\n    i decimal( 7, 2 ) generated always as ( a ),\n    j decimal( 7, 3 ) generated always as ( a )\n)\n");
        this.goodStatement(conn, "insert into t_cc_char( a ) values ( 'abcdefghij' )");
        this.goodStatement(conn, "insert into t_cc_varchar( a ) values ( 'abcdefghij' )");
        this.goodStatement(conn, "insert into t_cc_decimal( a ) values ( 12.345 )");
        this.assertResults(conn, "select * from t_cc_char order by a", new String[][]{{"abcdefghij", "ABCDE", "ABCDEFGHIJ", "ABCDEFGHIJ     ", "ABCDE", "ABCDEFGHIJ", "ABCDEFGHIJ"}}, false);
        this.assertResults(conn, "select * from t_cc_varchar order by a", new String[][]{{"abcdefghij", "ABCDE", "ABCDEFGHIJ", "ABCDEFGHIJ     ", "ABCDE", "ABCDEFGHIJ", "ABCDEFGHIJ"}}, false);
        this.assertResults(conn, "select * from t_cc_decimal order by a", new String[][]{{"12.34", "12.3", "12.34", "12.340", "12.3", "12.34", "12.340", "12.3", "12.34", "12.340"}}, true);
    }

    public void test_018_alterDatatype() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_atac_1( a char( 5 ), b varchar( 5 ) generated always as ( upper( a )  ) )");
        this.goodStatement(conn, "create table t_atac_2( a char( 5 ) for bit data,  b varchar( 5 ) for bit data generated always as ( a )  )");
        this.goodStatement(conn, "create table t_atac_3( a varchar( 5 ), b varchar( 5 ) generated always as ( cast(upper( a ) as varchar(5)) ) )");
        this.goodStatement(conn, "create table t_atac_4( a varchar( 5 ) for bit data,  b varchar( 5 ) for bit data generated always as ( cast(a as varchar( 5 ) for bit data))  )");
        this.goodStatement(conn, "insert into t_atac_1( a ) values ( 'abc' )");
        this.goodStatement(conn, "insert into t_atac_2( a ) values ( X'AB' )");
        this.goodStatement(conn, "insert into t_atac_3( a ) values ( 'abc' )");
        this.goodStatement(conn, "insert into t_atac_3( a ) values ( 'abcde' )");
        this.goodStatement(conn, "insert into t_atac_4( a ) values ( X'AB' )");
        this.goodStatement(conn, "insert into t_atac_4( a ) values ( X'ABCDEFABCD' )");
        this.goodStatement(conn, "alter table t_atac_1\n  alter column b set data type varchar( 10 )\n");
        this.goodStatement(conn, "alter table t_atac_2\n  alter column b set data type varchar( 10 ) for bit data\n");
        this.goodStatement(conn, "alter table t_atac_3\n  alter column a set data type varchar( 10 )\n");
        this.goodStatement(conn, "alter table t_atac_4\n  alter column a set data type varchar( 10 ) for bit data\n");
        this.goodStatement(conn, "insert into t_atac_3( a ) values ( 'abcdefg' )");
        this.goodStatement(conn, "insert into t_atac_4( a ) values ( X'ABCDEFABCDAB' )");
        this.assertResults(conn, "select * from t_atac_1 order by a", new String[][]{{"abc  ", "ABC  "}}, false);
        this.assertResults(conn, "select * from t_atac_2 order by a", new String[][]{{"ab20202020", "ab20202020"}}, false);
        this.assertResults(conn, "select * from t_atac_3 order by a", new String[][]{{"abc", "ABC"}, {"abcde", "ABCDE"}, {"abcdefg", "ABCDE"}}, false);
        this.assertResults(conn, "select * from t_atac_4 order by a", new String[][]{{"ab", "ab"}, {"abcdefabcd", "abcdefabcd"}, {"abcdefabcdab", "abcdefabcd"}}, false);
    }

    public void test_019_dropColumn() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_dc_1( a int, b int, c int generated always as ( -b ), d int )");
        this.goodStatement(conn, "insert into t_dc_1( b, d ) values ( 1, 1 )");
        this.goodStatement(conn, "alter table t_dc_1 drop column c restrict");
        this.goodStatement(conn, "insert into t_dc_1( b, d ) values ( 1, 1 )");
        this.assertResults(conn, "select * from t_dc_1 order by d", new String[][]{{null, "1", "1"}, {null, "1", "1"}}, false);
        this.goodStatement(conn, "create table t_dc_2( a int, b int, c int generated always as ( -b ), d int )");
        this.goodStatement(conn, "insert into t_dc_2( b, d ) values ( 1, 1 )");
        this.goodStatement(conn, "insert into t_dc_2( d ) values ( 2 )");
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_2 drop column b restrict");
        this.expectExecutionWarning(conn, "01009", "alter table t_dc_2 drop column b");
        this.goodStatement(conn, "insert into t_dc_2( d ) values ( 2 )");
        this.goodStatement(conn, "insert into t_dc_2( a, d ) values ( 3, 3 )");
        this.assertResults(conn, "select * from t_dc_2 order by d", new String[][]{{null, "1"}, {null, "2"}, {null, "2"}, {"3", "3"}}, false);
        this.goodStatement(conn, "alter table t_dc_2 drop column a restrict");
        this.goodStatement(conn, "insert into t_dc_2( d ) values ( 4 )");
        this.assertResults(conn, "select * from t_dc_2 order by d", new String[][]{{"1"}, {"2"}, {"2"}, {"3"}, {"4"}}, false);
        this.goodStatement(conn, "create table t_dc_3( a int, b int, c int, d int generated always as ( -c ), e int, f int )");
        this.goodStatement(conn, "insert into t_dc_3( b, c, f ) values ( 1, 1, 1 )");
        this.goodStatement(conn, "insert into t_dc_3( c ) values ( 2 )");
        this.goodStatement(conn, "insert into t_dc_3( f ) values ( 3 )");
        this.goodStatement(conn, "alter table t_dc_3 drop column a restrict");
        this.goodStatement(conn, "insert into t_dc_3( b, c, f ) values ( 1, 1, 1 )");
        this.goodStatement(conn, "insert into t_dc_3( c ) values ( 2 )");
        this.goodStatement(conn, "insert into t_dc_3( f ) values ( 3 )");
        this.assertResults(conn, "select * from t_dc_3 order by f", new String[][]{{"1", "1", "-1", null, "1"}, {"1", "1", "-1", null, "1"}, {null, null, null, null, "3"}, {null, null, null, null, "3"}, {null, "2", "-2", null, null}, {null, "2", "-2", null, null}}, false);
        this.goodStatement(conn, "alter table t_dc_3 drop column e restrict");
        this.goodStatement(conn, "insert into t_dc_3( b, c, f ) values ( 1, 1, 1 )");
        this.goodStatement(conn, "insert into t_dc_3( c ) values ( 2 )");
        this.goodStatement(conn, "insert into t_dc_3( f ) values ( 3 )");
        this.assertResults(conn, "select * from t_dc_3 order by f", new String[][]{{"1", "1", "-1", "1"}, {"1", "1", "-1", "1"}, {"1", "1", "-1", "1"}, {null, null, null, "3"}, {null, null, null, "3"}, {null, null, null, "3"}, {null, "2", "-2", null}, {null, "2", "-2", null}, {null, "2", "-2", null}}, false);
        this.goodStatement(conn, "alter table t_dc_3 drop column c");
        this.goodStatement(conn, "insert into t_dc_3( f ) values ( 3 )");
        this.assertResults(conn, "select * from t_dc_3 order by f", new String[][]{{"1", "1"}, {"1", "1"}, {"1", "1"}, {null, "3"}, {null, "3"}, {null, "3"}, {null, "3"}, {null, null}, {null, null}, {null, null}}, false);
        this.goodStatement(conn, "create table t_dc_4( a int, b int, c int, d int generated always as ( -(a + e) ), e int, f int )");
        this.goodStatement(conn, "insert into t_dc_4( a, f ) values ( 1, 1 )");
        this.goodStatement(conn, "insert into t_dc_4( a, e, f ) values ( 2, 2, 2 )");
        this.assertResults(conn, "select * from t_dc_4 order by f", new String[][]{{"1", null, null, null, null, "1"}, {"2", null, null, "-4", "2", "2"}}, false);
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_4 drop column a restrict");
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_4 drop column e restrict");
        this.expectExecutionWarning(conn, "01009", "alter table t_dc_4 drop column e");
        this.goodStatement(conn, "insert into t_dc_4( a, f ) values ( 1, 1 )");
        this.assertResults(conn, "select * from t_dc_4 order by f", new String[][]{{"1", null, null, "1"}, {"1", null, null, "1"}, {"2", null, null, "2"}}, false);
        this.goodStatement(conn, "create table t_dc_5( a int generated always as ( -b ), b int, c int )");
        this.goodStatement(conn, "insert into t_dc_5( b, c ) values ( 100, 1 )");
        this.goodStatement(conn, "insert into t_dc_5( c ) values ( 2 )");
        this.assertResults(conn, "select * from t_dc_5 order by c", new String[][]{{"-100", "100", "1"}, {null, null, "2"}}, false);
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_5 drop column b restrict");
        this.expectExecutionWarning(conn, "01009", "alter table t_dc_5 drop column b");
        this.goodStatement(conn, "insert into t_dc_5( c ) values ( 2 )");
        this.assertResults(conn, "select * from t_dc_5 order by c", new String[][]{{"1"}, {"2"}, {"2"}}, false);
        this.goodStatement(conn, "create table t_dc_6_prim( a int generated always as ( -b ) primary key, b int, c int )");
        this.goodStatement(conn, "create table t_dc_6_for( a int references t_dc_6_prim( a ) )");
        this.goodStatement(conn, "insert into t_dc_6_prim( b, c ) values ( 100, 1 )");
        this.expectExecutionError(conn, "23505", "insert into t_dc_6_prim( b, c ) values ( 100, 2 )");
        this.goodStatement(conn, "insert into t_dc_6_for( a ) values ( -100 )");
        this.expectExecutionError(conn, "23503", "insert into t_dc_6_for( a ) values ( -101 )");
        this.expectExecutionWarnings(conn, new String[]{"01009", "01500", "01500"}, "alter table t_dc_6_prim drop column b");
        this.goodStatement(conn, "insert into t_dc_6_prim( c ) values ( 2 )");
        this.goodStatement(conn, "insert into t_dc_6_for( a ) values ( -101 )");
        this.assertResults(conn, "select * from t_dc_6_prim order by c", new String[][]{{"1"}, {"2"}}, false);
        this.assertResults(conn, "select * from t_dc_6_for order by a", new String[][]{{"-101"}, {"-100"}}, false);
        this.goodStatement(conn, "create table t_dc_7( a int generated always as ( -b ), b int, c int )");
        this.goodStatement(conn, "create function dc_triggerReports()\nreturns TABLE\n  (\n     contents varchar( 100 )\n  )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.triggerReport'\n");
        this.goodStatement(conn, "create procedure dc_clearTriggerReports\n()\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.clearTriggerReports'\n");
        this.goodStatement(conn, "create procedure dc_report_proc\n( tag varchar( 40 ), a int, b int, c int )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.showValues'\n");
        this.goodStatement(conn, "create trigger t_dc_7_trig_after_update\nafter update of a\non t_dc_7\nreferencing new as ar\nfor each row\ncall dc_report_proc( 'after_update_row_trigger', ar.a, ar.a, ar.a ) \n");
        this._clearingProcName = "dc_clearTriggerReports";
        this._triggerReportVTIName = "dc_triggerReports";
        this.goodStatement(conn, "insert into t_dc_7( b, c ) values ( 100, 1 )");
        this.assertTriggerStatus(conn, "update t_dc_7 set b = 101", new String[][]{{"after_update_row_trigger: [ -101, -101, -101 ]"}});
        this.expectExecutionWarnings(conn, new String[]{"01009", "01502"}, "alter table t_dc_7 drop column b");
        this.goodStatement(conn, "insert into t_dc_7( c ) values ( 2 )");
        this.assertTriggerStatus(conn, "update t_dc_7 set c = c + 1000", new String[0][]);
        this.assertResults(conn, "select * from t_dc_7 order by c", new String[][]{{"1001"}, {"1002"}}, false);
        this.goodStatement(conn, "create table t_dc_8( a int generated always as ( -b ), b int )");
        this.goodStatement(conn, "insert into t_dc_8( b ) values ( 1 )");
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_8 drop column b");
        this.goodStatement(conn, "insert into t_dc_8( b ) values ( 2 )");
        this.assertResults(conn, "select * from t_dc_8 order by b", new String[][]{{"-1", "1"}, {"-2", "2"}}, false);
        this.goodStatement(conn, "create table t_dc_9( a int generated always as ( -b ), b int, c int )");
        this.goodStatement(conn, "create unique index t_dc_9_a_idx on t_dc_9( a )");
        this.goodStatement(conn, "insert into t_dc_9( c ) values ( 1 )");
        this.expectExecutionError(conn, "23505", "insert into t_dc_9( c ) values ( 1 )");
        this.expectExecutionWarning(conn, "01009", "alter table t_dc_9 drop column b");
        this.goodStatement(conn, "insert into t_dc_9( c ) values ( 1 )");
        this.assertResults(conn, "select * from t_dc_9 order by c", new String[][]{{"1"}, {"1"}}, false);
        this.goodStatement(conn, "create table t_dc_10( a int generated always as ( -b ) check ( a is not null ), b int, c int )");
        this.goodStatement(conn, "insert into t_dc_10( b, c ) values ( 1, 1 )");
        this.expectExecutionError(conn, "23513", "insert into t_dc_10( c ) values ( 2 )");
        this.expectExecutionError(conn, "X0Y25", "alter table t_dc_10 drop column a restrict");
        this.expectExecutionWarnings(conn, new String[]{"01009", "01500"}, "alter table t_dc_10 drop column b");
        this.goodStatement(conn, "insert into t_dc_10( c ) values ( 2 )");
        this.assertResults(conn, "select * from t_dc_10 order by c", new String[][]{{"1"}, {"2"}}, false);
    }

    public void test_020_alterColumn() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_ad_1( a int generated always as ( -b ), b int, c int )");
        this.expectCompilationError("42XA7", "alter table t_ad_1 alter column a with default 1");
        this.expectCompilationError("42XA8", "rename column t_ad_1.b to d");
    }

    public void test_021_dropFunction() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_fd_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(conn, "create function f_fd_minus_2\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(conn, "create table t_fd_1( a int generated always as ( f_fd_minus( b ) ), b int )");
        this.goodStatement(conn, "insert into t_fd_1( b ) values ( 1 )");
        this.expectExecutionError(conn, "X0Y25", "drop function f_fd_minus");
        this.goodStatement(conn, "alter table t_fd_1 drop column a");
        this.goodStatement(conn, "drop function f_fd_minus");
        this.goodStatement(conn, "insert into t_fd_1( b ) values ( 1 )");
        this.goodStatement(conn, "alter table t_fd_1 add column c int generated always as ( f_fd_minus_2( b ) )");
        this.goodStatement(conn, "insert into t_fd_1( b ) values ( 1 )");
        this.expectExecutionError(conn, "X0Y25", "drop function f_fd_minus_2");
        this.goodStatement(conn, "alter table t_fd_1 drop column c");
        this.goodStatement(conn, "drop function f_fd_minus_2");
        this.goodStatement(conn, "insert into t_fd_1( b ) values ( 1 )");
        this.assertResults(conn, "select * from t_fd_1 order by b", new String[][]{{"1"}, {"1"}, {"1"}, {"1"}}, false);
    }

    public void test_022_omitDatatype() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_nd_1( a int )");
        this.goodStatement(conn, "alter table t_nd_1 add b generated always as ( -a )");
        this.goodStatement(conn, "insert into t_nd_1( a ) values ( 1 )");
        this.assertColumnTypes(conn, "T_ND_1", new String[][]{{"A", "INTEGER"}, {"B", "INTEGER"}});
        this.assertResults(conn, "select * from t_nd_1 order by a", new String[][]{{"1", "-1"}}, false);
        this.expectCompilationError("42XA9", "create table t_nd_2( a generated always as identity )");
        this.expectCompilationError("42601", "alter table t_nd_1 add c generated always as identity");
        this.goodStatement(conn, "create table t_nd_3( a int, b generated always as ( -a ) )");
        this.goodStatement(conn, "insert into t_nd_3( a ) values ( 100 )");
        this.assertColumnTypes(conn, "T_ND_3", new String[][]{{"A", "INTEGER"}, {"B", "INTEGER"}});
        this.assertResults(conn, "select * from t_nd_3 order by a", new String[][]{{"100", "-100"}}, false);
        this.goodStatement(conn, "create table t_nd_smallint\n(\n   a smallint,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_smallint( a ) values ( 1 )");
        this.assertColumnTypes(conn, "T_ND_SMALLINT", new String[][]{{"A", "SMALLINT"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_smallint order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_int\n(\n   a int,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_int( a ) values ( 1 )");
        this.assertColumnTypes(conn, "T_ND_INT", new String[][]{{"A", "INTEGER"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_int order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_bigint\n(\n   a bigint,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_bigint( a ) values ( 1 )");
        this.assertColumnTypes(conn, "T_ND_BIGINT", new String[][]{{"A", "BIGINT"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_bigint order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_decimal\n(\n   a decimal,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_decimal( a ) values ( 1.0 )");
        this.assertColumnTypes(conn, "T_ND_DECIMAL", new String[][]{{"A", "DECIMAL(5,0)"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_decimal order by a", new String[][]{{"1", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_real\n(\n   a real,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_real( a ) values ( 1.0 )");
        this.assertColumnTypes(conn, "T_ND_REAL", new String[][]{{"A", "REAL"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_real order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_double\n(\n   a double,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_double( a ) values ( 1.0 )");
        this.assertColumnTypes(conn, "T_ND_DOUBLE", new String[][]{{"A", "DOUBLE"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_double order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_float\n(\n   a float,\n   b generated always as ( cast ( -a  as smallint ) ),\n   c generated always as ( cast ( -a as int ) ),\n   d generated always as ( cast( -a as bigint ) ),\n   e generated always as ( cast ( -a as decimal ) ),\n   f generated always as ( cast ( -a as real ) ),\n   g generated always as ( cast ( -a as double ) ),\n   h generated always as ( cast ( -a as float ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_float( a ) values ( 1.0 )");
        this.assertColumnTypes(conn, "T_ND_FLOAT", new String[][]{{"A", "DOUBLE"}, {"B", "SMALLINT"}, {"C", "INTEGER"}, {"D", "BIGINT"}, {"E", "DECIMAL(5,0)"}, {"F", "REAL"}, {"G", "DOUBLE"}, {"H", "DOUBLE"}});
        this.assertResults(conn, "select * from t_nd_float order by a", new String[][]{{"1.0", "-1", "-1", "-1", "-1", "-1.0", "-1.0", "-1.0"}}, false);
        this.goodStatement(conn, "create table t_nd_char\n(\n   a char( 20 ),\n   b generated always as ( cast ( upper( a ) as char( 20 ) ) ),\n   c generated always as ( cast ( upper( a ) as varchar( 20 ) ) ),\n   d generated always as ( cast ( upper( a ) as long varchar ) ),\n   e generated always as ( cast ( upper( a ) as clob ) ),\n   f generated always as ( cast( a as date ) ),\n   g generated always as ( cast( '15:09:02' as time ) ),\n   h generated always as ( cast( ( trim( a ) || ' 03:23:34.234' ) as timestamp ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_char( a ) values ( '1994-02-23' )");
        this.assertColumnTypes(conn, "T_ND_CHAR", new String[][]{{"A", "CHAR(20)"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "LONG VARCHAR"}, {"E", "CLOB(2147483647)"}, {"F", "DATE"}, {"G", "TIME NOT NULL"}, {"H", "TIMESTAMP"}});
        this.assertResults(conn, "select * from t_nd_char order by a", new String[][]{{"1994-02-23          ", "1994-02-23          ", "1994-02-23          ", "1994-02-23          ", "1994-02-23          ", "1994-02-23", "15:09:02", "1994-02-23 03:23:34.234"}}, false);
        this.goodStatement(conn, "create table t_nd_varchar\n(\n   a varchar( 20 ),\n   b generated always as ( cast ( upper( a ) as char( 20 ) ) ),\n   c generated always as ( cast ( upper( a ) as varchar( 20 ) ) ),\n   d generated always as ( cast ( upper( a ) as long varchar ) ),\n   e generated always as ( cast ( upper( a ) as clob ) ),\n   f generated always as ( cast( a as date ) ),\n   g generated always as ( cast( '15:09:02' as time ) ),\n   h generated always as ( cast( ( trim( a ) || ' 03:23:34.234' ) as timestamp ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_varchar( a ) values ( '1994-02-23' )");
        this.assertColumnTypes(conn, "T_ND_VARCHAR", new String[][]{{"A", "VARCHAR(20)"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "LONG VARCHAR"}, {"E", "CLOB(2147483647)"}, {"F", "DATE"}, {"G", "TIME NOT NULL"}, {"H", "TIMESTAMP"}});
        this.assertResults(conn, "select * from t_nd_varchar order by a", new String[][]{{"1994-02-23", "1994-02-23          ", "1994-02-23", "1994-02-23", "1994-02-23", "1994-02-23", "15:09:02", "1994-02-23 03:23:34.234"}}, false);
        this.goodStatement(conn, "create table t_nd_longvarchar\n(\n   a long varchar,\n   b generated always as ( cast ( upper( a ) as char( 20 ) ) ),\n   c generated always as ( cast ( upper( a ) as varchar( 20 ) ) ),\n   d generated always as ( cast ( upper( a ) as long varchar ) ),\n   e generated always as ( cast ( upper( a ) as clob ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_longvarchar( a ) values ( 'foo' )");
        this.assertColumnTypes(conn, "T_ND_LONGVARCHAR", new String[][]{{"A", "LONG VARCHAR"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "LONG VARCHAR"}, {"E", "CLOB(2147483647)"}});
        this.assertResults(conn, "select * from t_nd_longvarchar", new String[][]{{"foo", "FOO                 ", "FOO", "FOO", "FOO"}}, false);
        this.goodStatement(conn, "create table t_nd_clob\n(\n   a clob,\n   b generated always as ( cast ( upper( a ) as char( 20 ) ) ),\n   c generated always as ( cast ( upper( a ) as varchar( 20 ) ) ),\n   d generated always as ( cast ( upper( a ) as long varchar ) ),\n   e generated always as ( cast ( upper( a ) as clob ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_clob( a ) values ( 'foo' )");
        this.assertColumnTypes(conn, "T_ND_CLOB", new String[][]{{"A", "CLOB(2147483647)"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "LONG VARCHAR"}, {"E", "CLOB(2147483647)"}});
        this.assertResults(conn, "select * from t_nd_clob", new String[][]{{"foo", "FOO                 ", "FOO", "FOO", "FOO"}}, false);
        this.goodStatement(conn, "create table t_nd_charforbitdata\n(\n   a char( 4 ) for bit data,\n   b generated always as ( cast ( a as char( 4 ) for bit data ) ),\n   c generated always as ( cast ( a as varchar( 4 ) for bit data ) ),\n   d generated always as ( cast ( a as long varchar for bit data ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_charforbitdata( a ) values ( X'ABCDEFAB' )");
        this.assertColumnTypes(conn, "T_ND_CHARFORBITDATA", new String[][]{{"A", "CHAR (4) FOR BIT DATA"}, {"B", "CHAR (4) FOR BIT DATA"}, {"C", "VARCHAR (4) FOR BIT DATA"}, {"D", "LONG VARCHAR FOR BIT DATA"}});
        this.assertResults(conn, "select * from t_nd_charforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, false);
        this.goodStatement(conn, "create table t_nd_varcharforbitdata\n(\n   a varchar( 4 ) for bit data,\n   b generated always as ( cast ( a as char( 4 ) for bit data ) ),\n   c generated always as ( cast ( a as varchar( 4 ) for bit data ) ),\n   d generated always as ( cast ( a as long varchar for bit data ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_varcharforbitdata( a ) values ( X'ABCDEFAB' )");
        this.assertColumnTypes(conn, "T_ND_VARCHARFORBITDATA", new String[][]{{"A", "VARCHAR (4) FOR BIT DATA"}, {"B", "CHAR (4) FOR BIT DATA"}, {"C", "VARCHAR (4) FOR BIT DATA"}, {"D", "LONG VARCHAR FOR BIT DATA"}});
        this.assertResults(conn, "select * from t_nd_varcharforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, false);
        this.goodStatement(conn, "create table t_nd_longvarcharforbitdata\n(\n   a long varchar for bit data,\n   b generated always as ( cast ( a as char( 4 ) for bit data ) ),\n   c generated always as ( cast ( a as varchar( 4 ) for bit data ) ),\n   d generated always as ( cast ( a as long varchar for bit data ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_longvarcharforbitdata( a ) values ( X'ABCDEFAB' )");
        this.assertColumnTypes(conn, "T_ND_LONGVARCHARFORBITDATA", new String[][]{{"A", "LONG VARCHAR FOR BIT DATA"}, {"B", "CHAR (4) FOR BIT DATA"}, {"C", "VARCHAR (4) FOR BIT DATA"}, {"D", "LONG VARCHAR FOR BIT DATA"}});
        this.assertResults(conn, "select * from t_nd_longvarcharforbitdata", new String[][]{{"abcdefab", "abcdefab", "abcdefab", "abcdefab"}}, false);
        this.goodStatement(conn, "create table t_nd_date\n(\n   a date,\n   b generated always as ( cast ( a as char( 20 ) ) ),\n   c generated always as ( cast ( a as varchar( 20 ) ) ),\n   d generated always as ( cast ( a as date ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_date( a ) values ( date('1994-02-23') )");
        this.assertColumnTypes(conn, "T_ND_DATE", new String[][]{{"A", "DATE"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "DATE"}});
        this.assertResults(conn, "select * from t_nd_date", new String[][]{{"1994-02-23", "1994-02-23          ", "1994-02-23", "1994-02-23"}}, false);
        this.goodStatement(conn, "create table t_nd_time\n(\n   a time,\n   b generated always as ( cast ( a as char( 20 ) ) ),\n   c generated always as ( cast ( a as varchar( 20 ) ) ),\n   d generated always as ( cast ( a as time ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_time( a ) values (  time('15:09:02')  )");
        this.assertColumnTypes(conn, "T_ND_TIME", new String[][]{{"A", "TIME"}, {"B", "CHAR(20)"}, {"C", "VARCHAR(20)"}, {"D", "TIME"}});
        this.assertResults(conn, "select * from t_nd_time", new String[][]{{"15:09:02", "15:09:02            ", "15:09:02", "15:09:02"}}, false);
        this.goodStatement(conn, "create table t_nd_timestamp\n(\n   a  timestamp,\n   b  char( 30 ) generated always as ( cast( a as char( 30 ) ) ),\n   c  varchar( 30 ) generated always as ( cast ( a as varchar( 30 ) ) ),\n   d timestamp generated always as ( cast ( a as timestamp ) )\n)\n");
        this.goodStatement(conn, "insert into t_nd_timestamp( a ) values (  timestamp('1962-09-23 03:23:34.234')  )");
        this.assertColumnTypes(conn, "T_ND_TIMESTAMP", new String[][]{{"A", "TIMESTAMP"}, {"B", "CHAR(30)"}, {"C", "VARCHAR(30)"}, {"D", "TIMESTAMP"}});
        this.assertResults(conn, "select * from t_nd_timestamp", new String[][]{{"1962-09-23 03:23:34.234", "1962-09-23 03:23:34.234       ", "1962-09-23 03:23:34.234", "1962-09-23 03:23:34.234"}}, false);
    }

    public void test_023_drivingSelect() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_ds_source( a int, b int )");
        this.goodStatement(conn, "create table t_ds_id( a int, b int generated always as identity )");
        this.goodStatement(conn, "create table t_ds_gc( a int, b generated always as ( -a ) )");
        this.goodStatement(conn, "insert into t_ds_source( a, b ) values ( 1, 1 )");
        this.goodStatement(conn, "insert into t_ds_id values ( 3, default )");
        this.goodStatement(conn, "insert into t_ds_gc values ( 3, default )");
        this.goodStatement(conn, "insert into t_ds_id( a ) select a from t_ds_source");
        this.goodStatement(conn, "insert into t_ds_gc( a ) select a from t_ds_source");
        this.expectCompilationError("42Z23", "insert into t_ds_id values ( 2, 2 )");
        this.expectCompilationError("42XA3", "insert into t_ds_gc values ( 2, 2 )");
        this.expectCompilationError("42Z23", "insert into t_ds_id select * from t_ds_source");
        this.expectCompilationError("42XA3", "insert into t_ds_gc select * from t_ds_source");
        this.expectCompilationError("42Z23", "insert into t_ds_id select a, 3 from t_ds_source");
        this.expectCompilationError("42XA3", "insert into t_ds_gc select a, 3 from t_ds_source");
        this.expectCompilationError("42X01", "insert into t_ds_id select a, default from t_ds_source");
        this.expectCompilationError("42X01", "insert into t_ds_gc select a, default from t_ds_source");
        this.assertResults(conn, "select * from t_ds_id order by b", new String[][]{{"3", "1"}, {"1", "2"}}, false);
        this.assertResults(conn, "select * from t_ds_gc order by b", new String[][]{{"3", "-3"}, {"1", "-1"}}, false);
    }

    public void test_024_beforeTriggers() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create procedure t_tba_report_proc\n( tag varchar( 40 ), a int, b int, c int )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.showValues'\n");
        this.goodStatement(conn, "create procedure t_tba_wide_report_proc\n( tag varchar( 40 ), old_a int, old_b int, old_c int, new_a int, new_b int, new_c int )\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.showValues'\n");
        this.goodStatement(conn, "create table t_tba_1( a int, b int generated always as ( -a ), c int )");
        this.goodStatement(conn, "create trigger trig_tba_good_before_insert\nno cascade before insert on t_tba_1\nreferencing new as ar\nfor each row\ncall t_tba_report_proc( 'before_insert_row_trigger', ar.a, ar.a, ar.a )\n");
        this.expectCompilationError("42XAA", "create trigger trig_tba_bad_before_insert\nno cascade before insert on t_tba_1\nreferencing new as ar\nfor each row\ncall t_tba_report_proc( 'before_insert_row_trigger', ar.a, ar.b, ar.c )\n");
        this.goodStatement(conn, "create trigger trig_tba_good_after_insert\nafter insert on t_tba_1\nreferencing new as ar\nfor each row\ncall t_tba_report_proc( 'after_insert_row_trigger', ar.a, ar.b, ar.c ) \n");
        this.goodStatement(conn, "create trigger trig_tba_good_before_update\nno cascade before update on t_tba_1\nreferencing old as br new as ar\nfor each row\ncall t_tba_wide_report_proc( 'before_update_row_trigger', br.a, br.b, br.c, ar.a, ar.a, ar.a )\n");
        this.expectCompilationError("42XAA", "create trigger trig_tba_bad_before_update\nno cascade before update on t_tba_1\nreferencing old as br new as ar\nfor each row\ncall t_tba_wide_report_proc( 'before_update_row_trigger', br.a, br.b, br.c, ar.a, ar.b, ar.c )\n");
        this.goodStatement(conn, "create trigger trig_tba_good_after_update\nafter update on t_tba_1\nreferencing old as br new as ar\nfor each row\ncall t_tba_wide_report_proc( 'after_update_row_trigger', br.a, br.b, br.c, ar.a, ar.b, ar.c )\n");
        this.goodStatement(conn, "create trigger trig_tba_before_delete\nno cascade before delete on t_tba_1\nreferencing old as br\nfor each row\ncall t_tba_report_proc( 'before_delete_row_trigger', br.a, br.b, br.c )\n");
    }

    public void test_025_basicUpdatableResultSets() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        this.goodStatement(conn, "create table t_urs_1 ( a int, b generated always as ( -a ) )");
        this.goodStatement(conn, "insert into t_urs_1( a ) values ( 1 )");
        conn.commit();
        Statement stmt = conn.createStatement(1003, 1008);
        ResultSet rs = null;
        rs = GeneratedColumnsTest.executeQuery(stmt, "select * from t_urs_1 for update");
        rs.next();
        GeneratedColumnsTest.println("Initially ( a, b ) = ( " + rs.getInt(1) + ", " + rs.getInt(2) + " )");
        rs.updateInt(1, 2);
        rs.updateRow();
        rs.close();
        conn.commit();
        this.assertResults(conn, "select * from t_urs_1 order by a", new String[][]{{"2", "-2"}}, false);
        conn.commit();
        rs = GeneratedColumnsTest.executeQuery(stmt, "select * from t_urs_1 for update");
        rs.next();
        GeneratedColumnsTest.println("Initially ( a, b ) = ( " + rs.getInt(1) + ", " + rs.getInt(2) + " )");
        rs.updateInt(2, 2);
        this.expectUpdateRowError(rs, "42XA3");
        rs.close();
        conn.commit();
        this.assertResults(conn, "select * from t_urs_1 order by a", new String[][]{{"2", "-2"}}, false);
        conn.commit();
        rs = GeneratedColumnsTest.executeQuery(stmt, "select * from t_urs_1 for update");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(1, 10);
        rs.insertRow();
        rs.close();
        conn.commit();
        this.assertResults(conn, "select * from t_urs_1 order by a", new String[][]{{"2", "-2"}, {"10", "-10"}}, false);
        conn.commit();
        rs = GeneratedColumnsTest.executeQuery(stmt, "select * from t_urs_1 for update");
        rs.next();
        rs.moveToInsertRow();
        rs.updateInt(2, 10);
        this.expectInsertRowError(rs, "42XA3");
        rs.close();
        conn.commit();
        this.assertResults(conn, "select * from t_urs_1 order by a", new String[][]{{"2", "-2"}, {"10", "-10"}}, false);
        conn.commit();
        conn.setAutoCommit(true);
        stmt.close();
    }

    public void test_026_onDeleteSetNull() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_dhw_1( a int primary key )");
        this.goodStatement(conn, "create table t_dhw_2( a int references t_dhw_1( a ) on delete set null check ( a is null or a > 0 ), b int generated always as ( -a ) check ( b is null or b < 0 ) )");
        this.goodStatement(conn, "insert into t_dhw_1( a ) values ( 1 ), ( 2 )");
        this.goodStatement(conn, "insert into t_dhw_2( a ) values( 1 )");
        this.goodStatement(conn, "delete from t_dhw_1 where a = 1");
        this.assertResults(conn, "select * from t_dhw_1 order by a", new String[][]{{"2"}}, false);
        this.assertResults(conn, "select * from t_dhw_2 order by a", new String[][]{{null, null}}, false);
    }

    public void test_027_constraintsNoDatatype() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_ccnd_1( a int, b generated always as ( -a ) check ( b < 0 ) )");
        this.goodStatement(conn, "insert into t_ccnd_1( a ) values ( 1 )");
        this.expectExecutionError(conn, "23513", "insert into t_ccnd_1( a ) values ( -1 )");
        this.goodStatement(conn, "alter table t_ccnd_1 add column c generated always as ( -a ) check ( c > -10 )");
        this.goodStatement(conn, "insert into t_ccnd_1( a ) values ( 2 )");
        this.expectExecutionError(conn, "23513", "insert into t_ccnd_1( a ) values ( 20 )");
        this.assertResults(conn, "select * from t_ccnd_1 order by a", new String[][]{{"1", "-1", "-1"}, {"2", "-2", "-2"}}, false);
        this.goodStatement(conn, "create table t_ccnd_2( b int primary key )");
        this.goodStatement(conn, "create table t_ccnd_3( a int, b generated always as ( -a ) references t_ccnd_2( b ) )");
        this.goodStatement(conn, "create table t_ccnd_4( a int )");
        this.goodStatement(conn, "insert into t_ccnd_2( b ) values ( 1 )");
        this.goodStatement(conn, "insert into t_ccnd_3( a ) values ( -1 )");
        this.expectExecutionError(conn, "23503", "insert into t_ccnd_3( a ) values ( -2 )");
        this.goodStatement(conn, "alter table t_ccnd_4 add column b generated always as ( -a ) references t_ccnd_2( b )");
        this.goodStatement(conn, "insert into t_ccnd_4( a ) values ( -1 )");
        this.expectExecutionError(conn, "23503", "insert into t_ccnd_4( a ) values ( -2 )");
        this.assertResults(conn, "select * from t_ccnd_3 order by a", new String[][]{{"-1", "1"}}, false);
        this.assertResults(conn, "select * from t_ccnd_4 order by a", new String[][]{{"-1", "1"}}, false);
        this.goodStatement(conn, "create table t_ccnd_5( a int, b generated always as ( -a ) primary key )");
        this.goodStatement(conn, "insert into t_ccnd_5( a ) values ( 1 )");
        this.expectExecutionError(conn, "23505", "insert into t_ccnd_5( a ) values ( 1 )");
        this.assertResults(conn, "select * from t_ccnd_5 order by a", new String[][]{{"1", "-1"}}, false);
        this.expectCompilationError("42XAB", "create table t_ccnd_6( a int, b generated always as ( -a ) not null )");
        this.goodStatement(conn, "create table t_ccnd_6( a int )");
        this.expectCompilationError("42XAB", "alter table t_ccnd_6 add column b generated always as ( -a ) not null");
        this.goodStatement(conn, "create table t_ccnd_7( a int, b int generated always as ( -a ) not null )");
        this.goodStatement(conn, "insert into t_ccnd_7( a ) values ( 1 )");
        this.expectExecutionError(conn, "23502", "insert into t_ccnd_7( a ) values ( null )");
        this.assertResults(conn, "select * from t_ccnd_7 order by a", new String[][]{{"1", "-1"}}, false);
        this.goodStatement(conn, "create table t_ccnd_8( a int )");
        this.goodStatement(conn, "create table t_ccnd_9( a int not null )");
        this.expectCompilationError("42831", "alter table t_ccnd_8 add column b generated always as ( -a ) primary key");
        this.goodStatement(conn, "alter table t_ccnd_8 add column b int not null generated always as ( -a ) primary key");
        this.goodStatement(conn, "insert into t_ccnd_8( a ) values ( 1 )");
        this.expectExecutionError(conn, "23502", "insert into t_ccnd_8( a ) values ( null )");
        this.expectExecutionError(conn, "23505", "insert into t_ccnd_8( a ) values ( 1 )");
        this.assertResults(conn, "select * from t_ccnd_8 order by a", new String[][]{{"1", "-1"}}, false);
        this.goodStatement(conn, "alter table t_ccnd_9 add column b generated always as ( -a ) primary key");
        this.goodStatement(conn, "insert into t_ccnd_9( a ) values ( 1 )");
        this.expectExecutionError(conn, "23505", "insert into t_ccnd_9( a ) values ( 1 )");
        this.assertResults(conn, "select * from t_ccnd_9 order by a", new String[][]{{"1", "-1"}}, false);
        this.goodStatement(conn, "create table t_ccnd_10( a int, b generated always as ( -a ) unique )");
        this.goodStatement(conn, "create table t_ccnd_11( a int )");
        this.goodStatement(conn, "insert into t_ccnd_10( a ) values ( 1 )");
        this.goodStatement(conn, "insert into t_ccnd_10( a ) values ( null )");
        this.goodStatement(conn, "insert into t_ccnd_10( a ) values ( null )");
        this.expectExecutionError(conn, "23505", "insert into t_ccnd_10( a ) values ( 1 )");
        this.assertResults(conn, "select * from t_ccnd_10 order by a", new String[][]{{"1", "-1"}, {null, null}, {null, null}}, false);
        this.goodStatement(conn, "alter table t_ccnd_11 add column b generated always as ( -a ) unique");
        this.goodStatement(conn, "insert into t_ccnd_11( a ) values ( 1 )");
        this.goodStatement(conn, "insert into t_ccnd_11( a ) values ( null )");
        this.goodStatement(conn, "insert into t_ccnd_11( a ) values ( null )");
        this.expectExecutionError(conn, "23505", "insert into t_ccnd_11( a ) values ( 1 )");
        this.assertResults(conn, "select * from t_ccnd_11 order by a", new String[][]{{"1", "-1"}, {null, null}, {null, null}}, false);
    }

    public void test_028_bulkImport() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_bi_1( a int, b int, c generated always as ( a + b ) )");
        this.expectExecutionError(conn, "42XA3", "call syscs_util.syscs_import_table( null, 'T_BI_1', 'extin/t_bi_1.dat', null, null, null, 0 )");
        this.goodStatement(conn, "call syscs_util.syscs_import_data( null, 'T_BI_1', 'A', '1',  'extin/t_bi_1.dat', null, null, null, 0 )");
        this.goodStatement(conn, "call syscs_util.syscs_import_data( null, 'T_BI_1', 'A, B', '1, 2', 'extin/t_bi_1.dat', null, null, null, 0 )");
        this.assertResults(conn, "select * from t_bi_1 order by a, b", new String[][]{{"2", "3", "5"}, {"2", null, null}}, false);
    }

    public void test_029_derby_4145() throws Exception {
        this.expectCompilationError("42XA4", "create table t_4145(c1 int, c2 int, c3 generated always as (c1 + c4), c4 generated always as (-c1))");
    }

    public void test_030_derby_4146() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_4146 (c1 int generated always as identity, c2 generated always as (c1+100))");
        this.goodStatement(conn, "create table t_4146_2 (c1 int generated always as identity, c2 generated always as (c1+100), c3 int default 1000)");
        this.goodStatement(conn, "insert into t_4146 values ( default, default )");
        this.expectCompilationError("42Z23", "insert into t_4146 values ( -1, default )");
        this.expectCompilationError("42XA3", "insert into t_4146 values ( default, -1 )");
        this.goodStatement(conn, "insert into t_4146 (c1, c2) values ( default, default )");
        this.expectCompilationError("42Z23", "insert into t_4146 (c1, c2) values ( -1, default )");
        this.expectCompilationError("42XA3", "insert into t_4146 (c1, c2) values ( default, -1 )");
        this.assertResults(conn, "select * from t_4146 order by c1", new String[][]{{"1", "101"}, {"2", "102"}}, false);
        this.goodStatement(conn, "insert into t_4146_2 values ( default, default, default )");
        this.expectCompilationError("42Z23", "insert into t_4146_2 values ( -1, default, default )");
        this.expectCompilationError("42XA3", "insert into t_4146_2 values ( default, -1, default )");
        this.goodStatement(conn, "insert into t_4146_2 (c1, c2) values ( default, default )");
        this.expectCompilationError("42Z23", "insert into t_4146_2 (c1, c2) values ( -1, default )");
        this.expectCompilationError("42XA3", "insert into t_4146_2 (c1, c2) values ( default, -1 )");
        this.goodStatement(conn, "insert into t_4146_2 (c1, c2, c3) values ( default, default, default )");
        this.expectCompilationError("42Z23", "insert into t_4146_2 (c1, c2, c3) values ( -1, default, default )");
        this.expectCompilationError("42XA3", "insert into t_4146_2 (c1, c2, c3) values ( default, -1, default )");
        this.goodStatement(conn, "insert into t_4146_2 (c1, c2, c3) values ( default, default, 2000 )");
        this.expectCompilationError("42Z23", "insert into t_4146_2 (c1, c2, c3) values ( -1, default, 3000 )");
        this.expectCompilationError("42XA3", "insert into t_4146_2 (c1, c2, c3) values ( default, -1, 4000 )");
        this.assertResults(conn, "select * from t_4146_2 order by c1", new String[][]{{"1", "101", "1000"}, {"2", "102", "1000"}, {"3", "103", "1000"}, {"4", "104", "2000"}}, false);
    }

    public void test_031_derby_4413() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_4413 (     i integer,      j integer not null generated always as (i*2))");
        this.goodStatement(conn, "insert into t_4413(i) values 1,2,1");
        this.goodStatement(conn, "insert into t_4413(i) select distinct i from t_4413");
        this.assertResults(conn, "select * from t_4413 order by i, j", new String[][]{{"1", "2"}, {"1", "2"}, {"1", "2"}, {"2", "4"}, {"2", "4"}}, false);
    }

    public void test_derby_4425() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t4425_1(x int)");
        this.goodStatement(conn, "create table t4425_2(x int)");
        this.goodStatement(conn, "insert into t4425_1 values 1,2");
        this.goodStatement(conn, "insert into t4425_2 values 2,3");
        this.goodStatement(conn, "create table t4425_3 (x int, y generated always as (2*x))");
        this.goodStatement(conn, "insert into t4425_3(x) select * from t4425_1 union select * from t4425_2");
        this.assertResults(conn, "select * from t4425_3", new String[][]{{"1", "2"}, {"2", "4"}, {"3", "6"}}, false);
    }

    public void test_derby_4779() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create function f_getRegion\n(\n    v int\n)\nreturns int\nlanguage java\nparameter style java\ndeterministic\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.signum'\n");
        this.goodStatement(conn, "create table t1_orders( price int, region generated always as ( f_getRegion(price) ) )\n");
        this.goodStatement(conn, "create table t1_dummy(a int)\n");
        this.goodStatement(conn, "create trigger t1_trig_after_insert_row_trigger_4779\nafter insert on t1_orders\nreferencing new as ar\nfor each row\ninsert into t1_dummy( a ) values ( 1 )\n");
        this.goodStatement(conn, "insert into t1_orders(price) values (1), (2)");
        this.assertResults(conn, "select a from t1_dummy", new String[][]{{"1"}, {"1"}}, false);
    }

    public void test_derby_5749() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create table t_5749\n(c varchar(5) generated always as ('--' || b), b varchar(5))\n");
        this.expectExecutionError(conn, "22001", "insert into t_5749 values (default, '12345')");
        this.goodStatement(conn, "insert into t_5749 values (default, '123')");
        this.expectExecutionError(conn, "22001", "update t_5749 set b='12345'");
    }

    private int readMinusCounter(Connection conn) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "values ( f_readMinusCounter() )");
        ResultSet rs = ps.executeQuery();
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        ps.close();
        return result;
    }

    private void assertTriggerStatus(Connection conn, String query, String[][] rows) throws Exception {
        this.goodStatement(conn, "call " + this._clearingProcName + "()\n");
        this.goodStatement(conn, query);
        PreparedStatement ps = this.chattyPrepare(conn, "select * from table( " + this._triggerReportVTIName + "() ) s");
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, rows, true);
        rs.close();
        ps.close();
    }

    private void assertDefaultInfo(Connection conn, String tableName, String columnName, String[] expectedReferenceColumns, String expectedDefaultText) throws Exception {
        DefaultInfo di = this.getColumnDefault(conn, tableName, columnName);
        Object[] actualReferenceColumns = di.getReferencedColumnNames();
        GeneratedColumnsTest.assertEquals((String)this.fill(expectedReferenceColumns).toString(), (String)this.fill(actualReferenceColumns).toString());
        GeneratedColumnsTest.assertEquals((String)expectedDefaultText, (String)di.getDefaultText());
        GeneratedColumnsTest.assertTrue((boolean)di.isGeneratedColumn());
    }

    public DefaultInfo getColumnDefault(Connection conn, String tableName, String columnName) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, "select c.columndefault\nfrom sys.syscolumns c, sys.systables t\nwhere t.tableid = c.referenceid\nand t.tablename = ?\nand c.columnname = ?");
        ps.setString(1, tableName);
        ps.setString(2, columnName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        DefaultInfo result = (DefaultInfo)rs.getObject(1);
        rs.close();
        ps.close();
        return result;
    }

    public static Integer minus(Integer a) {
        ++_minusCounter;
        if (a == null) {
            return null;
        }
        return new Integer(-a.intValue());
    }

    public static int readMinusCounter() {
        return _minusCounter;
    }

    public static int signum(int i) {
        if (i > 0) {
            return 1;
        }
        if (i == 0) {
            return 0;
        }
        return -1;
    }

    public static void clearTriggerReports() {
        _triggerReports.clear();
    }

    public static ResultSet triggerReport() {
        int count = _triggerReports.size();
        String[][] rows = new String[count][];
        for (int i = 0; i < count; ++i) {
            rows[i] = new String[]{(String)_triggerReports.get(i)};
        }
        return new StringArrayVTI(new String[]{"contents"}, rows);
    }

    public static void showValues(String tag, Integer a, Integer b, Integer c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(tag);
        buffer.append(": [ ");
        buffer.append(a);
        buffer.append(", ");
        buffer.append(b);
        buffer.append(", ");
        buffer.append(c);
        buffer.append(" ]");
        String result = buffer.toString();
        _triggerReports.add(result);
    }

    public static void showValues(String tag, Integer old_a, Integer old_b, Integer old_c, Integer new_a, Integer new_b, Integer new_c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(tag);
        buffer.append(": [ ");
        buffer.append(old_a);
        buffer.append(", ");
        buffer.append(old_b);
        buffer.append(", ");
        buffer.append(old_c);
        buffer.append(", ");
        buffer.append(new_a);
        buffer.append(", ");
        buffer.append(new_b);
        buffer.append(", ");
        buffer.append(new_c);
        buffer.append(" ]");
        String result = buffer.toString();
        _triggerReports.add(result);
    }

    static {
        _triggerReports = new ArrayList();
    }
}

