/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.junitTests.compatibility;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.tests.junitTests.compatibility.JDBCDriverTest;
import org.apache.derbyTesting.functionTests.util.DerbyJUnitTest;

public class CompatibilitySuite
extends DerbyJUnitTest {
    public static final Version DRB_10_0 = new Version(10, 0);
    public static final Version DRB_10_1 = new Version(10, 1);
    public static final Version DRB_10_2 = new Version(10, 2);
    public static final Version DRB_10_3 = new Version(10, 3);
    public static final Version DRB_10_4 = new Version(10, 4);
    public static final Version DRB_10_5 = new Version(10, 5);
    public static final Version DRB_10_6 = new Version(10, 6);
    public static final Version DRB_10_7 = new Version(10, 7);
    public static final String SERVER_VERSION_FUNCTION = "getVMVersion";
    private static final String VERSION_PROPERTY = "java.version";
    private static final int EXPECTED_CLIENT_COUNT = 1;
    private static Driver _driver;
    private static Version _clientVMLevel;
    private static Version _serverVMLevel;
    private static Version _driverLevel;
    private static Version _serverLevel;

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTestSuite(JDBCDriverTest.class);
        return testSuite;
    }

    public static void main(String[] args) throws Exception {
        int exitStatus = 1;
        if (CompatibilitySuite.parseDebug() && CompatibilitySuite.parseArgs(args) && CompatibilitySuite.parseVMLevel() && CompatibilitySuite.findClient() && CompatibilitySuite.findServer()) {
            Test t = CompatibilitySuite.suite();
            CompatibilitySuite.println("CompatibilitySuite.main() will run suite with  " + t.countTestCases() + " testcases.");
            TestResult result = TestRunner.run((Test)t);
            exitStatus = result.errorCount() + result.failureCount();
        }
        Runtime.getRuntime().exit(exitStatus);
    }

    public Version getServerVersion() {
        return _serverLevel;
    }

    public Version getDriverVersion() {
        return _driverLevel;
    }

    public static Version getServerVMVersion() {
        return _serverVMLevel;
    }

    public Version getClientVMVersion() {
        return _clientVMLevel;
    }

    public boolean serverSupportsUDTs() {
        return this.getServerVersion().atLeast(DRB_10_6);
    }

    public static String getVMVersion() {
        return System.getProperty(VERSION_PROPERTY);
    }

    static boolean findClient() throws Exception {
        if (CompatibilitySuite.getClientSettings() != null) {
            CompatibilitySuite.faultInDriver(CompatibilitySuite.getClientSettings());
        } else {
            int legalCount = LEGAL_CLIENTS.length;
            int foundCount = 0;
            for (int i = 0; i < legalCount; ++i) {
                String[] candidate = LEGAL_CLIENTS[i];
                if (!CompatibilitySuite.faultInDriver(candidate)) continue;
                CompatibilitySuite.setClient(candidate);
                ++foundCount;
            }
            if (foundCount != 1) {
                throw new Exception("Wrong number of drivers: " + foundCount);
            }
        }
        try {
            _driver = DriverManager.getDriver(CompatibilitySuite.getClientSettings()[0]);
            _driverLevel = new Version(_driver.getMajorVersion(), _driver.getMinorVersion());
        }
        catch (SQLException e) {
            CompatibilitySuite.printStackTrace(e);
            throw new Exception("Driver doesn't understand expected URL: " + CompatibilitySuite.getClientSettings()[0]);
        }
        CompatibilitySuite.println("Driver " + _driver.getClass().getName() + " Version = " + _driverLevel);
        return true;
    }

    static boolean findServer() throws Exception {
        try {
            Connection conn = CompatibilitySuite.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            String dbProductVersion = dmd.getDatabaseProductVersion();
            _serverLevel = new Version(dbProductVersion);
            CompatibilitySuite.parseServerVMVersion(conn);
        }
        catch (Exception e) {
            CompatibilitySuite.printStackTrace(e);
            throw new Exception("Error lookup up server info: " + e.getMessage());
        }
        CompatibilitySuite.println("Server Version = " + _serverLevel);
        return true;
    }

    static boolean parseVMLevel() throws Exception {
        String vmVersion = CompatibilitySuite.getVMVersion();
        try {
            _clientVMLevel = new Version(vmVersion);
        }
        catch (NumberFormatException e) {
            throw new Exception("Badly formatted vm version: " + vmVersion);
        }
        CompatibilitySuite.println("VM Version = " + _clientVMLevel);
        return true;
    }

    static boolean parseArgs(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            throw new Exception("Missing database name.");
        }
        CompatibilitySuite.setDatabaseName(args[0]);
        if (args.length > 1 && !"".equals(args[1])) {
            String desiredClientName = args[1];
            int count = LEGAL_CLIENTS.length;
            for (int i = 0; i < count; ++i) {
                String[] candidate = LEGAL_CLIENTS[i];
                if (!desiredClientName.equals(candidate[1])) continue;
                CompatibilitySuite.setClient(candidate);
                break;
            }
            if (CompatibilitySuite.getClientSettings() == null) {
                throw new Exception("Could not find client " + desiredClientName + " on the classpath.");
            }
        }
        return true;
    }

    static void parseServerVMVersion(Connection conn) throws SQLException {
        CompatibilitySuite.dropFunction(conn, SERVER_VERSION_FUNCTION);
        PreparedStatement ps = CompatibilitySuite.prepare(conn, "create function getVMVersion() returns varchar(50)\nparameter style java no sql language java\nexternal name 'org.apache.derbyTesting.functionTests.tests.junitTests.compatibility.CompatibilitySuite.getVMVersion'");
        ps.execute();
        CompatibilitySuite.close(ps);
        ps = CompatibilitySuite.prepare(conn, "values getVMVersion()");
        ResultSet rs = ps.executeQuery();
        rs.next();
        String rawVersion = rs.getString(1);
        CompatibilitySuite.close(rs);
        CompatibilitySuite.close(ps);
        _serverVMLevel = new Version(rawVersion);
        CompatibilitySuite.println("Server VM Version = " + _serverVMLevel);
    }

    public static final class Version
    implements Comparable {
        private int _major;
        private int _minor;

        public Version(int major, int minor) {
            this.constructorMinion(major, minor);
        }

        public Version(String desc) throws NumberFormatException {
            StringTokenizer tokens = new StringTokenizer(desc, ".");
            this.constructorMinion(Integer.parseInt(tokens.nextToken()), Integer.parseInt(tokens.nextToken()));
        }

        private void constructorMinion(int major, int minor) {
            this._major = major;
            this._minor = minor;
        }

        public boolean atLeast(Version that) {
            return this.compareTo(that) > -1;
        }

        public int compareTo(Object other) {
            if (other == null) {
                return -1;
            }
            if (!(other instanceof Version)) {
                return -1;
            }
            Version that = (Version)other;
            if (this._major < that._major) {
                return -1;
            }
            if (this._major > that._major) {
                return 1;
            }
            return this._minor - that._minor;
        }

        public String toString() {
            return Integer.toString(this._major) + '.' + Integer.toString(this._minor);
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this._major ^ this._minor;
        }
    }

    public static final class Creator {
        private static CompatibilitySuite _driver = new CompatibilitySuite();

        public static void main(String[] args) throws Exception {
            String databaseName = args[0];
            CompatibilitySuite.findClient();
            Creator._driver.createDB(databaseName);
        }
    }
}

