/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollResultSetTest
extends BaseJDBCTestCase {
    public ScrollResultSetTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3() || JDBC.vmSupportsJSR169()) {
            return TestConfiguration.defaultSuite(ScrollResultSetTest.class);
        }
        return new TestSuite("Empty ScrollResultSetTest suite, no support for holdability");
    }

    public void setUp() throws Exception {
        Connection con = this.getConnection();
        con.setAutoCommit(true);
        String createTableWithPK = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        String insertData = "INSERT INTO tableWithPK values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)";
        Statement stmt = con.createStatement();
        stmt.execute(createTableWithPK);
        stmt.execute(insertData);
        stmt.close();
    }

    public void tearDown() throws Exception {
        ScrollResultSetTest.println("TearDown");
        Statement s = this.getConnection().createStatement();
        try {
            s.executeUpdate("DROP TABLE tableWithPK");
        }
        catch (SQLException e) {
            ScrollResultSetTest.printStackTrace(e);
        }
        s.close();
        super.tearDown();
    }

    public void testNextOnLastRowForwardOnly() throws SQLException {
        Connection con = this.getConnection();
        con.setAutoCommit(true);
        con.setHoldability(2);
        Statement roStmt = con.createStatement(1003, 1007);
        ResultSet rs = roStmt.executeQuery("SELECT c1 FROM tableWithPK");
        while (rs.next()) {
        }
        try {
            rs.next();
            ScrollResultSetTest.assertTrue((String)"Excepted exception to be thrown - result set is closed", (boolean)false);
        }
        catch (SQLException se) {
            ScrollResultSetTest.assertSQLState("Unexpected SQL State", "XCL16", se);
        }
    }

    public void testNextOnLastRowScrollable() throws SQLException {
        Connection con = this.getConnection();
        con.setAutoCommit(true);
        con.setHoldability(2);
        Statement roStmt = con.createStatement(1004, 1007);
        ResultSet rs = roStmt.executeQuery("SELECT c1 FROM tableWithPK");
        rs.last();
        rs.next();
        ScrollResultSetTest.assertFalse((String)"Calling next while positioned after last returns false", (boolean)rs.next());
        ScrollResultSetTest.assertTrue((String)"Moving to absolute(2) returns true", (boolean)rs.absolute(2));
        rs.close();
    }
}

