/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepStmtNullTest
extends BaseJDBCTestCase {
    public PrepStmtNullTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PrepStmtNullTest");
        suite.addTest(PrepStmtNullTest.baseSuite("PrepStmtNullTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(PrepStmtNullTest.baseSuite("PrepStmtNullTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(PrepStmtNullTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table nullTS(name varchar(10), ts timestamp)");
                stmt.executeUpdate("create table nullBlob(name varchar(10), bval blob(16K))");
                stmt.executeUpdate("create table ClobBlob(cval clob, bval blob(16K))");
            }
        };
    }

    public void testNullTimeStamp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement pStmt = this.prepareStatement("insert into nullTS values (?,?)");
        pStmt.setString(1, "work");
        pStmt.setNull(2, 93);
        pStmt.addBatch();
        pStmt.setString(1, "work1");
        pStmt.setNull(2, 93, "");
        pStmt.addBatch();
        pStmt.executeBatch();
        pStmt.close();
        this.commit();
        Statement stmt1 = this.createStatement();
        ResultSet rs = stmt1.executeQuery("select * from nullTS");
        String[][] expectedRows = new String[][]{{"work", null}, {"work1", null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        this.commit();
        conn.close();
    }

    public void testNullBlob() throws SQLException {
        Connection con = this.getConnection();
        con.setAutoCommit(false);
        PreparedStatement pStmt = con.prepareStatement("insert into nullBlob values (?,?)");
        pStmt.setString(1, "blob");
        pStmt.setNull(2, 2004);
        pStmt.addBatch();
        pStmt.setString(1, "blob1");
        pStmt.setNull(2, 2004, "");
        pStmt.addBatch();
        pStmt.executeBatch();
        pStmt.close();
        this.commit();
        Statement stmt1 = con.createStatement();
        ResultSet rs = stmt1.executeQuery("select * from nullBlob");
        String[][] expectedRows = new String[][]{{"blob", null}, {"blob1", null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        stmt1.close();
        this.commit();
        con.close();
    }

    public void testNullClobBlob() throws SQLException {
        byte[] b2 = new byte[]{64};
        PreparedStatement pStmt = this.prepareStatement("insert into ClobBlob values (?,?)");
        pStmt.setNull(1, 12);
        pStmt.setBytes(2, b2);
        pStmt.execute();
        pStmt.setNull(1, 12, "");
        pStmt.setBytes(2, b2);
        pStmt.execute();
        pStmt.close();
        Statement stmt1 = this.createStatement();
        ResultSet rs = stmt1.executeQuery("select * from ClobBlob");
        String[][] expectedRows = new String[][]{{null, this.bytesToString(b2)}, {null, this.bytesToString(b2)}};
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        stmt1.close();
    }

    private String bytesToString(byte[] ba) {
        if (ba == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            s.append(Integer.toHexString(ba[i] & 0xFF));
        }
        return s.toString();
    }
}

