/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobUpdatableReaderTest
extends BaseJDBCTestCase {
    private final String dummy = "This is a new String";

    public ClobUpdatableReaderTest(String name) {
        super(name);
    }

    public void testUpdateableStoreReader() throws Exception {
        long skipped;
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into updateClob (id , data) values (? ,?)");
        ps.setInt(1, 2);
        StringBuffer sb = new StringBuffer();
        String base = "SampleSampleSample";
        for (int i = 0; i < 100000; ++i) {
            sb.append(base);
        }
        ps.setCharacterStream(2, (Reader)new StringReader(sb.toString()), sb.length());
        ps.execute();
        ps.close();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select data from updateClob where id = 2");
        rs.next();
        Clob clob = rs.getClob(1);
        rs.close();
        stmt.close();
        ClobUpdatableReaderTest.assertEquals((long)sb.length(), (long)clob.length());
        Reader r = clob.getCharacterStream();
        String newString = "this is a new string";
        long l = r.skip(100L);
        clob.setString(1001L, newString);
        for (long toSkip = 1000L - l; toSkip > 0L; toSkip -= skipped) {
            skipped = r.skip(toSkip);
        }
        char[] newdata = new char[newString.length()];
        int len = r.read(newdata);
        ClobUpdatableReaderTest.assertEquals((String)"updated not reflected", (String)newString, (String)new String(newdata, 0, len));
        r.close();
    }

    public void testUpdateableReader() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into updateClob (id , data) values (? ,?)");
        ps.setInt(1, 1);
        StringBuffer sb = new StringBuffer();
        String base = "SampleSampleSample";
        for (int i = 0; i < 100; ++i) {
            sb.append(base);
        }
        ps.setCharacterStream(2, (Reader)new StringReader(sb.toString()), sb.length());
        ps.execute();
        ps.close();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select data from updateClob where id = 1");
        rs.next();
        Clob clob = rs.getClob(1);
        rs.close();
        stmt.close();
        ClobUpdatableReaderTest.assertEquals((long)sb.length(), (long)clob.length());
        Reader r = clob.getCharacterStream();
        char[] clobData = new char[sb.length()];
        r.read(clobData);
        ClobUpdatableReaderTest.assertEquals((String)"mismatch from inserted string", (String)String.valueOf(clobData), (String)sb.toString());
        r.close();
        clob.setString(50L, "This is a new String");
        r = clob.getCharacterStream();
        r.skip(49L);
        char[] newChars = new char["This is a new String".length()];
        r.read(newChars);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)"This is a new String", (String)String.valueOf(newChars));
        clob.setString(75L, "This is a new String");
        r.skip(25 - "This is a new String".length());
        char[] testChars = new char["This is a new String".length()];
        r.read(testChars);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)"This is a new String", (String)String.valueOf(newChars));
        r.close();
        String unicodeStr = this.getUnicodeString();
        clob.setString(50L, unicodeStr);
        char[] utf16Chars = new char[unicodeStr.length()];
        r = clob.getCharacterStream();
        r.skip(49L);
        r.read(utf16Chars);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)unicodeStr, (String)String.valueOf(utf16Chars));
        r.close();
        Writer w = clob.setCharacterStream(1L);
        r = clob.getCharacterStream();
        for (int i = 0; i < 10000; ++i) {
            w.write("This is a new String");
        }
        w.close();
        clob.setString(500L, unicodeStr);
        r.skip(499L);
        char[] unicodeChars = new char[unicodeStr.length()];
        r.read(unicodeChars);
        ClobUpdatableReaderTest.assertEquals((String)"update not reflected", (String)unicodeStr, (String)String.valueOf(unicodeChars));
    }

    public void testMultiplexedOperationProblem() throws IOException, SQLException {
        this.getConnection().setAutoCommit(false);
        int length = 266000;
        PreparedStatement ps = this.prepareStatement("insert into updateClob (id, data) values (?,?)");
        ps.setInt(1, length);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(length), length);
        ClobUpdatableReaderTest.assertEquals((int)1, (int)ps.executeUpdate());
        ps.close();
        PreparedStatement psFetchClob = this.prepareStatement("select data from updateClob where id = ?");
        psFetchClob.setInt(1, length);
        ResultSet rs = psFetchClob.executeQuery();
        ClobUpdatableReaderTest.assertTrue((String)("No Clob of length " + length + " in database"), (boolean)rs.next());
        Clob clob = rs.getClob(1);
        ClobUpdatableReaderTest.assertEquals((long)length, (long)clob.length());
        Reader r = clob.getCharacterStream();
        int lastReadChar = r.read();
        lastReadChar = this.assertCorrectChar(lastReadChar, r.read());
        lastReadChar = this.assertCorrectChar(lastReadChar, r.read());
        ClobUpdatableReaderTest.assertEquals((long)length, (long)clob.length());
        for (int i = 2; i < 160000; ++i) {
            int nextChar = r.read();
            if (nextChar == -1) {
                ClobUpdatableReaderTest.fail((String)("Failed at position " + i + ", stream should not be" + " exhausted now"));
            }
            lastReadChar = this.assertCorrectChar(lastReadChar, nextChar);
        }
        lastReadChar = this.assertCorrectChar(lastReadChar, r.read());
        lastReadChar = this.assertCorrectChar(lastReadChar, r.read());
        InputStream ra = clob.getAsciiStream();
        ClobUpdatableReaderTest.assertEquals((long)length, (long)clob.length());
        int lastReadAscii = ra.read();
        lastReadAscii = this.assertCorrectChar(lastReadAscii, ra.read());
        lastReadAscii = this.assertCorrectChar(lastReadAscii, ra.read());
        ClobUpdatableReaderTest.assertEquals((long)length, (long)clob.length());
        lastReadAscii = this.assertCorrectChar(lastReadAscii, ra.read());
        lastReadChar = this.assertCorrectChar(lastReadChar, r.read());
        r.close();
        ra.close();
        rs.close();
        psFetchClob.close();
    }

    private int assertCorrectChar(int prevChar, int nextChar) throws IOException {
        ClobUpdatableReaderTest.assertTrue((String)"Reached EOF unexpectedly", (nextChar != -1 ? 1 : 0) != 0);
        if (nextChar < 97 && nextChar > 122) {
            ClobUpdatableReaderTest.fail((String)("Char out of range: " + nextChar));
        }
        if (prevChar < 97 && prevChar > 122) {
            ClobUpdatableReaderTest.fail((String)("Char out of range: " + prevChar));
        }
        if (prevChar > -1) {
            if (prevChar == 122) {
                ClobUpdatableReaderTest.assertTrue((String)(prevChar + " -> " + nextChar), (nextChar == 97 ? 1 : 0) != 0);
            } else {
                ClobUpdatableReaderTest.assertTrue((String)(prevChar + " -> " + nextChar), (nextChar == prevChar + 1 ? 1 : 0) != 0);
            }
        }
        return nextChar;
    }

    private String getUnicodeString() {
        char[] fill = new char[]{'d', '\u03a9', '\u0e14', 'j'};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(fill);
        }
        return sb.toString();
    }

    public void setUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table updateClob (id integer primary key, data clob)");
        stmt.close();
        this.commit();
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("ClobUpdatableReaderTest");
        ts.addTest(TestConfiguration.defaultSuite(ClobUpdatableReaderTest.class));
        TestSuite encSuite = new TestSuite("ClobUpdatableReaderTest:encrypted");
        encSuite.addTestSuite(ClobUpdatableReaderTest.class);
        ts.addTest(Decorator.encryptedDatabase((Test)encSuite));
        return ts;
    }

    protected void tearDown() throws Exception {
        this.rollback();
        Statement stmt = this.createStatement();
        stmt.execute("drop table updateClob");
        stmt.close();
        this.commit();
        super.tearDown();
    }
}

