/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XADataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBC4FromJDBC3DataSourceTest
extends BaseJDBCTestCase {
    public JDBC4FromJDBC3DataSourceTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC4()) {
            return TestConfiguration.forceJDBC3Suite(JDBC4FromJDBC3DataSourceTest.class);
        }
        return new TestSuite("JDBC 4 from JDBC 3 Data Sources");
    }

    public void testPooledConnection() throws Exception {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        this.assertNonJDBC4DataSource((DataSource)((Object)ds));
        this.checkJDBC4Interface(ds.getPooledConnection());
    }

    public void testXAConnection() throws Exception {
        XADataSource ds = J2EEDataSource.getXADataSource();
        this.assertNonJDBC4DataSource((DataSource)((Object)ds));
        this.checkJDBC4Interface(ds.getXAConnection());
    }

    private void assertNonJDBC4DataSource(DataSource ds) throws SQLException {
        try {
            ds.isWrapperFor(DataSource.class);
            JDBC4FromJDBC3DataSourceTest.fail((String)"Found JDBC 4 data source when JDBC 3 was expected.");
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    private void checkJDBC4Interface(PooledConnection pc) throws Exception {
        StatementEventListener listener = new StatementEventListener(){

            @Override
            public void statementClosed(StatementEvent event) {
            }

            @Override
            public void statementErrorOccurred(StatementEvent event) {
            }
        };
        Connection conn = pc.getConnection();
        JDBC4FromJDBC3DataSourceTest.assertEquals((int)4, (int)conn.getMetaData().getJDBCMajorVersion());
        conn.close();
        conn = null;
        pc.addStatementEventListener(listener);
        pc.removeStatementEventListener(listener);
        pc.close();
    }
}

