/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RestrictiveFilePermissionsTest
extends BaseJDBCTestCase {
    static final String dbName = "RFPT_db";
    static final String dbName2 = "RFPT_db2";
    static final String exportFileName = "ourExport.txt";
    static final String exportFileName2 = "ourExport2.txt";
    static final String exportLobFileName = "ourExport.lob";
    static final String backupDir = "RFPT_backup";
    static final String derbyDotLog = "RFPT_db.log";
    static String home = null;
    static boolean supportsLaxTesting = false;
    public static final int NEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int UNKNOWN = 2;
    private static boolean initialized = false;
    private static Class filesClz;
    private static Class pathClz;
    private static Class pathsClz;
    private static Class aclEntryClz;
    private static Class aclFileAttributeViewClz;
    private static Class posixFileAttributeViewClz;
    private static Class posixFileAttributesClz;
    private static Class posixFilePermissionClz;
    private static Class userPrincipalClz;
    private static Class linkOptionArrayClz;
    private static Class linkOptionClz;
    private static Class stringArrayClz;
    private static Class aclEntryBuilderClz;
    private static Class aclEntryTypeClz;
    private static Class fileStoreClz;
    private static Method get;
    private static Method getFileAttributeView;
    private static Method supportsFileAttributeView;
    private static Method getFileStore;
    private static Method getOwner;
    private static Method getAcl;
    private static Method principal;
    private static Method getName;
    private static Method permissionsAcl;
    private static Method permissionsPosix;
    private static Method readAttributes;
    private static Field GROUP_EXECUTE;
    private static Field GROUP_READ;
    private static Field GROUP_WRITE;
    private static Field OTHERS_EXECUTE;
    private static Field OTHERS_READ;
    private static Field OTHERS_WRITE;
    private static Set unwantedPermissions;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public RestrictiveFilePermissionsTest(String name) {
        super(name);
    }

    public static Test suite() throws Exception {
        if (JVMInfo.JDK_ID < 8) {
            RestrictiveFilePermissionsTest.println("warning: testing of strict permissions in RestrictiveFilePermissionsTest can not take place, need Java 7");
            return new TestSuite();
        }
        File f = new File("system/testPermissions");
        RestrictiveFilePermissionsTest.assertTrue((boolean)f.mkdirs());
        supportsLaxTesting = RestrictiveFilePermissionsTest.checkAccessToOwner(f, false, 2);
        if (!supportsLaxTesting) {
            RestrictiveFilePermissionsTest.println("warning: testing of lax file permissions inRestrictiveFilePermissionsTest can not take place, use a more liberal runtime default (umask) for the tests");
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(f);
        TestSuite totalSuite = new TestSuite("RestrictiveFilePermissionsTest");
        Properties p = new Properties();
        p.put("derby.storage.useDefaultFilePermissions", "false");
        p.put("derby.stream.error.file", derbyDotLog);
        totalSuite.addTest((Test)new SystemPropertyTestSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new SupportFilesSetup((Test)new TestSuite(RestrictiveFilePermissionsTest.class, "haveWeGotAllCreatedFilesSuite"), new String[]{"functionTests/tests/lang/dcl_id.jar"}), dbName), p, true));
        if (Derby.hasServer()) {
            totalSuite.addTest((Test)new NetworkServerTestSetup((Test)new RestrictiveFilePermissionsTest("doTestCliServerIsRestrictive"), new String[0], new String[0], true));
        }
        if (supportsLaxTesting) {
            totalSuite.addTest(TestConfiguration.clientServerDecorator((Test)new RestrictiveFilePermissionsTest("doTestNonCliServerIsLax")));
            p = new Properties();
            p.put("derby.stream.error.file", "RFPT_db.log.lax");
            totalSuite.addTest((Test)new SystemPropertyTestSetup((Test)new RestrictiveFilePermissionsTest("dotestEmbeddedIsLax"), p, true));
        }
        return totalSuite;
    }

    public void setUp() throws Exception {
        this.getConnection();
        home = RestrictiveFilePermissionsTest.getSystemProperty("derby.system.home");
    }

    public void testDerbyDotLog() throws Exception {
        File derbydotlog = new File(home, derbyDotLog);
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbydotlog, 1);
    }

    public void testDbDirectory() throws Exception {
        File derbyDbDir = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbyDbDir, 1);
    }

    public void testServiceProperties() throws Exception {
        File servProp = new File(home, "RFPT_db/service.properties");
        RestrictiveFilePermissionsTest.checkAccessToOwner(servProp, 1);
    }

    public void testTmpDirectory() throws Exception {
        File tmp = new File(home, "RFPT_db/tmp");
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        RestrictiveFilePermissionsTest.checkAccessToOwner(tmp, true, 1);
    }

    public void testLockFiles() throws Exception {
        File dbLck = new File(home, "RFPT_db/db.lck");
        File dbexLck = new File(home, "RFPT_db/dbex.lck");
        RestrictiveFilePermissionsTest.checkAccessToOwner(dbLck, 1);
        if (PrivilegedFileOpsForTests.exists(dbexLck)) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(dbexLck, 1);
        }
    }

    public void testSeg0AndConglomerates() throws Exception {
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testLogDirAndLogFiles() throws Exception {
        File seg0 = new File(home, "RFPT_db/log");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testExportedFiles() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(    'SYS',    'SYSTABLES',    '" + home + "/" + dbName + "/" + exportFileName + "'," + "    NULL," + "    NULL," + "    NULL)");
        File exp = new File(home, "RFPT_db/ourExport.txt");
        RestrictiveFilePermissionsTest.checkAccessToOwner(exp, 1);
        s.executeUpdate("create table lobtable(i int, c clob)");
        PreparedStatement ps = this.prepareStatement("insert into lobtable values (1,?)");
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader(1000L), 1000);
        ps.executeUpdate();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(    'SYS',    'SYSTABLES',    '" + home + "/" + dbName + "/" + exportFileName2 + "'," + "    NULL," + "    NULL," + "    NULL," + "    '" + home + "/" + dbName + "/" + exportLobFileName + "')");
        File exp2 = new File(home, "RFPT_db/ourExport2.txt");
        File expLob = new File(home, "RFPT_db/ourExport.lob");
        RestrictiveFilePermissionsTest.checkAccessToOwner(exp2, 1);
        RestrictiveFilePermissionsTest.checkAccessToOwner(expLob, 1);
    }

    public void testConglomsAfterCompress() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create table comptable(i int primary key, j int)");
        s.executeUpdate("create index secondary on comptable(j)");
        PreparedStatement ps = this.prepareStatement("insert into comptable values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 10000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        this.commit();
        s.executeUpdate("delete from comptable where MOD(i, 2) = 0");
        this.commit();
        this.setAutoCommit(true);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'COMPTABLE', 0)");
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testTruncateTable() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create table trunctable(i int)");
        PreparedStatement ps = this.prepareStatement("insert into trunctable values (?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        s.executeUpdate("truncate table trunctable");
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testBackupRestoreFiles() throws Exception {
        URL jar = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, "testBackupFiles");
        cs.executeUpdate();
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String fullBackupDir = home + "/" + backupDir;
        cs.setString(1, fullBackupDir);
        cs.execute();
        File fbd = new File(fullBackupDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(fbd, true, 1);
        TestConfiguration.getCurrent().shutdownDatabase();
        DataSource ds = JDBCDataSource.getDataSource();
        String fullRestoreDir = home + "/" + backupDir + "/" + dbName;
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "restoreFrom=" + fullRestoreDir);
        Connection con = ds.getConnection();
        File db = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(db, true, 1);
        con.close();
        DataSource ds2 = JDBCDataSource.getDataSource(dbName2);
        JDBCDataSource.setBeanProperty(ds2, "connectionAttributes", "restoreFrom=" + fullRestoreDir);
        Connection con2 = ds2.getConnection();
        File newDb = new File(home, dbName2);
        RestrictiveFilePermissionsTest.checkAccessToOwner(newDb, true, 1);
        con2.close();
        DataSource[] srcs = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(dbName2)};
        for (int i = 0; i < srcs.length; ++i) {
            JDBCDataSource.setBeanProperty(srcs[i], "connectionAttributes", "shutdown=true");
            try {
                srcs[i].getConnection();
                RestrictiveFilePermissionsTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException e) {
                RestrictiveFilePermissionsTest.assertSQLState("database shutdown", "08006", e);
            }
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(newDb);
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(new File(home + "/" + backupDir));
    }

    public void testJarFiles() throws Exception {
        URL jar = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, "anyName");
        cs.executeUpdate();
        File jarsDir = new File(home, "RFPT_db/jar");
        RestrictiveFilePermissionsTest.checkAccessToOwner(jarsDir, true, 1);
    }

    public void doTestCliServerIsRestrictive() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String traceDir = home + "/" + dbName + "_tracefiles_restr";
        nsctrl.setTraceDirectory(traceDir);
        nsctrl.trace(true);
        nsctrl.ping();
        nsctrl.trace(false);
        File traceDirF = new File(traceDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(traceDirF, true, 1);
        nsctrl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(traceDirF);
    }

    public void doTestNonCliServerIsLax() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String traceDir = home + "/" + dbName + "_tracefiles_lax";
        nsctrl.setTraceDirectory(traceDir);
        nsctrl.trace(true);
        nsctrl.ping();
        nsctrl.trace(false);
        File traceDirF = new File(traceDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(traceDirF, true, 0);
        nsctrl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(traceDirF);
    }

    public void dotestEmbeddedIsLax() throws Exception {
        File derbydotlogF = new File(home, "RFPT_db.log.lax");
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbydotlogF, 0);
    }

    public static void checkAccessToOwner(File file, int expectedOutcome) throws Exception {
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, expectedOutcome);
    }

    private static boolean checkAccessToOwner(final File file, boolean doContents, final int expectedOutcome) throws Exception {
        if (doContents) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, expectedOutcome);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        RestrictiveFilePermissionsTest.checkAccessToOwner(files[i], false, expectedOutcome);
                    }
                    return null;
                }
            });
        }
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!initialized) {
                    initialized = true;
                    filesClz = Class.forName("java.nio.file.Files");
                    pathClz = Class.forName("java.nio.file.Path");
                    pathsClz = Class.forName("java.nio.file.Paths");
                    aclEntryClz = Class.forName("java.nio.file.attribute.AclEntry");
                    aclFileAttributeViewClz = Class.forName("java.nio.file.attribute.AclFileAttributeView");
                    posixFileAttributeViewClz = Class.forName("java.nio.file.attribute.PosixFileAttributeView");
                    posixFileAttributesClz = Class.forName("java.nio.file.attribute.PosixFileAttributes");
                    posixFilePermissionClz = Class.forName("java.nio.file.attribute.PosixFilePermission");
                    userPrincipalClz = Class.forName("java.nio.file.attribute.UserPrincipal");
                    linkOptionArrayClz = Class.forName("[Ljava.nio.file.LinkOption;");
                    linkOptionClz = Class.forName("java.nio.file.LinkOption");
                    stringArrayClz = Class.forName("[Ljava.lang.String;");
                    aclEntryBuilderClz = Class.forName("java.nio.file.attribute.AclEntry$Builder");
                    aclEntryTypeClz = Class.forName("java.nio.file.attribute.AclEntryType");
                    fileStoreClz = Class.forName("java.nio.file.FileStore");
                    get = pathsClz.getMethod("get", class$java$lang$String == null ? (class$java$lang$String = RestrictiveFilePermissionsTest.class$("java.lang.String")) : class$java$lang$String, stringArrayClz);
                    getFileAttributeView = filesClz.getMethod("getFileAttributeView", pathClz, class$java$lang$Class == null ? (class$java$lang$Class = RestrictiveFilePermissionsTest.class$("java.lang.Class")) : class$java$lang$Class, linkOptionArrayClz);
                    supportsFileAttributeView = fileStoreClz.getMethod("supportsFileAttributeView", class$java$lang$Class == null ? (class$java$lang$Class = RestrictiveFilePermissionsTest.class$("java.lang.Class")) : class$java$lang$Class);
                    getFileStore = filesClz.getMethod("getFileStore", pathClz);
                    getOwner = filesClz.getMethod("getOwner", pathClz, linkOptionArrayClz);
                    getAcl = aclFileAttributeViewClz.getMethod("getAcl", new Class[0]);
                    principal = aclEntryClz.getMethod("principal", new Class[0]);
                    getName = userPrincipalClz.getMethod("getName", new Class[0]);
                    permissionsAcl = aclEntryClz.getMethod("permissions", new Class[0]);
                    permissionsPosix = posixFileAttributesClz.getMethod("permissions", new Class[0]);
                    readAttributes = posixFileAttributeViewClz.getMethod("readAttributes", new Class[0]);
                    GROUP_EXECUTE = posixFilePermissionClz.getField("GROUP_EXECUTE");
                    GROUP_READ = posixFilePermissionClz.getField("GROUP_READ");
                    GROUP_WRITE = posixFilePermissionClz.getField("GROUP_WRITE");
                    OTHERS_EXECUTE = posixFilePermissionClz.getField("OTHERS_EXECUTE");
                    OTHERS_READ = posixFilePermissionClz.getField("OTHERS_READ");
                    OTHERS_WRITE = posixFilePermissionClz.getField("OTHERS_WRITE");
                    unwantedPermissions = new HashSet();
                    unwantedPermissions.add(GROUP_EXECUTE.get(null));
                    unwantedPermissions.add(GROUP_READ.get(null));
                    unwantedPermissions.add(GROUP_WRITE.get(null));
                    unwantedPermissions.add(OTHERS_EXECUTE.get(null));
                    unwantedPermissions.add(OTHERS_READ.get(null));
                    unwantedPermissions.add(OTHERS_WRITE.get(null));
                }
                boolean someThingBeyondOwnerFound = false;
                try {
                    Object fileP = get.invoke(null, file.getPath(), new String[0]);
                    Object fileStore = getFileStore.invoke(null, fileP);
                    boolean aclsSupported = (Boolean)supportsFileAttributeView.invoke(fileStore, aclFileAttributeViewClz);
                    Object aclView = getFileAttributeView.invoke(null, fileP, aclFileAttributeViewClz, Array.newInstance(linkOptionClz, 0));
                    Object posixView = getFileAttributeView.invoke(null, fileP, posixFileAttributeViewClz, Array.newInstance(linkOptionClz, 0));
                    if (aclsSupported && aclView != null && posixView == null) {
                        Object owner = getOwner.invoke(null, fileP, Array.newInstance(linkOptionClz, 0));
                        List oldAcl = (List)getAcl.invoke(aclView, (Object[])null);
                        Iterator i = oldAcl.iterator();
                        while (i.hasNext()) {
                            Object ace = i.next();
                            Object princ = principal.invoke(ace, (Object[])null);
                            String princName = (String)getName.invoke(princ, (Object[])null);
                            if (posixView != null) {
                                if (princName.equals("OWNER@") || !princName.equals("GROUP@") && !princName.equals("EVERYONE@")) continue;
                                Set s = (Set)permissionsAcl.invoke(ace, (Object[])null);
                                if (expectedOutcome == 1) {
                                    Assert.assertTrue((String)("Non-empty set of  permissions for uid: " + princName + " for file " + file), (boolean)s.isEmpty());
                                    continue;
                                }
                                someThingBeyondOwnerFound = !s.isEmpty();
                                continue;
                            }
                            if (princ.equals(owner)) continue;
                            if (expectedOutcome == 1) {
                                Assert.fail((String)("unexpected uid has access: " + princName));
                                continue;
                            }
                            someThingBeyondOwnerFound = true;
                        }
                    } else if (posixView != null) {
                        Object posixFileAttributes = readAttributes.invoke(posixView, new Object[0]);
                        Set permissionsSet = (Set)permissionsPosix.invoke(posixFileAttributes, new Object[0]);
                        Iterator i = permissionsSet.iterator();
                        while (i.hasNext()) {
                            Object perm = i.next();
                            if (!unwantedPermissions.contains(perm)) continue;
                            someThingBeyondOwnerFound = true;
                            break;
                        }
                    } else {
                        Assert.fail();
                    }
                    if (expectedOutcome == 0 && !someThingBeyondOwnerFound) {
                        Assert.fail((String)("unexpected restrictive access: " + file));
                    }
                }
                catch (IllegalAccessException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                if (expectedOutcome != 2) {
                    BaseTestCase.println("checked perms on: " + file);
                }
                if (expectedOutcome == 2 && someThingBeyondOwnerFound) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }
}

