/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RuntimeInfoTest
extends BaseJDBCTestCase {
    private static String[] RuntimeinfoCmd = new String[]{"-Demma.verbosity.level=silent", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static String[] RuntimeinfoLocaleCmd = new String[]{"-Demma.verbosity.level=silent", "-Duser.language=err", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "runtimeinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
    private static String POLICY_FILE_NAME = "functionTests/tests/derbynet/RuntimeInfoTest.policy";
    private static String TARGET_POLICY_FILE_NAME = "runtimeinfo.policy";
    private static Locale englishLocale = new Locale("en", "US");
    private static Locale germanLocale = new Locale("de", "DE");
    private static String stdout_err_tags = "<[^<>]*STD.*>";
    private static final HashMap outputs;

    public RuntimeInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RuntimeInfoTest");
        suite.addTest(RuntimeInfoTest.decorateTest(englishLocale));
        suite.addTest(RuntimeInfoTest.decorateTest(germanLocale));
        return suite;
    }

    public void testRunTests() throws Exception {
        this.x_testRuntimeInfoWithActiveConn();
        this.x_testRuntimeInfoLocale();
        this.x_testRuntimeInfoAfterConnClose();
    }

    public void x_testRuntimeInfoWithActiveConn() throws Exception {
        Process p = RuntimeInfoTest.execJavaCmd(RuntimeinfoCmd);
        String output = this.sed(RuntimeInfoTest.readProcessOutput(p));
        this.printIfVerbose("testRuntimeInfo", output);
        String expectedOutput = ((HashMap)outputs.get(Locale.getDefault())).get("RuntimeInfoWithActiveConn").toString();
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)expectedOutput, (String)output);
    }

    public void x_testRuntimeInfoLocale() throws Exception {
        Connection conn1 = this.getConnection();
        Connection conn2 = this.openDefaultConnection();
        PreparedStatement ps = RuntimeInfoTest.prepareAndExecuteQuery(conn1, "SELECT count(*) from sys.systables");
        PreparedStatement ps2 = RuntimeInfoTest.prepareAndExecuteQuery(conn1, "VALUES(1)");
        Connection conn3 = this.openDefaultConnection();
        PreparedStatement ps3 = RuntimeInfoTest.prepareAndExecuteQuery(conn2, "SELECT count(*) from sys.systables");
        PreparedStatement ps4 = RuntimeInfoTest.prepareAndExecuteQuery(conn2, "VALUES(2)");
        Process p = RuntimeInfoTest.execJavaCmd(RuntimeinfoLocaleCmd);
        String output = this.sed(RuntimeInfoTest.readProcessOutput(p));
        this.printIfVerbose("testRuntimeInfoLocale", output);
        int matched = 0;
        String matchString = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(1)\n";
        String invertedMatchString = "\tSYSLH0002\tVALUES(1)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        matched = output.indexOf(matchString);
        if (matched == -1) {
            matched = output.indexOf(invertedMatchString);
            RuntimeInfoTest.assertTrue((matched != -1 ? 1 : 0) != 0);
        }
        matched = 0;
        matchString = "\tSYSLH0001\tSELECT count(*) from sys.systables\n\tSYSLH0002\tVALUES(2)\n";
        invertedMatchString = "\tSYSLH0002\tVALUES(2)\n\tSYSLH0001\tSELECT count(*) from sys.systables\n";
        matched = output.indexOf(matchString);
        if (matched == -1) {
            matched = output.indexOf(invertedMatchString);
            RuntimeInfoTest.assertTrue((matched != -1 ? 1 : 0) != 0);
        }
        matched = 0;
        matchString = ((HashMap)outputs.get(Locale.getDefault())).get("RuntimeInfoLocaleString").toString();
        RuntimeInfoTest.assertTrue((output.indexOf(matchString) != -1 ? 1 : 0) != 0);
        ps.close();
        ps2.close();
        ps3.close();
        ps4.close();
        conn1.close();
        conn2.close();
        conn3.close();
    }

    public void x_testRuntimeInfoAfterConnClose() throws Exception {
        Thread.sleep(1000L);
        String s = NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getRuntimeInfo();
        s = this.sed(s);
        NetworkServerTestSetup.getNetworkServerControl().shutdown();
        this.printIfVerbose("testRuntimeInfoMethod", s);
        String expectedOutput = ((HashMap)outputs.get(Locale.getDefault())).get("RuntimeInfoAfterConnClose").toString();
        RuntimeInfoTest.assertEquals((String)"Output doesn't match", (String)expectedOutput, (String)s);
    }

    public static PreparedStatement prepareAndExecuteQuery(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        rs.next();
        return ps;
    }

    private String sed(String s) {
        String searchString = ((HashMap)outputs.get(Locale.getDefault())).get("sedMemorySearch").toString();
        String replaceString = ((HashMap)outputs.get(Locale.getDefault())).get("sedMemoryReplace").toString();
        s = s.replaceAll(searchString, replaceString);
        s = s.replaceAll(stdout_err_tags, "");
        s = s.trim();
        return s;
    }

    private void printIfVerbose(String name, String s) {
        RuntimeInfoTest.println("\n\n>>>" + name + ">>>");
        RuntimeInfoTest.println(s);
        RuntimeInfoTest.println("<<<" + name + "<<<\n\n");
    }

    private String makePolicyName() {
        try {
            String userDir = RuntimeInfoTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURI().toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            RuntimeInfoTest.fail((String)e.getMessage());
            return null;
        }
    }

    private static Test decorateTest(Locale serverLocale) {
        String policyName = new RuntimeInfoTest("test").makePolicyName();
        Object test = new TestSuite(RuntimeInfoTest.class);
        test = TestConfiguration.clientServerDecorator((Test)test);
        test = TestConfiguration.singleUseDatabaseDecorator((Test)test);
        test = new LocaleTestSetup((Test)test, serverLocale);
        test = new SecurityManagerSetup((Test)test, policyName);
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    static {
        HashMap<String, String> englishOutputs = new HashMap<String, String>();
        englishOutputs.put("RuntimeInfoWithActiveConn", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :2\n\n\n-------------------------------------------------------------\n# Connection Threads : 1\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        englishOutputs.put("RuntimeInfoAfterConnClose", "--- Derby Network Server Runtime Information ---\n---------- Session Information ---------------\nSession # :8\n\n\n-------------------------------------------------------------\n# Connection Threads : 4\n# Active Sessions : 1\n# Waiting  Sessions : 0\n\nTotal Memory : #####\tFree Memory : #####");
        englishOutputs.put("sedMemorySearch", "(?m)Memory : [0-9]*");
        englishOutputs.put("sedMemoryReplace", "Memory : #####");
        englishOutputs.put("RuntimeInfoLocaleString", "\tStmt ID\t\tSQLText\n\t-------------\t-----------\n\n\n\nSession");
        HashMap<String, String> germanOutputs = new HashMap<String, String>();
        germanOutputs.put("RuntimeInfoWithActiveConn", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sitzungsinformationen ---------------\nSitzungsnummer:2\n\n\n-------------------------------------------------------------\nAnzahl der Verbindungs-Threads: 1\nAnzahl der aktiven Sitzungen: 1\nAnzahl der wartenden Sitzungen: 0\n\nGesamtspeicher: #####\tFreier Speicher: #####");
        germanOutputs.put("RuntimeInfoAfterConnClose", "--- Laufzeitinformationen zu Derby Network Server ---\n---------- Sitzungsinformationen ---------------\nSitzungsnummer:8\n\n\n-------------------------------------------------------------\nAnzahl der Verbindungs-Threads: 4\nAnzahl der aktiven Sitzungen: 1\nAnzahl der wartenden Sitzungen: 0\n\nGesamtspeicher: #####\tFreier Speicher: #####");
        germanOutputs.put("sedMemorySearch", "Gesamtspeicher: [0-9]*\tFreier Speicher: [0-9]*");
        germanOutputs.put("sedMemoryReplace", "Gesamtspeicher: #####\tFreier Speicher: #####");
        germanOutputs.put("RuntimeInfoLocaleString", "\tAnwsg-ID\t\tSQL-Text\n\t-------------\t-----------\n\n\n\nSitzungsnummer");
        outputs = new HashMap();
        outputs.put(englishLocale, englishOutputs);
        outputs.put(germanLocale, germanOutputs);
    }
}

