/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DRDAProtocolTest
extends BaseJDBCTestCase {
    private String threadName;

    public void setUp() {
        this.threadName = Thread.currentThread().getName();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread().setName(this.threadName);
    }

    public void testNonEBCDICCharacters() throws SQLException {
        Thread.currentThread().setName("\u4e10");
        Connection conn2 = this.openConnection("FIRSTDB1");
        conn2.close();
    }

    public void testMultipleConnections() throws SQLException {
        Connection conn1 = this.openConnection("FIRSTDB1");
        conn1.setAutoCommit(false);
        Statement st = conn1.createStatement();
        st.execute("create table FIRSTDB_T1 (i int, j int, k int)");
        st.execute("insert into FIRSTDB_T1 values (1, 3, 5)");
        PreparedStatement pSt1 = conn1.prepareStatement("select * from FIRSTDB_T1");
        ResultSet rs1 = pSt1.executeQuery();
        rs1.next();
        rs1.close();
        pSt1.close();
        st.close();
        Connection conn2 = this.openConnection("SECONDDB2");
        conn2.setAutoCommit(false);
        Statement st2 = conn2.createStatement();
        st2.execute("create table SECONDDB_T1 (i int, j int, k int)");
        st2.execute("insert into SECONDDB_T1 values (2, 4, 6)");
        PreparedStatement pSt2 = conn2.prepareStatement("select * from SECONDDB_T1");
        rs1 = pSt2.executeQuery();
        rs1.next();
        rs1.close();
        pSt2.close();
        st2.close();
        JDBC.cleanup(conn1);
        JDBC.cleanup(conn2);
    }

    public DRDAProtocolTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.clientServerSuite(DRDAProtocolTest.class);
        test = TestConfiguration.additionalDatabaseDecorator(test, "FIRSTDB1");
        test = TestConfiguration.additionalDatabaseDecorator(test, "SECONDDB2");
        return test;
    }
}

