/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;

public class Utilities {
    public static String stringToHexLiteral(String s) {
        String hexLiteral = null;
        try {
            byte[] bytes = s.getBytes("UTF-16BE");
            hexLiteral = Utilities.convertToHexString(bytes);
        }
        catch (UnsupportedEncodingException ue) {
            System.out.println("This shouldn't happen as UTF-16BE should be supported");
            ue.printStackTrace();
        }
        return hexLiteral;
    }

    private static String convertToHexString(byte[] buf) {
        StringBuffer str = new StringBuffer();
        str.append("X'");
        for (int i = 0; i < buf.length; ++i) {
            int byteVal = buf[i] & 0xFF;
            String val = Integer.toHexString(byteVal);
            if (val.length() < 2) {
                str.append("0");
            }
            str.append(val);
        }
        return str.toString() + "'";
    }

    public static String repeatChar(String c, int repeatCount) {
        char ch = c.charAt(0);
        char[] chArray = new char[repeatCount];
        for (int i = 0; i < repeatCount; ++i) {
            chArray[i] = ch;
        }
        return new String(chArray);
    }

    public static void showResultSet(ResultSet rs) throws SQLException {
        System.out.print("{");
        int row = 0;
        boolean next = rs.next();
        while (next) {
            ++row;
            ResultSetMetaData rsmd = rs.getMetaData();
            int nocols = rsmd.getColumnCount();
            System.out.print("{");
            for (int i = 0; i < nocols; ++i) {
                String val = rs.getString(i + 1);
                if (val == null) {
                    System.out.print("null");
                } else {
                    System.out.print("\"" + rs.getString(i + 1) + "\"");
                }
                if (i == nocols - 1) {
                    System.out.print("}");
                    continue;
                }
                System.out.print(",");
            }
            next = rs.next();
            if (next) {
                System.out.println(",");
                continue;
            }
            System.out.println("};\n");
        }
    }

    public static BufferedReader getSysinfoLocally() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(20480);
        PrintWriter pw = new PrintWriter(byteStream, true);
        sysinfo.getInfo((PrintWriter)pw);
        pw.flush();
        pw.close();
        byte[] outBytes = byteStream.toByteArray();
        BufferedReader sysinfoOutput = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outBytes)));
        return sysinfoOutput;
    }

    public static BufferedReader getSysinfoFromServer() throws Exception {
        return new BufferedReader(new StringReader(NetworkServerTestSetup.getNetworkServerControl().getSysinfo()));
    }

    public static String[] split(String str, char delim) {
        if (str == null) {
            throw new NullPointerException("str can't be null");
        }
        StringTokenizer st = new StringTokenizer(str, String.valueOf(delim));
        int n = st.countTokens();
        String[] s = new String[n];
        for (int i = 0; i < n; ++i) {
            s[i] = st.nextToken();
        }
        return s;
    }
}

