/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.ChangeSSLSetup;
import org.apache.derbyTesting.junit.ChangeUserSetup;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.ConnectorSetup;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.DatabaseChangeSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.NetworkServerControlWrapper;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.ServerSetup;

public class TestConfiguration {
    private static final String DEFAULT_DBNAME = "wombat";
    private static final String DEFAULT_DBNAME_SQL = "dbsqlauth";
    private static final String DEFAULT_USER_NAME = "APP";
    private static final String DEFAULT_USER_PASSWORD = "APP";
    public static final int DEFAULT_PORT = 1527;
    private static final String DEFAULT_FRAMEWORK = "embedded";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_SSL = "off";
    public static final int DEFAULT_JMX_PORT = 9999;
    public static final String TEST_DBO = "TEST_DBO";
    private FileOutputStream serverOutput;
    private static final int SLEEP_TIME = 1000;
    private static final String KEY_DBNAME = "databaseName";
    private static final String KEY_FRAMEWORK = "framework";
    private static final String KEY_USER_PASSWORD = "password";
    private static final String KEY_USER_NAME = "user";
    private static final String KEY_HOSTNAME = "hostName";
    private static final String KEY_PORT = "port";
    private static final String KEY_VERBOSE = "derby.tests.debug";
    private static final String KEY_TRACE = "derby.tests.trace";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_JMX_PORT = "jmxPort";
    private static int uniqueDB;
    private static final TestConfiguration DERBY_HARNESS_CONFIG;
    private static final TestConfiguration JUNIT_CONFIG;
    private static final TestConfiguration DEFAULT_CONFIG;
    private static final boolean runningInDerbyHarness;
    private static final ThreadLocal CURRENT_CONFIG;
    private final String defaultDbName;
    private final ArrayList usedDbNames = new ArrayList();
    private final Hashtable logicalDbMapping = new Hashtable();
    private final String url;
    private final String userName;
    private final String userPassword;
    private final int port;
    private final String hostName;
    private final JDBCClient jdbcClient;
    private final int jmxPort;
    private boolean isVerbose;
    private boolean doTrace;
    private String ssl;
    private String passwordToken = "";
    Connector connector;

    public static TestConfiguration getCurrent() {
        return (TestConfiguration)CURRENT_CONFIG.get();
    }

    static void setCurrent(TestConfiguration config) {
        CURRENT_CONFIG.set(config);
    }

    public static Test defaultSuite(Class testClass) {
        return TestConfiguration.defaultSuite(testClass, true);
    }

    public static Test defaultSuite(Class testClass, boolean cleanDB) {
        TestSuite suite = new TestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(testClass)));
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientServerSuite(testClass)));
        } else {
            suite.addTest(TestConfiguration.embeddedSuite(testClass));
            suite.addTest(TestConfiguration.clientServerSuite(testClass));
        }
        return suite;
    }

    public static Test defaultExistingServerSuite(Class testClass) {
        return TestConfiguration.defaultExistingServerSuite(testClass, true);
    }

    public static Test defaultExistingServerSuite(Class testClass, boolean cleanDB) {
        TestSuite suite = new TestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(testClass)));
        } else {
            suite.addTest(TestConfiguration.clientExistingServerSuite(testClass));
        }
        return suite;
    }

    public static Test existingServerSuite(Class testClass, boolean cleanDB, String hostName, int portNumber) {
        TestSuite suite = new TestSuite(TestConfiguration.suiteName(testClass));
        if (cleanDB) {
            suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber)));
        } else {
            suite.addTest(TestConfiguration.clientExistingServerSuite(testClass, hostName, portNumber));
        }
        return suite;
    }

    public static Test forceJDBC3Suite(Class testClass) {
        TestSuite suite = new TestSuite(TestConfiguration.suiteName(testClass));
        suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3Embedded(TestConfiguration.embeddedSuite(testClass))));
        suite.addTest((Test)new CleanDatabaseTestSetup(TestConfiguration.forceJDBC3NetClient(TestConfiguration.clientServerSuite(testClass))));
        return suite;
    }

    private static String suiteName(Class testClass) {
        int lastDot = testClass.getName().lastIndexOf(46);
        String suiteName = testClass.getName();
        if (lastDot != -1) {
            suiteName = suiteName.substring(lastDot + 1, suiteName.length());
        }
        return suiteName;
    }

    public static Test embeddedSuite(Class testClass) {
        return new TestSuite(testClass, TestConfiguration.suiteName(testClass) + ":embedded");
    }

    public static Test clientServerSuite(Class testClass) {
        TestSuite suite = new TestSuite(testClass, TestConfiguration.suiteName(testClass) + ":client");
        return TestConfiguration.clientServerDecorator((Test)suite);
    }

    public static Test clientServerSuiteWithAlternativePort(Class testClass) {
        TestSuite suite = new TestSuite(testClass, TestConfiguration.suiteName(testClass) + ":client");
        return TestConfiguration.clientServerDecoratorWithAlternativePort((Test)suite);
    }

    public static Test clientExistingServerSuite(Class testClass) {
        TestSuite suite = new TestSuite(testClass, TestConfiguration.suiteName(testClass) + ":client");
        return TestConfiguration.defaultExistingServerDecorator((Test)suite);
    }

    public static Test clientExistingServerSuite(Class testClass, String hostName, int portNumber) {
        TestSuite suite = new TestSuite(testClass, TestConfiguration.suiteName(testClass) + ":client");
        return TestConfiguration.existingServerDecorator((Test)suite, hostName, portNumber);
    }

    public static Test clientServerDecorator(Test suite) {
        NetworkServerTestSetup test = new NetworkServerTestSetup(suite, false);
        return TestConfiguration.defaultServerDecorator((Test)test);
    }

    public static Test clientServerDecoratorWithAlternativePort(Test suite) {
        NetworkServerTestSetup test = new NetworkServerTestSetup(suite, false);
        return TestConfiguration.defaultServerDecoratorWithAlternativePort((Test)test);
    }

    public static Test defaultExistingServerDecorator(Test test) {
        if (!Derby.hasClient() || JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty: no network server support in JSR169 (or derbyclient.jar missing).");
        }
        ServerSetup r = new ServerSetup(test, DEFAULT_HOSTNAME, 1527);
        r.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return r;
    }

    public static Test defaultServerDecorator(Test test) {
        if (!Derby.hasClient() || !Derby.hasServer() || JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty: no network server support");
        }
        return new ServerSetup(test, DEFAULT_HOSTNAME, 1527);
    }

    public static Test existingServerDecorator(Test test, String hostName, int PortNumber) {
        ServerSetup r = new ServerSetup(test, hostName, PortNumber);
        r.setJDBCClient(JDBCClient.DERBYNETCLIENT);
        return r;
    }

    public static Test defaultServerDecoratorWithAlternativePort(Test test) {
        if (!Derby.hasClient() || !Derby.hasServer() || JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty: no network server support");
        }
        int port = TestConfiguration.getCurrent().getAlternativePort();
        return new ServerSetup(test, DEFAULT_HOSTNAME, port);
    }

    private static synchronized String generateUniqueDatabaseName() {
        String dbName = "singleUse/oneuse";
        dbName = dbName.concat(Integer.toHexString(uniqueDB++));
        return dbName;
    }

    public static TestSetup singleUseDatabaseDecorator(Test test) {
        String dbName = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, dbName), dbName, dbName, true);
    }

    public static TestSetup singleUseDatabaseDecoratorNoShutdown(Test test) {
        String dbName = TestConfiguration.generateUniqueDatabaseName();
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, dbName){

            protected void tearDown() throws Exception {
                this.removeDatabase();
            }
        }, dbName, dbName, true);
    }

    public static TestSetup additionalDatabaseDecorator(Test test, String logicalDbName) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, logicalDbName), logicalDbName, TestConfiguration.generateUniqueDatabaseName(), false);
    }

    public static TestSetup additionalDatabaseDecoratorNoShutdown(Test test, String logicalDbName) {
        return new DatabaseChangeSetup((Test)new DropDatabaseSetup(test, logicalDbName){

            protected void tearDown() throws Exception {
                this.removeDatabase();
            }
        }, logicalDbName, TestConfiguration.generateUniqueDatabaseName(), false);
    }

    public static Test changeUserDecorator(Test test, String user, String password) {
        return new ChangeUserSetup(test, user, password);
    }

    public static Test sqlAuthorizationDecorator(Test test) {
        Properties sqlAuth = new Properties();
        sqlAuth.setProperty("derby.database.sqlAuthorization", "true");
        DatabasePropertyTestSetup setSQLAuthMode = new DatabasePropertyTestSetup(test, sqlAuth, true){

            protected void tearDown() {
            }
        };
        return TestConfiguration.changeUserDecorator((Test)new DatabaseChangeSetup((Test)setSQLAuthMode, DEFAULT_DBNAME_SQL, DEFAULT_DBNAME_SQL, true), TEST_DBO, "dummy");
    }

    public static Test sqlAuthorizationDecoratorSingleUse(Test test) {
        Properties sqlAuth = new Properties();
        sqlAuth.setProperty("derby.database.sqlAuthorization", "true");
        TestSetup setSQLAuthMode = new DatabasePropertyTestSetup(test, sqlAuth, true){

            protected void tearDown() {
            }
        };
        setSQLAuthMode = new DatabaseChangeSetup((Test)new DropDatabaseSetup((Test)setSQLAuthMode, DEFAULT_DBNAME_SQL){

            protected void tearDown() throws Exception {
                this.removeDatabase();
            }
        }, DEFAULT_DBNAME_SQL, DEFAULT_DBNAME_SQL, true);
        return TestConfiguration.changeUserDecorator((Test)setSQLAuthMode, TEST_DBO, "dummy");
    }

    public static Test sqlAuthorizationDecorator(Test test, String[] users, String passwordToken) {
        String[] usersWithDBO = new String[users.length + 1];
        usersWithDBO[0] = TEST_DBO;
        System.arraycopy(users, 0, usersWithDBO, 1, users.length);
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication(test, usersWithDBO, passwordToken));
    }

    public static TestSetup connectionCPDecorator(Test test) {
        return new ConnectorSetup(test, "org.apache.derbyTesting.junit.ConnectionPoolDataSourceConnector");
    }

    public static TestSetup connectionXADecorator(Test test) {
        return new ConnectorSetup(test, "org.apache.derbyTesting.junit.XADataSourceConnector");
    }

    public static TestSetup connectionDSDecorator(Test test) {
        return new ConnectorSetup(test, "org.apache.derbyTesting.junit.DataSourceConnector");
    }

    public static Test forceJDBC3Embedded(Test test) {
        if (JDBC.vmSupportsJDBC4()) {
            test = new JDBCClientSetup((Test)test, JDBCClient.EMBEDDED_30);
        }
        return test;
    }

    public static Test forceJDBC3NetClient(Test test) {
        if (JDBC.vmSupportsJDBC4() && test instanceof ServerSetup) {
            ((ServerSetup)test).setJDBCClient(JDBCClient.DERBYNETCLIENT_30);
        }
        return test;
    }

    public static Test changeSSLDecorator(Test test, String ssl) {
        return new ChangeSSLSetup(test, ssl);
    }

    private TestConfiguration() {
        this.defaultDbName = DEFAULT_DBNAME;
        this.usedDbNames.add(DEFAULT_DBNAME);
        this.logicalDbMapping.put(DEFAULT_DBNAME, DEFAULT_DBNAME);
        this.userName = "APP";
        this.userPassword = "APP";
        this.hostName = null;
        this.port = -1;
        this.isVerbose = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(TestConfiguration.getSystemProperties().getProperty(KEY_TRACE));
        this.jdbcClient = JDBCClient.getDefaultEmbedded();
        this.ssl = null;
        this.jmxPort = 9999;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    TestConfiguration(TestConfiguration copy) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = copy.url;
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, JDBCClient client, String hostName, int port) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = client;
        this.hostName = hostName;
        this.ssl = copy.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, String user, String password, String passwordToken) {
        this.defaultDbName = copy.defaultDbName;
        this.usedDbNames.addAll(copy.usedDbNames);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        this.userName = user;
        this.userPassword = password;
        this.passwordToken = passwordToken == null ? copy.passwordToken : passwordToken;
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = copy.url;
        this.initConnector(copy.connector);
    }

    TestConfiguration(TestConfiguration copy, String ssl) {
        this(copy);
        this.ssl = ssl;
    }

    TestConfiguration(TestConfiguration copy, String logicalDbName, String dbName, boolean defaultDb) {
        this.usedDbNames.addAll(copy.usedDbNames);
        this.usedDbNames.add(dbName);
        this.logicalDbMapping.putAll(copy.logicalDbMapping);
        Assert.assertTrue((this.logicalDbMapping.put(logicalDbName, dbName) == null ? 1 : 0) != 0);
        this.defaultDbName = defaultDb ? dbName : copy.defaultDbName;
        this.userName = copy.userName;
        this.userPassword = copy.userPassword;
        this.isVerbose = copy.isVerbose;
        this.doTrace = copy.doTrace;
        this.port = copy.port;
        this.jmxPort = copy.jmxPort;
        this.jdbcClient = copy.jdbcClient;
        this.hostName = copy.hostName;
        this.ssl = copy.ssl;
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(copy.connector);
    }

    private TestConfiguration(Properties props) throws NumberFormatException {
        this.defaultDbName = props.getProperty(KEY_DBNAME, DEFAULT_DBNAME);
        this.usedDbNames.add(this.defaultDbName);
        this.logicalDbMapping.put(this.defaultDbName, this.defaultDbName);
        this.userName = props.getProperty(KEY_USER_NAME, "APP");
        this.userPassword = props.getProperty(KEY_USER_PASSWORD, "APP");
        this.hostName = props.getProperty(KEY_HOSTNAME, DEFAULT_HOSTNAME);
        this.isVerbose = Boolean.valueOf(props.getProperty(KEY_VERBOSE));
        this.doTrace = Boolean.valueOf(props.getProperty(KEY_TRACE));
        String portStr = props.getProperty(KEY_PORT);
        if (portStr != null) {
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Port number must be an integer. Value: " + portStr);
            }
        } else {
            this.port = 1527;
        }
        String jmxPortStr = props.getProperty(KEY_JMX_PORT);
        if (jmxPortStr != null) {
            try {
                this.jmxPort = Integer.parseInt(jmxPortStr);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("JMX Port number must be an integer. Value: " + jmxPortStr);
            }
        } else {
            this.jmxPort = 9999;
        }
        this.ssl = props.getProperty(KEY_SSL);
        String framework = props.getProperty(KEY_FRAMEWORK, DEFAULT_FRAMEWORK);
        this.jdbcClient = "DerbyNetClient".equals(framework) ? JDBCClient.DERBYNETCLIENT : ("DerbyNet".equals(framework) ? JDBCClient.DB2CLIENT : JDBCClient.getDefaultEmbedded());
        this.url = this.createJDBCUrlWithDatabaseName(this.defaultDbName);
        this.initConnector(null);
    }

    private static final Properties getSystemProperties() {
        Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        return sysProps;
    }

    private String createJDBCUrlWithDatabaseName(String name) {
        if (JDBC.vmSupportsJDBC2()) {
            String url = this.jdbcClient.isEmbedded() ? this.jdbcClient.getUrlBase() : this.jdbcClient.getUrlBase() + this.hostName + ":" + this.port + "/";
            return url.concat(name);
        }
        return null;
    }

    private void initConnector(Connector oldConnector) {
        if (oldConnector != null) {
            try {
                this.connector = (Connector)Class.forName(oldConnector.getClass().getName()).newInstance();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else if (JDBC.vmSupportsJDBC2()) {
            try {
                this.connector = (Connector)Class.forName("org.apache.derbyTesting.junit.DriverManagerConnector").newInstance();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            this.connector = new DataSourceConnector();
        }
        this.connector.setConfiguration(this);
    }

    public JDBCClient getJDBCClient() {
        return this.jdbcClient;
    }

    public String getJDBCUrl() {
        return this.url;
    }

    public String getJDBCUrl(String databaseName) {
        return this.createJDBCUrlWithDatabaseName(databaseName);
    }

    public String getDefaultDatabaseName() {
        return this.defaultDbName;
    }

    String getPhysicalDatabaseName(String logicalName) {
        return (String)this.logicalDbMapping.get(logicalName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getAlternativePort() {
        int possiblePort = this.getPort();
        possiblePort = possiblePort <= 0 ? 1528 : this.getPort() + 1;
        return possiblePort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public String getSsl() {
        return this.ssl;
    }

    Connection openDefaultConnection() throws SQLException {
        return this.connector.openConnection();
    }

    Connection openDefaultConnection(String user, String password) throws SQLException {
        return this.connector.openConnection(user, password);
    }

    Connection openConnection(String logicalDatabaseName) throws SQLException {
        String databaseName = this.getPhysicalDatabaseName(logicalDatabaseName);
        if (this.usedDbNames.contains(databaseName)) {
            return this.connector.openConnection(databaseName);
        }
        throw new SQLException("Database name \"" + logicalDatabaseName + "\" is not in a list of used databases." + "Use method TestConfiguration.additionalDatabaseDecorator first.");
    }

    public void shutdownDatabase() {
        try {
            this.connector.shutDatabase();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "08006", e);
        }
    }

    public void shutdownEngine() {
        try {
            this.connector.shutEngine();
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", e);
        }
    }

    public void stopNetworkServer() {
        try {
            NetworkServerControlWrapper networkServer = new NetworkServerControlWrapper();
            networkServer.shutdown();
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error shutting down server");
            se.initCause(e);
        }
    }

    public void startNetworkServer() throws SQLException {
        Exception failException = null;
        try {
            NetworkServerControlWrapper networkServer = new NetworkServerControlWrapper();
            this.serverOutput = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File logs = new File("logs");
                    logs.mkdir();
                    File console = new File(logs, "serverConsoleOutput.log");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(console.getPath(), true);
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    return fos;
                }
            });
            networkServer.start(new PrintWriter(this.serverOutput));
            boolean started = false;
            int retries = 10;
            while (!started && retries > 0) {
                try {
                    Thread.sleep(1000L);
                    networkServer.ping();
                    started = true;
                }
                catch (Exception e) {
                    --retries;
                    failException = e;
                }
            }
            if (!started) {
                throw failException;
            }
        }
        catch (Exception e) {
            SQLException se = new SQLException("Error starting network  server");
            se.initCause(failException);
            throw se;
        }
    }

    public void setVerbosity(boolean isChatty) {
        this.isVerbose = isChatty;
    }

    public void setTrace(boolean isChatty) {
        this.doTrace = isChatty;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean doTrace() {
        return this.doTrace;
    }

    public static boolean loadingFromJars() {
        return SecurityManagerSetup.isJars;
    }

    public static boolean runningInDerbyHarness() {
        return runningInDerbyHarness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getFailureFolder(TestCase test) {
        StringBuffer sb = new StringBuffer();
        sb.append("fail");
        sb.append(File.separatorChar);
        sb.append(this.getJDBCClient().getName());
        sb.append(File.separatorChar);
        String className = test.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1, className.length());
        }
        sb.append(className);
        sb.append(File.separatorChar);
        sb.append(test.getName());
        String base = sb.toString().intern();
        final File folder = new File(base);
        String string = base;
        synchronized (string) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (folder.exists()) {
                        // empty if block
                    }
                    return new Boolean(folder.mkdirs());
                }
            });
        }
        return folder;
    }

    boolean defaultSecurityManagerSetup() {
        if (this.jdbcClient.isDB2Client()) {
            SecurityManagerSetup.noSecurityManager();
            return false;
        }
        if ("<NONE>".equals(BaseTestCase.getSystemProperty("java.security.policy"))) {
            return false;
        }
        SecurityManagerSetup.installSecurityManager();
        return true;
    }

    static final String getPassword(String user, String token) {
        return user.concat(token);
    }

    final String getPassword(String user) {
        return TestConfiguration.getPassword(user, this.passwordToken);
    }

    static {
        DERBY_HARNESS_CONFIG = new TestConfiguration(TestConfiguration.getSystemProperties());
        JUNIT_CONFIG = new TestConfiguration();
        boolean assumeHarness = false;
        if (!DERBY_HARNESS_CONFIG.getJDBCClient().isEmbedded()) {
            assumeHarness = true;
        }
        if (!DERBY_HARNESS_CONFIG.getDefaultDatabaseName().equals(DEFAULT_DBNAME)) {
            assumeHarness = true;
        }
        if (!DERBY_HARNESS_CONFIG.getUserName().equals("APP")) {
            assumeHarness = true;
        }
        if (BaseTestCase.getSystemProperty("derby.system.home") != null) {
            assumeHarness = true;
        }
        DEFAULT_CONFIG = assumeHarness ? DERBY_HARNESS_CONFIG : JUNIT_CONFIG;
        runningInDerbyHarness = assumeHarness;
        if (!assumeHarness) {
            final File dsh = new File("system");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseTestCase.setSystemProperty("derby.system.home", dsh.getAbsolutePath());
                    return null;
                }
            });
        }
        CURRENT_CONFIG = new ThreadLocal(){

            protected Object initialValue() {
                return DEFAULT_CONFIG;
            }
        };
    }
}

