/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public final class SpawnedProcess {
    private final String name;
    private final Process javaProcess;
    private final ByteArrayOutputStream err;
    private final ByteArrayOutputStream out;
    int stdOutReadOffset;

    public SpawnedProcess(Process javaProcess, String name) {
        this.javaProcess = javaProcess;
        this.name = name;
        this.err = this.streamSaver(javaProcess.getErrorStream(), name.concat(":System.err"));
        this.out = this.streamSaver(javaProcess.getInputStream(), name.concat(":System.out"));
    }

    public Process getProcess() {
        return this.javaProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerOutput() throws Exception {
        Thread.sleep(500L);
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.out.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextServerOutput() throws Exception {
        byte[] fullData;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            fullData = this.out.toByteArray();
        }
        String output = new String(fullData, this.stdOutReadOffset, fullData.length - this.stdOutReadOffset);
        this.stdOutReadOffset = fullData.length;
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFailMessage(String reason) throws InterruptedException {
        Thread.sleep(500L);
        StringBuffer sb = new StringBuffer();
        sb.append(reason);
        sb.append(":Spawned ");
        sb.append(this.name);
        sb.append(" exitCode=");
        try {
            sb.append(this.javaProcess.exitValue());
        }
        catch (IllegalThreadStateException e) {
            sb.append("running");
        }
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            if (this.err.size() != 0) {
                sb.append("\nSTDERR:\n");
                sb.append(this.err.toString());
            }
            if (this.out.size() != 0) {
                sb.append("\nSTDOUT:\n");
                sb.append(this.out.toString());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int complete(boolean destroy) throws InterruptedException, IOException {
        if (destroy) {
            this.javaProcess.destroy();
        }
        int exitCode = this.javaProcess.waitFor();
        Thread.sleep(500L);
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            if (this.err.size() != 0) {
                System.err.println("START-SPAWNED:" + this.name + " ERROR OUTPUT:");
                this.err.writeTo(System.err);
                System.err.println("END-SPAWNED  :" + this.name + " ERROR OUTPUT:");
            }
            if ((destroy || exitCode != 0) && this.out.size() != 0) {
                System.out.println("START-SPAWNED:" + this.name + " STANDARD OUTPUT: exit code=" + exitCode);
                this.out.writeTo(System.out);
                System.out.println("END-SPAWNED  :" + this.name + " STANDARD OUTPUT:");
            }
        }
        return exitCode;
    }

    private ByteArrayOutputStream streamSaver(final InputStream in, String name) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream(){

            public void reset() {
                super.reset();
                new Throwable("WWW").printStackTrace(System.out);
            }
        };
        Thread streamReader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = in.read(buffer)) != -1) {
                        SpawnedProcess spawnedProcess = SpawnedProcess.this;
                        synchronized (spawnedProcess) {
                            out.write(buffer, 0, read);
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(new PrintStream(out, true));
                }
            }
        }, name);
        streamReader.setDaemon(true);
        streamReader.setPriority(1);
        streamReader.start();
        return out;
    }
}

