/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CleanDatabaseTestSetup
extends BaseJDBCTestSetup {
    private JDBCClient jdbcClient = null;
    private String hostName = null;
    private int portNo = -1;
    private static final String[] CLEAR_DB_PROPERTIES = new String[]{"derby.database.classpath"};
    private static final String[] COMPRESS_DB_OBJECTS = new String[]{"SYS.SYSDEPENDS"};

    public CleanDatabaseTestSetup(Test test) {
        super(test);
    }

    public CleanDatabaseTestSetup(Test test, boolean useNetworkClient, String hostName, int portNo) {
        super(test);
        if (useNetworkClient) {
            this.jdbcClient = JDBCClient.DERBYNETCLIENT;
        }
        this.hostName = hostName;
        this.portNo = portNo;
    }

    protected void setUp() throws Exception {
        if (this.jdbcClient != null) {
            TestConfiguration current = TestConfiguration.getCurrent();
            TestConfiguration modified = new TestConfiguration(current, this.jdbcClient, this.hostName, this.portNo);
            TestConfiguration.setCurrent(modified);
        }
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(conn, true);
        Statement s = conn.createStatement();
        this.decorateSQL(s);
        s.close();
        conn.commit();
        conn.close();
    }

    protected void decorateSQL(Statement s) throws SQLException {
    }

    protected void tearDown() throws Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(conn, false);
        super.tearDown();
    }

    public static void cleanDatabase(Connection conn, boolean compress) throws SQLException {
        CleanDatabaseTestSetup.clearProperties(conn);
        CleanDatabaseTestSetup.removeObjects(conn);
        if (compress) {
            CleanDatabaseTestSetup.compressObjects(conn);
        }
        CleanDatabaseTestSetup.removeRoles(conn);
    }

    private static void clearProperties(Connection conn) throws SQLException {
        CallableStatement ps = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        for (int i = 0; i < CLEAR_DB_PROPERTIES.length; ++i) {
            ps.setString(1, CLEAR_DB_PROPERTIES[i]);
            ps.executeUpdate();
        }
        ps.close();
        conn.commit();
    }

    private static void removeObjects(Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        SQLException sqle = null;
        for (int count = 0; count < 5; ++count) {
            ArrayList<String> schemas = new ArrayList<String>();
            ResultSet rs = dmd.getSchemas();
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                if (schema.startsWith("SYS") || schema.equals("SQLJ") || schema.equals("NULLID")) continue;
                schemas.add(schema);
            }
            rs.close();
            sqle = null;
            Iterator i = schemas.iterator();
            while (i.hasNext()) {
                String schema = (String)i.next();
                try {
                    JDBC.dropSchema(dmd, schema);
                }
                catch (SQLException e) {
                    sqle = e;
                }
            }
            if (sqle != null) continue;
            return;
        }
        throw sqle;
    }

    private static void removeRoles(Connection conn) throws SQLException {
        Statement stm = conn.createStatement();
        Statement dropStm = conn.createStatement();
        ResultSet rs = stm.executeQuery("select roleid from sys.sysroles where cast(isdef as char(1)) = 'Y'");
        while (rs.next()) {
            dropStm.executeUpdate("DROP ROLE " + JDBC.escape(rs.getString(1)));
        }
        stm.close();
        dropStm.close();
        conn.commit();
    }

    private static void compressObjects(Connection conn) throws SQLException {
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        for (int i = 0; i < COMPRESS_DB_OBJECTS.length; ++i) {
            int delim = COMPRESS_DB_OBJECTS[i].indexOf(".");
            cs.setString(1, COMPRESS_DB_OBJECTS[i].substring(0, delim));
            cs.setString(2, COMPRESS_DB_OBJECTS[i].substring(delim + 1));
            cs.execute();
        }
        cs.close();
        conn.commit();
    }
}

