/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_3_p6
extends ReplicationRun_Local_3 {
    String getDerbyServerPID = null;

    public ReplicationRun_Local_3_p6(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_3_p6 Suite");
        suite.addTestSuite(ReplicationRun_Local_3_p6.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_3_p6_autocommit_OK() throws Exception {
        this.derby_3896(true);
    }

    private void derby_3896(boolean autocommit) throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        String URL2 = this.masterURL(replicatedDb) + ";create=true" + this.useEncryption(true);
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            this.util.DEBUG("bootMasterDatabase getConnection(" + URL2 + ")");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            Connection conn = DriverManager.getConnection(URL2);
            conn.close();
        } else {
            ReplicationRun_Local_3_p6.assertTrue((String)"NOT IMPLEMENTED for non-local host!", (boolean)false);
        }
        Connection mConn = this._getConnection(masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort);
        if (!autocommit) {
            mConn.setAutoCommit(false);
        }
        PreparedStatement ps = mConn.prepareStatement("create table t(i integer)");
        ps.execute();
        ps = mConn.prepareStatement("insert into t values 0,1,2,3");
        int _noTuplesInserted = 4;
        ps.execute();
        this._verifyTable(mConn, _noTuplesInserted);
        this.util.DEBUG("************************** DERBY-???? Preliminary needs to freeze db before copying to slave and setting replication mode.");
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            URL2 = this.masterURL(replicatedDb);
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            this.util.DEBUG("bootMasterDatabase getConnection(" + URL2 + ")");
            Connection conn = DriverManager.getConnection(URL2);
            Statement s = conn.createStatement();
            s.execute("call syscs_util.syscs_freeze_database()");
            conn.close();
        } else {
            ReplicationRun_Local_3_p6.assertTrue((String)"NOT IMPLEMENTED for non-local host!", (boolean)false);
        }
        this.util.DEBUG("bootMasterDatabase done.");
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        mConn.commit();
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        Connection sConn = this._getConnection(slaveDatabasePath, slaveDbSubPath, replicatedDb, slaveServerHost, slaveServerPort);
        this._verifyTable(sConn, _noTuplesInserted);
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private Connection _getConnection(String databasePath, String dbSubPath, String dbName, String serverHost, int serverPort) throws SQLException {
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(databasePath + FS + dbSubPath + FS + dbName);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        return ds.getConnection();
    }

    private void _verifyTable(Connection conn, int noTuplesInserted) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        rs = s.executeQuery("select max(i) from t");
        rs.next();
        int max = rs.getInt(1);
        this.util.DEBUG("_verify: " + count + "/" + noTuplesInserted + " " + max + "/" + (noTuplesInserted - 1));
        ReplicationRun_Local_3_p6.assertEquals((String)("Expected " + noTuplesInserted + " tuples, got " + count + "."), (int)noTuplesInserted, (int)count);
        ReplicationRun_Local_3_p6.assertEquals((String)("Expected " + (noTuplesInserted - 1) + " max, got " + max + "."), (int)(noTuplesInserted - 1), (int)max);
    }
}

