/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun_Local_3;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_3_p5
extends ReplicationRun_Local_3 {
    public ReplicationRun_Local_3_p5(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_3_p5 Suite");
        suite.addTestSuite(ReplicationRun_Local_3_p5.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_3_p5_DERBY_3878() throws Exception {
        this.makeReadyForReplication();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this._killMasterServer();
        this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, false);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        if (masterServerHost.equalsIgnoreCase("localhost") || localEnv) {
            String URL2 = this.masterURL(replicatedDb);
            Class.forName("org.apache.derby.jdbc.ClientDriver");
            this.util.DEBUG("bootMasterDatabase getConnection(" + URL2 + ")");
            Connection conn = DriverManager.getConnection(URL2);
            Statement s = conn.createStatement();
            s.execute("call syscs_util.syscs_freeze_database()");
            conn.close();
        } else {
            this.runTest(freezeDB, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        }
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.assertSqlStateSlaveConn("XRE08");
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _killMasterServer() throws ClassNotFoundException, SQLException {
        String URL2 = this.masterURL(replicatedDb);
        Class.forName("org.apache.derby.jdbc.ClientDriver");
        Connection conn = DriverManager.getConnection(URL2);
        Statement s = conn.createStatement();
        conn.setAutoCommit(false);
        s.execute("create procedure kill(in p integer) parameter style java no sql language java external name'java.lang.System.exit'");
        try {
            s.execute("call kill(0)");
        }
        catch (SQLException se) {
            int errCode = se.getErrorCode();
            String msg = se.getMessage();
            String sState = se.getSQLState();
            String expectedState = "08006";
            msg = errCode + " " + sState + " " + msg + ". Expected: " + expectedState;
            if (errCode == 40000 && sState.equalsIgnoreCase(expectedState)) {
                this.util.DEBUG("As expected. " + msg);
            }
            ReplicationRun_Local_3_p5.assertTrue((String)("kill() failed. " + msg), (boolean)false);
        }
    }
}

