/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobMemTest
extends BaseJDBCTestCase {
    private static final int LONG_BLOB_LENGTH = 18000000;
    private static final String LONG_BLOB_LENGTH_STRING = "18000000";
    private static final byte[] SHORT_BLOB_BYTES = new byte[]{1, 2, 3};

    public BlobMemTest(String name) {
        super(name);
    }

    public void tearDown() throws SQLException {
        this.rollback();
    }

    private void testBlobLength(boolean lengthless, int extraLen) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int size;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE BLOBTAB (K INT CONSTRAINT PK PRIMARY KEY, B BLOB(18000000))");
        PreparedStatement ps = this.prepareStatement("INSERT INTO BLOBTAB VALUES(?,?)");
        ps.setInt(1, 1);
        int blobLen = 18000000 + extraLen;
        LoopingAlphabetStream stream = new LoopingAlphabetStream(blobLen);
        if (lengthless) {
            Method m = null;
            try {
                Class<?> c = ps.getClass();
                m = c.getMethod("setBinaryStream", Integer.TYPE, InputStream.class);
            }
            catch (NoSuchMethodException e) {
                BlobMemTest.println("Skipping lengthless insert because method is not available");
                return;
            }
            m.invoke((Object)ps, new Integer(2), stream);
        } else {
            ps.setBinaryStream(2, (InputStream)stream, blobLen);
        }
        if (extraLen != 0) {
            try {
                ps.executeUpdate();
                BlobMemTest.fail((String)"Expected truncation error for blob too large");
            }
            catch (SQLException sqlE) {
                BlobMemTest.assertSQLState("Wrong SQL State for truncation", "22001", sqlE);
            }
            return;
        }
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setBytes(2, new byte[0]);
        ps.executeUpdate();
        ps.setInt(1, 3);
        ps.setBytes(2, null);
        ps.executeUpdate();
        ps.setInt(1, 4);
        ps.setBytes(2, SHORT_BLOB_BYTES);
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT K, LENGTH(B), B FROM BLOBTAB-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        rs.next();
        BlobMemTest.assertEquals((String)LONG_BLOB_LENGTH_STRING, (String)rs.getString(2));
        InputStream rsstream = rs.getBinaryStream(3);
        int len = 0;
        byte[] buf = new byte[32672];
        while ((size = rsstream.read(buf)) != -1) {
            int expectedValue = ((len += size) - 1) % 26 + 97;
            if (size == 0) continue;
            BlobMemTest.assertEquals((int)expectedValue, (int)buf[size - 1]);
        }
        BlobMemTest.assertEquals((int)18000000, (int)len);
        rs.next();
        BlobMemTest.assertEquals((String)"0", (String)rs.getString(2));
        byte[] bytes = rs.getBytes(3);
        BlobMemTest.assertEquals((int)0, (int)bytes.length);
        rs.next();
        BlobMemTest.assertEquals(null, (String)rs.getString(2));
        bytes = rs.getBytes(3);
        BlobMemTest.assertEquals(null, (Object)bytes);
        rs.next();
        BlobMemTest.assertEquals((String)"3", (String)rs.getString(2));
        bytes = rs.getBytes(3);
        BlobMemTest.assertTrue((boolean)Arrays.equals(SHORT_BLOB_BYTES, bytes));
        rs.close();
        rs = s.executeQuery("SELECT K, LENGTH(B)  FROM BLOBTAB ORDER BY K");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", LONG_BLOB_LENGTH_STRING}, {"2", "0"}, {"3", null}, {"4", "3"}});
    }

    public void testBlobLength() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 0);
    }

    public void testBlobLengthWithLengthlessInsert() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(true, 0);
    }

    public void testBlobLengthTooLongDerby961() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 10000);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(BlobMemTest.class);
        Properties p = new Properties();
        p.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup(suite, p);
    }
}

