/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RenameTableTest
extends BaseJDBCTestCase {
    public RenameTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(RenameTableTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenameNonExistingTable() throws SQLException {
        Statement s = this.createStatement();
        RenameTableTest.assertStatementError("42Y55", s, "rename table notexists to notexists1");
    }

    public void testExistedNameForRenameTable() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key)");
        s.executeUpdate("create table t2(c21 int not null primary key)");
        RenameTableTest.assertStatementError("X0Y32", s, "rename table t1 to t2");
        s.executeUpdate("drop table t1");
        s.executeUpdate("drop table t2");
    }

    public void testRenameSystemTable() throws SQLException {
        Statement s = this.createStatement();
        RenameTableTest.assertStatementError("42X62", s, "rename table sys.systables to fake");
    }

    public void testRenameTableWithViews() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(c11 int not null primary key)");
        s.executeUpdate("insert into t1 values 11");
        s.executeUpdate("create view v1 as select * from t1");
        RenameTableTest.assertStatementError("42Y62", s, "rename table v1 to fake");
        RenameTableTest.assertStatementError("X0Y23", s, "rename table t1 to fake");
        s.executeUpdate("drop view v1");
        s.executeUpdate("drop table t1");
    }

    public void testRenameOnDependencies() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t4(c41 int not null primary key)");
        s.executeUpdate("create table t5 (c51 int, constraint fk foreign key(c51) references t4)");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table t4 to fake");
        s.executeUpdate("alter table t5 drop constraint fk");
        s.executeUpdate("rename table t4 to realTab");
        s.executeUpdate("drop table t5");
        s.executeUpdate("drop table realTab");
    }

    public void testRenameWithIndex() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null)");
        s.executeUpdate("create index i1_t3 on t3(c31)");
        RenameTableTest.assertUpdateCount(s, 0, "rename table t3 to t3r");
        s.executeUpdate("drop table t3r");
    }

    public void testRenameWithPreparedStatement() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t3(c31 int not null primary key)");
        s.executeUpdate("insert into t3 values 31");
        s.executeUpdate("insert into t3 values 32");
        s.executeUpdate("insert into t3 values 33");
        PreparedStatement pstmt = this.prepareStatement("select * from t3 where c31 > ?");
        pstmt.setInt(1, 30);
        ResultSet rs = pstmt.executeQuery();
        rs.next();
        rs.close();
        RenameTableTest.assertUpdateCount(s, 0, "rename table t3 to t3r");
        pstmt.setInt(1, 30);
        try {
            ResultSet rs1 = pstmt.executeQuery();
            RenameTableTest.fail((String)"Table/View t3 Doesn't exists:");
        }
        catch (SQLException e) {
            RenameTableTest.assertSQLState("42X05", e);
        }
        s.executeUpdate("drop table t3r");
    }

    public void testRenameTableWithTriggersOnIt() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t6 (c61 int default 1)");
        s.executeUpdate("create table t7(c71 int)");
        s.executeUpdate("create trigger t7insert after insert on t7 referencing new as NEWROW for each row insert into t6 values(NEWROW.c71)");
        s.executeUpdate("insert into t7 values(1)");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table t7 to t7r");
        RenameTableTest.assertStatementError("42X05", s, "select * from t7r");
        ResultSet rs = s.executeQuery("select * from t7");
        rs.next();
        rs.close();
        s.executeUpdate("rename table t6 to t6r");
        RenameTableTest.assertStatementError("42X05", s, "insert into t7 values(3)");
        rs = s.executeQuery("select * from t6r");
        RenameTableTest.assertStatementError("42X05", s, "select * from t7r");
        s.executeUpdate("drop table t6r");
        s.executeUpdate("drop table t7");
    }

    public void testRenameWithCheckConstraintsOnIt() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table tcheck (i int check(i>5))");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table tcheck to tcheck1");
        s.executeUpdate("drop table tcheck");
        s.executeUpdate("create table tcheck (i int, j int, constraint tcon check (i+j>2))");
        RenameTableTest.assertStatementError("X0Y25", s, "rename table tcheck to tcheck1");
        s.executeUpdate("alter table tcheck drop constraint tcon");
        s.executeUpdate("rename table tcheck to tcheck1");
        s.executeUpdate("drop table tcheck1");
    }
}

