/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class PrimaryKeyTest
extends BaseJDBCTestCase {
    public PrimaryKeyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PrimaryKeyTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDuplicatePrimaryKey() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertStatementError("42X90", s, "create table neg (c1 int not null primary key, c2 int, c3 int not null constraint asdf primary key)");
        PrimaryKeyTest.assertStatementError("42X90", s, "create table neg (c1 int not null primary key, c2 int not null, primary key(c1, c2))");
    }

    public void testInvalidConstaintDefs() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertStatementError("42X91", s, "create table neg (c1 int not null constraint asdf primary key, c2 int, c3 int constraint asdf unique)");
        PrimaryKeyTest.assertStatementError("42X92", s, "create table neg (c1 int not null, c2 int not null, primary key(c1, c2, c1))");
        PrimaryKeyTest.assertStatementError("42X93", s, "create table neg (c1 int not null, c2 int not null, primary key(c1, c2, cx))");
    }

    public void testInvalidConstraintSchemaNames() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertStatementError("42X85", s, "create table neg (c1 int not null, c2 int not null, constraint bar.pkneg primary key(c1, c2))");
        PrimaryKeyTest.assertStatementError("42X85", s, "create table neg (c1 int not null, c2 int not null, constraint sys.pkneg primary key(c1, c2))");
        PrimaryKeyTest.assertStatementError("42X85", s, "create table neg (c1 int not null constraint bar.pkneg primary key, c2 int)");
        PrimaryKeyTest.assertStatementError("42X85", s, "create table neg (c1 int not null constraint sys.pkneg primary key, c2 int)");
    }

    public void testDuplicateConstraintNames() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table neg1(c1 int not null constraint asdf primary key)");
        PrimaryKeyTest.assertStatementError("X0Y32", s, "create table neg2(c1 int not null constraint asdf primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table neg1");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table neg2(c1 int not null constraint asdf primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table neg2");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table neg1(c1 int not null constraint app.asdf primary key)");
        PrimaryKeyTest.assertStatementError("X0Y32", s, "create table neg2(c1 int not null constraint app.asdf primary key)");
        PrimaryKeyTest.assertStatementError("X0Y32", s, "create table neg1(c1 int not null constraint asdf primary key)");
        PrimaryKeyTest.assertStatementError("X0Y32", s, "create table neg2(c1 int not null constraint app.asdf primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table neg1");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table neg2(c1 int not null constraint app.asdf primary key)");
    }

    public void testExplicitNullabilityOfConstraints() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertStatementError("42X01", s, "create table neg2(c1 int null constraint asdf primary key)");
        PrimaryKeyTest.assertStatementError("42X01", s, "create table neg2(c1 int null, c2 int, constraint asdf primary key(c1, c2))");
        PrimaryKeyTest.assertStatementError("42X01", s, "create table neg1(c1 int null unique)");
        PrimaryKeyTest.assertStatementError("42X01", s, "create table neg1(c1 int null, c2 int, constraint asdf unique(c1))");
    }

    public void testKeyConstraintsImpliesNotNull() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table pos1 (c1 int primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 1, "insert into pos1(c1) values(1)");
        PrimaryKeyTest.assertStatementError("23505", s, "insert into pos1(c1) values(1)");
        PrimaryKeyTest.assertStatementError("23502", s, "insert into pos1(c1) values(null)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table pos1");
    }

    public void testConstraintwithNotNull() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table pos1 (c1 int not null unique, c2 int not null primary key)");
        PrimaryKeyTest.assertStatementError("23502", s, "insert into pos1 (c1) values (null)");
        PrimaryKeyTest.assertStatementError("23502", s, "insert into pos1 (c2) values (null)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table pos1");
        ResultSet rs1 = s.executeQuery("select count(*) from sys.sysconstraints");
        JDBC.assertSingleValueResultSet(rs1, "0");
        rs1 = s.executeQuery("select count(*) from sys.syskeys");
        JDBC.assertSingleValueResultSet(rs1, "0");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table pos1 (c1 int not null unique, c2 int not null primary key)");
        PrimaryKeyTest.assertStatementError("23502", s, "insert into pos1 (c1) values (null)");
        PrimaryKeyTest.assertStatementError("23502", s, "insert into pos1 (c2) values (null)");
        PrimaryKeyTest.assertStatementError("23505", s, "insert into pos1 values (1, 1), (1, 2)");
        PrimaryKeyTest.assertStatementError("23505", s, "insert into pos1 values (1, 1), (2, 1)");
        rs1 = s.executeQuery("select count(*) from sys.sysconstraints");
        JDBC.assertSingleValueResultSet(rs1, "2");
        rs1 = s.executeQuery("select count(*) from sys.syskeys");
        JDBC.assertSingleValueResultSet(rs1, "2");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table pos1");
    }

    public void testDeleteFromPrimaryKey() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table pos1 (c1 int not null, c2 int not null, primary key(c2, c1))");
        PrimaryKeyTest.assertUpdateCount(s, 1, "insert into pos1 values (1, 2)");
        ResultSet rs = s.executeQuery("select count(*) from pos1");
        JDBC.assertSingleValueResultSet(rs, "1");
        s.executeUpdate("delete from pos1");
        rs = s.executeQuery("select count(*) from pos1");
        JDBC.assertSingleValueResultSet(rs, "0");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table pos1");
    }

    public void testCatalog() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table pos1(c1 int primary key)");
        ResultSet rs = s.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where CAST(tabletype AS CHAR(1)) = 'S'  and CAST(tablename AS VARCHAR(128)) != 'SYSDUMMY1'");
        String[][] expectedCheckTables = new String[][]{{"SYSCONGLOMERATES", "1"}, {"SYSTABLES", "1"}, {"SYSCOLUMNS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSKEYS", "1"}, {"SYSDEPENDS", "1"}, {"SYSALIASES", "1"}, {"SYSVIEWS", "1"}, {"SYSCHECKS", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSFILES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSROLES", "1"}};
        JDBC.assertFullResultSet(rs, expectedCheckTables);
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table pos1");
        rs = s.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where CAST(tabletype AS CHAR(1)) = 'S'  and CAST(tablename AS VARCHAR(128)) != 'SYSDUMMY1'");
        JDBC.assertFullResultSet(rs, expectedCheckTables);
    }

    public void testBug5420() throws SQLException {
        Statement s = this.createStatement();
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_1.t1 (c1 int not null primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_2.t2 (c2 int not null constraint c2pk primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_3.t3 (c3 int not null constraint B5420_3.c3pk primary key)");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_4.t4 (c4 int not null, primary key (c4))");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_5.t5 (c5 int not null, constraint c5pk primary key (c5))");
        PrimaryKeyTest.assertUpdateCount(s, 0, "create table B5420_6.t6 (c6 int not null, constraint B5420_6.c6pk primary key (c6))");
        ResultSet rs = s.executeQuery("\tSELECT CAST (S.SCHEMANAME AS VARCHAR(12)), CAST (C.CONSTRAINTNAME AS VARCHAR(36)), CAST (T.TABLENAME AS VARCHAR(12)) FROM SYS.SYSCONSTRAINTS C , SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE C.SCHEMAID = S.SCHEMAID AND C.TABLEID = T.TABLEID AND T.SCHEMAID = S.SCHEMAID AND CAST(S.SCHEMANAME AS VARCHAR(128)) LIKE 'B5420_%' ORDER BY 1,2,3");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        PrimaryKeyTest.assertEquals((int)3, (int)rsmd.getColumnCount());
        int rows = 0;
        do {
            ++rows;
        } while (rs.next());
        PrimaryKeyTest.assertEquals((int)6, (int)rows);
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_1.t1");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_2.t2");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_3.t3");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_4.t4");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_5.t5");
        PrimaryKeyTest.assertUpdateCount(s, 0, "drop table B5420_6.t6");
    }
}

