/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class HoldCursorTest
extends BaseJDBCTestCase {
    public HoldCursorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("HoldCursorTest");
        suite.addTest(HoldCursorTest.baseSuite("HoldCursorTest:embedded"));
        suite.addTest(HoldCursorTest.baseSuite("HoldCursorTest:client"));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(HoldCursorTest.class);
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest((Test)new HoldCursorTest("StatementsInProcedureTest"));
        }
        return new CleanDatabaseTestSetup((Test)suite);
    }

    protected void setUp() throws SQLException {
        int i;
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        int stringLength = 400;
        stmt.executeUpdate("CREATE TABLE T1 (c11 int, c12 int, junk varchar(400))");
        PreparedStatement insertStmt = this.prepareStatement("INSERT INTO T1 VALUES(?,1,?)");
        int rows = 100;
        StringBuffer buff = new StringBuffer(400);
        for (i = 0; i < 400; ++i) {
            buff.append(" ");
        }
        for (i = 1; i <= 100; ++i) {
            insertStmt.setInt(1, i);
            insertStmt.setString(2, buff.toString());
            insertStmt.executeUpdate();
        }
        insertStmt.close();
        stmt.executeUpdate("CREATE TABLE T2 (c21 int, c22 int)");
        stmt.executeUpdate("INSERT INTO T2 VALUES(1,1)");
        stmt.executeUpdate("INSERT INTO T2 VALUES(1,2)");
        stmt.executeUpdate("INSERT INTO T2 VALUES(1,3)");
        stmt.execute("create table testtable1 (id integer, vc varchar(100))");
        stmt.execute("insert into testtable1 values (11, 'testtable1-one'), (12, 'testtable1-two')");
        stmt.execute("create table testtable2 (id integer, vc varchar(100))");
        stmt.execute("insert into testtable2 values (21, 'testtable2-one'), (22, 'testtable2-two')");
        stmt.execute("create procedure MYPROC() language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.HoldCursorTest.testProc' result sets 2");
        stmt.executeUpdate("Create table bug4385 (i int not null primary key, c int generated always as identity)");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("DROP PROCEDURE MYPROC");
        stmt.executeUpdate("DROP TABLE T1");
        stmt.executeUpdate("DROP TABLE T2");
        stmt.executeUpdate("DROP TABLE testtable1");
        stmt.executeUpdate("DROP TABLE testtable2");
        stmt.executeUpdate("DROP TABLE BUG4385");
        stmt.close();
        stmt.close();
        this.commit();
        super.tearDown();
    }

    public void testHoldCursorOnMultiTableQuery() throws Exception {
        Statement s = this.createStatement(1003, 1007, 1);
        ResultSet rs = s.executeQuery("select t1.c11, t2.c22 from t1, t2 where t1.c11=t2.c21");
        rs.next();
        HoldCursorTest.assertEquals((String)"1", (String)rs.getString(2));
        this.commit();
        rs.next();
        HoldCursorTest.assertEquals((String)"2", (String)rs.getString(2));
        rs.close();
    }

    public void testIsolationLevelChange() throws Exception {
        this.setTransactionIsolation(2);
        Statement s = this.createStatement(1003, 1007, 1);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        this.assertIsolationError("X0X03", 8);
        rs.close();
        this.setTransactionIsolation(8);
        this.setHoldability(1);
        this.setTransactionIsolation(1);
        this.createStatement().executeUpdate("SET ISOLATION RS");
        PreparedStatement ps = this.prepareStatement("insert into bug4385(i) values(?)", 1);
        ps.setInt(1, 199);
        ps.executeUpdate();
        HoldCursorTest.assertGetIntEquals(1, 1, ps.getGeneratedKeys());
        rs.close();
        ps.setInt(1, 299);
        ps.executeUpdate();
        HoldCursorTest.assertGetIntEquals(1, 2, ps.getGeneratedKeys());
        rs.close();
        ps.close();
        this.rollback();
        this.setHoldability(2);
        this.setTransactionIsolation(2);
    }

    public void testDropTable() throws SQLException {
        this.setHoldability(1);
        String dropTable = "DROP TABLE T1";
        Statement stmt1 = this.createStatement();
        Statement stmt2 = this.createStatement();
        ResultSet rs = stmt1.executeQuery("SELECT * FROM T1");
        rs.next();
        HoldCursorTest.assertStatementError("X0X95", stmt2, "DROP TABLE T1");
        HoldCursorTest.assertStatementError("X0X95", stmt2, "DROP TABLE T1");
        this.commit();
        HoldCursorTest.assertStatementError("X0X95", stmt2, "DROP TABLE T1");
        rs.close();
        stmt2.executeUpdate("DROP TABLE T1");
        stmt1.close();
        stmt2.close();
        this.rollback();
    }

    public void testHoldabilityOverCommit() throws SQLException {
        this.testStatements(1);
        this.testStatements(2);
    }

    public void StatementsInProcedureTest() throws SQLException {
        this.StatementsInProcedure(1);
        this.StatementsInProcedure(2);
    }

    public void testStatements(int holdability) throws SQLException {
        this.setHoldability(holdability);
        Statement st1 = this.createStatement(1004, 1007, 1);
        ResultSet rs1 = st1.executeQuery("select * from testtable1");
        rs1.next();
        HoldCursorTest.assertEquals((int)11, (int)rs1.getInt(1));
        this.commit();
        rs1.next();
        HoldCursorTest.assertEquals((int)12, (int)rs1.getInt(1));
        st1.close();
        Statement st2 = this.createStatement(1004, 1007, 2);
        ResultSet rs2 = st2.executeQuery("select * from testtable2");
        rs2.next();
        HoldCursorTest.assertEquals((int)21, (int)rs2.getInt(1));
        this.commit();
        HoldCursorTest.assertNextError("XCL16", rs2);
        st2.close();
        rs1.close();
        rs2.close();
    }

    public void StatementsInProcedure(int holdability) throws SQLException {
        this.setHoldability(holdability);
        CallableStatement cs1 = this.prepareCall("call MYPROC()");
        cs1.execute();
        ResultSet rs2 = cs1.getResultSet();
        rs2.next();
        HoldCursorTest.assertEquals((int)11, (int)rs2.getInt(1));
        rs2.next();
        HoldCursorTest.assertEquals((int)12, (int)rs2.getInt(1));
        CallableStatement cs2 = this.prepareCall("call MYPROC()");
        cs2.execute();
        this.commit();
        ResultSet rs1 = cs2.getResultSet();
        rs1.next();
        HoldCursorTest.assertEquals((int)11, (int)rs1.getInt(1));
        if (rs1.next()) {
            HoldCursorTest.assertEquals((int)12, (int)rs1.getInt(1));
        } else {
            HoldCursorTest.assertNull((Object)rs1);
        }
        cs1.close();
        cs2.close();
        rs1.close();
        rs2.close();
    }

    public void testCloseCursor() throws SQLException {
        String[] tables = new String[]{"T1", "T2"};
        Statement stmt1 = this.createStatement();
        Statement stmt2 = this.createStatement();
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            ResultSet rs = stmt1.executeQuery("SELECT * FROM " + table);
            rs.next();
            rs.close();
            stmt2.executeUpdate("DROP TABLE " + table);
        }
        stmt1.close();
        stmt2.close();
        this.rollback();
    }

    public void assertIsolationError(String sqlState, int level) {
        try {
            this.getConnection().setTransactionIsolation(level);
            HoldCursorTest.fail((String)("expected compile error: " + sqlState));
        }
        catch (SQLException se) {
            HoldCursorTest.assertSQLState(sqlState, se);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.getConnection().setTransactionIsolation(level);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.getConnection().setHoldability(holdability);
    }

    public static void assertGetIntEquals(int position, int expected, ResultSet rs) {
        try {
            while (rs.next()) {
                if (expected == rs.getInt(position)) {
                    return;
                }
                HoldCursorTest.fail((String)("Wrong value returned: " + rs.getInt(position)));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    public static void testProc(ResultSet[] rs1, ResultSet[] rs2) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement st1 = conn.createStatement(1004, 1007, 1);
        rs1[0] = st1.executeQuery("select * from testtable1");
        Statement st2 = conn.createStatement(1004, 1007, 2);
        rs2[0] = st2.executeQuery("select * from testtable2");
    }
}

