/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.junitTests.compatibility;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.derbyTesting.functionTests.tests.junitTests.compatibility.CompatibilitySuite;

public class JDBCDriverTest
extends CompatibilitySuite {
    private static final String ALL_TYPES_TABLE = "allTypesTable";
    private static final String KEY_COLUMN = "keyCol";
    private static final byte[] SAMPLE_BYTES = new byte[]{1, 2, 3, 4, 5};
    private static final String SAMPLE_STRING = "hello";
    private static final boolean Y = true;
    private static final boolean _ = false;
    private static final TypeDescriptor[] ALL_TYPES = new TypeDescriptor[]{new TypeDescriptor(-5, "bigint", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2004, "blob", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(1, "char(5)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-2, "char(5) for bit data", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2005, "clob", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(91, "date", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(3, "decimal", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "double", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "double precision", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(7, "float(23)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(8, "float", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(4, "integer", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-1, "long varchar", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-4, "long varchar for bit data", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(2, "numeric", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(7, "real", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(5, "smallint", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(92, "time", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(93, "timestamp", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(12, "varchar(5)", IBM_2_4, DRB_10_0, VM_1_3), new TypeDescriptor(-3, "varchar(5) for bit data", IBM_2_4, DRB_10_0, VM_1_3)};
    private static final Object[] ROW_1 = new Object[]{new Long(1L), new MyBlob(SAMPLE_BYTES), "hello", SAMPLE_BYTES, new MyClob("hello"), new Date(1L), new BigDecimal(1.0), new Double(1.0), new Double(1.0), new Float(1.0f), new Double(1.0), new Integer(1), "hello", SAMPLE_BYTES, new BigDecimal(1.0), new Float(1.0f), new Short(1), new Time(1L), new Timestamp(1L), "hello", SAMPLE_BYTES};
    private static final T_CN[] COERCIONS = new T_CN[]{new T_CN(-5, new boolean[]{true, false, true, false, false, false, false, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(2004, new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-2, new boolean[]{false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2005, new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(91, new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(3, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(8, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(4, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(-1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-4, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(5, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(92, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}), new T_CN(93, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}), new T_CN(12, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-3, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true})};
    private static HashMap _types = new HashMap();
    private static HashMap _coercionIndex = new HashMap();

    public void testSanity() {
        JDBCDriverTest.assertEquals((String)"ALL_TYPES.length == ROW_1.length", (int)ALL_TYPES.length, (int)ROW_1.length);
        int coercionCount = COERCIONS.length;
        for (int i = 0; i < coercionCount; ++i) {
            JDBCDriverTest.assertEquals((String)("Coercion " + i), (int)coercionCount, (int)COERCIONS[i].getCoercions().length);
        }
    }

    public void testJDBCDriver() throws Exception {
        Connection conn = JDBCDriverTest.getConnection();
        this.dropSchema(conn);
        this.createSchema(conn);
        this.datatypesTest(conn);
        JDBCDriverTest.close(conn);
    }

    private void datatypesTest(Connection conn) throws Exception {
        TypeDescriptor[] types = ALL_TYPES;
        String tableName = ALL_TYPES_TABLE;
        Object[][] rows = new Object[][]{this.makeNullRow(types.length), ROW_1};
        this.checkDBMetadata(conn, tableName);
        this.stuffTable(conn, tableName, types, rows);
        this.readTable(conn, tableName, types, rows, null);
    }

    private void checkDBMetadata(Connection conn, String tableName) throws Exception {
        String normalizedSchema = "APP".toUpperCase();
        String normalizedTable = tableName.toUpperCase();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, normalizedSchema, normalizedTable, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + normalizedSchema + '.' + normalizedTable);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int actualJdbcType = rs.getInt("DATA_TYPE");
            TypeDescriptor typeDesc = this.getType(columnName);
            if (columnName.equals(KEY_COLUMN)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[ ");
            buffer.append(rs.getString("COLUMN_NAME"));
            buffer.append(",\t");
            buffer.append("type( " + rs.getInt("DATA_TYPE") + " ),\t");
            buffer.append(rs.getString("TYPE_NAME"));
            buffer.append(" ]");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)this.ddmdTypeKludge(typeDesc.getJdbcType()), (int)actualJdbcType);
        }
        JDBCDriverTest.close(rs);
    }

    private void checkProcMetadata(Connection conn, String procName, TypeDescriptor[] signature) throws Exception {
        String normalizedSchema = "APP".toUpperCase();
        String normalizedProc = procName.toUpperCase();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getProcedureColumns(null, normalizedSchema, normalizedProc, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + normalizedSchema + '.' + normalizedProc);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            int actualJdbcType = rs.getInt("DATA_TYPE");
            TypeDescriptor typeDesc = this.getType(signature, columnName);
            if (columnName.equals(KEY_COLUMN)) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[ ");
            buffer.append(rs.getString("COLUMN_NAME"));
            buffer.append(",\t");
            buffer.append("type( " + rs.getInt("DATA_TYPE") + " ),\t");
            buffer.append(rs.getString("TYPE_NAME"));
            buffer.append(" ]");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)this.ddmdTypeKludge(typeDesc.getJdbcType()), (int)actualJdbcType);
        }
        JDBCDriverTest.close(rs);
    }

    private void stuffTable(Connection conn, String tableName, TypeDescriptor[] types, Object[][] rows) throws Exception {
        PreparedStatement ps = this.makeInsert(conn, tableName, types);
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            this.setRow(ps, i + 1, types, rows[i]);
        }
        JDBCDriverTest.close(ps);
    }

    private PreparedStatement makeInsert(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer masterBuffer = new StringBuffer();
        StringBuffer columnBuffer = new StringBuffer();
        StringBuffer valuesBuffer = new StringBuffer();
        int columnNumber = 0;
        int valuesNumber = 0;
        int typeCount = types.length;
        this.beginColumnList(columnBuffer);
        this.beginColumnList(valuesBuffer);
        this.addColumn(columnBuffer, columnNumber++, this.doubleQuote(KEY_COLUMN));
        this.addColumn(valuesBuffer, valuesNumber++, "?");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName);
            this.addColumn(columnBuffer, columnNumber++, columnDesc);
            this.addColumn(valuesBuffer, valuesNumber++, "?");
        }
        this.endColumnList(columnBuffer);
        this.endColumnList(valuesBuffer);
        masterBuffer.append("insert into " + tableName + "\n");
        masterBuffer.append(columnBuffer.toString());
        masterBuffer.append("values\n");
        masterBuffer.append(valuesBuffer.toString());
        PreparedStatement ps = JDBCDriverTest.prepare(conn, masterBuffer.toString());
        return ps;
    }

    private void readTable(Connection conn, String tableName, TypeDescriptor[] types, Object[][] rows, List casts) throws Exception {
        PreparedStatement ps = this.readTableQuery(conn, tableName, types);
        ResultSet rs = ps.executeQuery();
        this.checkRSMD(rs);
        this.checkRows(rs, types, rows, casts);
        JDBCDriverTest.close(rs);
        JDBCDriverTest.close(ps);
    }

    private PreparedStatement readTableQuery(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int columnNumber = 0;
        int typeCount = types.length;
        buffer.append("select \n");
        this.addColumn(buffer, columnNumber++, this.doubleQuote(KEY_COLUMN));
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName);
            this.addColumn(buffer, columnNumber++, columnDesc);
        }
        buffer.append("\nfrom " + tableName + "\n");
        buffer.append("order by " + this.doubleQuote(KEY_COLUMN));
        PreparedStatement ps = JDBCDriverTest.prepare(conn, buffer.toString());
        return ps;
    }

    private void checkRSMD(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int firstTastyColumn = 0;
        JDBCDriverTest.println("ResultSetMetaData:\n");
        for (int i = ++firstTastyColumn; i < columnCount; ++i) {
            StringBuffer buffer = new StringBuffer();
            int columnID = i + 1;
            String columnName = rsmd.getColumnName(columnID);
            TypeDescriptor typeDesc = this.getType(columnName);
            int expectedType = this.rsmdTypeKludge(typeDesc.getJdbcType());
            int actualType = rsmd.getColumnType(columnID);
            buffer.append("[ ");
            buffer.append(columnName);
            buffer.append(", type( ");
            buffer.append(actualType);
            buffer.append(" ), ");
            buffer.append(rsmd.getColumnTypeName(columnID));
            buffer.append(" ]\n");
            JDBCDriverTest.println(buffer.toString());
            JDBCDriverTest.assertEquals((String)columnName, (int)expectedType, (int)actualType);
        }
    }

    private void checkRows(ResultSet rs, TypeDescriptor[] types, Object[][] rows, List casts) throws Exception {
        int rowCount = rows.length;
        for (int i = 0; i < rowCount; ++i) {
            rs.next();
            this.checkRow(rs, types, rows[i], casts);
        }
    }

    private void checkRow(ResultSet rs, TypeDescriptor[] types, Object[] row, List casts) throws Exception {
        int typeCount = types.length;
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String columnName = type.getDerbyTypeName();
            Object expectedValue = row[i];
            Object actualValue = this.getColumn(rs, columnName, type);
            JDBCDriverTest.println("Comparing column " + columnName + ": " + expectedValue + " to " + actualValue);
            this.compareObjects(columnName, expectedValue, actualValue);
            this.checkCoercions(rs, columnName, type, casts);
        }
    }

    private void checkCoercions(ResultSet rs, String columnName, TypeDescriptor type, List casts) throws Exception {
        T_CN coercionDesc = COERCIONS[this.getCoercionIndex(type.getJdbcType())];
        boolean[] coercions = coercionDesc.getCoercions();
        int count = coercions.length;
        int legalCoercions = 0;
        JDBCDriverTest.println("Checking coercions for " + columnName);
        for (int i = 0; i < count; ++i) {
            if (!coercions[i]) continue;
            ++legalCoercions;
            int jdbcType = COERCIONS[i].getJdbcType();
            Object retval = this.getColumn(rs, columnName, jdbcType);
            if (casts != null) {
                casts.add(retval);
            }
            JDBCDriverTest.println("\t" + jdbcType + ":\t" + retval);
        }
        Object objval = rs.getObject(columnName);
        if (objval == null) {
            JDBCDriverTest.println("\tgetObject() = null");
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\tgetObject() = ");
            buffer.append(objval.getClass().getName());
            buffer.append("( ");
            buffer.append(objval);
            buffer.append(" )");
            JDBCDriverTest.println(buffer.toString());
        }
    }

    private int rsmdTypeKludge(int originalJDbcType) {
        if (this.usingEmbeddedClient() && JDBCDriverTest.getServerVMVersion().atLeast(VM_1_4)) {
            return originalJDbcType;
        }
        switch (originalJDbcType) {
            case 2: {
                if (this.usingEmbeddedClient()) {
                    return originalJDbcType;
                }
                return 3;
            }
        }
        return originalJDbcType;
    }

    private int ddmdTypeKludge(int originalJDbcType) {
        switch (originalJDbcType) {
            case 16: {
                if (JDBCDriverTest.getServerVMVersion().atLeast(VM_1_4)) {
                    return originalJDbcType;
                }
                return -7;
            }
        }
        return originalJDbcType;
    }

    private void setRow(PreparedStatement ps, int keyValue, TypeDescriptor[] types, Object[] row) throws Exception {
        int param = 1;
        int typeCount = types.length;
        ps.setInt(param++, keyValue);
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            Object value = row[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            this.setParameter(ps, param++, type, value);
        }
        ps.execute();
    }

    private Object[][] makeRows(Object[][] rows) {
        int count = rows.length;
        int columns = rows[0].length;
        Object[][] result = new Object[count + 1][];
        int idx = 0;
        result[idx++] = this.makeNullRow(columns);
        for (int i = 0; i < count; ++i) {
            result[idx++] = rows[i];
        }
        return result;
    }

    private Object[] makeNullRow(int rowLength) {
        return new Object[rowLength];
    }

    private void buildTypeMap() {
        int typeCount = ALL_TYPES.length;
        for (int i = 0; i < typeCount; ++i) {
            this.putType(ALL_TYPES[i]);
        }
    }

    private void putType(TypeDescriptor type) {
        _types.put(type.getDerbyTypeName(), type);
    }

    private TypeDescriptor getType(String typeName) {
        if (_types.size() == 0) {
            this.buildTypeMap();
        }
        return (TypeDescriptor)_types.get(typeName);
    }

    private TypeDescriptor getType(int jdbcType) {
        int count = ALL_TYPES.length;
        for (int i = 0; i < count; ++i) {
            TypeDescriptor type = ALL_TYPES[i];
            if (type.getJdbcType() != jdbcType) continue;
            return type;
        }
        return null;
    }

    private TypeDescriptor getType(TypeDescriptor[] types, String typeName) {
        int count = types.length;
        for (int i = 0; i < count; ++i) {
            TypeDescriptor type = types[i];
            if (!type.getDerbyTypeName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    private void buildCoercionMap() {
        int count = COERCIONS.length;
        for (int i = 0; i < count; ++i) {
            this.putCoercionIndex(i);
        }
    }

    private void putCoercionIndex(int index) {
        _coercionIndex.put(new Integer(COERCIONS[index].getJdbcType()), new Integer(index));
    }

    private int getCoercionIndex(int jdbcType) {
        if (_coercionIndex.size() == 0) {
            this.buildCoercionMap();
        }
        return (Integer)_coercionIndex.get(new Integer(jdbcType));
    }

    private void createSchema(Connection conn) throws Exception {
        this.createTable(conn, ALL_TYPES_TABLE, ALL_TYPES);
    }

    private void createTable(Connection conn, String tableName, TypeDescriptor[] types) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int columnNumber = 0;
        int typeCount = types.length;
        buffer.append("create table " + tableName + "\n");
        this.beginColumnList(buffer);
        this.addColumn(buffer, columnNumber++, this.doubleQuote(KEY_COLUMN) + "\tint");
        for (int i = 0; i < typeCount; ++i) {
            TypeDescriptor type = types[i];
            if (!this.getServerVersion().atLeast(type.getDerbyVersion())) continue;
            String typeName = type.getDerbyTypeName();
            String columnDesc = this.doubleQuote(typeName) + '\t' + typeName;
            this.addColumn(buffer, columnNumber++, columnDesc);
        }
        this.endColumnList(buffer);
        PreparedStatement ps = JDBCDriverTest.prepare(conn, buffer.toString());
        ps.execute();
        JDBCDriverTest.close(ps);
    }

    private void beginColumnList(StringBuffer buffer) {
        buffer.append("(\n");
    }

    private void endColumnList(StringBuffer buffer) {
        buffer.append("\n)\n");
    }

    private void addColumn(StringBuffer buffer, int columnNumber, String text) {
        if (columnNumber > 0) {
            buffer.append(",");
        }
        buffer.append("\n\t");
        buffer.append(text);
    }

    private void dropSchema(Connection conn) {
        JDBCDriverTest.dropTable(conn, ALL_TYPES_TABLE);
    }

    private void setParameter(PreparedStatement ps, int param, TypeDescriptor type, Object value) throws Exception {
        int jdbcType = type.getJdbcType();
        if (value != null) {
            this.setParameter(ps, param, jdbcType, value);
            return;
        }
        if (this.clientSupports(type)) {
            ps.setNull(param, jdbcType);
            return;
        }
        JDBCDriverTest.fail((String)("Unsupported Derby type: " + type.getDerbyTypeName()));
    }

    private void checkParameter(ResultSet rs, int param, Object value) throws Exception {
        if (value == null) {
            return;
        }
        JDBCDriverTest.println("Checking " + value.getClass().getName());
        Object actualValue = value instanceof Boolean ? new Boolean(rs.getBoolean(param)) : (value instanceof Byte ? new Byte(rs.getByte(param)) : (value instanceof Short ? new Short(rs.getShort(param)) : (value instanceof Integer ? new Integer(rs.getInt(param)) : (value instanceof Long ? new Long(rs.getLong(param)) : (value instanceof Float ? new Float(rs.getFloat(param)) : (value instanceof Double ? new Double(rs.getDouble(param)) : (value instanceof String ? rs.getString(param) : (value instanceof BigDecimal ? rs.getBigDecimal(param) : rs.getObject(param)))))))));
        JDBCDriverTest.assertTrue((boolean)value.equals(actualValue));
    }

    private boolean clientSupports(TypeDescriptor type) {
        CompatibilitySuite.Version firstSupportedVersion = this.usingDB2Client() ? type.getDb2jccVersion() : type.getDerbyVersion();
        if (firstSupportedVersion == null) {
            return false;
        }
        return this.getDriverVersion().atLeast(firstSupportedVersion);
    }

    private Object getColumn(ResultSet rs, String columnName, TypeDescriptor type) throws Exception {
        int jdbcType = type.getJdbcType();
        return this.getColumn(rs, columnName, jdbcType);
    }

    private Object getOutArg(CallableStatement cs, int arg, TypeDescriptor type) throws Exception {
        int jdbcType = type.getJdbcType();
        return this.getOutArg(cs, arg, jdbcType);
    }

    private String doubleQuote(String text) {
        return '\"' + text + '\"';
    }

    public static final class MyClob
    implements Clob {
        private String _contents;

        public MyClob(String contents) {
            this._contents = contents;
        }

        public InputStream getAsciiStream() {
            try {
                return new ByteArrayInputStream(this._contents.getBytes("UTF-8"));
            }
            catch (Exception e) {
                return null;
            }
        }

        public Reader getCharacterStream() {
            return new CharArrayReader(this._contents.toCharArray());
        }

        public String getSubString(long position, int length) {
            return this._contents.substring((int)position, length);
        }

        public long length() {
            return this._contents.length();
        }

        public long position(Clob searchstr, long start) {
            return 0L;
        }

        public long position(String searchstr, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Clob)) {
                return false;
            }
            Clob that = (Clob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getAsciiStream();
                InputStream thatStream = that.getAsciiStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public int setString(long arg0, String arg1) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public OutputStream setAsciiStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public Writer setCharacterStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }

    public static final class MyBlob
    implements Blob {
        private byte[] _bytes;

        public MyBlob(byte[] bytes) {
            this._bytes = bytes;
        }

        public InputStream getBinaryStream() {
            return new ByteArrayInputStream(this._bytes);
        }

        public byte[] getBytes(long position, int length) {
            return this._bytes;
        }

        public long length() {
            return this._bytes.length;
        }

        public long position(Blob pattern, long start) {
            return 0L;
        }

        public long position(byte[] pattern, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Blob)) {
                return false;
            }
            Blob that = (Blob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getBinaryStream();
                InputStream thatStream = that.getBinaryStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public int setBytes(long arg0, byte[] arg1) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public OutputStream setBinaryStream(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }

    public static final class T_CN {
        private int _jdbcType;
        private boolean[] _coercions;

        public T_CN(int jdbcType, boolean[] coercions) {
            this._jdbcType = jdbcType;
            this._coercions = coercions;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public boolean[] getCoercions() {
            return this._coercions;
        }
    }

    public static final class TypeDescriptor {
        private int _jdbcType;
        private String _derbyTypeName;
        private CompatibilitySuite.Version _db2jccVersion;
        private CompatibilitySuite.Version _derbyVersion;
        private CompatibilitySuite.Version _vmVersion;

        public TypeDescriptor(int jdbcType, String derbyTypeName, CompatibilitySuite.Version db2jccVersion, CompatibilitySuite.Version derbyVersion, CompatibilitySuite.Version vmVersion) {
            this._jdbcType = jdbcType;
            this._derbyTypeName = derbyTypeName;
            this._db2jccVersion = db2jccVersion;
            this._derbyVersion = derbyVersion;
            this._vmVersion = vmVersion;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public String getDerbyTypeName() {
            return this._derbyTypeName;
        }

        public CompatibilitySuite.Version getDb2jccVersion() {
            return this._db2jccVersion;
        }

        public CompatibilitySuite.Version getDerbyVersion() {
            return this._derbyVersion;
        }

        public CompatibilitySuite.Version getVMVersion() {
            return this._vmVersion;
        }
    }
}

