/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BLOBDataModelSetup;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public final class BLOBTest
extends BaseJDBCTestCase {
    public BLOBTest(String name) {
        super(name);
    }

    public void testUpdateBlobFromScrollableResultSetUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(3));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt(1);
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(rs, newVal, newSize);
        rs.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(3));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt(1);
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(rs, newVal, newSize);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(2) + 11;
        int newSize = rs.getInt(3) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(1));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt("VAL");
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt("VAL") + 11;
        int newSize = 0x2000000;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, 0x2000000);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val= " + 11);
        BLOBTest.println("Last");
        rs.last();
        int newVal = 22;
        int newSize = 0x2000000;
        this.testUpdateBlobWithPositionedUpdate(rs, 22, 0x2000000);
        rs.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(22, 0x2000000, rs.getBlob("DATA"));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = " + 11);
        rs.next();
        int newVal = 22;
        int newSize = 0x2000000;
        this.testUpdateBlobWithPositionedUpdate(rs, 22, 0x2000000);
        rs.close();
        stmt.close();
    }

    private void testUpdateBlobWithResultSetMethods(ResultSet rs, int newVal, int newSize) throws SQLException, IOException {
        int val = rs.getInt("VAL");
        int size = rs.getInt("LENGTH");
        BLOBTest.println("VerifyBlob");
        this.verifyBlob(val, size, rs.getBlob("DATA"));
        BLOBTest.println("UpdateBlob");
        TestInputStream newStream = new TestInputStream(newSize, newVal);
        rs.updateInt("VAL", newVal);
        rs.updateInt("LENGTH", newSize);
        rs.updateBinaryStream("DATA", (InputStream)newStream, newSize);
        rs.updateRow();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(newVal, newSize);
    }

    private void testUpdateBlobWithPositionedUpdate(ResultSet rs, int newVal, int newSize) throws SQLException, IOException {
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE " + BLOBDataModelSetup.getBlobTableName() + " SET val=?, length = ?, data = ? WHERE CURRENT OF " + rs.getCursorName());
        BLOBTest.println("UpdateBlob");
        TestInputStream newStream = new TestInputStream(newSize, newVal);
        preparedStatement.setInt(1, newVal);
        preparedStatement.setInt(2, newSize);
        preparedStatement.setBinaryStream(3, (InputStream)newStream, newSize);
        preparedStatement.executeUpdate();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(newVal, newSize);
    }

    private void verifyNewValueInTable(int newVal, int newSize) throws IOException, SQLException {
        BLOBTest.println("Verify new value in table: " + newVal);
        Statement stmt = this.createStatement(1003, 1007);
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = " + newVal);
        BLOBTest.println("Query executed, calling next");
        boolean foundVal = false;
        while (rs.next()) {
            BLOBTest.println("Next called, verifying row");
            BLOBTest.assertEquals((String)"Unexpected value in val column", (int)newVal, (int)rs.getInt(1));
            this.verifyBlob(newVal, newSize, rs.getBlob(3));
            foundVal = true;
        }
        BLOBTest.assertTrue((String)("No column with value= " + newVal + " found "), (boolean)foundVal);
        rs.close();
        stmt.close();
    }

    private void verifyBlob(int expectedVal, int expectedSize, Blob blob) throws IOException, SQLException {
        InputStream stream = blob.getBinaryStream();
        int blobSize = 0;
        int val = stream.read();
        while (val != -1) {
            ++blobSize;
            if (expectedVal != val) {
                BLOBTest.assertEquals((String)("Unexpected value in stream at position " + blobSize), (int)expectedVal, (int)val);
            }
            val = stream.read();
        }
        stream.close();
        BLOBTest.assertEquals((String)"Unexpected size of stream ", (int)expectedSize, (int)blobSize);
    }

    public static Test suite() {
        TestSuite mainSuite = new TestSuite(BLOBTest.class, "BLOBTest");
        return new BLOBDataModelSetup((Test)mainSuite);
    }

    public final void setUp() throws Exception {
        BLOBTest.println("Setup of: " + this.getName());
        this.getConnection().setAutoCommit(false);
    }
}

