/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SysinfoTest
extends BaseJDBCTestCase {
    private static String TARGET_POLICY_FILE_NAME = "sysinfo.policy";
    private String OUTPUT;
    private static boolean useProperties = false;

    public SysinfoTest(String name) {
        super(name);
        String OUTPUT1 = "--------- Derby Network Server Information --------\nderby.drda.maxThreads=0\nderby.drda.sslMode=off\nderby.drda.keepAlive=true\nderby.drda.minThreads=0\nderby.drda.portNumber=1527\nderby.drda.logConnections=false\nderby.drda.timeSlice=0\nderby.drda.startNetworkServer=false\nderby.drda.traceAll=false\n--------- Derby Information --------\n------------------------------------------------------\n----------------- Locale Information -----------------\n------------------------------------------------------";
        String OUTPUT2 = "--------- Derby Network Server Information --------\nderby.drda.securityMechanism=USER_ONLY_SECURITY\nderby.drda.maxThreads=0\nderby.drda.sslMode=off\nderby.drda.keepAlive=true\nderby.drda.minThreads=0\nderby.drda.portNumber=1527\nderby.drda.logConnections=false\nderby.drda.timeSlice=0\nderby.drda.startNetworkServer=false\nderby.drda.traceAll=false\n--------- Derby Information --------\n------------------------------------------------------\n----------------- Locale Information -----------------\n------------------------------------------------------";
        this.OUTPUT = useProperties ? OUTPUT2 : OUTPUT1;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SysinfoTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        useProperties = false;
        if (!TestConfiguration.loadingFromJars()) {
            Properties propstmp = new Properties();
            propstmp.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
            suite.addTest((Test)new SystemPropertyTestSetup(SysinfoTest.decorateTest(), propstmp));
        } else {
            suite.addTest(SysinfoTest.decorateTest());
        }
        useProperties = true;
        Properties props = new Properties();
        if (!TestConfiguration.loadingFromJars()) {
            props.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
        }
        props.put("derby.infolog.append", "true");
        props.put("derby.locks.waitTimeout", "120");
        props.put("derby.language.logStatementText", "true");
        props.put("derby.drda.securityMechanism", "USER_ONLY_SECURITY");
        suite.addTest((Test)new SystemPropertyTestSetup(SysinfoTest.decorateTest(), props));
        return suite;
    }

    private String makePolicyName() {
        try {
            String userDir = SysinfoTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            SysinfoTest.fail((String)("Unexpected exception caught by makeServerPolicyName(): " + e));
            return null;
        }
    }

    private static Test decorateTest() {
        String policyName = new SysinfoTest("test").makePolicyName();
        Object test = TestConfiguration.clientServerSuite(SysinfoTest.class);
        test = TestConfiguration.singleUseDatabaseDecorator((Test)new SecurityManagerSetup((Test)test, policyName));
        String POLICY_FILE_NAME = "functionTests/tests/derbynet/SysinfoTest.policy";
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    public void testSysinfo() throws Exception {
        String[] SysInfoCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "sysinfo"};
        Process p = this.execJavaCmd(SysInfoCmd);
        String s = this.readProcessOutput(p);
        s = this.sed(s);
        this.print("testSysinfo", s);
        SysinfoTest.assertEquals((String)this.OUTPUT, (String)s);
    }

    public void testSysinfoMethod() throws Exception {
        String s = NetworkServerTestSetup.getNetworkServerControlDefault().getSysinfo();
        s = this.sed(s);
        this.print("testSysinfoMethod", s);
        SysinfoTest.assertEquals((String)this.OUTPUT, (String)s);
    }

    public void testSysinfoLocale() throws Exception {
        String[] SysInfoLocaleCmd = new String[]{"-Duser.language=de", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "sysinfo"};
        Process p = this.execJavaCmd(SysInfoLocaleCmd);
        String s = this.readProcessOutput(p);
        s = this.sed(s);
        this.print("testSysinfoLocale", s);
        SysinfoTest.assertEquals((String)this.OUTPUT, (String)s);
    }

    private String sed(String s) {
        String[] sed = new String[]{"Version", "version", "Java", "OS", "[0-9*].[0-9*].[0-9*]", "JRE - JDBC", "derby.drda.traceDirectory", "Unable to access Protection Domain", "listing properties", "Current Locale", "Found support for locale:"};
        for (int i = 0; i < sed.length; ++i) {
            s = s.replaceAll("\r\n", "\n");
            s = s.replaceAll("(?m)^.*" + sed[i] + ".*\n", "");
        }
        s = s.trim();
        return s;
    }

    private void print(String name, String s) {
        SysinfoTest.println("\n\n>>>" + name + ">>>");
        SysinfoTest.println(s);
        SysinfoTest.println("<<<" + name + "<<<\n\n");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        TARGET_POLICY_FILE_NAME = null;
        this.OUTPUT = null;
    }

    private static String findClassDir() {
        URL url = null;
        try {
            final Class<?> cl = Class.forName("org.apache.derbyTesting.functionTests.tests.derbynet.SysinfoTest");
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getProtectionDomain().getCodeSource().getLocation();
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return url.getPath();
    }
}

