/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SqlExceptionTest
extends BaseJDBCTestCase {
    public SqlExceptionTest(String name) {
        super(name);
    }

    public void testChainedException() {
        IOException ioe = new IOException("Test exception");
        SqlException sqle = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)ioe);
        SQLException javae = sqle.getSQLException();
        SqlExceptionTest.assertEquals((Object)sqle, (Object)javae.getCause());
        SqlExceptionTest.assertEquals((Object)ioe, (Object)javae.getCause().getCause());
        SqlExceptionTest.assertNull((Object)sqle.getNextException());
    }

    public void testNextException() {
        SQLException nexte = new SQLException("test");
        SqlException sqle = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)nexte);
        SQLException javae = sqle.getSQLException();
        SqlExceptionTest.assertEquals((Object)sqle, (Object)javae.getCause());
        SqlExceptionTest.assertEquals((Object)nexte, (Object)javae.getCause().getCause());
        SqlExceptionTest.assertEquals((Object)nexte, (Object)javae.getNextException());
        SqlException internalException = new SqlException(null, new ClientMessageId("08000"));
        javae = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)internalException).getSQLException();
        SqlExceptionTest.assertNotNull((Object)javae.getNextException());
        SqlExceptionTest.assertEquals((String)javae.getNextException().getSQLState(), (String)"08000");
        SqlExceptionTest.assertEquals((Object)internalException, (Object)javae.getCause().getCause());
    }

    public void testSerializedException() throws Exception {
        SQLException se_ser;
        try {
            this.createStatement().execute("DROP TABLE APP.DERBY62_DAIN_SUNDSTROM");
            SqlExceptionTest.fail((String)"should've received an error");
        }
        catch (SQLException sqle) {
            se_ser = this.recreateSQLException(sqle);
            SqlExceptionTest.assertSQLState("Unexpected SQL State", sqle.getSQLState(), se_ser);
            SqlExceptionTest.assertSQLExceptionEquals(sqle, se_ser);
        }
        try {
            Connection conn = this.getConnection();
            Statement stmt = conn.createStatement();
            String insertData = "INSERT INTO tableWithPK values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)";
            stmt.addBatch(insertData);
            stmt.addBatch(insertData);
            stmt.addBatch(insertData);
            stmt.executeBatch();
            SqlExceptionTest.fail((String)"Unexpected: SQL statement should have failed");
        }
        catch (SQLException se) {
            se_ser = this.recreateSQLException(se);
            SqlExceptionTest.assertSQLState("Unexpected SQL State", se.getSQLState(), se_ser);
            SqlExceptionTest.assertSQLExceptionEquals(se, se_ser);
        }
    }

    public void testDerby3390() throws Exception {
        ResultSet rs;
        this.setAutoCommit(false);
        Statement stmt = this.createStatement();
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                stmt.execute("values badFunction1()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                stmt.execute("values badFunction1()");
                rs = stmt.getResultSet();
                rs.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException e) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", e);
            SqlExceptionTest.assertTrue((e.getMessage().indexOf("I refuse to return an int") > 1 ? 1 : 0) != 0);
        }
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                stmt.execute("values badFunction2()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                stmt.execute("values badFunction2()");
                rs = stmt.getResultSet();
                rs.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException e) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", e);
            SqlExceptionTest.assertSQLState("50000", e);
            SqlExceptionTest.assertTrue((e.getMessage().indexOf("I refuse to return an int") > 1 ? 1 : 0) != 0);
        }
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                stmt.execute("values badFunction3()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                stmt.execute("values badFunction3()");
                rs = stmt.getResultSet();
                rs.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException e) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", e);
            SqlExceptionTest.assertTrue((e.getMessage().indexOf("The exception 'java.lang.Exception: I refuse to return an int!'") == 0 ? 1 : 0) != 0);
        }
        stmt.close();
        this.rollback();
        this.setAutoCommit(true);
    }

    public void setUp() throws Exception {
        Connection conn = this.getConnection();
        String createTableWithPK = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        Statement stmt = conn.createStatement();
        stmt.execute(createTableWithPK);
        stmt.execute("create function badFunction1() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction1'");
        stmt.execute("create function badFunction2() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction2'");
        stmt.execute("create function badFunction3() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction3'");
        stmt.close();
        conn.close();
    }

    public void tearDown() throws Exception {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("DROP TABLE tableWithPK");
        stmt.executeUpdate("drop function badfunction1");
        stmt.executeUpdate("drop function badfunction2");
        stmt.executeUpdate("drop function badfunction3");
        stmt.close();
        conn.close();
        super.tearDown();
    }

    private SQLException recreateSQLException(SQLException se) throws Exception {
        SQLException recreatedDS = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(se);
        oos.flush();
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        recreatedDS = (SQLException)ois.readObject();
        ois.close();
        SqlExceptionTest.assertNotNull((Object)recreatedDS);
        return recreatedDS;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty SqlExceptionTest - client not supported on JSR169");
        }
        Test test = TestConfiguration.defaultSuite(SqlExceptionTest.class);
        return test;
    }

    public static int badFunction1() throws SQLException {
        throw new SQLException("I refuse to return an int!");
    }

    public static int badFunction2() throws SQLException {
        throw new SQLException("I refuse to return an int!", "50000");
    }

    public static int badFunction3() throws Exception {
        throw new Exception("I refuse to return an int!");
    }
}

