/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SecureServerTest
extends BaseJDBCTestCase {
    private static final String BASIC = "functionTests/tests/derbynet/SecureServerTest.derby.properties";
    private static final String SST_USER_NAME = "MARY";
    private static final String SST_PASSWORD = "marypwd";
    private static final String HOSTW = "0.0.0.0";
    private static final String ALTW = "0.00.000.0";
    private static final String IPV6W = "::";
    private static final Outcome RUNNING_SECURITY_NOT_BOOTED = new Outcome(true, "");
    private static final Outcome RUNNING_SECURITY_BOOTED = new Outcome(true, SecureServerTest.serverBootedOK());
    private NetworkServerTestSetup nsTestSetup;
    private boolean _unsecureSet;
    private boolean _authenticationRequired;
    private String _customDerbyProperties;
    private String _wildCardHost;
    private Outcome _outcome;

    public SecureServerTest(boolean unsecureSet, boolean authenticationRequired, String customDerbyProperties, String wildCardHost, Outcome outcome) {
        super("testServerStartup");
        this._unsecureSet = unsecureSet;
        this._authenticationRequired = authenticationRequired;
        this._customDerbyProperties = customDerbyProperties;
        this._wildCardHost = wildCardHost;
        this._outcome = outcome;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SecureServerTest");
        if (!TestConfiguration.loadingFromJars()) {
            return suite;
        }
        if (!Derby.hasServer()) {
            return suite;
        }
        suite.addTest(SecureServerTest.decorateTest(false, false, null, null, RUNNING_SECURITY_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(false, false, BASIC, null, RUNNING_SECURITY_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(false, true, null, null, RUNNING_SECURITY_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(false, true, null, HOSTW, RUNNING_SECURITY_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(false, true, null, ALTW, RUNNING_SECURITY_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(true, false, null, null, RUNNING_SECURITY_NOT_BOOTED));
        suite.addTest(SecureServerTest.decorateTest(true, true, null, null, RUNNING_SECURITY_NOT_BOOTED));
        return suite;
    }

    private static Test decorateTest(boolean unsecureSet, boolean authenticationRequired, String customDerbyProperties, String wildCardHost, Outcome outcome) {
        NetworkServerTestSetup networkServerTestSetup;
        SecureServerTest secureServerTest = new SecureServerTest(unsecureSet, authenticationRequired, customDerbyProperties, wildCardHost, outcome);
        String[] startupProperties = SecureServerTest.getStartupProperties(authenticationRequired, customDerbyProperties);
        String[] startupArgs = SecureServerTest.getStartupArgs(unsecureSet, wildCardHost);
        secureServerTest.nsTestSetup = networkServerTestSetup = new NetworkServerTestSetup((Test)secureServerTest, startupProperties, startupArgs, secureServerTest._outcome.serverShouldComeUp());
        Object testSetup = SecurityManagerSetup.noSecurityManager((Test)networkServerTestSetup);
        if (customDerbyProperties != null) {
            testSetup = new SupportFilesSetup((Test)testSetup, null, new String[]{BASIC}, null, new String[]{"derby.properties"});
        }
        Test test = TestConfiguration.defaultServerDecorator(testSetup);
        test = TestConfiguration.changeUserDecorator(test, SST_USER_NAME, SST_PASSWORD);
        return test;
    }

    private static String[] getStartupArgs(boolean setUnsecureOption, String wildCardHost) {
        ArrayList<String> list = new ArrayList<String>();
        if (setUnsecureOption) {
            list.add("-noSecurityManager");
        }
        if (wildCardHost != null) {
            list.add("-h");
            list.add(wildCardHost);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private static String[] getStartupProperties(boolean authenticationRequired, String customDerbyProperties) {
        ArrayList<String> list = new ArrayList<String>();
        if (authenticationRequired) {
            list.add("derby.connection.requireAuthentication=true");
            list.add("derby.authentication.provider=BUILTIN");
            list.add("derby.user.MARY=marypwd");
        }
        if (customDerbyProperties != null) {
            list.add("derby.system.home=extinout");
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public void testServerStartup() throws Exception {
        String myName = this.toString();
        String serverOutput = this.getServerOutput();
        boolean serverCameUp = this.serverCameUp();
        boolean outputOK = serverOutput.indexOf(this._outcome.expectedServerOutput()) >= 0;
        SecureServerTest.assertEquals((String)(myName + ": serverCameUp = " + serverCameUp), (boolean)this._outcome.serverShouldComeUp(), (boolean)serverCameUp);
        SecureServerTest.assertTrue((String)(myName + "\nExpected: " + this._outcome.expectedServerOutput() + "\nBut saw: " + serverOutput), (boolean)outputOK);
        if (this._authenticationRequired && this._wildCardHost != null) {
            this.connectToServer();
        }
        this.runsysinfo();
        this.enableTracing();
        this.setTraceDirectory();
        this.disableTracing();
    }

    private void disableTracing() throws Exception {
        String traceOffOutput = this.runServerCommand("trace off");
        SecureServerTest.println("Output for trace off command:\n\n" + traceOffOutput);
        if (traceOffOutput.indexOf("Trace turned off for all sessions.") < 0) {
            SecureServerTest.fail((String)("Failed to turn trace off:\n\n:" + traceOffOutput));
        }
    }

    private void setTraceDirectory() throws Exception {
        String pingOutput;
        String traceDirectoryOutput = this.runServerCommand("tracedirectory trace");
        SecureServerTest.println("Output for tracedirectory trace command:\n\n" + traceDirectoryOutput);
        if (traceDirectoryOutput.indexOf("Trace directory changed to trace.") < 0) {
            SecureServerTest.fail((String)("Unexpected output in setting trace directory:" + traceDirectoryOutput));
        }
        if ((pingOutput = this.runServerCommand("ping")).indexOf("Connection obtained for host:") < 0) {
            SecureServerTest.fail((String)("Failed ping after changing trace directory: " + pingOutput));
        }
        SecureServerTest.assertTrue((String)"directory trace does not exist", (boolean)PrivilegedFileOpsForTests.exists(new File("trace")));
    }

    private void connectToServer() throws Exception {
        TestConfiguration config = this.getTestConfiguration();
        String url = "jdbc:derby://localhost:" + config.getPort() + "/" + "wombat;create=true" + ";user=" + config.getUserName() + ";password=" + config.getUserPassword();
        SecureServerTest.println("XXX in connectToServer(). url = " + url);
        Class.forName("org.apache.derby.jdbc.ClientDriver");
        Connection conn = DriverManager.getConnection(url);
        SecureServerTest.assertNotNull((String)"Connection should not be null...", (Object)conn);
        conn.close();
    }

    private void runsysinfo() throws Exception {
        String sysinfoOutput = this.runServerCommand("sysinfo");
        if (sysinfoOutput.indexOf("Security Exception:") > -1) {
            SecureServerTest.fail((String)("Security exceptions in sysinfo output:\n\n:" + sysinfoOutput));
        }
    }

    private void enableTracing() throws Exception {
        String traceOnOutput = this.runServerCommand("trace on");
        SecureServerTest.println("Output for trace on command:\n\n" + traceOnOutput);
        if (traceOnOutput.indexOf("Trace turned on for all sessions.") < 0) {
            SecureServerTest.fail((String)("Security exceptions in output of trace enabling command:\n\n:" + traceOnOutput));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SecureServerTest( ");
        buffer.append("Opened = ");
        buffer.append(this._unsecureSet);
        buffer.append(", Authenticated= ");
        buffer.append(this._authenticationRequired);
        buffer.append(", CustomDerbyProperties= ");
        buffer.append(this._customDerbyProperties);
        buffer.append(", WildCardHost= ");
        buffer.append(this._wildCardHost);
        buffer.append(" )");
        return buffer.toString();
    }

    private String runServerCommand(String commandSpecifics) throws Exception {
        String portNumber = Integer.toString(this.getTestConfiguration().getPort());
        StringBuffer buffer = new StringBuffer();
        String classpath = SecureServerTest.getSystemProperty("java.class.path");
        buffer.append(SecureServerTest.getJavaExecutableName() + " -classpath ");
        buffer.append(classpath);
        buffer.append(" -Demma.verbosity.level=silent");
        buffer.append(" org.apache.derby.drda.NetworkServerControl -p " + portNumber + " " + commandSpecifics);
        final String command = buffer.toString();
        SecureServerTest.println("Server command is " + command);
        Process serverProcess = (Process)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Process result = null;
                try {
                    result = Runtime.getRuntime().exec(command);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return result;
            }
        });
        SpawnedProcess spawned = new SpawnedProcess(serverProcess, commandSpecifics);
        SecureServerTest.assertEquals((int)0, (int)spawned.complete(false));
        return spawned.getFullServerOutput();
    }

    private String getServerOutput() throws Exception {
        return this.nsTestSetup.getServerProcess().getNextServerOutput();
    }

    private static String serverBootedOK() {
        return "Security manager installed using the Basic server security policy.";
    }

    private boolean serverCameUp() throws Exception {
        return NetworkServerTestSetup.pingForServerUp(NetworkServerTestSetup.getNetworkServerControl(), this.nsTestSetup.getServerProcess().getProcess(), true);
    }

    public static final class Outcome {
        private boolean _serverShouldComeUp;
        private String _expectedServerOutput;

        public Outcome(boolean serverShouldComeUp, String expectedServerOutput) {
            this._serverShouldComeUp = serverShouldComeUp;
            this._expectedServerOutput = expectedServerOutput;
        }

        public boolean serverShouldComeUp() {
            return this._serverShouldComeUp;
        }

        public String expectedServerOutput() {
            return this._expectedServerOutput;
        }
    }
}

