/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.CodePointNameTable;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EbcdicCcsidManager;

public class TestProto {
    private static final CodePointNameTable codePointNameTable = new CodePointNameTable();
    private static final Hashtable codePointValueTable = new Hashtable();
    private static final Hashtable commandTable = new Hashtable();
    private static final CcsidManager ccsidManager = new EbcdicCcsidManager();
    private static final int CREATE_DSS_REQUEST = 1;
    private static final int CREATE_DSS_OBJECT = 2;
    private static final int END_DSS = 3;
    private static final int END_DDM_AND_DSS = 4;
    private static final int START_DDM = 5;
    private static final int END_DDM = 6;
    private static final int WRITE_BYTE = 7;
    private static final int WRITE_NETWORK_SHORT = 8;
    private static final int WRITE_NETWORK_INT = 9;
    private static final int WRITE_BYTES = 10;
    private static final int WRITE_CODEPOINT_4BYTES = 11;
    private static final int WRITE_SCALAR_1BYTE = 12;
    private static final int WRITE_SCALAR_2BYTES = 13;
    private static final int WRITE_SCALAR_BYTES = 14;
    private static final int WRITE_SCALAR_HEADER = 15;
    private static final int WRITE_SCALAR_STRING = 16;
    private static final int WRITE_SCALAR_PADDED_STRING = 17;
    private static final int WRITE_SCALAR_PADDED_BYTES = 18;
    private static final int WRITE_SHORT = 19;
    private static final int WRITE_INT = 20;
    private static final int WRITE_LONG = 21;
    private static final int WRITE_FLOAT = 22;
    private static final int WRITE_DOUBLE = 23;
    private static final int READ_REPLY_DSS = 24;
    private static final int READ_LENGTH_AND_CODEPOINT = 25;
    private static final int READ_CODEPOINT = 26;
    private static final int MARK_COLLECTION = 27;
    private static final int GET_CODEPOINT = 28;
    private static final int READ_BYTE = 29;
    private static final int READ_NETWORK_SHORT = 30;
    private static final int READ_SHORT = 31;
    private static final int READ_NETWORK_INT = 32;
    private static final int READ_INT = 33;
    private static final int READ_LONG = 34;
    private static final int READ_BOOLEAN = 35;
    private static final int READ_STRING = 36;
    private static final int READ_BYTES = 37;
    private static final int FLUSH = 38;
    private static final int DISPLAY = 39;
    private static final int CHECKERROR = 40;
    private static final int RESET = 41;
    private static final int CREATE_DSS_REPLY = 42;
    private static final int SKIP_DSS = 43;
    private static final int READ_SCALAR_2BYTES = 44;
    private static final int READ_SCALAR_1BYTE = 45;
    private static final int END_TEST = 46;
    private static final int SKIP_DDM = 47;
    private static final int INCLUDE = 48;
    private static final int SKIP_BYTES = 49;
    private static final int WRITE_PADDED_STRING = 50;
    private static final int WRITE_STRING = 51;
    private static final int WRITE_ENCODED_STRING = 52;
    private static final int WRITE_ENCODED_LDSTRING = 53;
    private static final int CHECK_SQLCARD = 54;
    private static final int MORE_DATA = 55;
    private static final int COMPLETE_TEST = 56;
    private static final int READ_SECMEC_SECCHKCD = 57;
    private static final String MULTIVAL_START = "MULTIVALSTART";
    private static final String MULTIVAL_SEP = "SEP";
    private static final String MULTIVAL_END = "MULTIVALEND";
    private Socket monitorSocket = null;
    private InputStream monitorIs = null;
    private OutputStream monitorOs = null;
    private DDMWriter writer = new DDMWriter(ccsidManager, null, null);
    private DDMReader reader;
    private boolean failed = false;
    private StreamTokenizer tkn;
    private String current_filename;
    private int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestProto(String string, int n) {
        this.current_filename = string;
        this.port = n;
        this.getConnection();
        try {
            this.reader = new DDMReader(ccsidManager, this.monitorIs);
            this.processFile(string);
        }
        catch (Exception exception) {
            int n2 = 0;
            if (this.tkn != null) {
                n2 = this.tkn.lineno();
            }
            System.err.println("Unexpected exception in line " + n2 + " file: " + this.current_filename);
            exception.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
    }

    private void processIncludeFile() throws IOException, DRDAProtocolException {
        String string = this.getString();
        StreamTokenizer streamTokenizer = this.tkn;
        this.processFile(string);
        this.tkn = streamTokenizer;
    }

    private void processFile(String string) throws IOException, DRDAProtocolException {
        int n;
        BufferedReader bufferedReader;
        String string2 = this.current_filename;
        this.current_filename = string;
        String string3 = TestProto.getHostName();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = System.getProperty("user.dir");
            String string5 = System.getProperty("file.separator");
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string4 + string5 + string), "UTF-8"));
        }
        this.tkn = new StreamTokenizer(bufferedReader);
        while ((n = this.tkn.nextToken()) != -1) {
            switch (n) {
                case -2: {
                    break;
                }
                case -3: {
                    this.processCommand();
                    break;
                }
            }
        }
        this.current_filename = string2;
    }

    private void getConnection() {
        String string = TestProto.getHostName();
        try {
            this.monitorSocket = new Socket(string, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Don't know about host: " + string);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't get I/O for the connection to: " + string);
            System.exit(1);
        }
        try {
            this.monitorIs = this.monitorSocket.getInputStream();
            this.monitorOs = this.monitorSocket.getOutputStream();
        }
        catch (IOException iOException) {
            System.err.println("Couldn't get I/O for the connection to: " + string);
            System.exit(1);
        }
    }

    private void closeConnection() {
        try {
            this.monitorIs.close();
            this.monitorOs.close();
            this.monitorSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reset() {
        this.closeConnection();
        this.getConnection();
        this.reader.initialize(this.monitorIs);
        this.writer.reset(null);
    }

    private void completeTest() {
        this.closeConnection();
    }

    private static void init() {
        commandTable.put("createdssrequest", new Integer(1));
        commandTable.put("createdssobject", new Integer(2));
        commandTable.put("createdssreply", new Integer(42));
        commandTable.put("enddss", new Integer(3));
        commandTable.put("enddss", new Integer(3));
        commandTable.put("endddmanddss", new Integer(4));
        commandTable.put("startddm", new Integer(5));
        commandTable.put("endddm", new Integer(6));
        commandTable.put("writebyte", new Integer(7));
        commandTable.put("writenetworkshort", new Integer(8));
        commandTable.put("writenetworkint", new Integer(9));
        commandTable.put("writebytes", new Integer(10));
        commandTable.put("writecodepoint4bytes", new Integer(11));
        commandTable.put("writescalar1byte", new Integer(12));
        commandTable.put("writescalar2bytes", new Integer(13));
        commandTable.put("writescalarbytes", new Integer(14));
        commandTable.put("writescalarheader", new Integer(15));
        commandTable.put("writescalarstring", new Integer(16));
        commandTable.put("writescalarpaddedstring", new Integer(17));
        commandTable.put("writescalarpaddedbytes", new Integer(18));
        commandTable.put("writeshort", new Integer(19));
        commandTable.put("writeint", new Integer(20));
        commandTable.put("writelong", new Integer(21));
        commandTable.put("writefloat", new Integer(22));
        commandTable.put("writedouble", new Integer(23));
        commandTable.put("readreplydss", new Integer(24));
        commandTable.put("readlengthandcodepoint", new Integer(25));
        commandTable.put("readcodepoint", new Integer(26));
        commandTable.put("markcollection", new Integer(27));
        commandTable.put("getcodepoint", new Integer(28));
        commandTable.put("readbyte", new Integer(29));
        commandTable.put("readnetworkshort", new Integer(30));
        commandTable.put("readshort", new Integer(31));
        commandTable.put("readint", new Integer(33));
        commandTable.put("readlong", new Integer(34));
        commandTable.put("readboolean", new Integer(35));
        commandTable.put("readstring", new Integer(36));
        commandTable.put("readbytes", new Integer(37));
        commandTable.put("flush", new Integer(38));
        commandTable.put("display", new Integer(39));
        commandTable.put("checkerror", new Integer(40));
        commandTable.put("reset", new Integer(41));
        commandTable.put("skipdss", new Integer(43));
        commandTable.put("skipddm", new Integer(47));
        commandTable.put("readscalar2bytes", new Integer(44));
        commandTable.put("readscalar1byte", new Integer(45));
        commandTable.put("endtest", new Integer(46));
        commandTable.put("include", new Integer(48));
        commandTable.put("skipbytes", new Integer(49));
        commandTable.put("writepaddedstring", new Integer(50));
        commandTable.put("writestring", new Integer(51));
        commandTable.put("writeencodedstring", new Integer(52));
        commandTable.put("writeencodedldstring", new Integer(53));
        commandTable.put("checksqlcard", new Integer(54));
        commandTable.put("moredata", new Integer(55));
        commandTable.put("completetest", new Integer(56));
        commandTable.put("readsecmecandsecchkcd", new Integer(57));
        Enumeration enumeration = codePointNameTable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            codePointValueTable.put(codePointNameTable.get((Object)n), n);
        }
    }

    private void processCommand() throws IOException, DRDAProtocolException {
        Integer n = (Integer)commandTable.get(this.tkn.sval.toLowerCase(Locale.ENGLISH));
        if (n == null) {
            System.err.println("Unknown command, " + this.tkn.sval + " in line " + this.tkn.lineno());
            System.exit(1);
        }
        int n2 = n;
        switch (n2) {
            case 48: {
                this.processIncludeFile();
                break;
            }
            case 1: {
                this.writer.createDssRequest();
                break;
            }
            case 2: {
                this.writer.createDssObject();
                break;
            }
            case 42: {
                this.writer.createDssReply();
                break;
            }
            case 3: {
                this.tkn.nextToken();
                this.tkn.pushBack();
                if (this.tkn.sval != null && this.tkn.sval.startsWith("0x")) {
                    this.writer.endDss(this.getBytes()[0]);
                    break;
                }
                this.writer.endDss();
                break;
            }
            case 6: {
                this.writer.endDdm();
                break;
            }
            case 4: {
                this.writer.endDdmAndDss();
                break;
            }
            case 5: {
                this.writer.startDdm(this.getCP());
                break;
            }
            case 16: {
                this.writer.writeScalarString(this.getCP(), this.getString());
                break;
            }
            case 13: {
                this.writer.writeScalar2Bytes(this.getCP(), this.getIntOrCP());
                break;
            }
            case 12: {
                this.writer.writeScalar1Byte(this.getCP(), this.getInt());
                break;
            }
            case 14: {
                this.writer.writeScalarBytes(this.getCP(), this.getBytes());
                break;
            }
            case 18: {
                this.writer.writeScalarPaddedBytes(this.getCP(), this.getBytes(), this.getInt(), TestProto.ccsidManager.space);
                break;
            }
            case 7: {
                this.writer.writeByte(this.getInt());
                break;
            }
            case 10: {
                this.writer.writeBytes(this.getBytes());
                break;
            }
            case 19: {
                this.writer.writeShort(this.getInt());
                break;
            }
            case 20: {
                this.writer.writeInt(this.getInt());
                break;
            }
            case 11: {
                this.writer.writeCodePoint4Bytes(this.getCP(), this.getInt());
                break;
            }
            case 51: {
                String string = this.getString();
                this.writer.writeBytes(this.getEBCDIC(string));
                break;
            }
            case 52: {
                this.writeEncodedString(this.getString(), this.getString());
                break;
            }
            case 53: {
                this.writeEncodedLDString(this.getString(), this.getString(), this.getInt());
                break;
            }
            case 50: {
                String string = this.getString();
                this.writer.writeBytes(this.getEBCDIC(string));
                int n3 = this.getInt();
                int n4 = string.length();
                if (n4 >= n3) break;
                this.writer.padBytes(TestProto.ccsidManager.space, n3 - n4);
                break;
            }
            case 24: {
                this.reader.readReplyDss();
                break;
            }
            case 43: {
                this.skipDss();
                break;
            }
            case 47: {
                this.skipDdm();
                break;
            }
            case 55: {
                String string = this.getString();
                boolean bl = string.equalsIgnoreCase("true");
                if (this.reader.moreData() && !bl) {
                    this.fail("Failed - more data left");
                }
                if (this.reader.moreData() || !bl) break;
                this.fail("Failed - no data left");
                break;
            }
            case 25: {
                this.readLengthAndCodePoint();
                break;
            }
            case 44: {
                this.readLengthAndCodePoint();
                int n5 = this.reader.readNetworkShort();
                this.checkIntOrCP(n5);
                break;
            }
            case 45: {
                this.readLengthAndCodePoint();
                byte by = this.reader.readByte();
                this.checkIntOrCP(by);
                break;
            }
            case 57: {
                this.readSecMecAndSECCHKCD();
                break;
            }
            case 37: {
                byte[] byArray = this.reader.readBytes();
                byte[] byArray2 = this.getBytes();
                if (byArray.length != byArray2.length) {
                    this.fail("Failed - byte array didn't match");
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    this.fail("Failed - byte array didn't match");
                }
                break;
            }
            case 30: {
                int n6 = this.reader.readNetworkShort();
                this.checkIntOrCP(n6);
                break;
            }
            case 38: {
                this.writer.finalizeChain(this.reader.getCurrChainState(), this.monitorOs);
                this.writer.reset(null);
                break;
            }
            case 39: {
                System.out.println(this.getString());
                break;
            }
            case 40: {
                this.checkError();
                break;
            }
            case 54: {
                this.checkSQLCARD(this.getInt(), this.getString());
                break;
            }
            case 56: {
                this.completeTest();
                break;
            }
            case 46: {
                if (!this.failed) {
                    System.out.println("PASSED");
                }
                this.failed = false;
                this.reset();
                break;
            }
            case 41: {
                this.reset();
                break;
            }
            case 49: {
                this.reader.skipBytes();
                break;
            }
            default: {
                System.out.println("unknown command in line " + this.tkn.lineno());
                while (this.tkn.nextToken() != 10) {
                }
                break block0;
            }
        }
    }

    private void skipDss() throws DRDAProtocolException {
        this.reader.readReplyDss();
        this.reader.skipDss();
    }

    private void skipDdm() throws DRDAProtocolException {
        this.reader.readLengthAndCodePoint(false);
        this.reader.skipBytes();
    }

    private int getInt() throws IOException {
        int n = 1;
        int n2 = this.tkn.nextToken();
        if (this.tkn.sval != null && this.tkn.sval.equals("-")) {
            n = -1;
            n2 = this.tkn.nextToken();
        }
        if (n2 != -2) {
            String string;
            if (this.tkn.sval == null) {
                System.err.println("Invalid string on line " + this.tkn.lineno());
                System.exit(1);
            }
            if (!(string = this.tkn.sval.toLowerCase(Locale.ENGLISH)).startsWith("0x")) {
                System.err.println("Expecting number, got " + this.tkn.sval + " on line " + this.tkn.lineno());
                System.exit(1);
            } else {
                return this.convertHex(string);
            }
        }
        return new Double(this.tkn.nval).intValue() * n;
    }

    private int convertHex(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        if (n2 % 2 == 1 || n2 > 10) {
            System.err.println("Invalid length for byte string, " + n2 + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        for (int i = 2; i < n2; ++i) {
            n <<= 4;
            n += Byte.valueOf(string.substring(i, i + 1), 16).byteValue();
        }
        return n;
    }

    private boolean checkIntOrCP(int n) throws IOException {
        boolean bl = false;
        int n2 = this.tkn.nextToken();
        String string = " ";
        if (n2 == -3 && this.tkn.sval.trim().equals(MULTIVAL_START)) {
            do {
                int n3 = this.getIntOrCP();
                string = string + n3 + " ";
                bl = bl || n == n3;
                this.tkn.nextToken();
            } while (this.tkn.sval.trim().equals(MULTIVAL_SEP));
            if (!this.tkn.sval.trim().equals(MULTIVAL_END)) {
                this.fail("Invalid test file format requires MULTIVALEND got: " + this.tkn.sval);
            }
        } else {
            this.tkn.pushBack();
            int n4 = this.getIntOrCP();
            string = " " + n4;
            boolean bl2 = bl = n == n4;
        }
        if (!bl) {
            this.fail("Failed - wrong val = " + n + " Required Value: " + string);
        }
        return bl;
    }

    private int getIntOrCP() throws IOException {
        int n = this.tkn.nextToken();
        if (n == -2) {
            return new Double(this.tkn.nval).intValue();
        }
        if (n == -3) {
            return this.decodeCP(this.tkn.sval);
        }
        this.fail("Expecting number, got " + this.tkn.sval + " on line " + this.tkn.lineno());
        System.exit(1);
        return 0;
    }

    private byte[] getBytes() throws IOException {
        String string;
        byte[] byArray = null;
        int n = this.tkn.nextToken();
        if (this.tkn.sval == null) {
            System.err.println("Invalid string on line " + this.tkn.lineno());
            System.exit(1);
        }
        if (!(string = this.tkn.sval.toLowerCase(Locale.ENGLISH)).startsWith("0x")) {
            return ccsidManager.convertFromUCS2(string);
        }
        int n2 = string.length();
        if (n2 % 2 == 1) {
            System.err.println("Invalid length for byte string, " + n2 + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        byArray = new byte[(n2 - 2) / 2];
        int n3 = 0;
        for (int i = 2; i < n2; i += 2) {
            byArray[n3] = (byte)(Byte.valueOf(string.substring(i, i + 1), 16) << 4);
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] + Byte.valueOf(string.substring(i + 1, i + 2), 16));
        }
        return byArray;
    }

    private String getString() throws IOException {
        int n = this.tkn.nextToken();
        if (n == -2) {
            System.err.println("Expecting word, got " + this.tkn.nval + " on line " + this.tkn.lineno());
            System.exit(1);
        }
        return this.tkn.sval;
    }

    private int getCP() throws IOException {
        String string = this.getString();
        return this.decodeCP(string);
    }

    private int decodeCP(String string) {
        Integer n = (Integer)codePointValueTable.get(string);
        if (n == null) {
            System.err.println("Unknown codepoint, " + string + " in line " + this.tkn.lineno());
            Exception exception = new Exception();
            exception.printStackTrace();
            System.exit(1);
        }
        return n;
    }

    private void fail(String string) throws IOException {
        System.out.println("FAILED - " + string + " in line " + this.tkn.lineno());
        int n = this.tkn.nextToken();
        while (!(n == -1 || n == -3 && this.tkn.sval.toLowerCase(Locale.ENGLISH).equals("endtest"))) {
            n = this.tkn.nextToken();
        }
        this.failed = true;
        this.reset();
        Exception exception = new Exception();
        exception.printStackTrace();
    }

    private void checkError() throws IOException, DRDAProtocolException {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        byte by2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        this.reader.readReplyDss();
        int n3 = this.reader.readLengthAndCodePoint(false);
        int n4 = this.getCP();
        if (n3 != n4) {
            this.cpError(n3, n4);
            return;
        }
        block7: while (this.reader.moreDssData()) {
            int n5 = this.reader.readLengthAndCodePoint(false);
            switch (n5) {
                case 4425: {
                    n = this.reader.readNetworkShort();
                    continue block7;
                }
                case 12: {
                    n2 = this.reader.readNetworkShort();
                    continue block7;
                }
                case 4415: {
                    by = this.reader.readByte();
                    continue block7;
                }
                case 4426: {
                    by2 = this.reader.readByte();
                    continue block7;
                }
                case 5124: {
                    while (this.reader.moreDdmData()) {
                        vector.addElement(new Integer(this.reader.readNetworkShort()));
                        vector2.addElement(new Integer(this.reader.readNetworkShort()));
                    }
                    continue block7;
                }
            }
            this.reader.skipBytes();
        }
        int n6 = this.getInt();
        if (n != n6) {
            this.fail("wrong svrcod val = " + Integer.toHexString(n) + ", required val = " + Integer.toHexString(n6));
            return;
        }
        if (n3 == 4677 && by != (n6 = this.getInt())) {
            this.fail("wrong prccnvd, val = " + Integer.toHexString(by) + ", required val = " + Integer.toHexString(n6));
            return;
        }
        if (n3 == 4684) {
            n6 = this.getInt();
            if (by2 != n6) {
                this.fail("wrong synerrcd, val = " + Integer.toHexString(by2) + ", required val = " + Integer.toHexString(n6));
                return;
            }
            n6 = this.getIntOrCP();
            if (n2 != n6) {
                this.cpError(n2, n6);
                return;
            }
        }
        if (n3 == 4624) {
            for (int i = 0; i < vector.size(); ++i) {
                n6 = this.getCP();
                int n7 = (Integer)vector.elementAt(i);
                if (n7 != n6) {
                    this.cpError(n7, n6);
                    return;
                }
                int n8 = (Integer)vector2.elementAt(i);
                if (n8 == (n6 = this.getInt())) continue;
                this.fail("wrong manager level, level = " + Integer.toHexString(n8) + ", required val = " + Integer.toHexString(n6));
                return;
            }
        }
    }

    private void readLengthAndCodePoint() throws IOException, DRDAProtocolException {
        int n;
        int n2 = this.reader.readLengthAndCodePoint(false);
        if (n2 != (n = this.getCP())) {
            this.cpError(n2, n);
        }
    }

    private void readSecMecAndSECCHKCD() throws IOException, DRDAProtocolException {
        boolean bl = true;
        int n = -1;
        do {
            int n2 = this.reader.readLengthAndCodePoint(false);
            switch (n2) {
                case 4514: {
                    System.out.print("SECMEC=");
                    n = this.reader.readNetworkShort();
                    System.out.print(n + " ");
                    break;
                }
                case 4516: {
                    System.out.print("SECCHKCD=");
                    n = this.reader.readByte();
                    System.out.println(n);
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        } while (bl);
    }

    private void cpError(int n, int n2) throws IOException {
        String string = codePointNameTable.lookup(n);
        String string2 = codePointNameTable.lookup(n2);
        this.fail("wrong codepoint val = " + Integer.toHexString(n) + "(" + string + ")" + ", required codepoint = " + Integer.toHexString(n2) + "(" + string2 + ")");
    }

    private byte[] getEBCDIC(String string) {
        return ccsidManager.convertFromUCS2(string);
    }

    private void writeEncodedString(String string, String string2) throws IOException {
        try {
            byte[] byArray = string.getBytes(string2);
            this.writer.writeBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fail("Unsupported encoding " + string2);
        }
    }

    private void writeEncodedLDString(String string, String string2, int n) throws IOException {
        try {
            byte[] byArray = string.getBytes(string2);
            if (n == 2) {
                this.writer.writeShort(byArray.length);
            } else {
                this.writer.writeInt(byArray.length);
            }
            this.writer.writeBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fail("Unsupported encoding " + string2);
        }
    }

    private void checkSQLCARD(int n, String string) throws IOException, DRDAProtocolException {
        this.reader.readReplyDss();
        int n2 = this.reader.readLengthAndCodePoint(false);
        if (n2 != 9224) {
            this.fail("Expecting SQLCARD got " + Integer.toHexString(n2));
            return;
        }
        byte by = this.reader.readByte();
        int n3 = this.reader.readNetworkInt();
        if (n3 != n) {
            this.fail("Expecting sqlCode " + n + " got " + Integer.toHexString(n3));
            return;
        }
        String string2 = this.reader.readString(5, "UTF-8");
        if (!string2.equals(string)) {
            this.fail("Expecting sqlState " + string + " got " + string2);
            return;
        }
        this.reader.skipBytes();
    }

    private static String getHostName() {
        String string = System.getProperty("hostName");
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    static {
        TestProto.init();
    }
}

