/* $Id: text.c,v 1.1 2005/01/29 21:06:35 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

#include <string.h>

#include "text.h"

/* return true if buf is CRLF terminated, false otherwise */
bool
crlf_terminated(const char *buf, size_t len)
{

	if ((len >= 2)
	    && (*(buf + len - 2) == '\r')
	    && (*(buf + len - 1) == '\n'))
		return true;
	else
		return false;
}

/* extract first line in buf, strip CRLF, null-terminate result */
int
extract_line(char *line, const char *buf, size_t dstsize)
{
	size_t          len;
	char           *p;

	/* we want at least one char plus CRLF */
	if ((len = strlen(buf)) <= 2)
		return 0;

	len = 0;

	for (p = line;
	     (*buf != '\0')
	     && (!((*buf == '\r') && (*(buf + 1) == '\n')))
	     && (len < (dstsize - 1));
	     p++, buf++, len++)
		*p = *buf;

	*p = '\0';

	return len;             /* strlen(line) */
}

char           *
stars(int n)
{
#define BUFSIZE		128
	int             i;
	static char     buf[BUFSIZE];

	for (i = 0; (i < n) && (i < (BUFSIZE - 1)); i++)
		buf[i] = '*';
	buf[i] = '\0';

	return buf;
}
