/* $Id: system.h,v 1.11 2005/01/02 17:24:51 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SYSTEM_H
#define SYSTEM_H

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

/* library function replacements */
#if !HAVE_SNPRINTF
int             snprintf(char *str, size_t n, const char *fmt, ...);
#endif				/* not HAVE_SNPRINTF */
#if !HAVE_STRNCASECMP
int             strncasecmp(const char *s1, const char *s2, size_t n);
#endif				/* not HAVE_STRNCASECMP */
#if !HAVE_STRCASESTR
char           *strcasestr(const char *s, const char *find);
#endif				/* not HAVE_STRCASESTR */

/* bool type */
#if HAVE_STDBOOL_H
#include <stdbool.h>
#else
#if !HAVE__BOOL
#ifdef __cplusplus
typedef bool    _Bool;
#else
typedef unsigned char _Bool;
#endif				/* __cplusplus */
#endif				/* not HAVE__BOOL */
#define bool _Bool
#define false 0
#define true 1
#define __bool_true_false_are_defined 1
#endif				/* HAVE_STDBOOL_H */

/* NeXTStep, OpenStep, Rhapsody */
#ifdef __NeXT__
#include <libc.h>		/* instead, we could define _POSIX_SOURCE */
#ifndef O_NONBLOCK
#define O_NONBLOCK	00004	/* non-blocking I/O */
#endif
#ifndef S_IRUSR
#define S_IRUSR		0000400	/* read permission, owner */
#endif
#ifndef S_IRGRP
#define S_IRGRP		0000040	/* read permission, group */
#endif
#ifndef S_IROTH
#define S_IROTH		0000004	/* read permission, other */
#endif
#ifndef S_IWUSR
#define S_IWUSR		0000200	/* write permission, owner */
#endif
#ifndef S_IWGRP
#define S_IWGRP		0000020	/* write permission, group */
#endif
#ifndef S_IWOTH
#define S_IWOTH		0000002	/* write permission, other */
#endif
#ifndef S_IXUSR
#define S_IXUSR		0000100	/* execute/search permission, owner */
#endif
#ifndef S_IXGRP
#define S_IXGRP		0000010	/* execute/search permission, group */
#endif
#ifndef S_IXOTH
#define S_IXOTH		0000001	/* execute/search permission, other */
#endif
#ifndef S_IRWXU
#define S_IRWXU		0000700	/* read, write, execute permissions, owner */
#endif
#ifndef S_IRWXG
#define S_IRWXG		0000070	/* read, write, execute permissions, group */
#endif
#ifndef S_IRWXO
#define S_IRWXO		0000007	/* read, write, execute permissions, other */
#endif
#ifndef S_ISBLK
#define S_ISBLK(mode)	(((mode) & (0170000)) == (0060000))
#endif
#ifndef S_ISCHR
#define S_ISCHR(mode)	(((mode) & (0170000)) == (0020000))
#endif
#ifndef S_ISDIR
#define S_ISDIR(mode)	(((mode) & (0170000)) == (0040000))
#endif
#ifndef S_ISFIFO
#define S_ISFIFO(mode)	(((mode) & (0170000)) == (0010000))
#endif
#ifndef S_ISREG
#define S_ISREG(mode)	(((mode) & (0170000)) == (0100000))
#endif
#endif				/* __NeXT__ */

#endif				/* SYSTEM_H */
