/* $Id: snprintf.c,v 1.5 2005/01/02 01:24:23 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This snprintf() probably won't work on anything else than NeXT.  If we find
 * another system which doesn't have snprintf(), we should steel the following
 * implementation from NetBSDs source tree:
 *
 * src/crypto/dist/heimdal/lib/roken/snprintf.c
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

#if !HAVE_SNPRINTF
#ifdef __NeXT__
#include <ansi.h>

int
snprintf(char *str, size_t n, const char *fmt, ...)
{
	va_list         ap;
	FILE            f;

	if (n > INT_MAX)
		n = INT_MAX;
	else if (n < 0)
		return -1;
	va_start(ap, fmt);
	f._file = EOF;
	f._flag = _IOWRT | _IOSTRG;
	f._base = f._ptr = str;
	f._bufsiz = f._cnt = n ? n - 1 : 0;
	vfprintf(&f, fmt, ap);
	va_end(ap);
	if (n)
		*f._ptr = '\0';
	return (f._ptr - str);
}

#else
#error "don't know how to implement snprintf() on your platform"
#endif				/* __NeXT__ */
#else
/* dummy declaration to avoid empty translation unit warnings */
int             main(int argc, char **argv);
#endif				/* not HAVE_SNPRINTF */
