/* $Id: report.h,v 1.13 2005/01/02 17:44:18 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef REPORT_H
#define REPORT_H

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

#include <errno.h>
#include <stdio.h>
#include <string.h>

#if WITH_SSL
#include <openssl/err.h>
#endif				/* WITH_SSL */

extern int      errno;
extern int      debug_level;	/* requested by user */
extern char    *deletemail;	/* basename(argv[0]) */

/*
 * Log levels:
 *
 * -3/-2/-1: unconditional | 0: default | 1: verbose | 2: debug
 */
#define LOG_SERROR	-3	/* SSL error output */
#define LOG_PERROR	-2	/* syscall error output */
#define LOG_ERROR	-1	/* error output */
#define LOG_DEFAULT	 0	/* default output */
#define LOG_INFO	 1	/* verbose output */
#define LOG_DEBUG	 2	/* debug output */

#define REPORT_PREFIX	fprintf(stderr, "%s: ", deletemail);   \
                     	if (debug_level >= LOG_DEBUG)          \
                     		fprintf(stderr, "[%s:%d] ",    \
                     		        __FILE__,              \
                     		        __LINE__);

#if WITH_SSL
#define REPORT_SSL_ERROR(log_level)                            \
  	if (log_level == LOG_SERROR) {                         \
  		REPORT_PREFIX                                  \
  		fputs("SSL error: ", stderr);                  \
  		ERR_print_errors_fp(stderr);                   \
  	}
#else
#define REPORT_SSL_ERROR(log_level)
#endif				/* WITH_SSL */

/* report() macro used for all stderr ouput */
#if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L) \
     || (defined(__SUNPRO_C) && __SUNPRO_C >= 0x420)
#define report(log_level, ...)                                 \
  	do {                                                   \
  		if (debug_level >= log_level) {                \
  			REPORT_SSL_ERROR(log_level)            \
  			REPORT_PREFIX                          \
  			fprintf(stderr, __VA_ARGS__);          \
  			if (log_level == LOG_PERROR)           \
  				fprintf(stderr,                \
  				        ": %s",                \
  				        strerror(errno));      \
  			putc('\n', stderr);                    \
  			fflush(stderr);                        \
  		}                                              \
  	} while (/* CONSTCOND */ 0)
/*
 * I don't know which GNU cpp version introduced the ##args
 * syntax.  GCC 2.95.4 does work, 2.5.8 does not, but checking
 * for GCC >= 2.9 is a pure guess.  Anyone?
 */
#elif defined(__GNUC__)                                        \
      && (__GNUC__ >= 3                                        \
          || ( __GNUC__ == 2 && __GNUC_MINOR__ >= 9))
#define report(log_level, format, args...)                     \
  	do {                                                   \
  		if (debug_level >= log_level) {                \
  			REPORT_SSL_ERROR(log_level)            \
  			REPORT_PREFIX                          \
  			fprintf(stderr, format , ##args);      \
  			if (log_level == LOG_PERROR)           \
  				fprintf(stderr,                \
  				        ": %s",                \
  				        strerror(errno));      \
  			putc('\n', stderr);                    \
  			fflush(stderr);                        \
  		}                                              \
  	} while (/* CONSTCOND */ 0)
#elif HAVE_STDARG_H
#define NEED_REPORT_FUNC	1
void            report(int log_level, const char *format,...);
#else
#error "don't know how to implement report() on your platform"
#endif				/* __STDC_VERSION__ >= 199901L */

#endif				/* REPORT_H */
