/* $Id: report.c,v 1.10 2005/01/02 17:26:15 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

#include "report.h"

#if NEED_REPORT_FUNC
#include <stdarg.h>

void
report(int log_level, const char *format, ...)
{

	if (debug_level >= log_level) {
		va_list         args;

#if WITH_SSL
		if (log_level == LOG_SERROR) {
			fprintf(stderr, "%s: ", deletemail);
			fputs("SSL error: ", stderr);
			ERR_print_errors_fp(stderr);
		}
#endif				/* WITH_SSL */
		fprintf(stderr, "%s: ", deletemail);
		va_start(args, format);
		vfprintf(stderr, format, args);
		va_end(args);
		if (log_level == LOG_PERROR)
			fprintf(stderr, ": %s", strerror(errno));
		putc('\n', stderr);
		fflush(stderr);
	}
}

#endif				/* NEED_REPORT_FUNC */
