/* $Id: imap.h,v 1.20 2005/01/24 14:37:22 holger Exp $ */

/*
 * Copyright (c) 2004, 2005 Holger Weiss
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef IMAP_H
#define IMAP_H

#if HAVE_CONFIG_H
#include <config.h>
#endif				/* HAVE_CONFIG_H */

#if HAVE_INTTYPES_H
#include <inttypes.h>
#else
#if HAVE_STDINT_H
#include <stdint.h>
#else
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif				/* HAVE_SYS_TYPES_H */
#endif				/* HAVE_STDINT_H */
#endif				/* HAVE_INTTYPES_H */

#include "system.h"

/* IMAP protocols */
#define IMAP4unknown	-40
#define IMAP4old	 40
#define IMAP4rev1	 41

/* return values */
#define IMAP_TLS	-20
#define IMAP_SEND	-10
#define IMAP_FATAL	 -5
#define IMAP_PROTO	 -4
#define IMAP_NO		 -3
#define IMAP_RO	 	 -2
#define IMAP_PREAUTH	 -1
#define IMAP_OK		  0
#define IMAP_UNKNOWN	 42

/* returns above return values as string */
#define IMAP_ERROR(x)	_imap_error_table[_lookup_imap_error(x)].str

typedef struct {
	const int       code;
	const char     *str;
}               _imap_error_mapping;

/* IMAP server capabilities */
typedef struct {
	short           proto;
	bool            starttls;
	bool            logindisabled;
}               capabilities;

/* needed for IMAP_ERROR() macro */
extern _imap_error_mapping _imap_error_table[];

/* total number of messages */
extern uint32_t exists;

#if WITH_SSL
int             imap_connect(const char *server, int port, bool use_ssl);
int             imap_starttls(const char *server);
#else
int             imap_connect(const char *server, int port);
#endif				/* WITH_SSL */
int             imap_capability(capabilities * capa);
int             imap_login(const char *user, const char *pass);
int             imap_select(const char *folder);
int             imap_search(char **response, const char *search, bool uid_search);
int             imap_store(const uint32_t *message, const char *flags, bool uid_store);
int             imap_close(void);
void            imap_logout(void);
uint32_t       *parse_search_response(const char *response);
char           *mk_date(int days);
unsigned short  _lookup_imap_error(int err_code);

#endif				/* IMAP_H */
