/**********************************************************************/
/*  Include file: dtlkttse.h                                          */
/*                                                                    */
/*  DECtalk TTS engine GUID definitions.                              */
/*                                                                    */
/*  Copyright 1995 by Digital Equipment Corporation.                  */
/*  All rights reserved.                                              */
/**********************************************************************/
/*
 * 19-mar-97            ncs            remerged in willowpond stuff
 * 13-feb-1998			MGS				added keys for multiple languages
 * 18-mar-1998          cjl             Fixing Multi Lange typos (Matt strikes again!)
 * 18-mar-1998          cjl             Removed specific path for dectalkf.h.
 * 30-jul-1998			jhu				Added support for SPANISH_LA and SPANISH_SP.
 */

#include "dectalkf.h"

#ifndef WILLOWPOND

#if defined ENGLISH_US || !(defined SAPI_MULTI_LANGUAGE_SUPPORT)

// {ED737300-8FCB-11ce-AB5D-00AA00590F2B}
#define GUID_DECTALKCLSID \
{0xed737300, 0x8fcb, 0x11ce, {0xab, 0x5d, 0x0, 0xaa, 0x0, 0x59, 0xf, 0x2b}}
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum,
0xed737300, 0x8fcb, 0x11ce, 0xab, 0x5d, 0x0, 0xaa, 0x0, 0x59, 0xf, 0x2b);

// {7FB66061-29D5-11cf-B6B3-08002B34B759}
#define GUID_MODEID_PAUL \
{0x7fb66061, 0x29d5, 0x11cf, {0xb6, 0xb3, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_PAUL, 
0x7fb66061, 0x29d5, 0x11cf, 0xb6, 0xb3, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {7FB66062-29D5-11cf-B6B3-08002B34B759}
#define GUID_MODEID_BETTY \
{0x7fb66062, 0x29d5, 0x11cf, {0xb6, 0xb3, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_BETTY, 
0x7fb66062, 0x29d5, 0x11cf, 0xb6, 0xb3, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B11-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_HARRY \
{0x80bb5b11, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_HARRY, 
0x80bb5b11, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B12-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_FRANK \
{0x80bb5b12, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_FRANK, 
0x80bb5b12, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B13-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_DENNIS \
{0x80bb5b13, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_DENNIS, 
0x80bb5b13, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B14-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_KIT \
{0x80bb5b14, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_KIT, 
0x80bb5b14, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B15-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_URSULA \
{0x80bb5b15, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_URSULA, 
0x80bb5b15, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B16-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_RITA \
{0x80bb5b16, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_RITA, 
0x80bb5b16, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

// {80BB5B17-4A17-11cf-B6D5-08002B34B759}
#define GUID_MODEID_WENDY \
{0x80bb5b17, 0x4a17, 0x11cf, {0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59}}
DEFINE_GUID(MODEID_WENDY, 
0x80bb5b17, 0x4a17, 0x11cf, 0xb6, 0xd5, 0x8, 0x0, 0x2b, 0x34, 0xb7, 0x59);

#endif
	
#if defined ENGLISH_UK && defined SAPI_MULTI_LANGUAGE_SUPPORT

// {99EE9540-A4A6-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x99ee9540, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x99ee9540, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9541-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x99ee9541, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x99ee9541, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9542-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x99ee9542, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x99ee9542, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9543-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x99ee9543, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x99ee9543, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9544-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x99ee9544, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x99ee9544, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9545-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x99ee9545, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x99ee9545, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9546-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x99ee9546, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x99ee9546, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9547-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x99ee9547, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x99ee9547, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9548-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x99ee9548, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x99ee9548, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9549-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x99ee9549, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x99ee9549, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);
#endif

#if defined SPANISH && defined SAPI_MULTI_LANGUAGE_SUPPORT
#ifdef SPANISH_LA

// {99EE9550-A4A6-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x99ee9550, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x99ee9550, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9551-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x99ee9551, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x99ee9551, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9552-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x99ee9552, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x99ee9552, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9553-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x99ee9553, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x99ee9553, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9554-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x99ee9554, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x99ee9554, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9555-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x99ee9555, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x99ee9555, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9556-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x99ee9556, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x99ee9556, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9557-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x99ee9557, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x99ee9557, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9558-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x99ee9558, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x99ee9558, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9559-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x99ee9559, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x99ee9559, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#else

// {99EE9560-A4A6-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x99ee9560, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x99ee9560, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9561-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x99ee9561, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x99ee9561, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9562-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x99ee9562, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x99ee9562, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9563-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x99ee9563, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x99ee9563, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9564-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x99ee9564, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x99ee9564, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9565-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x99ee9565, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x99ee9565, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9566-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x99ee9566, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x99ee9566, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9567-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x99ee9567, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x99ee9567, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9568-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x99ee9568, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x99ee9568, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9569-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x99ee9569, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x99ee9569, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#endif
#endif
#if defined GERMAN && defined SAPI_MULTI_LANGUAGE_SUPPORT

// {99EE9570-A4A6-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x99ee9570, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x99ee9570, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9571-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x99ee9571, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x99ee9571, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9572-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x99ee9572, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x99ee9572, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9573-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x99ee9573, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x99ee9573, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9574-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x99ee9574, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x99ee9574, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9575-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x99ee9575, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x99ee9575, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9576-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x99ee9576, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x99ee9576, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9577-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x99ee9577, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x99ee9577, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9578-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x99ee9578, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x99ee9578, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {99EE9579-A4A6-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x99ee9579, 0xa4a6, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x99ee9579, 0xa4a6, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#endif

/* 19-mar-97 ncs
   Starting here is where Willowpond stuff is.
*/

#else

#include "idec.h"

#if defined ENGLISH_US || !(defined SAPI_MULTI_LANGUAGE_SUPPORT)
// {655789E1-0FD9-11d0-B026-0020AF26D014}
#define GUID_DECTALKCLSID \
{0x655789E1, 0x0fd9, 0x11d0, {0xB0, 0x26, 0x00, 0x20, 0xAF, 0x26, 0xD0, 0x14}}
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x655789e1, 0xfd9, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

/*
#define GUID_IID_IDECUnlockEng -> idec.h
*/

// {D877AFE5-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_PAUL \
{0xd877afe5, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_PAUL, 
0xd877afe5, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFE6-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_BETTY \
{0xd877afe6, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_BETTY, 
0xd877afe6, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFE7-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_HARRY \
{0xd877afe7, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_HARRY, 
0xd877afe7, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFE8-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_FRANK \
{0xd877afe8, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_FRANK, 
0xd877afe8, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFE9-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_DENNIS \
{0xd877afe9, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_DENNIS, 
0xd877afe9, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFEA-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_KIT \
{0xd877afea, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_KIT, 
0xd877afea, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFEB-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_URSULA \
{0xd877afeb, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_URSULA, 
0xd877afeb, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFEC-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_RITA \
{0xd877afec, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_RITA, 
0xd877afec, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);

// {D877AFED-108D-11d0-B026-0020AF26D014}
#define GUID_MODEID_WENDY \
{0xd877afed, 0x108d, 0x11d0, {0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14}}
DEFINE_GUID(MODEID_WENDY, 
0xd877afed, 0x108d, 0x11d0, 0xb0, 0x26, 0x0, 0x20, 0xaf, 0x26, 0xd0, 0x14);
#endif

#if defined ENGLISH_UK && defined SAPI_MULTI_LANGUAGE_SUPPORT

// {612FF710-A6DF-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x612ff710, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x612ff710, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF711-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x612ff711, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x612ff711, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF712-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x612ff712, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x612ff712, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF713-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x612ff713, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x612ff713, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF714-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x612ff714, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x612ff714, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF715-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x612ff715, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x612ff715, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF716-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x612ff716, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x612ff716, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF717-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x612ff717, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x612ff717, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF718-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x612ff718, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x612ff718, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF719-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x612ff719, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x612ff719, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#endif
#if defined SPANISH && defined SAPI_MULTI_LANGUAGE_SUPPORT
#ifdef SPANISH_LA

// {612FF720-A6DF-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x612ff720, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x612ff720, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF721-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x612ff721, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x612ff721, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF722-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x612ff722, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x612ff722, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF723-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x612ff723, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x612ff723, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF724-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x612ff724, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x612ff724, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF725-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x612ff725, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x612ff725, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF726-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x612ff726, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x612ff726, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF727-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x612ff727, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x612ff727, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF728-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x612ff728, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x612ff728, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF729-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x612ff729, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x612ff729, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#else

// {612FF730-A6DF-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x612ff730, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x612ff730, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF731-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x612ff731, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x612ff731, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF732-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x612ff732, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x612ff732, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF733-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x612ff733, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x612ff733, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF734-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x612ff734, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x612ff734, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF735-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x612ff735, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x612ff735, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF736-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x612ff736, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x612ff736, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF737-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x612ff737, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x612ff737, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF738-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x612ff738, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x612ff738, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF739-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x612ff739, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x612ff739, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

#endif
#endif
#if defined GERMAN && defined SAPI_MULTI_LANGUAGE_SUPPORT

// {612FF740-A6DF-11d1-BEB2-0060083E8376}
#define GUID_DECTALKCLSID \
{ 0x612ff740, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(CLSID_DECtalkTTSEngineEnum, 
0x612ff740, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF741-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_PAUL \
{ 0x612ff741, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_PAUL, 
0x612ff741, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF742-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_BETTY \
{ 0x612ff742, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_BETTY, 
0x612ff742, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF743-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_HARRY \
{ 0x612ff743, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_HARRY, 
0x612ff743, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF744-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_FRANK \
{ 0x612ff744, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_FRANK, 
0x612ff744, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF745-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_DENNIS \
{ 0x612ff745, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_DENNIS, 
0x612ff745, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF746-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_KIT \
{ 0x612ff746, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_KIT, 
0x612ff746, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF747-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_URSULA \
{ 0x612ff747, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_URSULA, 
0x612ff747, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF748-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_RITA \
{ 0x612ff748, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_RITA, 
0x612ff748, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);

// {612FF749-A6DF-11d1-BEB2-0060083E8376}
#define GUID_MODEID_WENDY \
{ 0x612ff749, 0xa6df, 0x11d1, { 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76 } }
DEFINE_GUID(MODEID_WENDY, 
0x612ff749, 0xa6df, 0x11d1, 0xbe, 0xb2, 0x0, 0x60, 0x8, 0x3e, 0x83, 0x76);


#endif


#endif //WILLOWPOND
