/***************************************************************************
 *            dyndns.h
 *
 *  Fri Sep 10 23:09:27 2004
 *  Copyright  2004  User
 *  Email
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

/* DynDNS.org Settings */

#define DYNDNS_SERVICE_NAME "dyndns.org"
#define DYNDNS_HOST "members.dyndns.org"
#define DYNDNS_PORT 80

/* DynDNS.org return codes */

// UPDATE_COMPLETE means everything went OK.
#define DYNDNS_UPDATE_COMPLETE 0
// NOIPCHG_COMPLETE means the IP address didn't change,
// but the request was made without an error. This
// may mean either the IP address had not changed since
// the last time it was updated, or ddnsu did not try
// to update the IP address, so this may or may not be
// of concern.
#define DYNDNS_NOIPCHG_COMPLETE 1
// BADAUTH_ERROR means the username or password
// was wrong.
#define DYNDNS_BADAUTH_ERROR 2
// NOTDONATOR_ERROR usually means you logged in
// correctly, but you do not have permission to use
// that particular option using your account.
// Try coughing up a few bucks to those poor guys.
#define DYNDNS_NOTDONATOR_ERROR 3
// BADSYS_ERROR means you passed the wrong value to
// the system type option.
#define DYNDNS_BADSYS_ERROR 4
// BADAGENT_ERROR means (for some reason) ddnsu is not
// allowed to update; try changing the User-Agent field
// in ddnsu.c/h.
#define DYNDNS_BADAGENT_ERROR 5
// NOTFQDN_ERROR means the domain was not a fully-
// qualified-domain-name. Fix it.
#define DYNDNS_NOTFQDN_ERROR 6
// NOHOST_ERROR means either the domain does not exist or
// you forgot to specify the right system type (dyndns,
// statdns, custom).
#define DYNDNS_NOHOST_ERROR 7
// NOTYOURS_ERROR means you tried to edit a domain which
// is not in your account.
#define DYNDNS_NOTYOURS_ERROR 8
// ABUSE_ERROR means you are abusing the system. Stop
// updating before your domain gets disabled.
#define DYNDNS_ABUSE_ERROR 9
// NUMHOST_ERROR means something's screwed up over at
// DynDNS.org's servers; contact their support department.
#define DYNDNS_NUMHOST_ERROR 10
// DNSERR_ERROR is another bad error which means you
// should contact DynDNS.org's support immediately.
// You may want to recompile ddnsu with DEBUG enabled to
// tell the support department a numeric packet ID.
#define DYNDNS_DNSERR_ERROR 11

extern int update_dyndns();
